/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.persistence;

import android.util.Log;
import androidx.annotation.NonNull;
import com.vungle.warren.persistence.CacheManager;
import com.vungle.warren.persistence.Designer;
import com.vungle.warren.utility.FileUtility;
import java.io.File;
import java.io.IOException;

public class GraphicDesigner
implements Designer,
CacheManager.Listener {
    private static final String FOLDER_NAME = "vungle";
    private static final String TAG = GraphicDesigner.class.getSimpleName();
    private CacheManager cacheManager;

    public GraphicDesigner(@NonNull CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        this.cacheManager.addListener(this);
        FileUtility.printDirectoryTree(this.getCacheDirectory());
    }

    @Override
    public File getAssetDirectory(String identifier) throws IllegalStateException {
        File assetDir = new File(this.getCacheDirectory().getPath() + File.separator + identifier);
        if (!assetDir.exists()) {
            assetDir.mkdir();
        }
        return assetDir;
    }

    @Override
    public void deleteAssets(String identifier) throws IOException, IllegalStateException {
        File[] files = this.getCacheDirectory().listFiles();
        if (files == null) {
            return;
        }
        for (File f2 : files) {
            if (!f2.isDirectory() || !f2.getName().equals(identifier)) continue;
            FileUtility.delete(f2);
        }
    }

    @Override
    public File getCacheDirectory() throws IllegalStateException {
        if (this.cacheManager == null) {
            throw new IllegalStateException("Context has expired, cannot continue.");
        }
        File dir = new File(this.cacheManager.getCache() + File.separator + FOLDER_NAME);
        if (!dir.exists()) {
            dir.mkdir();
        }
        return dir;
    }

    @Override
    public void clearCache() {
        if (this.cacheManager == null || this.cacheManager.getCache() == null) {
            return;
        }
        File dir = new File(this.cacheManager.getCache().getPath() + File.separator + FOLDER_NAME);
        if (dir.exists()) {
            try {
                FileUtility.delete(dir);
            }
            catch (IOException e2) {
                Log.e((String)TAG, (String)("Failed to delete cached files. Reason: " + e2.getLocalizedMessage()));
            }
        }
        if (!dir.exists()) {
            dir.mkdir();
        }
    }

    @Override
    public void onCacheChanged() {
        if (this.cacheManager == null) {
            return;
        }
        for (File root : this.cacheManager.getOldCaches()) {
            try {
                FileUtility.delete(new File(root.getPath() + File.separator + FOLDER_NAME));
            }
            catch (IOException e2) {
                Log.e((String)TAG, (String)("Failed to delete cached files. Reason: " + e2.getLocalizedMessage()));
            }
        }
    }
}

