/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.tasks;

import android.os.Bundle;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.vungle.warren.AdConfig;
import com.vungle.warren.AdLoader;
import com.vungle.warren.AdRequest;
import com.vungle.warren.CacheBustManager;
import com.vungle.warren.LoadAdCallback;
import com.vungle.warren.VungleApiClient;
import com.vungle.warren.VungleLogger;
import com.vungle.warren.model.Advertisement;
import com.vungle.warren.model.CacheBust;
import com.vungle.warren.model.Cookie;
import com.vungle.warren.model.Placement;
import com.vungle.warren.network.Response;
import com.vungle.warren.persistence.DatabaseHelper;
import com.vungle.warren.persistence.Repository;
import com.vungle.warren.tasks.Job;
import com.vungle.warren.tasks.JobInfo;
import com.vungle.warren.tasks.JobRunner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;

public class CacheBustJob
implements Job {
    public static final String TAG = CacheBustJob.class.getCanonicalName();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final VungleApiClient client;
    private final Repository repository;
    private final ExecutorService backgroundExecutor;
    private final AdLoader adLoader;

    public CacheBustJob(@NonNull VungleApiClient client, @NonNull Repository repository, @NonNull ExecutorService backgroundExecutor, AdLoader adLoader) {
        this.client = client;
        this.repository = repository;
        this.backgroundExecutor = backgroundExecutor;
        this.adLoader = adLoader;
    }

    @Override
    public int onRunJob(Bundle bundle, JobRunner jobRunner) {
        Log.i((String)TAG, (String)"CacheBustJob started");
        if (this.client == null || this.repository == null) {
            Log.e((String)TAG, (String)"CacheBustJob finished - no client or repository");
            return 1;
        }
        try {
            Cookie cacheBustCookie = this.repository.load("cacheBustSettings", Cookie.class).get();
            if (cacheBustCookie == null) {
                cacheBustCookie = new Cookie("cacheBustSettings");
            }
            long lastCacheBustTime = cacheBustCookie.getLong("last_cache_bust");
            Response<JsonObject> response = this.client.cacheBust(lastCacheBustTime).execute();
            ArrayList<CacheBust> cacheBustList = new ArrayList<CacheBust>();
            List<CacheBust> unProcessedBusts = this.repository.getUnProcessedBusts();
            if (unProcessedBusts != null && !unProcessedBusts.isEmpty()) {
                cacheBustList.addAll(unProcessedBusts);
            }
            Gson gson = new Gson();
            if (response.isSuccessful()) {
                long lastCacheBust;
                JsonObject jsonObject = response.body();
                if (jsonObject == null || !jsonObject.has("cache_bust")) {
                    Log.e((String)TAG, (String)"CacheBustJob finished - no jsonObject or cache_bust in it");
                    return 1;
                }
                JsonObject cacheBustObject = jsonObject.getAsJsonObject("cache_bust");
                if (cacheBustObject.has("last_updated") && (lastCacheBust = cacheBustObject.get("last_updated").getAsLong()) > 0L) {
                    cacheBustCookie.putValue("last_cache_bust", cacheBustObject.get("last_updated").getAsLong());
                    this.repository.save(cacheBustCookie);
                }
                this.parseAndSaveCacheBust(cacheBustObject, "campaign_ids", 1, "cannot save campaignBust=", cacheBustList, gson);
                this.parseAndSaveCacheBust(cacheBustObject, "creative_ids", 2, "cannot save creativeBust=", cacheBustList, gson);
            }
            this.processBust(cacheBustList);
            this.updateTimerData(bundle, cacheBustCookie);
        }
        catch (IOException e2) {
            Log.e((String)TAG, (String)"CacheBustJob failed - IOException", (Throwable)e2);
            return 2;
        }
        catch (DatabaseHelper.DBException e3) {
            Log.e((String)TAG, (String)"CacheBustJob failed - DBException", (Throwable)e3);
            return 2;
        }
        this.sendAnalytics();
        Log.d((String)TAG, (String)"CacheBustJob finished");
        return 2;
    }

    private void parseAndSaveCacheBust(JsonObject cacheBustObject, String fieldName, int cacheBustIdType, String errorLogMessage, List<CacheBust> cacheBustList, Gson gson) {
        if (cacheBustObject.has(fieldName)) {
            for (JsonElement jsonElement : cacheBustObject.getAsJsonArray(fieldName)) {
                CacheBust cacheBust = (CacheBust)gson.fromJson(jsonElement, CacheBust.class);
                cacheBust.setTimeWindowEnd(cacheBust.getTimeWindowEnd() * 1000L);
                cacheBust.setIdType(cacheBustIdType);
                cacheBustList.add(cacheBust);
                try {
                    this.repository.save(cacheBust);
                }
                catch (DatabaseHelper.DBException e2) {
                    VungleLogger.error(CacheBustJob.class.getSimpleName() + "#onRunJob", errorLogMessage + cacheBust);
                }
            }
        }
    }

    private void processBust(Iterable<CacheBust> busts) {
        for (CacheBust bust : busts) {
            List<Advertisement> adsInRepo = bust.getIdType() == 1 ? this.repository.getAdsByCampaign(bust.getId()) : this.repository.getAdsByCreative(bust.getId());
            LinkedList<String> eventIds = new LinkedList<String>();
            LinkedList<Advertisement> adsToBust = new LinkedList<Advertisement>();
            for (Advertisement adInRepo : adsInRepo) {
                if (adInRepo.getServerRequestTimestamp() >= bust.getTimeWindowEnd() || !this.shouldAdBeBusted(adInRepo)) continue;
                eventIds.add(adInRepo.getId());
                adsToBust.add(adInRepo);
            }
            if (eventIds.isEmpty()) {
                Log.d((String)TAG, (String)("processBust: bust has no relevant ads, deleting " + bust));
                try {
                    this.repository.delete(bust);
                }
                catch (DatabaseHelper.DBException e2) {
                    VungleLogger.error(CacheBustJob.class.getSimpleName() + "#processBust", "Cannot delete obsolete bust " + bust + " because of " + e2);
                }
                continue;
            }
            bust.setEventIds(eventIds.toArray(EMPTY_STRING_ARRAY));
            for (Advertisement adToBust : adsToBust) {
                this.bustAd(adToBust, bust);
            }
        }
    }

    private boolean shouldAdBeBusted(Advertisement advertisement) {
        return advertisement.getState() != 2 && advertisement.getState() != 3;
    }

    private void sendAnalytics() {
        List<CacheBust> cacheBusts = this.repository.loadAll(CacheBust.class).get();
        if (cacheBusts == null || cacheBusts.size() == 0) {
            Log.d((String)TAG, (String)"sendAnalytics: no cachebusts in repository");
            return;
        }
        LinkedList<CacheBust> bustsToSend = new LinkedList<CacheBust>();
        for (CacheBust cacheBust : cacheBusts) {
            if (cacheBust.getTimestampProcessed() == 0L) continue;
            bustsToSend.add(cacheBust);
        }
        if (bustsToSend.isEmpty()) {
            Log.d((String)TAG, (String)"sendAnalytics: no cachebusts to send analytics");
            return;
        }
        try {
            Response<JsonObject> bustAnalytics = this.client.bustAnalytics(bustsToSend).execute();
            if (bustAnalytics.isSuccessful()) {
                for (CacheBust cacheBust : bustsToSend) {
                    try {
                        this.repository.delete(cacheBust);
                    }
                    catch (DatabaseHelper.DBException e2) {
                        VungleLogger.error(CacheBustManager.class.getSimpleName() + "#sendAnalytics", "can't delete bust \" + cacheBust");
                    }
                }
            } else {
                Log.e((String)TAG, (String)("sendAnalytics: not successful, aborting, response is " + bustAnalytics));
            }
        }
        catch (IOException e3) {
            Log.e((String)TAG, (String)"sendAnalytics: can't execute API call", (Throwable)e3);
        }
    }

    private void bustAd(Advertisement advertisement, CacheBust cacheBust) {
        try {
            Log.d((String)TAG, (String)("bustAd: deleting " + advertisement.getId()));
            this.adLoader.dropCache(advertisement.getId());
            this.repository.deleteAdvertisement(advertisement.getId());
            Placement busted = this.repository.load(this.repository.getPlacementIdByAd(advertisement), Placement.class).get();
            if (busted != null) {
                AdConfig config = new AdConfig();
                config.setAdSize(busted.getAdSize());
                if (busted.isMultipleHBPEnabled()) {
                    this.adLoader.loadEndlessIfNeeded(busted, busted.getAdSize(), 0L);
                } else {
                    this.adLoader.load(new AdLoader.Operation(new AdRequest(busted.getId()), busted.getAdSize(), 0L, 2000L, 5, 1, 0, false, busted.getAutoCachePriority(), new LoadAdCallback[0]));
                }
            }
            cacheBust.setTimestampProcessed(System.currentTimeMillis());
            this.repository.save(cacheBust);
        }
        catch (DatabaseHelper.DBException e2) {
            Log.e((String)TAG, (String)("bustAd: cannot drop cache or delete advertisement for " + advertisement), (Throwable)e2);
        }
    }

    protected void updateTimerData(Bundle bundle, Cookie cacheBustCookie) throws DatabaseHelper.DBException {
        long cacheBustInterval = bundle.getLong("cache_bust_interval");
        if (cacheBustInterval != 0L) {
            cacheBustCookie.putValue("next_cache_bust", SystemClock.elapsedRealtime() + cacheBustInterval);
        }
        this.repository.save(cacheBustCookie);
    }

    public static JobInfo makeJobInfo() {
        return new JobInfo(TAG).setPriority(0).setUpdateCurrent(true);
    }
}

