/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.tasks;

import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class JobInfo
implements Cloneable {
    private static final String TAG = "JobInfo";
    private final String tag;
    private boolean updateCurrent;
    private long delay;
    private long rescheduleTimeout;
    private long nextRescheduleTimeout;
    private Bundle extras = new Bundle();
    private int reschedulePolicy = 1;
    private int priority = 2;
    @NetworkType
    private int requiredNetworkType = 0;

    public JobInfo(@NonNull String tag) {
        this.tag = tag;
    }

    public JobInfo setUpdateCurrent(boolean updateCurrent) {
        this.updateCurrent = updateCurrent;
        return this;
    }

    public JobInfo setExtras(@NonNull Bundle extras) {
        if (extras != null) {
            this.extras = extras;
        }
        return this;
    }

    public JobInfo setDelay(long delay) {
        this.delay = delay;
        return this;
    }

    public JobInfo setReschedulePolicy(long rescheduleTimeout, int delayCriteria) {
        this.rescheduleTimeout = rescheduleTimeout;
        this.reschedulePolicy = delayCriteria;
        return this;
    }

    public JobInfo setPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public String getJobTag() {
        return this.tag;
    }

    public Bundle getExtras() {
        return this.extras;
    }

    public long getDelay() {
        return this.delay;
    }

    public long makeNextRescedule() {
        if (this.rescheduleTimeout == 0L) {
            return 0L;
        }
        if (this.nextRescheduleTimeout == 0L) {
            this.nextRescheduleTimeout = this.rescheduleTimeout;
        } else if (this.reschedulePolicy == 1) {
            this.nextRescheduleTimeout *= 2L;
        }
        return this.nextRescheduleTimeout;
    }

    public boolean getUpdateCurrent() {
        return this.updateCurrent;
    }

    public int getPriority() {
        return this.priority;
    }

    public JobInfo copy() {
        try {
            return (JobInfo)super.clone();
        }
        catch (CloneNotSupportedException e2) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e2));
            return null;
        }
    }

    public int getRequiredNetworkType() {
        return this.requiredNetworkType;
    }

    public JobInfo setRequiredNetworkType(@NetworkType int requiredNetworkType) {
        this.requiredNetworkType = requiredNetworkType;
        return this;
    }

    public static @interface NetworkType {
        public static final int ANY = 0;
        public static final int CONNECTED = 1;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Priority {
        public static final int LOWEST = 0;
        public static final int LOW = 1;
        public static final int NORMAL = 2;
        public static final int HIGH = 3;
        public static final int HIGHEST = 4;
        public static final int CRITICAL = 5;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ReschedulePolicy {
        public static final int LINEAR = 0;
        public static final int EXPONENTIAL = 1;
    }
}

