/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.tasks;

import android.os.Bundle;
import android.util.Log;
import com.google.gson.JsonObject;
import com.vungle.warren.VungleApiClient;
import com.vungle.warren.model.Report;
import com.vungle.warren.network.Response;
import com.vungle.warren.persistence.DatabaseHelper;
import com.vungle.warren.persistence.Repository;
import com.vungle.warren.tasks.Job;
import com.vungle.warren.tasks.JobInfo;
import com.vungle.warren.tasks.JobRunner;
import java.io.IOException;
import java.util.List;

public class SendReportsJob
implements Job {
    private static final long DEFAULT_DELAY = 30000L;
    static final String TAG = SendReportsJob.class.getCanonicalName();
    private Repository repository;
    private VungleApiClient vungleApiClient;

    public SendReportsJob(Repository repository, VungleApiClient vungleApiClient) {
        this.repository = repository;
        this.vungleApiClient = vungleApiClient;
    }

    public static JobInfo makeJobInfo(boolean sendAllReports) {
        Bundle extras = new Bundle();
        extras.putBoolean("sendAll", sendAllReports);
        return new JobInfo(TAG).setExtras(extras).setPriority(5).setReschedulePolicy(30000L, 1);
    }

    @Override
    public int onRunJob(Bundle params, JobRunner jobRunner) {
        boolean sendAllReports = params.getBoolean("sendAll", false);
        List<Report> reportList = sendAllReports ? this.repository.loadAllReportToSend().get() : this.repository.loadReadyOrFailedReportToSend().get();
        if (reportList == null) {
            return 1;
        }
        for (Report r : reportList) {
            try {
                Response<JsonObject> response = this.vungleApiClient.reportAd(r.toReportBody()).execute();
                if (response.code() == 200) {
                    this.repository.delete(r);
                    continue;
                }
                r.setStatus(3);
                this.repository.save(r);
                long retryAfterHeaderValue = this.vungleApiClient.getRetryAfterHeaderValue(response);
                if (retryAfterHeaderValue <= 0L) continue;
                jobRunner.execute(SendReportsJob.makeJobInfo(false).setDelay(retryAfterHeaderValue));
                return 1;
            }
            catch (IOException e2) {
                Log.d((String)TAG, (String)"SendReportsJob: IOEx");
                for (Report markFail : reportList) {
                    markFail.setStatus(3);
                    try {
                        this.repository.save(markFail);
                    }
                    catch (DatabaseHelper.DBException ignored) {
                        return 1;
                    }
                }
                Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e2));
                return 2;
            }
            catch (DatabaseHelper.DBException e3) {
                return 1;
            }
        }
        return 0;
    }
}

