/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.ui.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowInsets;
import android.view.WindowInsetsController;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.VideoView;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.vungle.warren.ui.JavascriptBridge;
import com.vungle.warren.ui.view.WebSettingsUtils;
import com.vungle.warren.utility.HandlerScheduler;
import com.vungle.warren.utility.ViewUtility;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.Map;

public class FullAdWidget
extends RelativeLayout {
    private static final String TAG = FullAdWidget.class.getSimpleName();
    private Map<View, Integer> viewToId = new HashMap<View, Integer>();
    private final RelativeLayout.LayoutParams matchParentLayoutParams;
    private final Window window;
    public final VideoView videoView;
    private final RelativeLayout videoViewContainer;
    @Nullable
    private WebView webView;
    private final ProgressBar progressBar;
    private final ImageView muteButton;
    private final ImageView closeButton;
    private final ImageView ctaOverlay;
    private final ImageView privacyOverlay;
    private OnItemClickListener onClickProxy;
    private MediaPlayer.OnPreparedListener onPreparedListener;
    private MediaPlayer.OnErrorListener onErrorListener;
    private MediaPlayer.OnCompletionListener onCompletionListener;
    private int startPosition;
    private GestureDetector gestureDetector;
    private Runnable hideSystemUiRunnable;
    private GestureDetector.SimpleOnGestureListener singleTapOnVideoListener = new GestureDetector.SimpleOnGestureListener(){

        public boolean onSingleTapConfirmed(MotionEvent e2) {
            FullAdWidget.this.proxyClickListener.onClick((View)FullAdWidget.this.videoViewContainer);
            return true;
        }
    };
    ViewTreeObserver.OnGlobalLayoutListener immersiveModeListener = new ViewTreeObserver.OnGlobalLayoutListener(){

        public void onGlobalLayout() {
            FullAdWidget.this.removeImmersiveModeListener();
            FullAdWidget.this.hideSystemUi();
        }
    };
    private View.OnClickListener proxyClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (FullAdWidget.this.onClickProxy != null) {
                FullAdWidget.this.onClickProxy.onItemClicked(FullAdWidget.this.matchView(v));
            }
        }
    };

    public FullAdWidget(Context context, Window window) throws InstantiationException {
        super(context);
        this.window = window;
        Resources resources = this.getResources();
        this.matchParentLayoutParams = new RelativeLayout.LayoutParams(-1, -1);
        this.setLayoutParams((ViewGroup.LayoutParams)this.matchParentLayoutParams);
        this.hideSystemUiRunnable = new Runnable(){

            @Override
            public void run() {
                FullAdWidget.this.hideSystemUi();
            }
        };
        this.videoView = new VideoView((Context)new AudioContextWrapper(context));
        RelativeLayout.LayoutParams videoViewLayoutParams = new RelativeLayout.LayoutParams(-1, -1);
        videoViewLayoutParams.addRule(13);
        this.videoView.setLayoutParams((ViewGroup.LayoutParams)videoViewLayoutParams);
        this.videoViewContainer = new RelativeLayout(context);
        this.videoViewContainer.setTag((Object)"videoViewContainer");
        this.videoViewContainer.setLayoutParams((ViewGroup.LayoutParams)this.matchParentLayoutParams);
        this.videoViewContainer.addView((View)this.videoView, (ViewGroup.LayoutParams)videoViewLayoutParams);
        this.addView((View)this.videoViewContainer, (ViewGroup.LayoutParams)this.matchParentLayoutParams);
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this.singleTapOnVideoListener);
        this.webView = ViewUtility.getWebView(context);
        this.webView.setLayoutParams((ViewGroup.LayoutParams)this.matchParentLayoutParams);
        this.webView.setTag((Object)"webView");
        this.addView((View)this.webView, (ViewGroup.LayoutParams)this.matchParentLayoutParams);
        this.progressBar = new ProgressBar(context, null, 16842872);
        int progressBarHeight = (int)TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)resources.getDisplayMetrics());
        RelativeLayout.LayoutParams progressBarLayoutParams = new RelativeLayout.LayoutParams(-1, progressBarHeight);
        progressBarLayoutParams.addRule(12);
        this.progressBar.setLayoutParams((ViewGroup.LayoutParams)progressBarLayoutParams);
        this.progressBar.setMax(100);
        this.progressBar.setIndeterminate(false);
        this.progressBar.setVisibility(4);
        this.addView((View)this.progressBar);
        int imageViewDimension = (int)TypedValue.applyDimension((int)1, (float)24.0f, (DisplayMetrics)resources.getDisplayMetrics());
        RelativeLayout.LayoutParams imageViewLayoutParams = new RelativeLayout.LayoutParams(imageViewDimension, imageViewDimension);
        int imageViewMargin = (int)TypedValue.applyDimension((int)1, (float)12.0f, (DisplayMetrics)resources.getDisplayMetrics());
        imageViewLayoutParams.setMargins(imageViewMargin, imageViewMargin, imageViewMargin, imageViewMargin);
        this.muteButton = new ImageView(context);
        this.muteButton.setImageBitmap(ViewUtility.getBitmap(ViewUtility.Asset.unMute, context));
        this.muteButton.setLayoutParams((ViewGroup.LayoutParams)imageViewLayoutParams);
        this.muteButton.setVisibility(8);
        this.addView((View)this.muteButton);
        RelativeLayout.LayoutParams closeLayoutParams = new RelativeLayout.LayoutParams(imageViewDimension, imageViewDimension);
        closeLayoutParams.setMargins(imageViewMargin, imageViewMargin, imageViewMargin, imageViewMargin);
        this.closeButton = new ImageView(context);
        this.closeButton.setTag((Object)"closeButton");
        this.closeButton.setImageBitmap(ViewUtility.getBitmap(ViewUtility.Asset.close, context));
        closeLayoutParams.addRule(11);
        this.closeButton.setLayoutParams((ViewGroup.LayoutParams)closeLayoutParams);
        this.closeButton.setVisibility(8);
        this.addView((View)this.closeButton);
        RelativeLayout.LayoutParams ctaOverlayLayoutParams = new RelativeLayout.LayoutParams(imageViewDimension, imageViewDimension);
        ctaOverlayLayoutParams.addRule(12);
        ctaOverlayLayoutParams.addRule(11);
        ctaOverlayLayoutParams.setMargins(imageViewMargin, imageViewMargin, imageViewMargin, imageViewMargin);
        this.ctaOverlay = new ImageView(context);
        this.ctaOverlay.setTag((Object)"ctaOverlay");
        this.ctaOverlay.setLayoutParams((ViewGroup.LayoutParams)ctaOverlayLayoutParams);
        this.ctaOverlay.setImageBitmap(ViewUtility.getBitmap(ViewUtility.Asset.cta, this.getContext()));
        this.ctaOverlay.setVisibility(8);
        this.addView((View)this.ctaOverlay);
        RelativeLayout.LayoutParams privacyLayoutParams = new RelativeLayout.LayoutParams(imageViewDimension, imageViewDimension);
        privacyLayoutParams.addRule(12);
        privacyLayoutParams.addRule(9);
        privacyLayoutParams.setMargins(imageViewMargin, imageViewMargin, imageViewMargin, imageViewMargin);
        this.privacyOverlay = new ImageView(context);
        this.privacyOverlay.setLayoutParams((ViewGroup.LayoutParams)privacyLayoutParams);
        this.privacyOverlay.setVisibility(8);
        this.addView((View)this.privacyOverlay);
        this.bindListeners();
        this.prepare();
    }

    private void bindListeners() {
        this.bindListener((View)this.closeButton, 1);
        this.bindListener((View)this.ctaOverlay, 2);
        this.bindListener((View)this.muteButton, 3);
        this.bindListener((View)this.privacyOverlay, 4);
        this.viewToId.put((View)this.videoViewContainer, 5);
        this.videoViewContainer.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                FullAdWidget.this.gestureDetector.onTouchEvent(event);
                return true;
            }
        });
        this.videoView.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mp) {
                if (Build.VERSION.SDK_INT >= 26) {
                    mp.seekTo((long)FullAdWidget.this.startPosition, 3);
                }
                if (FullAdWidget.this.onPreparedListener != null) {
                    FullAdWidget.this.onPreparedListener.onPrepared(mp);
                }
                FullAdWidget.this.muteButton.setVisibility(0);
            }
        });
        this.videoView.setOnErrorListener(new MediaPlayer.OnErrorListener(){

            public boolean onError(MediaPlayer mp, int what, int extra) {
                if (FullAdWidget.this.onErrorListener != null) {
                    return FullAdWidget.this.onErrorListener.onError(mp, what, extra);
                }
                return false;
            }
        });
        this.videoView.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mp) {
                if (FullAdWidget.this.onCompletionListener != null) {
                    FullAdWidget.this.onCompletionListener.onCompletion(mp);
                }
                FullAdWidget.this.muteButton.setEnabled(false);
            }
        });
    }

    private void bindListener(View v, int event) {
        this.viewToId.put(v, event);
        v.setOnClickListener(this.proxyClickListener);
    }

    @SuppressLint(value={"NewApi"})
    private void prepare() {
        if (this.webView != null) {
            this.webView.getSettings().setMediaPlaybackRequiresUserGesture(false);
            this.webView.setVisibility(8);
        }
        this.videoViewContainer.setVisibility(8);
    }

    public void linkWebView(WebViewClient webViewClient, JavascriptBridge javascriptBridge) {
        if (this.webView == null) {
            return;
        }
        WebSettingsUtils.applyDefault(this.webView);
        this.webView.setWebViewClient(webViewClient);
        this.webView.addJavascriptInterface((Object)javascriptBridge, "Android");
    }

    public void showWebsite(String url) {
        if (this.webView == null) {
            return;
        }
        Log.d((String)TAG, (String)("loadJs: " + url));
        this.webView.loadUrl(url);
        this.webView.setVisibility(0);
        this.videoViewContainer.setVisibility(8);
        this.videoViewContainer.setOnClickListener(null);
        this.progressBar.setVisibility(8);
        this.closeButton.setVisibility(8);
        this.muteButton.setVisibility(8);
        this.ctaOverlay.setVisibility(8);
        this.privacyOverlay.setVisibility(8);
    }

    public void setCtaEnabled(boolean isCtaIconEnabled) {
        this.ctaOverlay.setVisibility(isCtaIconEnabled ? 0 : 8);
    }

    public boolean isVideoPlaying() {
        return this.videoView.isPlaying();
    }

    public void stopPlayback() {
        this.videoView.stopPlayback();
    }

    public void pausePlayback() {
        this.videoView.pause();
    }

    public boolean startPlayback(int position) {
        if (!this.videoView.isPlaying()) {
            this.videoView.requestFocus();
            this.startPosition = position;
            if (Build.VERSION.SDK_INT < 26) {
                this.videoView.seekTo(this.startPosition);
            }
            this.videoView.start();
        }
        return this.videoView.isPlaying();
    }

    private void hideSystemUi() {
        if (Build.VERSION.SDK_INT >= 30) {
            this.window.setDecorFitsSystemWindows(false);
            WindowInsetsController controller = this.window.getInsetsController();
            if (controller != null) {
                controller.hide(WindowInsets.Type.statusBars() | WindowInsets.Type.navigationBars());
                controller.setSystemBarsBehavior(2);
            }
        } else {
            this.window.getDecorView().setSystemUiVisibility(5894);
        }
    }

    public void setImmersiveMode() {
        this.getViewTreeObserver().addOnGlobalLayoutListener(this.immersiveModeListener);
    }

    @SuppressLint(value={"NewApi"})
    private void removeImmersiveModeListener() {
        this.getViewTreeObserver().removeOnGlobalLayoutListener(this.immersiveModeListener);
    }

    public void updateWindow() {
        this.window.setFlags(1024, 1024);
        this.window.getDecorView().setBackgroundColor(-16777216);
    }

    public int getCurrentVideoPosition() {
        return this.videoView.getCurrentPosition();
    }

    public int getVideoDuration() {
        return this.videoView.getDuration();
    }

    public void setOnItemClickListener(OnItemClickListener proxyClickListener) {
        this.onClickProxy = proxyClickListener;
    }

    private int matchView(View v) {
        Integer id = this.viewToId.get(v);
        return id == null ? -1 : id;
    }

    public void setMuted(boolean muted) {
        Bitmap muteBitmap = ViewUtility.getBitmap(ViewUtility.Asset.mute, this.getContext());
        Bitmap unMuteBitmap = ViewUtility.getBitmap(ViewUtility.Asset.unMute, this.getContext());
        this.muteButton.setImageBitmap(muted ? muteBitmap : unMuteBitmap);
    }

    public void playVideo(Uri uri, int videoPosition) {
        this.videoViewContainer.setVisibility(0);
        this.videoView.setVideoURI(uri);
        Bitmap privacyBitmap = ViewUtility.getBitmap(ViewUtility.Asset.privacy, this.getContext());
        this.privacyOverlay.setImageBitmap(privacyBitmap);
        this.privacyOverlay.setVisibility(0);
        this.progressBar.setVisibility(0);
        this.progressBar.setMax(this.videoView.getDuration());
        this.startPlayback(videoPosition);
    }

    public void setOnPreparedListener(MediaPlayer.OnPreparedListener preapredListener) {
        this.onPreparedListener = preapredListener;
    }

    public void setOnErrorListener(MediaPlayer.OnErrorListener errorListener) {
        this.onErrorListener = errorListener;
    }

    public void setOnCompletionListener(MediaPlayer.OnCompletionListener completionListener) {
        this.onCompletionListener = completionListener;
    }

    public void release(long webViewDestroyDelay) {
        this.videoView.stopPlayback();
        this.videoView.setOnCompletionListener(null);
        this.videoView.setOnErrorListener(null);
        this.videoView.setOnPreparedListener(null);
        this.videoView.suspend();
        this.destroyWebView(webViewDestroyDelay);
    }

    public void pauseWeb() {
        if (this.webView != null) {
            this.webView.onPause();
        }
        this.removeImmersiveModeListener();
        this.removeCallbacks(this.hideSystemUiRunnable);
    }

    public void resumeWeb() {
        if (this.webView != null) {
            this.webView.onResume();
        }
        this.post(this.hideSystemUiRunnable);
    }

    public String getUrl() {
        return this.webView == null ? null : this.webView.getUrl();
    }

    public void showCloseButton(boolean visible) {
        this.closeButton.setVisibility(visible ? 0 : 8);
    }

    public void setProgress(int position, float duration) {
        this.progressBar.setMax((int)duration);
        this.progressBar.setProgress(position);
    }

    public void destroyWebView(long webViewDestroyDelay) {
        if (this.webView == null) {
            return;
        }
        this.webView.removeJavascriptInterface("Android");
        this.webView.setWebChromeClient(null);
        this.removeView((View)this.webView);
        this.webView.removeAllViews();
        if (webViewDestroyDelay <= 0L) {
            new DestroyRunnable(this.webView).run();
        } else {
            new HandlerScheduler().schedule(new DestroyRunnable(this.webView), webViewDestroyDelay);
        }
        this.webView = null;
    }

    public boolean hasWebView() {
        return this.webView != null;
    }

    @VisibleForTesting
    @Nullable
    WebView getWebView() {
        return this.webView;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ViewEvent {
        public static final int CLOSE_CLICK = 1;
        public static final int CTA_CLICK = 2;
        public static final int MUTE_CLICK = 3;
        public static final int PRIVACY_CLICK = 4;
        public static final int VIDEO_CLICK = 5;
    }

    public static class AudioContextWrapper
    extends ContextWrapper {
        public AudioContextWrapper(Context base) {
            super(base);
        }

        public Object getSystemService(String name) {
            if ("audio".equals(name)) {
                return this.getApplicationContext().getSystemService(name);
            }
            return super.getSystemService(name);
        }
    }

    public static interface OnItemClickListener {
        public void onItemClicked(int var1);
    }

    private static class DestroyRunnable
    implements Runnable {
        private WebView webView;

        DestroyRunnable(WebView webView) {
            this.webView = webView;
        }

        @Override
        public void run() {
            this.webView.stopLoading();
            this.webView.setWebViewClient(null);
            if (Build.VERSION.SDK_INT >= 29) {
                this.webView.setWebViewRenderProcessClient(null);
            }
            this.webView.loadData("", null, null);
            this.webView.destroy();
        }
    }
}

