/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.ui.view;

import android.annotation.TargetApi;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.webkit.WebViewRenderProcess;
import android.webkit.WebViewRenderProcessClient;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.vungle.warren.model.Advertisement;
import com.vungle.warren.model.Placement;
import com.vungle.warren.omsdk.WebViewObserver;
import com.vungle.warren.ui.view.WebViewAPI;
import java.util.Map;

public class VungleWebClient
extends WebViewClient
implements WebViewAPI {
    public static final String TAG = VungleWebClient.class.getSimpleName();
    private Advertisement advertisement;
    private Placement placement;
    private WebViewAPI.MRAIDDelegate MRAIDDelegate;
    private boolean collectConsent;
    private WebView loadedWebView;
    private boolean ready;
    private String gdprTitle;
    private String gdprBody;
    private String gdprAccept;
    private String gdprDeny;
    private Boolean isViewable;
    private WebViewAPI.WebClientErrorHandler errorHandler;
    @Nullable
    private WebViewObserver webViewObserver;

    public VungleWebClient(Advertisement advertisement, Placement placement) {
        this.advertisement = advertisement;
        this.placement = placement;
    }

    @Override
    public void setConsentStatus(boolean collectedConsent, @Nullable String title, @Nullable String message, @Nullable String accept, @Nullable String deny) {
        this.collectConsent = collectedConsent;
        this.gdprTitle = title;
        this.gdprBody = message;
        this.gdprAccept = accept;
        this.gdprDeny = deny;
    }

    @Override
    public void setMRAIDDelegate(WebViewAPI.MRAIDDelegate MRAIDDelegate2) {
        this.MRAIDDelegate = MRAIDDelegate2;
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        Log.d((String)TAG, (String)("MRAID Command " + url));
        if (TextUtils.isEmpty((CharSequence)url)) {
            Log.e((String)TAG, (String)"Invalid URL ");
            return false;
        }
        Uri uri = Uri.parse((String)url);
        if (uri.getScheme() != null) {
            String scheme = uri.getScheme();
            if (scheme.equals("mraid")) {
                String command = uri.getHost();
                if (command != null) {
                    if ("propertiesChangeCompleted".equals(command) && !this.ready) {
                        JsonObject mraidArgs = this.advertisement.createMRAIDArgs();
                        String injectJs = "window.vungle.mraidBridge.notifyReadyEvent(" + mraidArgs + ")";
                        this.runJavascriptOnWebView(view, injectJs);
                        this.ready = true;
                    } else if (this.MRAIDDelegate != null) {
                        JsonObject args = new JsonObject();
                        for (String param : uri.getQueryParameterNames()) {
                            args.addProperty(param, uri.getQueryParameter(param));
                        }
                        if (this.MRAIDDelegate.processCommand(command, args)) {
                            String injectJs = "window.vungle.mraidBridge.notifyCommandComplete()";
                            this.runJavascriptOnWebView(view, injectJs);
                        }
                    }
                    return true;
                }
                return false;
            }
            if ("http".equalsIgnoreCase(scheme) || "https".equalsIgnoreCase(scheme)) {
                Log.d((String)TAG, (String)("Open URL" + url));
                if (this.MRAIDDelegate != null) {
                    JsonObject args = new JsonObject();
                    args.addProperty("url", url);
                    this.MRAIDDelegate.processCommand("openNonMraid", args);
                }
                return true;
            }
        }
        return false;
    }

    public void onPageFinished(WebView webView, String url) {
        super.onPageFinished(webView, url);
        switch (this.advertisement.getAdType()) {
            case 0: {
                String inject = "function actionClicked(action){Android.performAction(action);};";
                this.runJavascriptOnWebView(webView, inject);
                break;
            }
            case 1: {
                this.loadedWebView = webView;
                this.loadedWebView.setVisibility(0);
                this.notifyPropertiesChange(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Client Type!");
            }
        }
        if (Build.VERSION.SDK_INT >= 29) {
            webView.setWebViewRenderProcessClient((WebViewRenderProcessClient)new VungleWebViewRenderProcessClient(this.errorHandler));
        }
        if (this.webViewObserver != null) {
            this.webViewObserver.onPageFinished(webView);
        }
    }

    @Override
    public void notifyPropertiesChange(boolean skipCmdQueue) {
        if (this.loadedWebView != null) {
            JsonObject screenJson = new JsonObject();
            JsonObject size = new JsonObject();
            size.addProperty("width", (Number)this.loadedWebView.getWidth());
            size.addProperty("height", (Number)this.loadedWebView.getHeight());
            JsonObject position = new JsonObject();
            position.addProperty("x", (Number)0);
            position.addProperty("y", (Number)0);
            position.addProperty("width", (Number)this.loadedWebView.getWidth());
            position.addProperty("height", (Number)this.loadedWebView.getHeight());
            JsonObject supports = new JsonObject();
            supports.addProperty("sms", Boolean.valueOf(false));
            supports.addProperty("tel", Boolean.valueOf(false));
            supports.addProperty("calendar", Boolean.valueOf(false));
            supports.addProperty("storePicture", Boolean.valueOf(false));
            supports.addProperty("inlineVideo", Boolean.valueOf(false));
            screenJson.add("maxSize", (JsonElement)size);
            screenJson.add("screenSize", (JsonElement)size);
            screenJson.add("defaultPosition", (JsonElement)position);
            screenJson.add("currentPosition", (JsonElement)position);
            screenJson.add("supports", (JsonElement)supports);
            screenJson.addProperty("placementType", this.advertisement.getTemplateType());
            if (this.isViewable != null) {
                screenJson.addProperty("isViewable", this.isViewable);
            }
            screenJson.addProperty("os", "android");
            screenJson.addProperty("osVersion", Integer.toString(Build.VERSION.SDK_INT));
            screenJson.addProperty("incentivized", Boolean.valueOf(this.placement.isIncentivized()));
            screenJson.addProperty("enableBackImmediately", Boolean.valueOf(this.advertisement.getShowCloseDelay(this.placement.isIncentivized()) == 0));
            screenJson.addProperty("version", "1.0");
            if (this.collectConsent) {
                screenJson.addProperty("consentRequired", Boolean.valueOf(true));
                screenJson.addProperty("consentTitleText", this.gdprTitle);
                screenJson.addProperty("consentBodyText", this.gdprBody);
                screenJson.addProperty("consentAcceptButtonText", this.gdprAccept);
                screenJson.addProperty("consentDenyButtonText", this.gdprDeny);
            } else {
                screenJson.addProperty("consentRequired", Boolean.valueOf(false));
            }
            screenJson.addProperty("sdkVersion", "6.10.1");
            Log.d((String)TAG, (String)("loadJsjavascript:window.vungle.mraidBridge.notifyPropertiesChange(" + screenJson + "," + skipCmdQueue + ")"));
            String injectJs = "window.vungle.mraidBridge.notifyPropertiesChange(" + screenJson + "," + skipCmdQueue + ")";
            this.runJavascriptOnWebView(this.loadedWebView, injectJs);
        }
    }

    @Override
    public void setAdVisibility(boolean isViewable) {
        this.isViewable = isViewable;
        this.notifyPropertiesChange(false);
    }

    @Override
    public void setErrorHandler(WebViewAPI.WebClientErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public void setWebViewObserver(WebViewObserver webViewObserver) {
        this.webViewObserver = webViewObserver;
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        super.onReceivedError(view, errorCode, description, failingUrl);
        if (Build.VERSION.SDK_INT < 23) {
            Log.e((String)TAG, (String)("Error desc " + description));
            Log.e((String)TAG, (String)("Error for URL " + failingUrl));
            this.handleWebViewError(description, failingUrl);
        }
    }

    public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
        super.onReceivedHttpError(view, request, errorResponse);
        if (Build.VERSION.SDK_INT >= 21) {
            Log.e((String)TAG, (String)("Error desc " + errorResponse.getStatusCode()));
            Log.e((String)TAG, (String)("Error for URL " + request.getUrl().toString()));
            this.handleWebViewError(String.valueOf(errorResponse.getStatusCode()), request.getUrl().toString());
        }
    }

    public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
        super.onReceivedError(view, request, error);
        if (Build.VERSION.SDK_INT >= 23) {
            Log.e((String)TAG, (String)("Error desc " + error.getDescription().toString()));
            Log.e((String)TAG, (String)("Error for URL " + request.getUrl().toString()));
            this.handleWebViewError(error.getDescription().toString(), request.getUrl().toString());
        }
    }

    private void handleWebViewError(String errorMsg, String url) {
        boolean criticalError = this.isCriticalAsset(url);
        String errorDesc = url + " " + errorMsg;
        if (this.errorHandler != null) {
            this.errorHandler.onReceivedError(errorDesc, criticalError);
        }
    }

    private boolean isCriticalAsset(String url) {
        if (!TextUtils.isEmpty((CharSequence)url) && this.advertisement != null) {
            Map<String, String> assets = this.advertisement.getDownloadableUrls();
            return assets.containsValue(url);
        }
        return false;
    }

    @TargetApi(value=26)
    public boolean onRenderProcessGone(WebView view, RenderProcessGoneDetail detail) {
        Log.w((String)TAG, (String)("onRenderProcessGone url: " + view.getUrl() + ",  did crash: " + detail.didCrash()));
        this.loadedWebView = null;
        if (this.errorHandler != null) {
            return this.errorHandler.onWebRenderingProcessGone(view, detail.didCrash());
        }
        return super.onRenderProcessGone(view, detail);
    }

    private void runJavascriptOnWebView(@NonNull WebView webView, @NonNull String injectJs) {
        if (Build.VERSION.SDK_INT >= 19) {
            webView.evaluateJavascript(injectJs, null);
        } else {
            webView.loadUrl("javascript:" + injectJs);
        }
    }

    @RequiresApi(value=29)
    static class VungleWebViewRenderProcessClient
    extends WebViewRenderProcessClient {
        WebViewAPI.WebClientErrorHandler errorHandler;

        VungleWebViewRenderProcessClient(WebViewAPI.WebClientErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
        }

        public void onRenderProcessUnresponsive(WebView webView, WebViewRenderProcess webViewRenderProcess) {
            Log.w((String)TAG, (String)("onRenderProcessUnresponsive(Title = " + webView.getTitle() + ", URL = " + webView.getOriginalUrl() + ", (webViewRenderProcess != null) = " + (webViewRenderProcess != null)));
            if (this.errorHandler != null) {
                this.errorHandler.onRenderProcessUnresponsive(webView, webViewRenderProcess);
            }
        }

        public void onRenderProcessResponsive(WebView webView, WebViewRenderProcess webViewRenderProcess) {
        }
    }
}

