/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.utility;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.vungle.warren.SessionData;
import com.vungle.warren.utility.ActivityManager;

public class AppSession {
    @Nullable
    private SessionData sessionData;
    @Nullable
    private SessionCallback sessionCallback;
    @VisibleForTesting
    ActivityManager.LifeCycleCallback appLifeCycleCallback = new ActivityManager.LifeCycleCallback(){
        private long timestamp;

        @Override
        public void onStart() {
            if (this.timestamp <= 0L) {
                return;
            }
            long duration = System.currentTimeMillis() - this.timestamp;
            if (AppSession.this.sessionData != null && AppSession.this.sessionData.getTimeout() > -1L && duration >= AppSession.this.sessionData.getTimeout() * 1000L && AppSession.this.sessionCallback != null) {
                AppSession.this.sessionCallback.onSessionTimeout();
            }
        }

        @Override
        public void onStop() {
            this.timestamp = System.currentTimeMillis();
        }
    };

    public AppSession setSessionData(@Nullable SessionData sessionData) {
        this.sessionData = sessionData;
        return this;
    }

    public AppSession setSessionCallback(@Nullable SessionCallback sessionCallback) {
        this.sessionCallback = sessionCallback;
        return this;
    }

    public void observe() {
        ActivityManager.getInstance().addListener(this.appLifeCycleCallback);
    }

    public static interface SessionCallback {
        public void onSessionTimeout();
    }
}

