package com.vungle.ads

/**
 * Callback interface for collecting bid tokens.
 */
interface BidTokenCallback {

    /**
     * Called when a bid token is collected.
     * @param bidToken the bid token with non-null value
     */
    fun onBidTokenCollected(bidToken: String)

    /**
     * Called when an error occurs while collecting a bid token.
     * @param errorMessage the error message when collect bid token failed
     */
    fun onBidTokenError(errorMessage: String)
}
