package com.vungle.ads.internal.signals

internal object SignalKey {

    // Timestamp of the ad session creation
    const val SESSION_CREATION_TIME = 100

    // UUID for separated sessions
    const val SESSION_ID = 101

    // Foreground Time duration for each ad session
    const val SESSION_DURATION = 102

    // Total session count in 24 hrs
    const val SESSION_COUNT = 103

    // Played ad count in one session, across all placement IDs.
    const val SESSION_DEPTH = 104

    // unclosed ad in previous session
    const val UNCLOSED_AD = 105

    // Sequential ad information, including all the ad lifecycle events.
    // Will only be valid for full screen ads on phrase 1.
    const val AD_SIGNAL = 106

    // Ad event id
    const val EVENT_ID = 107

    // Check the current visible activity / view controller screen orientation settings
    const val SCREEN_ORIENTATION = 108

    // The time difference between each ad load with the same placement.
    const val DURATION_AFTER_PREVIOUS_LOAD = 109

    // The time difference between ad loaded and ad shown.
    const val AD_LOADED_PLAYED_DURATION = 110

    // Signal from template. The VM team will pass the collected signal via mraid bridge,
    // this part is transparent to SDK.
    const val TEMPLATE_SIGNAL = 500

}
