package com.vungle.ads.internal.util

import android.graphics.Bitmap
import android.graphics.BitmapFactory
import java.util.concurrent.Executor

/**
 * ImageLoader for native ad assets and only for already cached local files currently.
 */
class ImageLoader private constructor() {
    private var ioExecutor: Executor? = null

    fun init(ioExecutor: Executor) {
        this.ioExecutor = ioExecutor
    }

    fun displayImage(uri: String?, onImageLoaded: (bitmap: Bitmap) -> Unit) {
        if (ioExecutor == null) {
            Logger.w(TAG, "ImageLoader not initialized.")
            return
        }
        if (uri.isNullOrEmpty()) {
            Logger.w(TAG, "the uri is required.")
            return
        }
        ioExecutor?.execute(Runnable {
            if (!uri.startsWith(FILE_SCHEME)) {
                return@Runnable
            }
            val assetFile = uri.substring(FILE_SCHEME.length)
            val bitmap = BitmapFactory.decodeFile(assetFile)
            if (bitmap != null) {
                onImageLoaded(bitmap)
            } else {
                Logger.w(TAG, "decode bitmap failed.")
            }
        })
    }

    fun getImageSize(uri: String?, onImageSizeLoaded: (width: Int, height: Int) -> Unit) {
        if (ioExecutor == null) {
            Logger.w(TAG, "ImageLoader not initialized.")
            return
        }
        if (uri.isNullOrEmpty()) {
            Logger.w(TAG, "the uri is required.")
            return
        }
        ioExecutor?.execute(Runnable {
            if (!uri.startsWith(FILE_SCHEME)) {
                return@Runnable
            }
            val assetFile = uri.substring(FILE_SCHEME.length)
            val options = BitmapFactory.Options()
            options.inJustDecodeBounds = true
            BitmapFactory.decodeFile(assetFile, options)
            onImageSizeLoaded(options.outWidth, options.outHeight)
        })
    }

    companion object {
        private val TAG = ImageLoader::class.java.simpleName
        private const val FILE_SCHEME = "file://"
        val instance = ImageLoader()
    }
}
