/*
 * Decompiled with CFR 0.152.
 */
package com.xsolla.android.payments;

import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.core.os.BundleKt;
import androidx.work.BackoffPolicy;
import androidx.work.Constraints;
import androidx.work.Data;
import androidx.work.NetworkType;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import com.xsolla.android.payments.data.AccessData;
import com.xsolla.android.payments.data.AccessToken;
import com.xsolla.android.payments.status.PaymentStatus;
import com.xsolla.android.payments.status.StatusWorker;
import com.xsolla.android.payments.ui.ActivityPaystation;
import com.xsolla.android.payments.ui.ActivityPaystationBrowserProxy;
import com.xsolla.android.payments.ui.ActivityPaystationWebView;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\b\u0018\u0000 \u00052\u00020\u0001:\u0006\u0003\u0004\u0005\u0006\u0007\bB\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\t"}, d2={"Lcom/xsolla/android/payments/XPayments;", "", "()V", "CheckTransactionResult", "CheckTransactionResultStatus", "Companion", "IntentBuilder", "Result", "Status", "xsolla-payments-sdk_release"})
public final class XPayments {
    @NotNull
    public static final String SERVER_PROD = "secure.xsolla.com";
    @NotNull
    public static final String SERVER_SANDBOX = "sandbox-secure.xsolla.com";
    @NotNull
    public static final String ACTION_STATUS = "com.xsolla.android.payments.status";
    @NotNull
    public static final String EXTRA_STATUS = "status";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @NotNull
    public static final IntentBuilder createIntentBuilder(@NotNull Context context) {
        return Companion.createIntentBuilder(context);
    }

    @JvmStatic
    @NotNull
    public static final String generateExternalId() {
        return Companion.generateExternalId();
    }

    @JvmStatic
    public static final void checkTransactionStatus(@NotNull Context context, int projectId, @NotNull String externalId) {
        Companion.checkTransactionStatus(context, projectId, externalId);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\b\u0010\u0014\u001a\u00020\u000fH\u0002J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\nH\u0007R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/xsolla/android/payments/XPayments$IntentBuilder;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "accessData", "Lcom/xsolla/android/payments/data/AccessData;", "accessToken", "Lcom/xsolla/android/payments/data/AccessToken;", "isSandbox", "", "useWebview", "build", "Landroid/content/Intent;", "generateUrl", "", "getActivityClass", "Ljava/lang/Class;", "Lcom/xsolla/android/payments/ui/ActivityPaystation;", "url", "getServer", "xsolla-payments-sdk_release"})
    public static final class IntentBuilder {
        private AccessToken accessToken;
        private AccessData accessData;
        private boolean isSandbox;
        private boolean useWebview;
        private final Context context;

        @NotNull
        public final IntentBuilder accessToken(@NotNull AccessToken accessToken) {
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            IntentBuilder intentBuilder = this;
            boolean bl = false;
            boolean bl2 = false;
            IntentBuilder $this$apply = intentBuilder;
            boolean bl3 = false;
            $this$apply.accessToken = accessToken;
            return intentBuilder;
        }

        @NotNull
        public final IntentBuilder accessData(@NotNull AccessData accessData) {
            Intrinsics.checkNotNullParameter((Object)accessData, (String)"accessData");
            IntentBuilder intentBuilder = this;
            boolean bl = false;
            boolean bl2 = false;
            IntentBuilder $this$apply = intentBuilder;
            boolean bl3 = false;
            $this$apply.accessData = accessData;
            return intentBuilder;
        }

        @NotNull
        public final IntentBuilder isSandbox(boolean isSandbox) {
            IntentBuilder intentBuilder = this;
            boolean bl = false;
            boolean bl2 = false;
            IntentBuilder $this$apply = intentBuilder;
            boolean bl3 = false;
            $this$apply.isSandbox = isSandbox;
            return intentBuilder;
        }

        @Deprecated(message="WebView usage is not recommended")
        @NotNull
        public final IntentBuilder useWebview(boolean useWebview) {
            IntentBuilder intentBuilder = this;
            boolean bl = false;
            boolean bl2 = false;
            IntentBuilder $this$apply = intentBuilder;
            boolean bl3 = false;
            $this$apply.useWebview = useWebview;
            return intentBuilder;
        }

        @NotNull
        public final Intent build() {
            String url = this.generateUrl();
            Intent intent = new Intent();
            intent.setClass(this.context, this.getActivityClass(url));
            intent.putExtras(BundleKt.bundleOf((Pair[])new Pair[]{TuplesKt.to((Object)"token", (Object)url)}));
            return intent;
        }

        private final Class<? extends ActivityPaystation> getActivityClass(String url) {
            Class clazz;
            if (this.useWebview) {
                clazz = ActivityPaystationWebView.class;
            } else if (ActivityPaystationBrowserProxy.Companion.checkAvailability(this.context, url)) {
                clazz = ActivityPaystationBrowserProxy.class;
            } else {
                Log.d((String)XPayments.class.getSimpleName(), (String)"Browser is not available");
                clazz = ActivityPaystationWebView.class;
            }
            return clazz;
        }

        private final String generateUrl() {
            AccessToken accessToken = this.accessToken;
            if (accessToken != null) {
                AccessToken accessToken2 = accessToken;
                boolean bl = false;
                boolean bl2 = false;
                AccessToken it = accessToken2;
                boolean bl3 = false;
                return "https://" + this.getServer() + "/paystation3/?access_token=" + it.getToken();
            }
            AccessData accessData = this.accessData;
            if (accessData != null) {
                AccessData accessData2 = accessData;
                boolean bl = false;
                boolean bl4 = false;
                AccessData it = accessData2;
                boolean bl5 = false;
                return "https://" + this.getServer() + "/paystation3/?access_data=" + it.getUrlencodedString();
            }
            throw (Throwable)new IllegalArgumentException("access token or access data isn't specified");
        }

        private final String getServer() {
            return this.isSandbox ? XPayments.SERVER_SANDBOX : XPayments.SERVER_PROD;
        }

        public IntentBuilder(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.context = context;
            this.isSandbox = true;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001J\u0019\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000fH\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lcom/xsolla/android/payments/XPayments$Result;", "Landroid/os/Parcelable;", "status", "Lcom/xsolla/android/payments/XPayments$Status;", "invoiceId", "", "(Lcom/xsolla/android/payments/XPayments$Status;Ljava/lang/String;)V", "getInvoiceId", "()Ljava/lang/String;", "getStatus", "()Lcom/xsolla/android/payments/XPayments$Status;", "component1", "component2", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "Companion", "xsolla-payments-sdk_release"})
    @Parcelize
    public static final class Result
    implements Parcelable {
        @NotNull
        private final Status status;
        @Nullable
        private final String invoiceId;
        @NotNull
        public static final Companion Companion = new Companion(null);
        public static final Parcelable.Creator<Result> CREATOR = new Creator();

        @NotNull
        public final Status getStatus() {
            return this.status;
        }

        @Nullable
        public final String getInvoiceId() {
            return this.invoiceId;
        }

        public Result(@NotNull Status status, @Nullable String invoiceId) {
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)XPayments.EXTRA_STATUS);
            this.status = status;
            this.invoiceId = invoiceId;
        }

        @NotNull
        public final Status component1() {
            return this.status;
        }

        @Nullable
        public final String component2() {
            return this.invoiceId;
        }

        @NotNull
        public final Result copy(@NotNull Status status, @Nullable String invoiceId) {
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)XPayments.EXTRA_STATUS);
            return new Result(status, invoiceId);
        }

        public static /* synthetic */ Result copy$default(Result result, Status status, String string, int n, Object object) {
            if ((n & 1) != 0) {
                status = result.status;
            }
            if ((n & 2) != 0) {
                string = result.invoiceId;
            }
            return result.copy(status, string);
        }

        @NotNull
        public String toString() {
            return "Result(status=" + (Object)((Object)this.status) + ", invoiceId=" + this.invoiceId + ")";
        }

        public int hashCode() {
            Status status = this.status;
            String string = this.invoiceId;
            return (status != null ? ((Object)((Object)status)).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Result)) break block3;
                    Result result = (Result)object;
                    if (!Intrinsics.areEqual((Object)((Object)this.status), (Object)((Object)result.status)) || !Intrinsics.areEqual((Object)this.invoiceId, (Object)result.invoiceId)) break block3;
                }
                return true;
            }
            return false;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel parcel, int flags) {
            Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
            parcel.writeString(this.status.name());
            parcel.writeString(this.invoiceId);
        }

        @JvmStatic
        @NotNull
        public static final Result fromResultIntent(@Nullable Intent intent) {
            return Companion.fromResultIntent(intent);
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3)
        public static final class Creator
        implements Parcelable.Creator<Result> {
            @NotNull
            public final Result[] newArray(int size) {
                return new Result[size];
            }

            @NotNull
            public final Result createFromParcel(@NotNull Parcel in) {
                Intrinsics.checkNotNullParameter((Object)in, (String)"in");
                return new Result(Enum.valueOf(Status.class, in.readString()), in.readString());
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/xsolla/android/payments/XPayments$Result$Companion;", "", "()V", "fromResultIntent", "Lcom/xsolla/android/payments/XPayments$Result;", "intent", "Landroid/content/Intent;", "xsolla-payments-sdk_release"})
        public static final class Companion {
            @JvmStatic
            @NotNull
            public final Result fromResultIntent(@Nullable Intent intent) {
                Object object = intent;
                if (object == null || (object = (Result)object.getParcelableExtra("result")) == null) {
                    object = new Result(Status.UNKNOWN, null);
                }
                return object;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/xsolla/android/payments/XPayments$Status;", "", "(Ljava/lang/String;I)V", "COMPLETED", "CANCELLED", "UNKNOWN", "xsolla-payments-sdk_release"})
    public static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status COMPLETED;
        public static final /* enum */ Status CANCELLED;
        public static final /* enum */ Status UNKNOWN;
        private static final /* synthetic */ Status[] $VALUES;

        static {
            Status[] statusArray = new Status[3];
            Status[] statusArray2 = statusArray;
            statusArray[0] = COMPLETED = new Status();
            statusArray[1] = CANCELLED = new Status();
            statusArray[2] = UNKNOWN = new Status();
            $VALUES = statusArray;
        }

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String string) {
            return Enum.valueOf(Status.class, string);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J+\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0007H\u00d6\u0001J\u0019\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0014H\u00d6\u0001R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006 "}, d2={"Lcom/xsolla/android/payments/XPayments$CheckTransactionResult;", "Landroid/os/Parcelable;", "status", "Lcom/xsolla/android/payments/XPayments$CheckTransactionResultStatus;", "paymentStatus", "Lcom/xsolla/android/payments/status/PaymentStatus;", "errorMessage", "", "(Lcom/xsolla/android/payments/XPayments$CheckTransactionResultStatus;Lcom/xsolla/android/payments/status/PaymentStatus;Ljava/lang/String;)V", "getErrorMessage", "()Ljava/lang/String;", "getPaymentStatus", "()Lcom/xsolla/android/payments/status/PaymentStatus;", "getStatus", "()Lcom/xsolla/android/payments/XPayments$CheckTransactionResultStatus;", "component1", "component2", "component3", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "xsolla-payments-sdk_release"})
    @Parcelize
    public static final class CheckTransactionResult
    implements Parcelable {
        @NotNull
        private final CheckTransactionResultStatus status;
        @Nullable
        private final PaymentStatus paymentStatus;
        @Nullable
        private final String errorMessage;
        public static final Parcelable.Creator<CheckTransactionResult> CREATOR = new Creator();

        @NotNull
        public final CheckTransactionResultStatus getStatus() {
            return this.status;
        }

        @Nullable
        public final PaymentStatus getPaymentStatus() {
            return this.paymentStatus;
        }

        @Nullable
        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public CheckTransactionResult(@NotNull CheckTransactionResultStatus status, @Nullable PaymentStatus paymentStatus, @Nullable String errorMessage) {
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)XPayments.EXTRA_STATUS);
            this.status = status;
            this.paymentStatus = paymentStatus;
            this.errorMessage = errorMessage;
        }

        @NotNull
        public final CheckTransactionResultStatus component1() {
            return this.status;
        }

        @Nullable
        public final PaymentStatus component2() {
            return this.paymentStatus;
        }

        @Nullable
        public final String component3() {
            return this.errorMessage;
        }

        @NotNull
        public final CheckTransactionResult copy(@NotNull CheckTransactionResultStatus status, @Nullable PaymentStatus paymentStatus, @Nullable String errorMessage) {
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)XPayments.EXTRA_STATUS);
            return new CheckTransactionResult(status, paymentStatus, errorMessage);
        }

        public static /* synthetic */ CheckTransactionResult copy$default(CheckTransactionResult checkTransactionResult, CheckTransactionResultStatus checkTransactionResultStatus, PaymentStatus paymentStatus, String string, int n, Object object) {
            if ((n & 1) != 0) {
                checkTransactionResultStatus = checkTransactionResult.status;
            }
            if ((n & 2) != 0) {
                paymentStatus = checkTransactionResult.paymentStatus;
            }
            if ((n & 4) != 0) {
                string = checkTransactionResult.errorMessage;
            }
            return checkTransactionResult.copy(checkTransactionResultStatus, paymentStatus, string);
        }

        @NotNull
        public String toString() {
            return "CheckTransactionResult(status=" + (Object)((Object)this.status) + ", paymentStatus=" + this.paymentStatus + ", errorMessage=" + this.errorMessage + ")";
        }

        public int hashCode() {
            CheckTransactionResultStatus checkTransactionResultStatus = this.status;
            PaymentStatus paymentStatus = this.paymentStatus;
            String string = this.errorMessage;
            return ((checkTransactionResultStatus != null ? ((Object)((Object)checkTransactionResultStatus)).hashCode() : 0) * 31 + (paymentStatus != null ? ((Object)paymentStatus).hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CheckTransactionResult)) break block3;
                    CheckTransactionResult checkTransactionResult = (CheckTransactionResult)object;
                    if (!Intrinsics.areEqual((Object)((Object)this.status), (Object)((Object)checkTransactionResult.status)) || !Intrinsics.areEqual((Object)this.paymentStatus, (Object)checkTransactionResult.paymentStatus) || !Intrinsics.areEqual((Object)this.errorMessage, (Object)checkTransactionResult.errorMessage)) break block3;
                }
                return true;
            }
            return false;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel parcel, int flags) {
            Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
            parcel.writeString(this.status.name());
            Parcel parcel2 = parcel;
            PaymentStatus paymentStatus = this.paymentStatus;
            if (paymentStatus != null) {
                parcel.writeInt(1);
                paymentStatus.writeToParcel(parcel2, 0);
            } else {
                parcel2.writeInt(0);
            }
            parcel.writeString(this.errorMessage);
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3)
        public static final class Creator
        implements Parcelable.Creator<CheckTransactionResult> {
            @NotNull
            public final CheckTransactionResult[] newArray(int size) {
                return new CheckTransactionResult[size];
            }

            @NotNull
            public final CheckTransactionResult createFromParcel(@NotNull Parcel in) {
                Intrinsics.checkNotNullParameter((Object)in, (String)"in");
                return new CheckTransactionResult(Enum.valueOf(CheckTransactionResultStatus.class, in.readString()), in.readInt() != 0 ? (PaymentStatus)PaymentStatus.CREATOR.createFromParcel(in) : null, in.readString());
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/xsolla/android/payments/XPayments$CheckTransactionResultStatus;", "", "(Ljava/lang/String;I)V", "SUCCESS", "FAIL", "xsolla-payments-sdk_release"})
    public static final class CheckTransactionResultStatus
    extends Enum<CheckTransactionResultStatus> {
        public static final /* enum */ CheckTransactionResultStatus SUCCESS;
        public static final /* enum */ CheckTransactionResultStatus FAIL;
        private static final /* synthetic */ CheckTransactionResultStatus[] $VALUES;

        static {
            CheckTransactionResultStatus[] checkTransactionResultStatusArray = new CheckTransactionResultStatus[2];
            CheckTransactionResultStatus[] checkTransactionResultStatusArray2 = checkTransactionResultStatusArray;
            checkTransactionResultStatusArray[0] = SUCCESS = new CheckTransactionResultStatus();
            checkTransactionResultStatusArray[1] = FAIL = new CheckTransactionResultStatus();
            $VALUES = checkTransactionResultStatusArray;
        }

        public static CheckTransactionResultStatus[] values() {
            return (CheckTransactionResultStatus[])$VALUES.clone();
        }

        public static CheckTransactionResultStatus valueOf(String string) {
            return Enum.valueOf(CheckTransactionResultStatus.class, string);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0007J\b\u0010\u0011\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/xsolla/android/payments/XPayments$Companion;", "", "()V", "ACTION_STATUS", "", "EXTRA_STATUS", "SERVER_PROD", "SERVER_SANDBOX", "checkTransactionStatus", "", "context", "Landroid/content/Context;", "projectId", "", "externalId", "createIntentBuilder", "Lcom/xsolla/android/payments/XPayments$IntentBuilder;", "generateExternalId", "xsolla-payments-sdk_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final IntentBuilder createIntentBuilder(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new IntentBuilder(context);
        }

        @JvmStatic
        @NotNull
        public final String generateExternalId() {
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UUID.randomUUID().toString()");
            return string;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void checkTransactionStatus(@NotNull Context context, int projectId, @NotNull String externalId) {
            void pairs$iv;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)externalId, (String)"externalId");
            Constraints constraints = new Constraints.Builder().setRequiredNetworkType(NetworkType.CONNECTED).build();
            Intrinsics.checkNotNullExpressionValue((Object)constraints, (String)"Constraints.Builder()\n  \u2026                 .build()");
            Constraints constraints2 = constraints;
            boolean $i$f$OneTimeWorkRequestBuilder22 = false;
            Pair[] $i$f$OneTimeWorkRequestBuilder22 = new Pair[]{TuplesKt.to((Object)"PROJECT_ID", (Object)projectId), TuplesKt.to((Object)"EXTERNAL_ID", (Object)externalId), TuplesKt.to((Object)"START_TIME", (Object)System.currentTimeMillis())};
            OneTimeWorkRequest.Builder builder = new OneTimeWorkRequest.Builder(StatusWorker.class);
            boolean $i$f$workDataOf = false;
            Data.Builder dataBuilder$iv = new Data.Builder();
            for (void pair$iv : pairs$iv) {
                dataBuilder$iv.put((String)pair$iv.getFirst(), pair$iv.getSecond());
            }
            Data data = dataBuilder$iv.build();
            Intrinsics.checkExpressionValueIsNotNull((Object)data, (String)"dataBuilder.build()");
            Data data2 = data;
            WorkRequest workRequest = ((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)builder.setInputData(data2)).setConstraints(constraints2)).setBackoffCriteria(BackoffPolicy.LINEAR, 10000L, TimeUnit.MILLISECONDS)).setInitialDelay(15L, TimeUnit.SECONDS)).build();
            Intrinsics.checkNotNullExpressionValue((Object)workRequest, (String)"OneTimeWorkRequestBuilde\u2026                 .build()");
            OneTimeWorkRequest workRequest2 = (OneTimeWorkRequest)workRequest;
            WorkManager.getInstance((Context)context).enqueue((WorkRequest)workRequest2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

