/*
 * Decompiled with CFR 0.152.
 */
package com.xsolla.android.payments.data;

import android.os.Build;
import java.net.URLEncoder;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002\u000f\u0010BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u0012\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u000e\u001a\u00020\u0005R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/xsolla/android/payments/data/AccessData;", "", "projectId", "", "userId", "", "isSandbox", "", "theme", "externalId", "virtualItems", "", "Lcom/xsolla/android/payments/data/AccessData$VirtualItem;", "(ILjava/lang/String;ZLjava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getUrlencodedString", "Builder", "VirtualItem", "xsolla-payments-sdk_release"})
public final class AccessData {
    private final int projectId;
    private final String userId;
    private final boolean isSandbox;
    private final String theme;
    private final String externalId;
    private final List<VirtualItem> virtualItems;

    @NotNull
    public final String getUrlencodedString() {
        JSONObject root = new JSONObject();
        JSONObject user = new JSONObject();
        JSONObject id = new JSONObject();
        id.put("value", (Object)this.userId);
        user.put("id", (Object)id);
        root.put("user", (Object)user);
        JSONObject settings = new JSONObject();
        settings.put("project_id", this.projectId);
        if (this.isSandbox) {
            settings.put("mode", (Object)"sandbox");
        }
        JSONObject ui = new JSONObject();
        if (this.theme != null) {
            ui.put("theme", (Object)this.theme);
        }
        settings.put("ui", (Object)ui);
        if (this.externalId != null) {
            settings.put("external_id", (Object)this.externalId);
        }
        settings.put("xsolla_product_tag", (Object)("SDK-payments_ver-0.16.0_integr-serverless_engine-android_enginever-" + Build.VERSION.RELEASE));
        root.put("settings", (Object)settings);
        if (this.virtualItems != null) {
            JSONObject purchase = new JSONObject();
            JSONObject virtual_items = new JSONObject();
            JSONArray items = new JSONArray();
            Iterable $this$forEach$iv = this.virtualItems;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VirtualItem it = (VirtualItem)element$iv;
                boolean bl = false;
                JSONObject itemsItem = new JSONObject();
                itemsItem.put("sku", (Object)it.getSku());
                itemsItem.put("amount", it.getAmount());
                items.put((Object)itemsItem);
            }
            virtual_items.put("items", (Object)items);
            purchase.put("virtual_items", (Object)virtual_items);
            root.put("purchase", (Object)purchase);
        }
        String string = root.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"root.toString()");
        String jsonString = string;
        String string2 = URLEncoder.encode(jsonString, "UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"URLEncoder.encode(jsonString, \"UTF-8\")");
        return string2;
    }

    public AccessData(int projectId, @NotNull String userId, boolean isSandbox, @Nullable String theme, @Nullable String externalId, @Nullable List<VirtualItem> virtualItems) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        this.projectId = projectId;
        this.userId = userId;
        this.isSandbox = isSandbox;
        this.theme = theme;
        this.externalId = externalId;
        this.virtualItems = virtualItems;
    }

    public /* synthetic */ AccessData(int n, String string, boolean bl, String string2, String string3, List list, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            string2 = null;
        }
        this(n, string, bl, string2, string3, list);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/xsolla/android/payments/data/AccessData$VirtualItem;", "", "sku", "", "amount", "", "(Ljava/lang/String;I)V", "getAmount", "()I", "getSku", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "xsolla-payments-sdk_release"})
    public static final class VirtualItem {
        @NotNull
        private final String sku;
        private final int amount;

        @NotNull
        public final String getSku() {
            return this.sku;
        }

        public final int getAmount() {
            return this.amount;
        }

        public VirtualItem(@NotNull String sku, int amount) {
            Intrinsics.checkNotNullParameter((Object)sku, (String)"sku");
            this.sku = sku;
            this.amount = amount;
        }

        @NotNull
        public final String component1() {
            return this.sku;
        }

        public final int component2() {
            return this.amount;
        }

        @NotNull
        public final VirtualItem copy(@NotNull String sku, int amount) {
            Intrinsics.checkNotNullParameter((Object)sku, (String)"sku");
            return new VirtualItem(sku, amount);
        }

        public static /* synthetic */ VirtualItem copy$default(VirtualItem virtualItem, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = virtualItem.sku;
            }
            if ((n2 & 2) != 0) {
                n = virtualItem.amount;
            }
            return virtualItem.copy(string, n);
        }

        @NotNull
        public String toString() {
            return "VirtualItem(sku=" + this.sku + ", amount=" + this.amount + ")";
        }

        public int hashCode() {
            String string = this.sku;
            return (string != null ? string.hashCode() : 0) * 31 + Integer.hashCode(this.amount);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof VirtualItem)) break block3;
                    VirtualItem virtualItem = (VirtualItem)object;
                    if (!Intrinsics.areEqual((Object)this.sku, (Object)virtualItem.sku) || this.amount != virtualItem.amount) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0004J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0004J\u0014\u0010\f\u001a\u00020\u00002\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/xsolla/android/payments/data/AccessData$Builder;", "", "()V", "externalId", "", "isSandbox", "", "projectId", "", "Ljava/lang/Integer;", "theme", "userId", "virtualItems", "", "Lcom/xsolla/android/payments/data/AccessData$VirtualItem;", "build", "Lcom/xsolla/android/payments/data/AccessData;", "xsolla-payments-sdk_release"})
    public static final class Builder {
        private Integer projectId;
        private String userId;
        private boolean isSandbox = true;
        private String theme;
        private String externalId;
        private List<VirtualItem> virtualItems;

        @NotNull
        public final Builder projectId(int projectId) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.projectId = projectId;
            return builder;
        }

        @NotNull
        public final Builder userId(@NotNull String userId) {
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.userId = userId;
            return builder;
        }

        @NotNull
        public final Builder isSandbox(boolean isSandbox) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.isSandbox = isSandbox;
            return builder;
        }

        @NotNull
        public final Builder theme(@NotNull String theme) {
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.theme = theme;
            return builder;
        }

        @NotNull
        public final Builder externalId(@NotNull String externalId) {
            Intrinsics.checkNotNullParameter((Object)externalId, (String)"externalId");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.externalId = externalId;
            return builder;
        }

        @NotNull
        public final Builder virtualItems(@NotNull List<VirtualItem> virtualItems) {
            Intrinsics.checkNotNullParameter(virtualItems, (String)"virtualItems");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.virtualItems = virtualItems;
            return builder;
        }

        @NotNull
        public final AccessData build() {
            Integer n = this.projectId;
            if (n == null) {
                throw (Throwable)new IllegalArgumentException();
            }
            int projectId = n;
            String string = this.userId;
            if (string == null) {
                throw (Throwable)new IllegalArgumentException();
            }
            String userId = string;
            return new AccessData(projectId, userId, this.isSandbox, this.theme, this.externalId, this.virtualItems);
        }
    }
}

