/*
 * Decompiled with CFR 0.152.
 */
package com.xsolla.android.payments.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import com.xsolla.android.payments.XPayments;
import com.xsolla.android.payments.ui.ActivityPaystation;
import com.xsolla.android.payments.ui.utils.BrowserUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0014J\u0012\u0010\u0010\u001a\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J\b\u0010\u0013\u001a\u00020\bH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/xsolla/android/payments/ui/ActivityPaystationBrowserProxy;", "Lcom/xsolla/android/payments/ui/ActivityPaystation;", "()V", "needStartBrowser", "", "url", "", "finishWithResult", "", "resultCode", "", "resultData", "Lcom/xsolla/android/payments/XPayments$Result;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onNewIntent", "intent", "Landroid/content/Intent;", "onResume", "Companion", "xsolla-payments-sdk_release"})
public final class ActivityPaystationBrowserProxy
extends ActivityPaystation {
    private boolean needStartBrowser;
    private String url;
    @NotNull
    public static final Companion Companion = new Companion(null);

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        String url = this.getIntent().getStringExtra("token");
        if (url == null) {
            this.finish();
            return;
        }
        if (savedInstanceState == null) {
            this.needStartBrowser = true;
            this.url = url;
        }
    }

    protected void onNewIntent(@Nullable Intent intent) {
        Uri uri;
        super.onNewIntent(intent);
        Intent intent2 = intent;
        Object object = uri = intent2 != null ? intent2.getData() : null;
        if (uri == null) {
            this.finish();
            return;
        }
        String invoiceId = uri.getQueryParameter("invoice_id");
        this.finishWithResult(-1, new XPayments.Result(XPayments.Status.COMPLETED, invoiceId));
    }

    protected void onResume() {
        super.onResume();
        if (this.needStartBrowser) {
            Context context = (Context)this;
            String string2 = this.url;
            if (string2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"url");
            }
            if (BrowserUtils.INSTANCE.isCustomTabsAvailable(context, string2)) {
                Context context2 = (Context)this;
                String string3 = this.url;
                if (string3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"url");
                }
                BrowserUtils.INSTANCE.launchCustomTab(context2, string3);
            } else {
                Activity activity = (Activity)this;
                String string4 = this.url;
                if (string4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"url");
                }
                BrowserUtils.INSTANCE.launchBrowser(activity, string4);
            }
            this.needStartBrowser = false;
        } else {
            this.finishWithResult(0, new XPayments.Result(XPayments.Status.CANCELLED, null));
        }
    }

    private final void finishWithResult(int resultCode, XPayments.Result resultData) {
        Intent intent = new Intent();
        intent.putExtra("result", (Parcelable)resultData);
        this.setResult(resultCode, intent);
        this.finish();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/xsolla/android/payments/ui/ActivityPaystationBrowserProxy$Companion;", "", "()V", "checkAvailability", "", "context", "Landroid/content/Context;", "url", "", "xsolla-payments-sdk_release"})
    public static final class Companion {
        public final boolean checkAvailability(@NotNull Context context, @NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return BrowserUtils.INSTANCE.isBrowserAvailable(context, url) || BrowserUtils.INSTANCE.isCustomTabsAvailable(context, url);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

