/*
 * Decompiled with CFR 0.152.
 */
package com.xsolla.android.payments.ui.utils;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import androidx.browser.customtabs.CustomTabColorSchemeParams;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.core.content.ContextCompat;
import com.xsolla.android.payments.R;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0010\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0011"}, d2={"Lcom/xsolla/android/payments/ui/utils/BrowserUtils;", "", "()V", "createBrowserIntent", "Landroid/content/Intent;", "url", "", "isBrowserAvailable", "", "context", "Landroid/content/Context;", "isCustomTabsAvailable", "launchBrowser", "", "activity", "Landroid/app/Activity;", "launchCustomTab", "xsolla-payments-sdk_release"})
public final class BrowserUtils {
    @NotNull
    public static final BrowserUtils INSTANCE;

    public final boolean isCustomTabsAvailable(@NotNull Context context, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        PackageManager pm = context.getPackageManager();
        Intent intent = new Intent().setAction("android.intent.action.VIEW").addCategory("android.intent.category.BROWSABLE").setData(Uri.parse((String)url));
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent()\n            .se\u2026 .setData(Uri.parse(url))");
        Intent activityIntent = intent;
        List activities = pm.queryIntentActivities(activityIntent, 0);
        for (ResolveInfo info : activities) {
            Intent serviceIntent;
            Intrinsics.checkNotNullExpressionValue((Object)new Intent().setAction("android.support.customtabs.action.CustomTabsService").setPackage(info.activityInfo.packageName), (String)"Intent()\n               \u2026activityInfo.packageName)");
            if (pm.resolveService(serviceIntent, 0) == null) continue;
            return true;
        }
        return false;
    }

    public final boolean isBrowserAvailable(@NotNull Context context, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.createBrowserIntent(url).resolveActivity(context.getPackageManager()) != null;
    }

    public final void launchCustomTab(@NotNull Context context, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        CustomTabColorSchemeParams customTabColorSchemeParams = new CustomTabColorSchemeParams.Builder().setNavigationBarColor(ContextCompat.getColor((Context)context, (int)R.color.xsolla_payments_tab)).setToolbarColor(ContextCompat.getColor((Context)context, (int)R.color.xsolla_payments_tab)).setSecondaryToolbarColor(ContextCompat.getColor((Context)context, (int)R.color.xsolla_payments_tab)).build();
        Intrinsics.checkNotNullExpressionValue((Object)customTabColorSchemeParams, (String)"CustomTabColorSchemePara\u2026   )\n            .build()");
        CustomTabColorSchemeParams colorSchemeParams = customTabColorSchemeParams;
        CustomTabsIntent customTabsIntent = new CustomTabsIntent.Builder().setDefaultColorSchemeParams(colorSchemeParams).setShowTitle(true).setUrlBarHidingEnabled(true).build();
        Intrinsics.checkNotNullExpressionValue((Object)customTabsIntent, (String)"CustomTabsIntent.Builder\u2026rue)\n            .build()");
        CustomTabsIntent intent = customTabsIntent;
        intent.launchUrl(context, Uri.parse((String)url));
    }

    public final void launchBrowser(@NotNull Activity activity, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        activity.startActivity(this.createBrowserIntent(url));
    }

    private final Intent createBrowserIntent(String url) {
        Intent intent = new Intent("android.intent.action.VIEW").setData(Uri.parse((String)url));
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent(Intent.ACTION_VIEW).setData(Uri.parse(url))");
        return intent;
    }

    private BrowserUtils() {
    }

    static {
        BrowserUtils browserUtils;
        INSTANCE = browserUtils = new BrowserUtils();
    }
}

