/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.metrica;

import android.location.Location;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.yandex.metrica.PreloadInfo;
import com.yandex.metrica.impl.ob.abk;
import com.yandex.metrica.impl.ob.abo;
import com.yandex.metrica.impl.ob.abp;
import com.yandex.metrica.impl.ob.bj;
import com.yandex.metrica.impl.ob.dk;

public class YandexMetricaConfig {
    @NonNull
    public final String apiKey;
    @Nullable
    public final String appVersion;
    @Nullable
    public final Integer sessionTimeout;
    @Nullable
    public final Boolean crashReporting;
    @Nullable
    public final Boolean nativeCrashReporting;
    @Nullable
    public final Location location;
    @Nullable
    public final Boolean locationTracking;
    @Nullable
    public final Boolean installedAppCollecting;
    @Nullable
    public final Boolean logs;
    @Nullable
    public final PreloadInfo preloadInfo;
    @Nullable
    public final Boolean firstActivationAsUpdate;
    @Nullable
    public final Boolean statisticsSending;
    @Nullable
    public final Integer maxReportsInDatabaseCount;

    @NonNull
    public static Builder newConfigBuilder(@NonNull String apiKey) {
        return new Builder(apiKey);
    }

    public static YandexMetricaConfig fromJson(String json) {
        return new bj().a(json);
    }

    protected YandexMetricaConfig(@NonNull Builder builder) {
        this.apiKey = builder.b;
        this.appVersion = builder.c;
        this.sessionTimeout = builder.d;
        this.crashReporting = builder.e;
        this.nativeCrashReporting = builder.f;
        this.location = builder.g;
        this.locationTracking = builder.h;
        this.installedAppCollecting = builder.i;
        this.logs = builder.j;
        this.preloadInfo = builder.k;
        this.firstActivationAsUpdate = builder.l;
        this.statisticsSending = builder.m;
        this.maxReportsInDatabaseCount = builder.n;
    }

    protected YandexMetricaConfig(@NonNull YandexMetricaConfig source) {
        this.apiKey = source.apiKey;
        this.appVersion = source.appVersion;
        this.sessionTimeout = source.sessionTimeout;
        this.crashReporting = source.crashReporting;
        this.nativeCrashReporting = source.nativeCrashReporting;
        this.location = source.location;
        this.locationTracking = source.locationTracking;
        this.installedAppCollecting = source.installedAppCollecting;
        this.logs = source.logs;
        this.preloadInfo = source.preloadInfo;
        this.firstActivationAsUpdate = source.firstActivationAsUpdate;
        this.statisticsSending = source.statisticsSending;
        this.maxReportsInDatabaseCount = source.maxReportsInDatabaseCount;
    }

    @NonNull
    public static Builder createBuilderFromConfig(@NonNull YandexMetricaConfig source) {
        Builder builder = YandexMetricaConfig.newConfigBuilder(source.apiKey);
        if (dk.a((Object)source.appVersion)) {
            builder.withAppVersion(source.appVersion);
        }
        if (dk.a(source.sessionTimeout)) {
            builder.withSessionTimeout(source.sessionTimeout);
        }
        if (dk.a(source.crashReporting)) {
            builder.withCrashReporting(source.crashReporting);
        }
        if (dk.a(source.nativeCrashReporting)) {
            builder.withNativeCrashReporting(source.nativeCrashReporting);
        }
        if (dk.a(source.location)) {
            builder.withLocation(source.location);
        }
        if (dk.a(source.locationTracking)) {
            builder.withLocationTracking(source.locationTracking);
        }
        if (dk.a(source.installedAppCollecting)) {
            builder.withInstalledAppCollecting(source.installedAppCollecting);
        }
        if (dk.a(source.logs) && source.logs.booleanValue()) {
            builder.withLogs();
        }
        if (dk.a(source.preloadInfo)) {
            builder.withPreloadInfo(source.preloadInfo);
        }
        if (dk.a(source.firstActivationAsUpdate)) {
            builder.handleFirstActivationAsUpdate(source.firstActivationAsUpdate);
        }
        if (dk.a(source.statisticsSending)) {
            builder.withStatisticsSending(source.statisticsSending);
        }
        if (dk.a(source.maxReportsInDatabaseCount)) {
            builder.withMaxReportsInDatabaseCount(source.maxReportsInDatabaseCount);
        }
        return builder;
    }

    public String toJson() {
        return new bj().a(this);
    }

    public static class Builder {
        private static final abo<String> a = new abk<String>(new abp());
        @NonNull
        private final String b;
        @Nullable
        private String c;
        @Nullable
        private Integer d;
        @Nullable
        private Boolean e;
        @Nullable
        private Boolean f;
        @Nullable
        private Location g;
        @Nullable
        private Boolean h;
        @Nullable
        private Boolean i;
        @Nullable
        private Boolean j;
        @Nullable
        private PreloadInfo k;
        @Nullable
        private Boolean l;
        @Nullable
        private Boolean m;
        @Nullable
        private Integer n;

        protected Builder(@NonNull String apiKey) {
            a.a(apiKey);
            this.b = apiKey;
        }

        @NonNull
        public Builder withAppVersion(@Nullable String appVersion) {
            this.c = appVersion;
            return this;
        }

        @NonNull
        public Builder withSessionTimeout(int sessionTimeout) {
            this.d = sessionTimeout;
            return this;
        }

        @NonNull
        public Builder withCrashReporting(boolean enabled) {
            this.e = enabled;
            return this;
        }

        @NonNull
        public Builder withNativeCrashReporting(boolean enabled) {
            this.f = enabled;
            return this;
        }

        @NonNull
        public Builder withLogs() {
            this.j = true;
            return this;
        }

        @NonNull
        public Builder withLocation(@Nullable Location location) {
            this.g = location;
            return this;
        }

        @NonNull
        public Builder withLocationTracking(boolean enabled) {
            this.h = enabled;
            return this;
        }

        @NonNull
        public Builder withInstalledAppCollecting(boolean enabled) {
            this.i = enabled;
            return this;
        }

        @NonNull
        public Builder withPreloadInfo(@Nullable PreloadInfo preloadInfo) {
            this.k = preloadInfo;
            return this;
        }

        @NonNull
        public Builder handleFirstActivationAsUpdate(boolean value) {
            this.l = value;
            return this;
        }

        @NonNull
        public Builder withStatisticsSending(boolean value) {
            this.m = value;
            return this;
        }

        @NonNull
        public Builder withMaxReportsInDatabaseCount(int value) {
            this.n = value;
            return this;
        }

        @NonNull
        public YandexMetricaConfig build() {
            return new YandexMetricaConfig(this);
        }
    }
}

