/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.metrica;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.yandex.metrica.impl.ob.cx;
import com.yandex.metrica.impl.ob.yg;
import com.yandex.metrica.impl.ob.yk;
import com.yandex.metrica.impl.ob.yl;

public class ReporterConfig {
    @NonNull
    public final String apiKey;
    @Nullable
    public final Integer sessionTimeout;
    @Nullable
    public final Boolean statisticsSending;
    @Nullable
    public final Integer maxReportsInDatabaseCount;
    @Nullable
    public final Boolean logs;

    ReporterConfig(@NonNull Builder builder) {
        this.apiKey = builder.b;
        this.sessionTimeout = builder.c;
        this.logs = builder.d;
        this.statisticsSending = builder.e;
        this.maxReportsInDatabaseCount = builder.f;
    }

    ReporterConfig(@NonNull ReporterConfig config) {
        this.apiKey = config.apiKey;
        this.sessionTimeout = config.sessionTimeout;
        this.logs = config.logs;
        this.statisticsSending = config.statisticsSending;
        this.maxReportsInDatabaseCount = config.maxReportsInDatabaseCount;
    }

    public static Builder createBuilderFromConfig(@NonNull ReporterConfig config) {
        Builder builder = ReporterConfig.newConfigBuilder(config.apiKey);
        if (cx.a(config.sessionTimeout)) {
            builder.withSessionTimeout(config.sessionTimeout);
        }
        if (cx.a(config.logs) && config.logs.booleanValue()) {
            builder.withLogs();
        }
        if (cx.a(config.statisticsSending)) {
            builder.withStatisticsSending(config.statisticsSending);
        }
        if (cx.a(config.maxReportsInDatabaseCount)) {
            builder.withMaxReportsInDatabaseCount(config.maxReportsInDatabaseCount);
        }
        return builder;
    }

    @NonNull
    public static Builder newConfigBuilder(@NonNull String apiKey) {
        return new Builder(apiKey);
    }

    public static class Builder {
        private static final yk<String> a = new yg<String>(new yl());
        private final String b;
        @Nullable
        private Integer c;
        @Nullable
        private Boolean d;
        @Nullable
        private Boolean e;
        @Nullable
        private Integer f;

        Builder(@NonNull String apiKey) {
            a.a(apiKey);
            this.b = apiKey;
        }

        @NonNull
        public Builder withSessionTimeout(int sessionTimeout) {
            this.c = sessionTimeout;
            return this;
        }

        @NonNull
        public Builder withLogs() {
            this.d = true;
            return this;
        }

        @NonNull
        public Builder withStatisticsSending(boolean enabled) {
            this.e = enabled;
            return this;
        }

        @NonNull
        public Builder withMaxReportsInDatabaseCount(int maxReportsInDatabaseCount) {
            this.f = maxReportsInDatabaseCount;
            return this;
        }

        @NonNull
        public ReporterConfig build() {
            return new ReporterConfig(this);
        }
    }
}

