// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.json.*
import com.yandex.div.json.expressions.Expression
import com.yandex.div.json.expressions.ExpressionsList
import com.yandex.div.json.schema.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*

@Mockable
class DivAccessibilityTemplate : JSONSerializable, JsonTemplate<DivAccessibility> {
    @JvmField final val description: Field<Expression<String>> // at least 1 char
    @JvmField final val hint: Field<Expression<String>> // at least 1 char
    @JvmField final val mode: Field<Expression<DivAccessibility.Mode>> // default value: default
    @JvmField final val muteAfterAction: Field<Expression<Boolean>> // default value: false
    @JvmField final val stateDescription: Field<Expression<String>> // at least 1 char
    @JvmField final val type: Field<DivAccessibility.Type>

    constructor (
        env: ParsingEnvironment,
        parent: DivAccessibilityTemplate? = null,
        topLevel: Boolean = false,
        json: JSONObject
    ) {
        val logger = env.logger
        description = JsonTemplateParser.readOptionalFieldWithExpression(json, "description", topLevel, parent?.description, DESCRIPTION_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_STRING)
        hint = JsonTemplateParser.readOptionalFieldWithExpression(json, "hint", topLevel, parent?.hint, HINT_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_STRING)
        mode = JsonTemplateParser.readOptionalFieldWithExpression(json, "mode", topLevel, parent?.mode, DivAccessibility.Mode.Converter.FROM_STRING, logger, env, TYPE_HELPER_MODE)
        muteAfterAction = JsonTemplateParser.readOptionalFieldWithExpression(json, "mute_after_action", topLevel, parent?.muteAfterAction, ANY_TO_BOOLEAN, logger, env, TYPE_HELPER_BOOLEAN)
        stateDescription = JsonTemplateParser.readOptionalFieldWithExpression(json, "state_description", topLevel, parent?.stateDescription, STATE_DESCRIPTION_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_STRING)
        type = JsonTemplateParser.readOptionalField(json, "type", topLevel, parent?.type, DivAccessibility.Type.Converter.FROM_STRING, logger, env)
    }

    override fun resolve(env: ParsingEnvironment, data: JSONObject): DivAccessibility {
        return DivAccessibility(
            description = description.resolveOptional(env = env, key = "description", data = data, reader = DESCRIPTION_READER),
            hint = hint.resolveOptional(env = env, key = "hint", data = data, reader = HINT_READER),
            mode = mode.resolveOptional(env = env, key = "mode", data = data, reader = MODE_READER) ?: MODE_DEFAULT_VALUE,
            muteAfterAction = muteAfterAction.resolveOptional(env = env, key = "mute_after_action", data = data, reader = MUTE_AFTER_ACTION_READER) ?: MUTE_AFTER_ACTION_DEFAULT_VALUE,
            stateDescription = stateDescription.resolveOptional(env = env, key = "state_description", data = data, reader = STATE_DESCRIPTION_READER),
            type = type.resolveOptional(env = env, key = "type", data = data, reader = TYPE_READER)
        )
    }

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.writeFieldWithExpression(key = "description", field = description)
        json.writeFieldWithExpression(key = "hint", field = hint)
        json.writeFieldWithExpression(key = "mode", field = mode, converter = { v: DivAccessibility.Mode -> DivAccessibility.Mode.toString(v) })
        json.writeFieldWithExpression(key = "mute_after_action", field = muteAfterAction)
        json.writeFieldWithExpression(key = "state_description", field = stateDescription)
        json.writeField(key = "type", field = type, converter = { v: DivAccessibility.Type -> DivAccessibility.Type.toString(v) })
        return json
    }

    companion object {
        private val MODE_DEFAULT_VALUE = Expression.constant(DivAccessibility.Mode.DEFAULT)
        private val MUTE_AFTER_ACTION_DEFAULT_VALUE = Expression.constant(false)

        private val TYPE_HELPER_MODE = TypeHelper.from(default = DivAccessibility.Mode.values().first()) { it is DivAccessibility.Mode }

        private val DESCRIPTION_TEMPLATE_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val DESCRIPTION_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val HINT_TEMPLATE_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val HINT_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val STATE_DESCRIPTION_TEMPLATE_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val STATE_DESCRIPTION_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }

        val DESCRIPTION_READER: Reader<Expression<String>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DESCRIPTION_VALIDATOR, env.logger, env, TYPE_HELPER_STRING) }
        val HINT_READER: Reader<Expression<String>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, HINT_VALIDATOR, env.logger, env, TYPE_HELPER_STRING) }
        val MODE_READER: Reader<Expression<DivAccessibility.Mode>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivAccessibility.Mode.Converter.FROM_STRING, env.logger, env, MODE_DEFAULT_VALUE, TYPE_HELPER_MODE) ?: MODE_DEFAULT_VALUE }
        val MUTE_AFTER_ACTION_READER: Reader<Expression<Boolean>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, ANY_TO_BOOLEAN, env.logger, env, MUTE_AFTER_ACTION_DEFAULT_VALUE, TYPE_HELPER_BOOLEAN) ?: MUTE_AFTER_ACTION_DEFAULT_VALUE }
        val STATE_DESCRIPTION_READER: Reader<Expression<String>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, STATE_DESCRIPTION_VALIDATOR, env.logger, env, TYPE_HELPER_STRING) }
        val TYPE_READER: Reader<DivAccessibility.Type?> = { key, json, env -> JsonParser.readOptional(json, key, DivAccessibility.Type.Converter.FROM_STRING, env.logger, env) }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivAccessibilityTemplate(env, json = it) }
    }

}
