// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.json.*
import com.yandex.div.json.expressions.Expression
import com.yandex.div.json.expressions.ExpressionsList
import com.yandex.div.json.schema.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*

@Mockable
class DivAction(
    @JvmField final val downloadCallbacks: DivDownloadCallbacks? = null,
    @JvmField final val logId: String, // at least 1 char
    @JvmField final val logUrl: Expression<Uri>? = null,
    @JvmField final val menuItems: List<MenuItem>? = null, // at least 1 elements
    @JvmField final val payload: JSONObject? = null,
    @JvmField final val referer: Expression<Uri>? = null,
    @JvmField final val target: Expression<Target>? = null,
    @JvmField final val url: Expression<Uri>? = null,
) : JSONSerializable {

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.write(key = "download_callbacks", value = downloadCallbacks)
        json.write(key = "log_id", value = logId)
        json.writeExpression(key = "log_url", value = logUrl, converter = URI_TO_STRING)
        json.write(key = "menu_items", value = menuItems)
        json.write(key = "payload", value = payload)
        json.writeExpression(key = "referer", value = referer, converter = URI_TO_STRING)
        json.writeExpression(key = "target", value = target, converter = { v: Target -> Target.toString(v) })
        json.writeExpression(key = "url", value = url, converter = URI_TO_STRING)
        return json
    }

    companion object {
        private val TYPE_HELPER_TARGET = TypeHelper.from(default = DivAction.Target.values().first()) { it is DivAction.Target }

        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivAction {
            val logger = env.logger
            return DivAction(
                downloadCallbacks = JsonParser.readOptional(json, "download_callbacks", DivDownloadCallbacks.CREATOR, logger, env),
                logId = JsonParser.read(json, "log_id", LOG_ID_VALIDATOR, logger, env),
                logUrl = JsonParser.readOptionalExpression(json, "log_url", STRING_TO_URI, logger, env, TYPE_HELPER_URI),
                menuItems = JsonParser.readOptionalList(json, "menu_items", MenuItem.CREATOR, MENU_ITEMS_VALIDATOR, logger, env),
                payload = JsonParser.readOptional(json, "payload", logger, env),
                referer = JsonParser.readOptionalExpression(json, "referer", STRING_TO_URI, logger, env, TYPE_HELPER_URI),
                target = JsonParser.readOptionalExpression(json, "target", Target.Converter.FROM_STRING, logger, env, TYPE_HELPER_TARGET),
                url = JsonParser.readOptionalExpression(json, "url", STRING_TO_URI, logger, env, TYPE_HELPER_URI)
            )
        }

        private val LOG_ID_TEMPLATE_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val LOG_ID_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val MENU_ITEMS_VALIDATOR = ListValidator<DivAction.MenuItem> { it: List<*> -> it.size >= 1 }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivAction(env, json = it) }
    }


    @Mockable
    class MenuItem(
        @JvmField final val action: DivAction? = null,
        @JvmField final val actions: List<DivAction>? = null, // at least 1 elements
        @JvmField final val text: Expression<String>, // at least 1 char
    ) : JSONSerializable {

        override fun writeToJSON(): JSONObject {
            val json = JSONObject()
            json.write(key = "action", value = action)
            json.write(key = "actions", value = actions)
            json.writeExpression(key = "text", value = text)
            return json
        }

        companion object {
            @JvmStatic
            @JvmName("fromJson")
            operator fun invoke(env: ParsingEnvironment, json: JSONObject): MenuItem {
                val logger = env.logger
                return MenuItem(
                    action = JsonParser.readOptional(json, "action", DivAction.CREATOR, logger, env),
                    actions = JsonParser.readOptionalList(json, "actions", DivAction.CREATOR, ACTIONS_VALIDATOR, logger, env),
                    text = JsonParser.readExpression(json, "text", TEXT_VALIDATOR, logger, env, TYPE_HELPER_STRING)
                )
            }

            private val ACTIONS_VALIDATOR = ListValidator<DivAction> { it: List<*> -> it.size >= 1 }
            private val TEXT_TEMPLATE_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
            private val TEXT_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }

            val CREATOR = { env: ParsingEnvironment, it: JSONObject -> MenuItem(env, json = it) }
        }

    }

    enum class Target(private val value: String) {
        SELF("_self"),
        BLANK("_blank");

        companion object Converter {
            fun toString(obj: Target): String {
                return obj.value
            }

            fun fromString(string: String): Target? {
                return when (string) {
                    SELF.value -> SELF
                    BLANK.value -> BLANK
                    else -> null
                }
            }

            val FROM_STRING = { string: String ->
                when (string) {
                    SELF.value -> SELF
                    BLANK.value -> BLANK
                    else -> null
                }
            }
        }
    }
}
