// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.json.*
import com.yandex.div.json.expressions.Expression
import com.yandex.div.json.expressions.ExpressionsList
import com.yandex.div.json.schema.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*

@Mockable
class DivAnimation(
    @JvmField final val duration: Expression<Int> = DURATION_DEFAULT_VALUE, // constraint: number >= 0; default value: 300
    @JvmField final val endValue: Expression<Double>? = null,
    @JvmField final val interpolator: Expression<DivAnimationInterpolator> = INTERPOLATOR_DEFAULT_VALUE, // default value: spring
    @JvmField final val items: List<DivAnimation>? = null, // at least 1 elements
    @JvmField final val name: Expression<Name>,
    @JvmField final val repeat: DivCount = REPEAT_DEFAULT_VALUE, // default value: DivCount.Infinity(DivInfinityCount())
    @JvmField final val startDelay: Expression<Int> = START_DELAY_DEFAULT_VALUE, // constraint: number >= 0; default value: 0
    @JvmField final val startValue: Expression<Double>? = null,
) : JSONSerializable {

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.writeExpression(key = "duration", value = duration)
        json.writeExpression(key = "end_value", value = endValue)
        json.writeExpression(key = "interpolator", value = interpolator, converter = { v: DivAnimationInterpolator -> DivAnimationInterpolator.toString(v) })
        json.write(key = "items", value = items)
        json.writeExpression(key = "name", value = name, converter = { v: Name -> Name.toString(v) })
        json.write(key = "repeat", value = repeat)
        json.writeExpression(key = "start_delay", value = startDelay)
        json.writeExpression(key = "start_value", value = startValue)
        return json
    }

    companion object {
        private val DURATION_DEFAULT_VALUE = Expression.constant(300)
        private val INTERPOLATOR_DEFAULT_VALUE = Expression.constant(DivAnimationInterpolator.SPRING)
        private val REPEAT_DEFAULT_VALUE = DivCount.Infinity(DivInfinityCount())
        private val START_DELAY_DEFAULT_VALUE = Expression.constant(0)

        private val TYPE_HELPER_INTERPOLATOR = TypeHelper.from(default = DivAnimationInterpolator.values().first()) { it is DivAnimationInterpolator }
        private val TYPE_HELPER_NAME = TypeHelper.from(default = DivAnimation.Name.values().first()) { it is DivAnimation.Name }

        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivAnimation {
            val logger = env.logger
            return DivAnimation(
                duration = JsonParser.readOptionalExpression(json, "duration", NUMBER_TO_INT, DURATION_VALIDATOR, logger, env, DURATION_DEFAULT_VALUE, TYPE_HELPER_INT) ?: DURATION_DEFAULT_VALUE,
                endValue = JsonParser.readOptionalExpression(json, "end_value", NUMBER_TO_DOUBLE, logger, env, TYPE_HELPER_DOUBLE),
                interpolator = JsonParser.readOptionalExpression(json, "interpolator", DivAnimationInterpolator.Converter.FROM_STRING, logger, env, INTERPOLATOR_DEFAULT_VALUE, TYPE_HELPER_INTERPOLATOR) ?: INTERPOLATOR_DEFAULT_VALUE,
                items = JsonParser.readOptionalList(json, "items", DivAnimation.CREATOR, ITEMS_VALIDATOR, logger, env),
                name = JsonParser.readExpression(json, "name", Name.Converter.FROM_STRING, logger, env, TYPE_HELPER_NAME),
                repeat = JsonParser.readOptional(json, "repeat", DivCount.CREATOR, logger, env) ?: REPEAT_DEFAULT_VALUE,
                startDelay = JsonParser.readOptionalExpression(json, "start_delay", NUMBER_TO_INT, START_DELAY_VALIDATOR, logger, env, START_DELAY_DEFAULT_VALUE, TYPE_HELPER_INT) ?: START_DELAY_DEFAULT_VALUE,
                startValue = JsonParser.readOptionalExpression(json, "start_value", NUMBER_TO_DOUBLE, logger, env, TYPE_HELPER_DOUBLE)
            )
        }

        private val DURATION_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val DURATION_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val ITEMS_VALIDATOR = ListValidator<DivAnimation> { it: List<*> -> it.size >= 1 }
        private val START_DELAY_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val START_DELAY_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivAnimation(env, json = it) }
    }


    enum class Name(private val value: String) {
        FADE("fade"),
        TRANSLATE("translate"),
        SCALE("scale"),
        NATIVE("native"),
        SET("set"),
        NO_ANIMATION("no_animation");

        companion object Converter {
            fun toString(obj: Name): String {
                return obj.value
            }

            fun fromString(string: String): Name? {
                return when (string) {
                    FADE.value -> FADE
                    TRANSLATE.value -> TRANSLATE
                    SCALE.value -> SCALE
                    NATIVE.value -> NATIVE
                    SET.value -> SET
                    NO_ANIMATION.value -> NO_ANIMATION
                    else -> null
                }
            }

            val FROM_STRING = { string: String ->
                when (string) {
                    FADE.value -> FADE
                    TRANSLATE.value -> TRANSLATE
                    SCALE.value -> SCALE
                    NATIVE.value -> NATIVE
                    SET.value -> SET
                    NO_ANIMATION.value -> NO_ANIMATION
                    else -> null
                }
            }
        }
    }
}
