// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.json.*
import com.yandex.div.json.expressions.Expression
import com.yandex.div.json.expressions.ExpressionsList
import com.yandex.div.json.schema.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*

@Mockable
class DivFadeTransition(
    @JvmField final val alpha: Expression<Double> = ALPHA_DEFAULT_VALUE, // constraint: number >= 0.0 && number <= 1.0; default value: 0.0
    override val duration: Expression<Int> = DURATION_DEFAULT_VALUE, // constraint: number >= 0; default value: 200
    override val interpolator: Expression<DivAnimationInterpolator> = INTERPOLATOR_DEFAULT_VALUE, // default value: ease_in_out
    override val startDelay: Expression<Int> = START_DELAY_DEFAULT_VALUE, // constraint: number >= 0; default value: 0
) : JSONSerializable, DivTransitionBase {

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.writeExpression(key = "alpha", value = alpha)
        json.writeExpression(key = "duration", value = duration)
        json.writeExpression(key = "interpolator", value = interpolator, converter = { v: DivAnimationInterpolator -> DivAnimationInterpolator.toString(v) })
        json.writeExpression(key = "start_delay", value = startDelay)
        json.write(key = "type", value = TYPE)
        return json
    }

    companion object {
        const val TYPE = "fade"

        private val ALPHA_DEFAULT_VALUE = Expression.constant(0.0)
        private val DURATION_DEFAULT_VALUE = Expression.constant(200)
        private val INTERPOLATOR_DEFAULT_VALUE = Expression.constant(DivAnimationInterpolator.EASE_IN_OUT)
        private val START_DELAY_DEFAULT_VALUE = Expression.constant(0)

        private val TYPE_HELPER_INTERPOLATOR = TypeHelper.from(default = DivAnimationInterpolator.values().first()) { it is DivAnimationInterpolator }

        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivFadeTransition {
            val logger = env.logger
            return DivFadeTransition(
                alpha = JsonParser.readOptionalExpression(json, "alpha", NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, logger, env, ALPHA_DEFAULT_VALUE, TYPE_HELPER_DOUBLE) ?: ALPHA_DEFAULT_VALUE,
                duration = JsonParser.readOptionalExpression(json, "duration", NUMBER_TO_INT, DURATION_VALIDATOR, logger, env, DURATION_DEFAULT_VALUE, TYPE_HELPER_INT) ?: DURATION_DEFAULT_VALUE,
                interpolator = JsonParser.readOptionalExpression(json, "interpolator", DivAnimationInterpolator.Converter.FROM_STRING, logger, env, INTERPOLATOR_DEFAULT_VALUE, TYPE_HELPER_INTERPOLATOR) ?: INTERPOLATOR_DEFAULT_VALUE,
                startDelay = JsonParser.readOptionalExpression(json, "start_delay", NUMBER_TO_INT, START_DELAY_VALIDATOR, logger, env, START_DELAY_DEFAULT_VALUE, TYPE_HELPER_INT) ?: START_DELAY_DEFAULT_VALUE
            )
        }

        private val ALPHA_TEMPLATE_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val ALPHA_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val DURATION_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val DURATION_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val START_DELAY_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val START_DELAY_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivFadeTransition(env, json = it) }
    }

}
