// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.json.*
import com.yandex.div.json.expressions.Expression
import com.yandex.div.json.expressions.ExpressionsList
import com.yandex.div.json.schema.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*

@Mockable
class DivImageBackgroundTemplate : JSONSerializable, JsonTemplate<DivImageBackground> {
    @JvmField final val alpha: Field<Expression<Double>> // constraint: number >= 0.0 && number <= 1.0; default value: 1.0
    @JvmField final val contentAlignmentHorizontal: Field<Expression<DivAlignmentHorizontal>> // default value: center
    @JvmField final val contentAlignmentVertical: Field<Expression<DivAlignmentVertical>> // default value: center
    @JvmField final val filters: Field<List<DivFilterTemplate>> // at least 1 elements
    @JvmField final val imageUrl: Field<Expression<Uri>>
    @JvmField final val preloadRequired: Field<Expression<Boolean>> // default value: false
    @JvmField final val scale: Field<Expression<DivImageScale>> // default value: fill

    constructor (
        env: ParsingEnvironment,
        parent: DivImageBackgroundTemplate? = null,
        topLevel: Boolean = false,
        json: JSONObject
    ) {
        val logger = env.logger
        alpha = JsonTemplateParser.readOptionalFieldWithExpression(json, "alpha", topLevel, parent?.alpha, NUMBER_TO_DOUBLE, ALPHA_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_DOUBLE)
        contentAlignmentHorizontal = JsonTemplateParser.readOptionalFieldWithExpression(json, "content_alignment_horizontal", topLevel, parent?.contentAlignmentHorizontal, DivAlignmentHorizontal.Converter.FROM_STRING, logger, env, TYPE_HELPER_CONTENT_ALIGNMENT_HORIZONTAL)
        contentAlignmentVertical = JsonTemplateParser.readOptionalFieldWithExpression(json, "content_alignment_vertical", topLevel, parent?.contentAlignmentVertical, DivAlignmentVertical.Converter.FROM_STRING, logger, env, TYPE_HELPER_CONTENT_ALIGNMENT_VERTICAL)
        filters = JsonTemplateParser.readOptionalListField(json, "filters", topLevel, parent?.filters, DivFilterTemplate.CREATOR, FILTERS_TEMPLATE_VALIDATOR, logger, env)
        imageUrl = JsonTemplateParser.readFieldWithExpression(json, "image_url", topLevel, parent?.imageUrl, STRING_TO_URI, logger, env, TYPE_HELPER_URI)
        preloadRequired = JsonTemplateParser.readOptionalFieldWithExpression(json, "preload_required", topLevel, parent?.preloadRequired, ANY_TO_BOOLEAN, logger, env, TYPE_HELPER_BOOLEAN)
        scale = JsonTemplateParser.readOptionalFieldWithExpression(json, "scale", topLevel, parent?.scale, DivImageScale.Converter.FROM_STRING, logger, env, TYPE_HELPER_SCALE)
    }

    override fun resolve(env: ParsingEnvironment, data: JSONObject): DivImageBackground {
        return DivImageBackground(
            alpha = alpha.resolveOptional(env = env, key = "alpha", data = data, reader = ALPHA_READER) ?: ALPHA_DEFAULT_VALUE,
            contentAlignmentHorizontal = contentAlignmentHorizontal.resolveOptional(env = env, key = "content_alignment_horizontal", data = data, reader = CONTENT_ALIGNMENT_HORIZONTAL_READER) ?: CONTENT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE,
            contentAlignmentVertical = contentAlignmentVertical.resolveOptional(env = env, key = "content_alignment_vertical", data = data, reader = CONTENT_ALIGNMENT_VERTICAL_READER) ?: CONTENT_ALIGNMENT_VERTICAL_DEFAULT_VALUE,
            filters = filters.resolveOptionalTemplateList(env = env, key = "filters", data = data, FILTERS_VALIDATOR, reader = FILTERS_READER),
            imageUrl = imageUrl.resolve(env = env, key = "image_url", data = data, reader = IMAGE_URL_READER),
            preloadRequired = preloadRequired.resolveOptional(env = env, key = "preload_required", data = data, reader = PRELOAD_REQUIRED_READER) ?: PRELOAD_REQUIRED_DEFAULT_VALUE,
            scale = scale.resolveOptional(env = env, key = "scale", data = data, reader = SCALE_READER) ?: SCALE_DEFAULT_VALUE
        )
    }

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.writeFieldWithExpression(key = "alpha", field = alpha)
        json.writeFieldWithExpression(key = "content_alignment_horizontal", field = contentAlignmentHorizontal, converter = { v: DivAlignmentHorizontal -> DivAlignmentHorizontal.toString(v) })
        json.writeFieldWithExpression(key = "content_alignment_vertical", field = contentAlignmentVertical, converter = { v: DivAlignmentVertical -> DivAlignmentVertical.toString(v) })
        json.writeField(key = "filters", field = filters)
        json.writeFieldWithExpression(key = "image_url", field = imageUrl, converter = URI_TO_STRING)
        json.writeFieldWithExpression(key = "preload_required", field = preloadRequired)
        json.writeFieldWithExpression(key = "scale", field = scale, converter = { v: DivImageScale -> DivImageScale.toString(v) })
        json.write(key = "type", value = TYPE)
        return json
    }

    companion object {
        const val TYPE = "image"

        private val ALPHA_DEFAULT_VALUE = Expression.constant(1.0)
        private val CONTENT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE = Expression.constant(DivAlignmentHorizontal.CENTER)
        private val CONTENT_ALIGNMENT_VERTICAL_DEFAULT_VALUE = Expression.constant(DivAlignmentVertical.CENTER)
        private val PRELOAD_REQUIRED_DEFAULT_VALUE = Expression.constant(false)
        private val SCALE_DEFAULT_VALUE = Expression.constant(DivImageScale.FILL)

        private val TYPE_HELPER_CONTENT_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.values().first()) { it is DivAlignmentHorizontal }
        private val TYPE_HELPER_CONTENT_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.values().first()) { it is DivAlignmentVertical }
        private val TYPE_HELPER_SCALE = TypeHelper.from(default = DivImageScale.values().first()) { it is DivImageScale }

        private val ALPHA_TEMPLATE_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val ALPHA_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val FILTERS_VALIDATOR = ListValidator<DivFilter> { it: List<*> -> it.size >= 1 }
        private val FILTERS_TEMPLATE_VALIDATOR = ListValidator<DivFilterTemplate> { it: List<*> -> it.size >= 1 }

        val ALPHA_READER: Reader<Expression<Double>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, env.logger, env, ALPHA_DEFAULT_VALUE, TYPE_HELPER_DOUBLE) ?: ALPHA_DEFAULT_VALUE }
        val CONTENT_ALIGNMENT_HORIZONTAL_READER: Reader<Expression<DivAlignmentHorizontal>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivAlignmentHorizontal.Converter.FROM_STRING, env.logger, env, CONTENT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE, TYPE_HELPER_CONTENT_ALIGNMENT_HORIZONTAL) ?: CONTENT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE }
        val CONTENT_ALIGNMENT_VERTICAL_READER: Reader<Expression<DivAlignmentVertical>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivAlignmentVertical.Converter.FROM_STRING, env.logger, env, CONTENT_ALIGNMENT_VERTICAL_DEFAULT_VALUE, TYPE_HELPER_CONTENT_ALIGNMENT_VERTICAL) ?: CONTENT_ALIGNMENT_VERTICAL_DEFAULT_VALUE }
        val FILTERS_READER: Reader<List<DivFilter>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivFilter.CREATOR, FILTERS_VALIDATOR, env.logger, env) }
        val IMAGE_URL_READER: Reader<Expression<Uri>> = { key, json, env -> JsonParser.readExpression(json, key, STRING_TO_URI, env.logger, env, TYPE_HELPER_URI) }
        val PRELOAD_REQUIRED_READER: Reader<Expression<Boolean>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, ANY_TO_BOOLEAN, env.logger, env, PRELOAD_REQUIRED_DEFAULT_VALUE, TYPE_HELPER_BOOLEAN) ?: PRELOAD_REQUIRED_DEFAULT_VALUE }
        val SCALE_READER: Reader<Expression<DivImageScale>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivImageScale.Converter.FROM_STRING, env.logger, env, SCALE_DEFAULT_VALUE, TYPE_HELPER_SCALE) ?: SCALE_DEFAULT_VALUE }
        val TYPE_READER: Reader<String> = { key, json, env -> JsonParser.read(json, key, env.logger, env) }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivImageBackgroundTemplate(env, json = it) }
    }

}
