// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.json.*
import com.yandex.div.json.expressions.Expression
import com.yandex.div.json.expressions.ExpressionsList
import com.yandex.div.json.schema.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*

@Mockable
class DivInput(
    override val accessibility: DivAccessibility = ACCESSIBILITY_DEFAULT_VALUE,
    override val alignmentHorizontal: Expression<DivAlignmentHorizontal>? = null,
    override val alignmentVertical: Expression<DivAlignmentVertical>? = null,
    override val alpha: Expression<Double> = ALPHA_DEFAULT_VALUE, // constraint: number >= 0.0 && number <= 1.0; default value: 1.0
    override val background: List<DivBackground>? = null, // at least 1 elements
    override val border: DivBorder = BORDER_DEFAULT_VALUE,
    override val columnSpan: Expression<Int>? = null, // constraint: number >= 0
    override val extensions: List<DivExtension>? = null, // at least 1 elements
    override val focus: DivFocus? = null,
    @JvmField final val fontFamily: Expression<DivFontFamily> = FONT_FAMILY_DEFAULT_VALUE, // default value: text
    @JvmField final val fontSize: Expression<Int> = FONT_SIZE_DEFAULT_VALUE, // constraint: number >= 0; default value: 12
    @JvmField final val fontSizeUnit: Expression<DivSizeUnit> = FONT_SIZE_UNIT_DEFAULT_VALUE, // default value: sp
    @JvmField final val fontWeight: Expression<DivFontWeight> = FONT_WEIGHT_DEFAULT_VALUE, // default value: regular
    override val height: DivSize = HEIGHT_DEFAULT_VALUE, // default value: DivSize.WrapContent(DivWrapContentSize())
    @JvmField final val highlightColor: Expression<Int>? = null,
    @JvmField final val hintColor: Expression<Int> = HINT_COLOR_DEFAULT_VALUE, // default value: #73000000
    @JvmField final val hintText: Expression<String>? = null, // at least 1 char
    override val id: String? = null, // at least 1 char
    @JvmField final val keyboardType: Expression<KeyboardType> = KEYBOARD_TYPE_DEFAULT_VALUE, // default value: multi_line_text
    @JvmField final val letterSpacing: Expression<Double> = LETTER_SPACING_DEFAULT_VALUE, // default value: 0
    @JvmField final val lineHeight: Expression<Int>? = null, // constraint: number >= 0
    override val margins: DivEdgeInsets = MARGINS_DEFAULT_VALUE,
    @JvmField final val maxVisibleLines: Expression<Int>? = null, // constraint: number > 0
    @JvmField final val nativeInterface: NativeInterface? = null,
    override val paddings: DivEdgeInsets = PADDINGS_DEFAULT_VALUE,
    override val rowSpan: Expression<Int>? = null, // constraint: number >= 0
    @JvmField final val selectAllOnFocus: Expression<Boolean> = SELECT_ALL_ON_FOCUS_DEFAULT_VALUE, // default value: false
    override val selectedActions: List<DivAction>? = null, // at least 1 elements
    @JvmField final val textColor: Expression<Int> = TEXT_COLOR_DEFAULT_VALUE, // default value: #FF000000
    @JvmField final val textVariable: String, // at least 1 char
    override val tooltips: List<DivTooltip>? = null, // at least 1 elements
    override val transform: DivTransform = TRANSFORM_DEFAULT_VALUE,
    override val transitionChange: DivChangeTransition? = null,
    override val transitionIn: DivAppearanceTransition? = null,
    override val transitionOut: DivAppearanceTransition? = null,
    override val transitionTriggers: List<DivTransitionTrigger>? = null, // at least 1 elements
    override val visibility: Expression<DivVisibility> = VISIBILITY_DEFAULT_VALUE, // default value: visible
    override val visibilityAction: DivVisibilityAction? = null,
    override val visibilityActions: List<DivVisibilityAction>? = null, // at least 1 elements
    override val width: DivSize = WIDTH_DEFAULT_VALUE, // default value: DivSize.MatchParent(DivMatchParentSize())
) : JSONSerializable, DivBase {

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.write(key = "accessibility", value = accessibility)
        json.writeExpression(key = "alignment_horizontal", value = alignmentHorizontal, converter = { v: DivAlignmentHorizontal -> DivAlignmentHorizontal.toString(v) })
        json.writeExpression(key = "alignment_vertical", value = alignmentVertical, converter = { v: DivAlignmentVertical -> DivAlignmentVertical.toString(v) })
        json.writeExpression(key = "alpha", value = alpha)
        json.write(key = "background", value = background)
        json.write(key = "border", value = border)
        json.writeExpression(key = "column_span", value = columnSpan)
        json.write(key = "extensions", value = extensions)
        json.write(key = "focus", value = focus)
        json.writeExpression(key = "font_family", value = fontFamily, converter = { v: DivFontFamily -> DivFontFamily.toString(v) })
        json.writeExpression(key = "font_size", value = fontSize)
        json.writeExpression(key = "font_size_unit", value = fontSizeUnit, converter = { v: DivSizeUnit -> DivSizeUnit.toString(v) })
        json.writeExpression(key = "font_weight", value = fontWeight, converter = { v: DivFontWeight -> DivFontWeight.toString(v) })
        json.write(key = "height", value = height)
        json.writeExpression(key = "highlight_color", value = highlightColor, converter = COLOR_INT_TO_STRING)
        json.writeExpression(key = "hint_color", value = hintColor, converter = COLOR_INT_TO_STRING)
        json.writeExpression(key = "hint_text", value = hintText)
        json.write(key = "id", value = id)
        json.writeExpression(key = "keyboard_type", value = keyboardType, converter = { v: KeyboardType -> KeyboardType.toString(v) })
        json.writeExpression(key = "letter_spacing", value = letterSpacing)
        json.writeExpression(key = "line_height", value = lineHeight)
        json.write(key = "margins", value = margins)
        json.writeExpression(key = "max_visible_lines", value = maxVisibleLines)
        json.write(key = "native_interface", value = nativeInterface)
        json.write(key = "paddings", value = paddings)
        json.writeExpression(key = "row_span", value = rowSpan)
        json.writeExpression(key = "select_all_on_focus", value = selectAllOnFocus)
        json.write(key = "selected_actions", value = selectedActions)
        json.writeExpression(key = "text_color", value = textColor, converter = COLOR_INT_TO_STRING)
        json.write(key = "text_variable", value = textVariable)
        json.write(key = "tooltips", value = tooltips)
        json.write(key = "transform", value = transform)
        json.write(key = "transition_change", value = transitionChange)
        json.write(key = "transition_in", value = transitionIn)
        json.write(key = "transition_out", value = transitionOut)
        json.write(key = "transition_triggers", value = transitionTriggers, converter = { v: DivTransitionTrigger -> DivTransitionTrigger.toString(v) })
        json.write(key = "type", value = TYPE)
        json.writeExpression(key = "visibility", value = visibility, converter = { v: DivVisibility -> DivVisibility.toString(v) })
        json.write(key = "visibility_action", value = visibilityAction)
        json.write(key = "visibility_actions", value = visibilityActions)
        json.write(key = "width", value = width)
        return json
    }

    companion object {
        const val TYPE = "input"

        private val ACCESSIBILITY_DEFAULT_VALUE = DivAccessibility()
        private val ALPHA_DEFAULT_VALUE = Expression.constant(1.0)
        private val BORDER_DEFAULT_VALUE = DivBorder()
        private val FONT_FAMILY_DEFAULT_VALUE = Expression.constant(DivFontFamily.TEXT)
        private val FONT_SIZE_DEFAULT_VALUE = Expression.constant(12)
        private val FONT_SIZE_UNIT_DEFAULT_VALUE = Expression.constant(DivSizeUnit.SP)
        private val FONT_WEIGHT_DEFAULT_VALUE = Expression.constant(DivFontWeight.REGULAR)
        private val HEIGHT_DEFAULT_VALUE = DivSize.WrapContent(DivWrapContentSize())
        private val HINT_COLOR_DEFAULT_VALUE = Expression.constant(0x73000000.toInt())
        private val KEYBOARD_TYPE_DEFAULT_VALUE = Expression.constant(KeyboardType.MULTI_LINE_TEXT)
        private val LETTER_SPACING_DEFAULT_VALUE = Expression.constant(0.0)
        private val MARGINS_DEFAULT_VALUE = DivEdgeInsets()
        private val PADDINGS_DEFAULT_VALUE = DivEdgeInsets()
        private val SELECT_ALL_ON_FOCUS_DEFAULT_VALUE = Expression.constant(false)
        private val TEXT_COLOR_DEFAULT_VALUE = Expression.constant(0xFF000000.toInt())
        private val TRANSFORM_DEFAULT_VALUE = DivTransform()
        private val VISIBILITY_DEFAULT_VALUE = Expression.constant(DivVisibility.VISIBLE)
        private val WIDTH_DEFAULT_VALUE = DivSize.MatchParent(DivMatchParentSize())

        private val TYPE_HELPER_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.values().first()) { it is DivAlignmentHorizontal }
        private val TYPE_HELPER_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.values().first()) { it is DivAlignmentVertical }
        private val TYPE_HELPER_FONT_FAMILY = TypeHelper.from(default = DivFontFamily.values().first()) { it is DivFontFamily }
        private val TYPE_HELPER_FONT_SIZE_UNIT = TypeHelper.from(default = DivSizeUnit.values().first()) { it is DivSizeUnit }
        private val TYPE_HELPER_FONT_WEIGHT = TypeHelper.from(default = DivFontWeight.values().first()) { it is DivFontWeight }
        private val TYPE_HELPER_KEYBOARD_TYPE = TypeHelper.from(default = DivInput.KeyboardType.values().first()) { it is DivInput.KeyboardType }
        private val TYPE_HELPER_VISIBILITY = TypeHelper.from(default = DivVisibility.values().first()) { it is DivVisibility }

        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivInput {
            val logger = env.logger
            return DivInput(
                accessibility = JsonParser.readOptional(json, "accessibility", DivAccessibility.CREATOR, logger, env) ?: ACCESSIBILITY_DEFAULT_VALUE,
                alignmentHorizontal = JsonParser.readOptionalExpression(json, "alignment_horizontal", DivAlignmentHorizontal.Converter.FROM_STRING, logger, env, TYPE_HELPER_ALIGNMENT_HORIZONTAL),
                alignmentVertical = JsonParser.readOptionalExpression(json, "alignment_vertical", DivAlignmentVertical.Converter.FROM_STRING, logger, env, TYPE_HELPER_ALIGNMENT_VERTICAL),
                alpha = JsonParser.readOptionalExpression(json, "alpha", NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, logger, env, ALPHA_DEFAULT_VALUE, TYPE_HELPER_DOUBLE) ?: ALPHA_DEFAULT_VALUE,
                background = JsonParser.readOptionalList(json, "background", DivBackground.CREATOR, BACKGROUND_VALIDATOR, logger, env),
                border = JsonParser.readOptional(json, "border", DivBorder.CREATOR, logger, env) ?: BORDER_DEFAULT_VALUE,
                columnSpan = JsonParser.readOptionalExpression(json, "column_span", NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR, logger, env, TYPE_HELPER_INT),
                extensions = JsonParser.readOptionalList(json, "extensions", DivExtension.CREATOR, EXTENSIONS_VALIDATOR, logger, env),
                focus = JsonParser.readOptional(json, "focus", DivFocus.CREATOR, logger, env),
                fontFamily = JsonParser.readOptionalExpression(json, "font_family", DivFontFamily.Converter.FROM_STRING, logger, env, FONT_FAMILY_DEFAULT_VALUE, TYPE_HELPER_FONT_FAMILY) ?: FONT_FAMILY_DEFAULT_VALUE,
                fontSize = JsonParser.readOptionalExpression(json, "font_size", NUMBER_TO_INT, FONT_SIZE_VALIDATOR, logger, env, FONT_SIZE_DEFAULT_VALUE, TYPE_HELPER_INT) ?: FONT_SIZE_DEFAULT_VALUE,
                fontSizeUnit = JsonParser.readOptionalExpression(json, "font_size_unit", DivSizeUnit.Converter.FROM_STRING, logger, env, FONT_SIZE_UNIT_DEFAULT_VALUE, TYPE_HELPER_FONT_SIZE_UNIT) ?: FONT_SIZE_UNIT_DEFAULT_VALUE,
                fontWeight = JsonParser.readOptionalExpression(json, "font_weight", DivFontWeight.Converter.FROM_STRING, logger, env, FONT_WEIGHT_DEFAULT_VALUE, TYPE_HELPER_FONT_WEIGHT) ?: FONT_WEIGHT_DEFAULT_VALUE,
                height = JsonParser.readOptional(json, "height", DivSize.CREATOR, logger, env) ?: HEIGHT_DEFAULT_VALUE,
                highlightColor = JsonParser.readOptionalExpression(json, "highlight_color", STRING_TO_COLOR_INT, logger, env, TYPE_HELPER_COLOR),
                hintColor = JsonParser.readOptionalExpression(json, "hint_color", STRING_TO_COLOR_INT, logger, env, HINT_COLOR_DEFAULT_VALUE, TYPE_HELPER_COLOR) ?: HINT_COLOR_DEFAULT_VALUE,
                hintText = JsonParser.readOptionalExpression(json, "hint_text", HINT_TEXT_VALIDATOR, logger, env, TYPE_HELPER_STRING),
                id = JsonParser.readOptional(json, "id", ID_VALIDATOR, logger, env),
                keyboardType = JsonParser.readOptionalExpression(json, "keyboard_type", KeyboardType.Converter.FROM_STRING, logger, env, KEYBOARD_TYPE_DEFAULT_VALUE, TYPE_HELPER_KEYBOARD_TYPE) ?: KEYBOARD_TYPE_DEFAULT_VALUE,
                letterSpacing = JsonParser.readOptionalExpression(json, "letter_spacing", NUMBER_TO_DOUBLE, logger, env, LETTER_SPACING_DEFAULT_VALUE, TYPE_HELPER_DOUBLE) ?: LETTER_SPACING_DEFAULT_VALUE,
                lineHeight = JsonParser.readOptionalExpression(json, "line_height", NUMBER_TO_INT, LINE_HEIGHT_VALIDATOR, logger, env, TYPE_HELPER_INT),
                margins = JsonParser.readOptional(json, "margins", DivEdgeInsets.CREATOR, logger, env) ?: MARGINS_DEFAULT_VALUE,
                maxVisibleLines = JsonParser.readOptionalExpression(json, "max_visible_lines", NUMBER_TO_INT, MAX_VISIBLE_LINES_VALIDATOR, logger, env, TYPE_HELPER_INT),
                nativeInterface = JsonParser.readOptional(json, "native_interface", NativeInterface.CREATOR, logger, env),
                paddings = JsonParser.readOptional(json, "paddings", DivEdgeInsets.CREATOR, logger, env) ?: PADDINGS_DEFAULT_VALUE,
                rowSpan = JsonParser.readOptionalExpression(json, "row_span", NUMBER_TO_INT, ROW_SPAN_VALIDATOR, logger, env, TYPE_HELPER_INT),
                selectAllOnFocus = JsonParser.readOptionalExpression(json, "select_all_on_focus", ANY_TO_BOOLEAN, logger, env, SELECT_ALL_ON_FOCUS_DEFAULT_VALUE, TYPE_HELPER_BOOLEAN) ?: SELECT_ALL_ON_FOCUS_DEFAULT_VALUE,
                selectedActions = JsonParser.readOptionalList(json, "selected_actions", DivAction.CREATOR, SELECTED_ACTIONS_VALIDATOR, logger, env),
                textColor = JsonParser.readOptionalExpression(json, "text_color", STRING_TO_COLOR_INT, logger, env, TEXT_COLOR_DEFAULT_VALUE, TYPE_HELPER_COLOR) ?: TEXT_COLOR_DEFAULT_VALUE,
                textVariable = JsonParser.read(json, "text_variable", TEXT_VARIABLE_VALIDATOR, logger, env),
                tooltips = JsonParser.readOptionalList(json, "tooltips", DivTooltip.CREATOR, TOOLTIPS_VALIDATOR, logger, env),
                transform = JsonParser.readOptional(json, "transform", DivTransform.CREATOR, logger, env) ?: TRANSFORM_DEFAULT_VALUE,
                transitionChange = JsonParser.readOptional(json, "transition_change", DivChangeTransition.CREATOR, logger, env),
                transitionIn = JsonParser.readOptional(json, "transition_in", DivAppearanceTransition.CREATOR, logger, env),
                transitionOut = JsonParser.readOptional(json, "transition_out", DivAppearanceTransition.CREATOR, logger, env),
                transitionTriggers = JsonParser.readOptionalList(json, "transition_triggers", DivTransitionTrigger.Converter.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR, logger, env),
                visibility = JsonParser.readOptionalExpression(json, "visibility", DivVisibility.Converter.FROM_STRING, logger, env, VISIBILITY_DEFAULT_VALUE, TYPE_HELPER_VISIBILITY) ?: VISIBILITY_DEFAULT_VALUE,
                visibilityAction = JsonParser.readOptional(json, "visibility_action", DivVisibilityAction.CREATOR, logger, env),
                visibilityActions = JsonParser.readOptionalList(json, "visibility_actions", DivVisibilityAction.CREATOR, VISIBILITY_ACTIONS_VALIDATOR, logger, env),
                width = JsonParser.readOptional(json, "width", DivSize.CREATOR, logger, env) ?: WIDTH_DEFAULT_VALUE
            )
        }

        private val ALPHA_TEMPLATE_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val ALPHA_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val BACKGROUND_VALIDATOR = ListValidator<DivBackground> { it: List<*> -> it.size >= 1 }
        private val COLUMN_SPAN_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val COLUMN_SPAN_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val EXTENSIONS_VALIDATOR = ListValidator<DivExtension> { it: List<*> -> it.size >= 1 }
        private val FONT_SIZE_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val FONT_SIZE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val HINT_TEXT_TEMPLATE_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val HINT_TEXT_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val ID_TEMPLATE_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val ID_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val LINE_HEIGHT_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val LINE_HEIGHT_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val MAX_VISIBLE_LINES_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it > 0 }
        private val MAX_VISIBLE_LINES_VALIDATOR = ValueValidator<Int> { it: Int -> it > 0 }
        private val ROW_SPAN_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val ROW_SPAN_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val SELECTED_ACTIONS_VALIDATOR = ListValidator<DivAction> { it: List<*> -> it.size >= 1 }
        private val TEXT_VARIABLE_TEMPLATE_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val TEXT_VARIABLE_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val TOOLTIPS_VALIDATOR = ListValidator<DivTooltip> { it: List<*> -> it.size >= 1 }
        private val TRANSITION_TRIGGERS_VALIDATOR = ListValidator<DivTransitionTrigger> { it: List<*> -> it.size >= 1 }
        private val VISIBILITY_ACTIONS_VALIDATOR = ListValidator<DivVisibilityAction> { it: List<*> -> it.size >= 1 }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivInput(env, json = it) }
    }


    @Mockable
    class NativeInterface(
        @JvmField final val color: Expression<Int>,
    ) : JSONSerializable {

        override fun writeToJSON(): JSONObject {
            val json = JSONObject()
            json.writeExpression(key = "color", value = color, converter = COLOR_INT_TO_STRING)
            return json
        }

        companion object {
            @JvmStatic
            @JvmName("fromJson")
            operator fun invoke(env: ParsingEnvironment, json: JSONObject): NativeInterface {
                val logger = env.logger
                return NativeInterface(
                    color = JsonParser.readExpression(json, "color", STRING_TO_COLOR_INT, logger, env, TYPE_HELPER_COLOR)
                )
            }

            val CREATOR = { env: ParsingEnvironment, it: JSONObject -> NativeInterface(env, json = it) }
        }

    }

    enum class KeyboardType(private val value: String) {
        SINGLE_LINE_TEXT("single_line_text"),
        MULTI_LINE_TEXT("multi_line_text"),
        PHONE("phone"),
        NUMBER("number"),
        EMAIL("email"),
        URI("uri");

        companion object Converter {
            fun toString(obj: KeyboardType): String {
                return obj.value
            }

            fun fromString(string: String): KeyboardType? {
                return when (string) {
                    SINGLE_LINE_TEXT.value -> SINGLE_LINE_TEXT
                    MULTI_LINE_TEXT.value -> MULTI_LINE_TEXT
                    PHONE.value -> PHONE
                    NUMBER.value -> NUMBER
                    EMAIL.value -> EMAIL
                    URI.value -> URI
                    else -> null
                }
            }

            val FROM_STRING = { string: String ->
                when (string) {
                    SINGLE_LINE_TEXT.value -> SINGLE_LINE_TEXT
                    MULTI_LINE_TEXT.value -> MULTI_LINE_TEXT
                    PHONE.value -> PHONE
                    NUMBER.value -> NUMBER
                    EMAIL.value -> EMAIL
                    URI.value -> URI
                    else -> null
                }
            }
        }
    }
}
