// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.json.*
import com.yandex.div.json.expressions.Expression
import com.yandex.div.json.expressions.ExpressionsList
import com.yandex.div.json.schema.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*

@Mockable
class DivLinearGradientTemplate : JSONSerializable, JsonTemplate<DivLinearGradient> {
    @JvmField final val angle: Field<Expression<Int>> // constraint: number >= 0 && number <= 360; default value: 0
    @JvmField final val colors: Field<ExpressionsList<Int>> // at least 2 elements

    constructor (
        env: ParsingEnvironment,
        parent: DivLinearGradientTemplate? = null,
        topLevel: Boolean = false,
        json: JSONObject
    ) {
        val logger = env.logger
        angle = JsonTemplateParser.readOptionalFieldWithExpression(json, "angle", topLevel, parent?.angle, NUMBER_TO_INT, ANGLE_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
        colors = JsonTemplateParser.readExpressionsListField(json, "colors", topLevel, parent?.colors, STRING_TO_COLOR_INT, COLORS_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_COLOR)
    }

    override fun resolve(env: ParsingEnvironment, data: JSONObject): DivLinearGradient {
        return DivLinearGradient(
            angle = angle.resolveOptional(env = env, key = "angle", data = data, reader = ANGLE_READER) ?: ANGLE_DEFAULT_VALUE,
            colors = colors.resolveExpressionList(env = env, key = "colors", data = data, reader = COLORS_READER)
        )
    }

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.writeFieldWithExpression(key = "angle", field = angle)
        json.writeExpressionsListField(key = "colors", field = colors, converter = COLOR_INT_TO_STRING)
        json.write(key = "type", value = TYPE)
        return json
    }

    companion object {
        const val TYPE = "gradient"

        private val ANGLE_DEFAULT_VALUE = Expression.constant(0)

        private val ANGLE_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 && it <= 360 }
        private val ANGLE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 && it <= 360 }
        private val COLORS_VALIDATOR = ListValidator<Int> { it: List<*> -> it.size >= 2 }
        private val COLORS_TEMPLATE_VALIDATOR = ListValidator<Int> { it: List<*> -> it.size >= 2 }

        val ANGLE_READER: Reader<Expression<Int>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, ANGLE_VALIDATOR, env.logger, env, ANGLE_DEFAULT_VALUE, TYPE_HELPER_INT) ?: ANGLE_DEFAULT_VALUE }
        val COLORS_READER: Reader<ExpressionsList<Int>> = { key, json, env -> JsonParser.readExpressionsList(json, key, STRING_TO_COLOR_INT, COLORS_VALIDATOR, env.logger, env, TYPE_HELPER_COLOR) }
        val TYPE_READER: Reader<String> = { key, json, env -> JsonParser.read(json, key, env.logger, env) }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivLinearGradientTemplate(env, json = it) }
    }

}
