// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.json.*
import com.yandex.div.json.expressions.Expression
import com.yandex.div.json.expressions.ExpressionsList
import com.yandex.div.json.schema.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*

@Mockable
class DivPager(
    override val accessibility: DivAccessibility = ACCESSIBILITY_DEFAULT_VALUE,
    override val alignmentHorizontal: Expression<DivAlignmentHorizontal>? = null,
    override val alignmentVertical: Expression<DivAlignmentVertical>? = null,
    override val alpha: Expression<Double> = ALPHA_DEFAULT_VALUE, // constraint: number >= 0.0 && number <= 1.0; default value: 1.0
    override val background: List<DivBackground>? = null, // at least 1 elements
    override val border: DivBorder = BORDER_DEFAULT_VALUE,
    override val columnSpan: Expression<Int>? = null, // constraint: number >= 0
    @JvmField final val defaultItem: Expression<Int> = DEFAULT_ITEM_DEFAULT_VALUE, // constraint: number >= 0; default value: 0
    override val extensions: List<DivExtension>? = null, // at least 1 elements
    override val focus: DivFocus? = null,
    override val height: DivSize = HEIGHT_DEFAULT_VALUE, // default value: DivSize.WrapContent(DivWrapContentSize())
    override val id: String? = null, // at least 1 char
    @JvmField final val itemSpacing: DivFixedSize = ITEM_SPACING_DEFAULT_VALUE, // default value: DivFixedSize(value = Expression.constant(0))
    @JvmField final val items: List<Div>, // at least 1 elements
    @JvmField final val layoutMode: DivPagerLayoutMode,
    override val margins: DivEdgeInsets = MARGINS_DEFAULT_VALUE,
    @JvmField final val orientation: Expression<Orientation> = ORIENTATION_DEFAULT_VALUE, // default value: horizontal
    override val paddings: DivEdgeInsets = PADDINGS_DEFAULT_VALUE,
    @JvmField final val restrictParentScroll: Expression<Boolean> = RESTRICT_PARENT_SCROLL_DEFAULT_VALUE, // default value: false
    override val rowSpan: Expression<Int>? = null, // constraint: number >= 0
    override val selectedActions: List<DivAction>? = null, // at least 1 elements
    override val tooltips: List<DivTooltip>? = null, // at least 1 elements
    override val transform: DivTransform = TRANSFORM_DEFAULT_VALUE,
    override val transitionChange: DivChangeTransition? = null,
    override val transitionIn: DivAppearanceTransition? = null,
    override val transitionOut: DivAppearanceTransition? = null,
    override val transitionTriggers: List<DivTransitionTrigger>? = null, // at least 1 elements
    override val visibility: Expression<DivVisibility> = VISIBILITY_DEFAULT_VALUE, // default value: visible
    override val visibilityAction: DivVisibilityAction? = null,
    override val visibilityActions: List<DivVisibilityAction>? = null, // at least 1 elements
    override val width: DivSize = WIDTH_DEFAULT_VALUE, // default value: DivSize.MatchParent(DivMatchParentSize())
) : JSONSerializable, DivBase {

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.write(key = "accessibility", value = accessibility)
        json.writeExpression(key = "alignment_horizontal", value = alignmentHorizontal, converter = { v: DivAlignmentHorizontal -> DivAlignmentHorizontal.toString(v) })
        json.writeExpression(key = "alignment_vertical", value = alignmentVertical, converter = { v: DivAlignmentVertical -> DivAlignmentVertical.toString(v) })
        json.writeExpression(key = "alpha", value = alpha)
        json.write(key = "background", value = background)
        json.write(key = "border", value = border)
        json.writeExpression(key = "column_span", value = columnSpan)
        json.writeExpression(key = "default_item", value = defaultItem)
        json.write(key = "extensions", value = extensions)
        json.write(key = "focus", value = focus)
        json.write(key = "height", value = height)
        json.write(key = "id", value = id)
        json.write(key = "item_spacing", value = itemSpacing)
        json.write(key = "items", value = items)
        json.write(key = "layout_mode", value = layoutMode)
        json.write(key = "margins", value = margins)
        json.writeExpression(key = "orientation", value = orientation, converter = { v: Orientation -> Orientation.toString(v) })
        json.write(key = "paddings", value = paddings)
        json.writeExpression(key = "restrict_parent_scroll", value = restrictParentScroll)
        json.writeExpression(key = "row_span", value = rowSpan)
        json.write(key = "selected_actions", value = selectedActions)
        json.write(key = "tooltips", value = tooltips)
        json.write(key = "transform", value = transform)
        json.write(key = "transition_change", value = transitionChange)
        json.write(key = "transition_in", value = transitionIn)
        json.write(key = "transition_out", value = transitionOut)
        json.write(key = "transition_triggers", value = transitionTriggers, converter = { v: DivTransitionTrigger -> DivTransitionTrigger.toString(v) })
        json.write(key = "type", value = TYPE)
        json.writeExpression(key = "visibility", value = visibility, converter = { v: DivVisibility -> DivVisibility.toString(v) })
        json.write(key = "visibility_action", value = visibilityAction)
        json.write(key = "visibility_actions", value = visibilityActions)
        json.write(key = "width", value = width)
        return json
    }

    fun copyWithNewArray(
        items: List<Div>,
    ) = DivPager(
        accessibility,
        alignmentHorizontal,
        alignmentVertical,
        alpha,
        background,
        border,
        columnSpan,
        defaultItem,
        extensions,
        focus,
        height,
        id,
        itemSpacing,
        items,
        layoutMode,
        margins,
        orientation,
        paddings,
        restrictParentScroll,
        rowSpan,
        selectedActions,
        tooltips,
        transform,
        transitionChange,
        transitionIn,
        transitionOut,
        transitionTriggers,
        visibility,
        visibilityAction,
        visibilityActions,
        width,
    )

    companion object {
        const val TYPE = "pager"

        private val ACCESSIBILITY_DEFAULT_VALUE = DivAccessibility()
        private val ALPHA_DEFAULT_VALUE = Expression.constant(1.0)
        private val BORDER_DEFAULT_VALUE = DivBorder()
        private val DEFAULT_ITEM_DEFAULT_VALUE = Expression.constant(0)
        private val HEIGHT_DEFAULT_VALUE = DivSize.WrapContent(DivWrapContentSize())
        private val ITEM_SPACING_DEFAULT_VALUE = DivFixedSize(value = Expression.constant(0))
        private val MARGINS_DEFAULT_VALUE = DivEdgeInsets()
        private val ORIENTATION_DEFAULT_VALUE = Expression.constant(Orientation.HORIZONTAL)
        private val PADDINGS_DEFAULT_VALUE = DivEdgeInsets()
        private val RESTRICT_PARENT_SCROLL_DEFAULT_VALUE = Expression.constant(false)
        private val TRANSFORM_DEFAULT_VALUE = DivTransform()
        private val VISIBILITY_DEFAULT_VALUE = Expression.constant(DivVisibility.VISIBLE)
        private val WIDTH_DEFAULT_VALUE = DivSize.MatchParent(DivMatchParentSize())

        private val TYPE_HELPER_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.values().first()) { it is DivAlignmentHorizontal }
        private val TYPE_HELPER_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.values().first()) { it is DivAlignmentVertical }
        private val TYPE_HELPER_ORIENTATION = TypeHelper.from(default = DivPager.Orientation.values().first()) { it is DivPager.Orientation }
        private val TYPE_HELPER_VISIBILITY = TypeHelper.from(default = DivVisibility.values().first()) { it is DivVisibility }

        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivPager {
            val logger = env.logger
            return DivPager(
                accessibility = JsonParser.readOptional(json, "accessibility", DivAccessibility.CREATOR, logger, env) ?: ACCESSIBILITY_DEFAULT_VALUE,
                alignmentHorizontal = JsonParser.readOptionalExpression(json, "alignment_horizontal", DivAlignmentHorizontal.Converter.FROM_STRING, logger, env, TYPE_HELPER_ALIGNMENT_HORIZONTAL),
                alignmentVertical = JsonParser.readOptionalExpression(json, "alignment_vertical", DivAlignmentVertical.Converter.FROM_STRING, logger, env, TYPE_HELPER_ALIGNMENT_VERTICAL),
                alpha = JsonParser.readOptionalExpression(json, "alpha", NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, logger, env, ALPHA_DEFAULT_VALUE, TYPE_HELPER_DOUBLE) ?: ALPHA_DEFAULT_VALUE,
                background = JsonParser.readOptionalList(json, "background", DivBackground.CREATOR, BACKGROUND_VALIDATOR, logger, env),
                border = JsonParser.readOptional(json, "border", DivBorder.CREATOR, logger, env) ?: BORDER_DEFAULT_VALUE,
                columnSpan = JsonParser.readOptionalExpression(json, "column_span", NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR, logger, env, TYPE_HELPER_INT),
                defaultItem = JsonParser.readOptionalExpression(json, "default_item", NUMBER_TO_INT, DEFAULT_ITEM_VALIDATOR, logger, env, DEFAULT_ITEM_DEFAULT_VALUE, TYPE_HELPER_INT) ?: DEFAULT_ITEM_DEFAULT_VALUE,
                extensions = JsonParser.readOptionalList(json, "extensions", DivExtension.CREATOR, EXTENSIONS_VALIDATOR, logger, env),
                focus = JsonParser.readOptional(json, "focus", DivFocus.CREATOR, logger, env),
                height = JsonParser.readOptional(json, "height", DivSize.CREATOR, logger, env) ?: HEIGHT_DEFAULT_VALUE,
                id = JsonParser.readOptional(json, "id", ID_VALIDATOR, logger, env),
                itemSpacing = JsonParser.readOptional(json, "item_spacing", DivFixedSize.CREATOR, logger, env) ?: ITEM_SPACING_DEFAULT_VALUE,
                items = JsonParser.readList(json, "items", Div.CREATOR, ITEMS_VALIDATOR, logger, env),
                layoutMode = JsonParser.read(json, "layout_mode", DivPagerLayoutMode.CREATOR, logger, env),
                margins = JsonParser.readOptional(json, "margins", DivEdgeInsets.CREATOR, logger, env) ?: MARGINS_DEFAULT_VALUE,
                orientation = JsonParser.readOptionalExpression(json, "orientation", Orientation.Converter.FROM_STRING, logger, env, ORIENTATION_DEFAULT_VALUE, TYPE_HELPER_ORIENTATION) ?: ORIENTATION_DEFAULT_VALUE,
                paddings = JsonParser.readOptional(json, "paddings", DivEdgeInsets.CREATOR, logger, env) ?: PADDINGS_DEFAULT_VALUE,
                restrictParentScroll = JsonParser.readOptionalExpression(json, "restrict_parent_scroll", ANY_TO_BOOLEAN, logger, env, RESTRICT_PARENT_SCROLL_DEFAULT_VALUE, TYPE_HELPER_BOOLEAN) ?: RESTRICT_PARENT_SCROLL_DEFAULT_VALUE,
                rowSpan = JsonParser.readOptionalExpression(json, "row_span", NUMBER_TO_INT, ROW_SPAN_VALIDATOR, logger, env, TYPE_HELPER_INT),
                selectedActions = JsonParser.readOptionalList(json, "selected_actions", DivAction.CREATOR, SELECTED_ACTIONS_VALIDATOR, logger, env),
                tooltips = JsonParser.readOptionalList(json, "tooltips", DivTooltip.CREATOR, TOOLTIPS_VALIDATOR, logger, env),
                transform = JsonParser.readOptional(json, "transform", DivTransform.CREATOR, logger, env) ?: TRANSFORM_DEFAULT_VALUE,
                transitionChange = JsonParser.readOptional(json, "transition_change", DivChangeTransition.CREATOR, logger, env),
                transitionIn = JsonParser.readOptional(json, "transition_in", DivAppearanceTransition.CREATOR, logger, env),
                transitionOut = JsonParser.readOptional(json, "transition_out", DivAppearanceTransition.CREATOR, logger, env),
                transitionTriggers = JsonParser.readOptionalList(json, "transition_triggers", DivTransitionTrigger.Converter.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR, logger, env),
                visibility = JsonParser.readOptionalExpression(json, "visibility", DivVisibility.Converter.FROM_STRING, logger, env, VISIBILITY_DEFAULT_VALUE, TYPE_HELPER_VISIBILITY) ?: VISIBILITY_DEFAULT_VALUE,
                visibilityAction = JsonParser.readOptional(json, "visibility_action", DivVisibilityAction.CREATOR, logger, env),
                visibilityActions = JsonParser.readOptionalList(json, "visibility_actions", DivVisibilityAction.CREATOR, VISIBILITY_ACTIONS_VALIDATOR, logger, env),
                width = JsonParser.readOptional(json, "width", DivSize.CREATOR, logger, env) ?: WIDTH_DEFAULT_VALUE
            )
        }

        private val ALPHA_TEMPLATE_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val ALPHA_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val BACKGROUND_VALIDATOR = ListValidator<DivBackground> { it: List<*> -> it.size >= 1 }
        private val COLUMN_SPAN_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val COLUMN_SPAN_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val DEFAULT_ITEM_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val DEFAULT_ITEM_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val EXTENSIONS_VALIDATOR = ListValidator<DivExtension> { it: List<*> -> it.size >= 1 }
        private val ID_TEMPLATE_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val ID_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val ITEMS_VALIDATOR = ListValidator<Div> { it: List<*> -> it.size >= 1 }
        private val ROW_SPAN_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val ROW_SPAN_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val SELECTED_ACTIONS_VALIDATOR = ListValidator<DivAction> { it: List<*> -> it.size >= 1 }
        private val TOOLTIPS_VALIDATOR = ListValidator<DivTooltip> { it: List<*> -> it.size >= 1 }
        private val TRANSITION_TRIGGERS_VALIDATOR = ListValidator<DivTransitionTrigger> { it: List<*> -> it.size >= 1 }
        private val VISIBILITY_ACTIONS_VALIDATOR = ListValidator<DivVisibilityAction> { it: List<*> -> it.size >= 1 }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivPager(env, json = it) }
    }


    enum class Orientation(private val value: String) {
        HORIZONTAL("horizontal"),
        VERTICAL("vertical");

        companion object Converter {
            fun toString(obj: Orientation): String {
                return obj.value
            }

            fun fromString(string: String): Orientation? {
                return when (string) {
                    HORIZONTAL.value -> HORIZONTAL
                    VERTICAL.value -> VERTICAL
                    else -> null
                }
            }

            val FROM_STRING = { string: String ->
                when (string) {
                    HORIZONTAL.value -> HORIZONTAL
                    VERTICAL.value -> VERTICAL
                    else -> null
                }
            }
        }
    }
}
