// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.json.*
import com.yandex.div.json.expressions.Expression
import com.yandex.div.json.expressions.ExpressionsList
import com.yandex.div.json.schema.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*

@Mockable
sealed class DivPivot : JSONSerializable {
    class Fixed(val value: DivPivotFixed) : DivPivot()
    class Percentage(val value: DivPivotPercentage) : DivPivot()

    fun value(): Any {
        return when (this) {
            is Fixed -> value
            is Percentage -> value
        }
    }

    override fun writeToJSON(): JSONObject {
        return when (this) {
            is Fixed -> value.writeToJSON()
            is Percentage -> value.writeToJSON()
        }
    }

    companion object {
        @Throws(ParsingException::class)
        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivPivot {
            val logger = env.logger
            val type: String = json.read("type", logger = logger, env = env)
            when (type) {
                DivPivotFixed.TYPE -> return Fixed(DivPivotFixed(env, json))
                DivPivotPercentage.TYPE -> return Percentage(DivPivotPercentage(env, json))
            }
            val template = env.templates.getOrThrow(type, json) as? DivPivotTemplate
            if (template != null) {
                return template.resolve(env, json)
            } else {
                throw typeMismatch(json = json, key = "type", value = type)
            }
        }
        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivPivot(env, json = it) }
    }
}
