// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.json.*
import com.yandex.div.json.expressions.Expression
import com.yandex.div.json.expressions.ExpressionsList
import com.yandex.div.json.schema.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*

@Mockable
class DivShadow(
    @JvmField final val alpha: Expression<Double> = ALPHA_DEFAULT_VALUE, // constraint: number >= 0.0 && number <= 1.0; default value: 0.19
    @JvmField final val blur: Expression<Int> = BLUR_DEFAULT_VALUE, // constraint: number >= 0; default value: 2
    @JvmField final val color: Expression<Int> = COLOR_DEFAULT_VALUE, // default value: #000000
    @JvmField final val offset: DivPoint,
) : JSONSerializable {

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.writeExpression(key = "alpha", value = alpha)
        json.writeExpression(key = "blur", value = blur)
        json.writeExpression(key = "color", value = color, converter = COLOR_INT_TO_STRING)
        json.write(key = "offset", value = offset)
        return json
    }

    companion object {
        private val ALPHA_DEFAULT_VALUE = Expression.constant(0.19)
        private val BLUR_DEFAULT_VALUE = Expression.constant(2)
        private val COLOR_DEFAULT_VALUE = Expression.constant(0x000000.toInt())

        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivShadow {
            val logger = env.logger
            return DivShadow(
                alpha = JsonParser.readOptionalExpression(json, "alpha", NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, logger, env, ALPHA_DEFAULT_VALUE, TYPE_HELPER_DOUBLE) ?: ALPHA_DEFAULT_VALUE,
                blur = JsonParser.readOptionalExpression(json, "blur", NUMBER_TO_INT, BLUR_VALIDATOR, logger, env, BLUR_DEFAULT_VALUE, TYPE_HELPER_INT) ?: BLUR_DEFAULT_VALUE,
                color = JsonParser.readOptionalExpression(json, "color", STRING_TO_COLOR_INT, logger, env, COLOR_DEFAULT_VALUE, TYPE_HELPER_COLOR) ?: COLOR_DEFAULT_VALUE,
                offset = JsonParser.read(json, "offset", DivPoint.CREATOR, logger, env)
            )
        }

        private val ALPHA_TEMPLATE_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val ALPHA_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val BLUR_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val BLUR_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivShadow(env, json = it) }
    }

}
