// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.json.*
import com.yandex.div.json.expressions.Expression
import com.yandex.div.json.expressions.ExpressionsList
import com.yandex.div.json.schema.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*

@Mockable
class DivShadowTemplate : JSONSerializable, JsonTemplate<DivShadow> {
    @JvmField final val alpha: Field<Expression<Double>> // constraint: number >= 0.0 && number <= 1.0; default value: 0.19
    @JvmField final val blur: Field<Expression<Int>> // constraint: number >= 0; default value: 2
    @JvmField final val color: Field<Expression<Int>> // default value: #000000
    @JvmField final val offset: Field<DivPointTemplate>

    constructor (
        env: ParsingEnvironment,
        parent: DivShadowTemplate? = null,
        topLevel: Boolean = false,
        json: JSONObject
    ) {
        val logger = env.logger
        alpha = JsonTemplateParser.readOptionalFieldWithExpression(json, "alpha", topLevel, parent?.alpha, NUMBER_TO_DOUBLE, ALPHA_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_DOUBLE)
        blur = JsonTemplateParser.readOptionalFieldWithExpression(json, "blur", topLevel, parent?.blur, NUMBER_TO_INT, BLUR_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
        color = JsonTemplateParser.readOptionalFieldWithExpression(json, "color", topLevel, parent?.color, STRING_TO_COLOR_INT, logger, env, TYPE_HELPER_COLOR)
        offset = JsonTemplateParser.readField(json, "offset", topLevel, parent?.offset, DivPointTemplate.CREATOR, logger, env)
    }

    override fun resolve(env: ParsingEnvironment, data: JSONObject): DivShadow {
        return DivShadow(
            alpha = alpha.resolveOptional(env = env, key = "alpha", data = data, reader = ALPHA_READER) ?: ALPHA_DEFAULT_VALUE,
            blur = blur.resolveOptional(env = env, key = "blur", data = data, reader = BLUR_READER) ?: BLUR_DEFAULT_VALUE,
            color = color.resolveOptional(env = env, key = "color", data = data, reader = COLOR_READER) ?: COLOR_DEFAULT_VALUE,
            offset = offset.resolveTemplate(env = env, key = "offset", data = data, reader = OFFSET_READER)
        )
    }

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.writeFieldWithExpression(key = "alpha", field = alpha)
        json.writeFieldWithExpression(key = "blur", field = blur)
        json.writeFieldWithExpression(key = "color", field = color, converter = COLOR_INT_TO_STRING)
        json.writeField(key = "offset", field = offset)
        return json
    }

    companion object {
        private val ALPHA_DEFAULT_VALUE = Expression.constant(0.19)
        private val BLUR_DEFAULT_VALUE = Expression.constant(2)
        private val COLOR_DEFAULT_VALUE = Expression.constant(0x000000.toInt())

        private val ALPHA_TEMPLATE_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val ALPHA_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val BLUR_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val BLUR_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }

        val ALPHA_READER: Reader<Expression<Double>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, env.logger, env, ALPHA_DEFAULT_VALUE, TYPE_HELPER_DOUBLE) ?: ALPHA_DEFAULT_VALUE }
        val BLUR_READER: Reader<Expression<Int>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, BLUR_VALIDATOR, env.logger, env, BLUR_DEFAULT_VALUE, TYPE_HELPER_INT) ?: BLUR_DEFAULT_VALUE }
        val COLOR_READER: Reader<Expression<Int>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, STRING_TO_COLOR_INT, env.logger, env, COLOR_DEFAULT_VALUE, TYPE_HELPER_COLOR) ?: COLOR_DEFAULT_VALUE }
        val OFFSET_READER: Reader<DivPoint> = { key, json, env -> JsonParser.read(json, key, DivPoint.CREATOR, env.logger, env) }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivShadowTemplate(env, json = it) }
    }

}
