// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.json.*
import com.yandex.div.json.expressions.Expression
import com.yandex.div.json.expressions.ExpressionsList
import com.yandex.div.json.schema.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*

@Mockable
class DivSlider(
    override val accessibility: DivAccessibility = ACCESSIBILITY_DEFAULT_VALUE,
    override val alignmentHorizontal: Expression<DivAlignmentHorizontal>? = null,
    override val alignmentVertical: Expression<DivAlignmentVertical>? = null,
    override val alpha: Expression<Double> = ALPHA_DEFAULT_VALUE, // constraint: number >= 0.0 && number <= 1.0; default value: 1.0
    override val background: List<DivBackground>? = null, // at least 1 elements
    override val border: DivBorder = BORDER_DEFAULT_VALUE,
    override val columnSpan: Expression<Int>? = null, // constraint: number >= 0
    override val extensions: List<DivExtension>? = null, // at least 1 elements
    override val focus: DivFocus? = null,
    override val height: DivSize = HEIGHT_DEFAULT_VALUE, // default value: DivSize.WrapContent(DivWrapContentSize())
    override val id: String? = null, // at least 1 char
    override val margins: DivEdgeInsets = MARGINS_DEFAULT_VALUE,
    @JvmField final val maxValue: Expression<Int> = MAX_VALUE_DEFAULT_VALUE, // default value: 100
    @JvmField final val minValue: Expression<Int> = MIN_VALUE_DEFAULT_VALUE, // default value: 0
    override val paddings: DivEdgeInsets = PADDINGS_DEFAULT_VALUE,
    override val rowSpan: Expression<Int>? = null, // constraint: number >= 0
    @JvmField final val secondaryValueAccessibility: DivAccessibility = SECONDARY_VALUE_ACCESSIBILITY_DEFAULT_VALUE,
    override val selectedActions: List<DivAction>? = null, // at least 1 elements
    @JvmField final val thumbSecondaryStyle: DivDrawable? = null,
    @JvmField final val thumbSecondaryTextStyle: TextStyle? = null,
    @JvmField final val thumbSecondaryValueVariable: String? = null, // at least 1 char
    @JvmField final val thumbStyle: DivDrawable,
    @JvmField final val thumbTextStyle: TextStyle? = null,
    @JvmField final val thumbValueVariable: String? = null, // at least 1 char
    @JvmField final val tickMarkActiveStyle: DivDrawable? = null,
    @JvmField final val tickMarkInactiveStyle: DivDrawable? = null,
    override val tooltips: List<DivTooltip>? = null, // at least 1 elements
    @JvmField final val trackActiveStyle: DivDrawable,
    @JvmField final val trackInactiveStyle: DivDrawable,
    override val transform: DivTransform = TRANSFORM_DEFAULT_VALUE,
    override val transitionChange: DivChangeTransition? = null,
    override val transitionIn: DivAppearanceTransition? = null,
    override val transitionOut: DivAppearanceTransition? = null,
    override val transitionTriggers: List<DivTransitionTrigger>? = null, // at least 1 elements
    override val visibility: Expression<DivVisibility> = VISIBILITY_DEFAULT_VALUE, // default value: visible
    override val visibilityAction: DivVisibilityAction? = null,
    override val visibilityActions: List<DivVisibilityAction>? = null, // at least 1 elements
    override val width: DivSize = WIDTH_DEFAULT_VALUE, // default value: DivSize.MatchParent(DivMatchParentSize())
) : JSONSerializable, DivBase {

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.write(key = "accessibility", value = accessibility)
        json.writeExpression(key = "alignment_horizontal", value = alignmentHorizontal, converter = { v: DivAlignmentHorizontal -> DivAlignmentHorizontal.toString(v) })
        json.writeExpression(key = "alignment_vertical", value = alignmentVertical, converter = { v: DivAlignmentVertical -> DivAlignmentVertical.toString(v) })
        json.writeExpression(key = "alpha", value = alpha)
        json.write(key = "background", value = background)
        json.write(key = "border", value = border)
        json.writeExpression(key = "column_span", value = columnSpan)
        json.write(key = "extensions", value = extensions)
        json.write(key = "focus", value = focus)
        json.write(key = "height", value = height)
        json.write(key = "id", value = id)
        json.write(key = "margins", value = margins)
        json.writeExpression(key = "max_value", value = maxValue)
        json.writeExpression(key = "min_value", value = minValue)
        json.write(key = "paddings", value = paddings)
        json.writeExpression(key = "row_span", value = rowSpan)
        json.write(key = "secondary_value_accessibility", value = secondaryValueAccessibility)
        json.write(key = "selected_actions", value = selectedActions)
        json.write(key = "thumb_secondary_style", value = thumbSecondaryStyle)
        json.write(key = "thumb_secondary_text_style", value = thumbSecondaryTextStyle)
        json.write(key = "thumb_secondary_value_variable", value = thumbSecondaryValueVariable)
        json.write(key = "thumb_style", value = thumbStyle)
        json.write(key = "thumb_text_style", value = thumbTextStyle)
        json.write(key = "thumb_value_variable", value = thumbValueVariable)
        json.write(key = "tick_mark_active_style", value = tickMarkActiveStyle)
        json.write(key = "tick_mark_inactive_style", value = tickMarkInactiveStyle)
        json.write(key = "tooltips", value = tooltips)
        json.write(key = "track_active_style", value = trackActiveStyle)
        json.write(key = "track_inactive_style", value = trackInactiveStyle)
        json.write(key = "transform", value = transform)
        json.write(key = "transition_change", value = transitionChange)
        json.write(key = "transition_in", value = transitionIn)
        json.write(key = "transition_out", value = transitionOut)
        json.write(key = "transition_triggers", value = transitionTriggers, converter = { v: DivTransitionTrigger -> DivTransitionTrigger.toString(v) })
        json.write(key = "type", value = TYPE)
        json.writeExpression(key = "visibility", value = visibility, converter = { v: DivVisibility -> DivVisibility.toString(v) })
        json.write(key = "visibility_action", value = visibilityAction)
        json.write(key = "visibility_actions", value = visibilityActions)
        json.write(key = "width", value = width)
        return json
    }

    companion object {
        const val TYPE = "slider"

        private val ACCESSIBILITY_DEFAULT_VALUE = DivAccessibility()
        private val ALPHA_DEFAULT_VALUE = Expression.constant(1.0)
        private val BORDER_DEFAULT_VALUE = DivBorder()
        private val HEIGHT_DEFAULT_VALUE = DivSize.WrapContent(DivWrapContentSize())
        private val MARGINS_DEFAULT_VALUE = DivEdgeInsets()
        private val MAX_VALUE_DEFAULT_VALUE = Expression.constant(100)
        private val MIN_VALUE_DEFAULT_VALUE = Expression.constant(0)
        private val PADDINGS_DEFAULT_VALUE = DivEdgeInsets()
        private val SECONDARY_VALUE_ACCESSIBILITY_DEFAULT_VALUE = DivAccessibility()
        private val TRANSFORM_DEFAULT_VALUE = DivTransform()
        private val VISIBILITY_DEFAULT_VALUE = Expression.constant(DivVisibility.VISIBLE)
        private val WIDTH_DEFAULT_VALUE = DivSize.MatchParent(DivMatchParentSize())

        private val TYPE_HELPER_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.values().first()) { it is DivAlignmentHorizontal }
        private val TYPE_HELPER_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.values().first()) { it is DivAlignmentVertical }
        private val TYPE_HELPER_VISIBILITY = TypeHelper.from(default = DivVisibility.values().first()) { it is DivVisibility }

        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivSlider {
            val logger = env.logger
            return DivSlider(
                accessibility = JsonParser.readOptional(json, "accessibility", DivAccessibility.CREATOR, logger, env) ?: ACCESSIBILITY_DEFAULT_VALUE,
                alignmentHorizontal = JsonParser.readOptionalExpression(json, "alignment_horizontal", DivAlignmentHorizontal.Converter.FROM_STRING, logger, env, TYPE_HELPER_ALIGNMENT_HORIZONTAL),
                alignmentVertical = JsonParser.readOptionalExpression(json, "alignment_vertical", DivAlignmentVertical.Converter.FROM_STRING, logger, env, TYPE_HELPER_ALIGNMENT_VERTICAL),
                alpha = JsonParser.readOptionalExpression(json, "alpha", NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, logger, env, ALPHA_DEFAULT_VALUE, TYPE_HELPER_DOUBLE) ?: ALPHA_DEFAULT_VALUE,
                background = JsonParser.readOptionalList(json, "background", DivBackground.CREATOR, BACKGROUND_VALIDATOR, logger, env),
                border = JsonParser.readOptional(json, "border", DivBorder.CREATOR, logger, env) ?: BORDER_DEFAULT_VALUE,
                columnSpan = JsonParser.readOptionalExpression(json, "column_span", NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR, logger, env, TYPE_HELPER_INT),
                extensions = JsonParser.readOptionalList(json, "extensions", DivExtension.CREATOR, EXTENSIONS_VALIDATOR, logger, env),
                focus = JsonParser.readOptional(json, "focus", DivFocus.CREATOR, logger, env),
                height = JsonParser.readOptional(json, "height", DivSize.CREATOR, logger, env) ?: HEIGHT_DEFAULT_VALUE,
                id = JsonParser.readOptional(json, "id", ID_VALIDATOR, logger, env),
                margins = JsonParser.readOptional(json, "margins", DivEdgeInsets.CREATOR, logger, env) ?: MARGINS_DEFAULT_VALUE,
                maxValue = JsonParser.readOptionalExpression(json, "max_value", NUMBER_TO_INT, logger, env, MAX_VALUE_DEFAULT_VALUE, TYPE_HELPER_INT) ?: MAX_VALUE_DEFAULT_VALUE,
                minValue = JsonParser.readOptionalExpression(json, "min_value", NUMBER_TO_INT, logger, env, MIN_VALUE_DEFAULT_VALUE, TYPE_HELPER_INT) ?: MIN_VALUE_DEFAULT_VALUE,
                paddings = JsonParser.readOptional(json, "paddings", DivEdgeInsets.CREATOR, logger, env) ?: PADDINGS_DEFAULT_VALUE,
                rowSpan = JsonParser.readOptionalExpression(json, "row_span", NUMBER_TO_INT, ROW_SPAN_VALIDATOR, logger, env, TYPE_HELPER_INT),
                secondaryValueAccessibility = JsonParser.readOptional(json, "secondary_value_accessibility", DivAccessibility.CREATOR, logger, env) ?: SECONDARY_VALUE_ACCESSIBILITY_DEFAULT_VALUE,
                selectedActions = JsonParser.readOptionalList(json, "selected_actions", DivAction.CREATOR, SELECTED_ACTIONS_VALIDATOR, logger, env),
                thumbSecondaryStyle = JsonParser.readOptional(json, "thumb_secondary_style", DivDrawable.CREATOR, logger, env),
                thumbSecondaryTextStyle = JsonParser.readOptional(json, "thumb_secondary_text_style", TextStyle.CREATOR, logger, env),
                thumbSecondaryValueVariable = JsonParser.readOptional(json, "thumb_secondary_value_variable", THUMB_SECONDARY_VALUE_VARIABLE_VALIDATOR, logger, env),
                thumbStyle = JsonParser.read(json, "thumb_style", DivDrawable.CREATOR, logger, env),
                thumbTextStyle = JsonParser.readOptional(json, "thumb_text_style", TextStyle.CREATOR, logger, env),
                thumbValueVariable = JsonParser.readOptional(json, "thumb_value_variable", THUMB_VALUE_VARIABLE_VALIDATOR, logger, env),
                tickMarkActiveStyle = JsonParser.readOptional(json, "tick_mark_active_style", DivDrawable.CREATOR, logger, env),
                tickMarkInactiveStyle = JsonParser.readOptional(json, "tick_mark_inactive_style", DivDrawable.CREATOR, logger, env),
                tooltips = JsonParser.readOptionalList(json, "tooltips", DivTooltip.CREATOR, TOOLTIPS_VALIDATOR, logger, env),
                trackActiveStyle = JsonParser.read(json, "track_active_style", DivDrawable.CREATOR, logger, env),
                trackInactiveStyle = JsonParser.read(json, "track_inactive_style", DivDrawable.CREATOR, logger, env),
                transform = JsonParser.readOptional(json, "transform", DivTransform.CREATOR, logger, env) ?: TRANSFORM_DEFAULT_VALUE,
                transitionChange = JsonParser.readOptional(json, "transition_change", DivChangeTransition.CREATOR, logger, env),
                transitionIn = JsonParser.readOptional(json, "transition_in", DivAppearanceTransition.CREATOR, logger, env),
                transitionOut = JsonParser.readOptional(json, "transition_out", DivAppearanceTransition.CREATOR, logger, env),
                transitionTriggers = JsonParser.readOptionalList(json, "transition_triggers", DivTransitionTrigger.Converter.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR, logger, env),
                visibility = JsonParser.readOptionalExpression(json, "visibility", DivVisibility.Converter.FROM_STRING, logger, env, VISIBILITY_DEFAULT_VALUE, TYPE_HELPER_VISIBILITY) ?: VISIBILITY_DEFAULT_VALUE,
                visibilityAction = JsonParser.readOptional(json, "visibility_action", DivVisibilityAction.CREATOR, logger, env),
                visibilityActions = JsonParser.readOptionalList(json, "visibility_actions", DivVisibilityAction.CREATOR, VISIBILITY_ACTIONS_VALIDATOR, logger, env),
                width = JsonParser.readOptional(json, "width", DivSize.CREATOR, logger, env) ?: WIDTH_DEFAULT_VALUE
            )
        }

        private val ALPHA_TEMPLATE_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val ALPHA_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val BACKGROUND_VALIDATOR = ListValidator<DivBackground> { it: List<*> -> it.size >= 1 }
        private val COLUMN_SPAN_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val COLUMN_SPAN_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val EXTENSIONS_VALIDATOR = ListValidator<DivExtension> { it: List<*> -> it.size >= 1 }
        private val ID_TEMPLATE_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val ID_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val ROW_SPAN_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val ROW_SPAN_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val SELECTED_ACTIONS_VALIDATOR = ListValidator<DivAction> { it: List<*> -> it.size >= 1 }
        private val THUMB_SECONDARY_VALUE_VARIABLE_TEMPLATE_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val THUMB_SECONDARY_VALUE_VARIABLE_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val THUMB_VALUE_VARIABLE_TEMPLATE_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val THUMB_VALUE_VARIABLE_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val TOOLTIPS_VALIDATOR = ListValidator<DivTooltip> { it: List<*> -> it.size >= 1 }
        private val TRANSITION_TRIGGERS_VALIDATOR = ListValidator<DivTransitionTrigger> { it: List<*> -> it.size >= 1 }
        private val VISIBILITY_ACTIONS_VALIDATOR = ListValidator<DivVisibilityAction> { it: List<*> -> it.size >= 1 }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivSlider(env, json = it) }
    }


    @Mockable
    class TextStyle(
        @JvmField final val fontSize: Expression<Int>, // constraint: number >= 0
        @JvmField final val fontSizeUnit: Expression<DivSizeUnit> = FONT_SIZE_UNIT_DEFAULT_VALUE, // default value: sp
        @JvmField final val fontWeight: Expression<DivFontWeight> = FONT_WEIGHT_DEFAULT_VALUE, // default value: regular
        @JvmField final val offset: DivPoint? = null,
        @JvmField final val textColor: Expression<Int> = TEXT_COLOR_DEFAULT_VALUE, // default value: #FF000000
    ) : JSONSerializable {

        override fun writeToJSON(): JSONObject {
            val json = JSONObject()
            json.writeExpression(key = "font_size", value = fontSize)
            json.writeExpression(key = "font_size_unit", value = fontSizeUnit, converter = { v: DivSizeUnit -> DivSizeUnit.toString(v) })
            json.writeExpression(key = "font_weight", value = fontWeight, converter = { v: DivFontWeight -> DivFontWeight.toString(v) })
            json.write(key = "offset", value = offset)
            json.writeExpression(key = "text_color", value = textColor, converter = COLOR_INT_TO_STRING)
            return json
        }

        companion object {
            private val FONT_SIZE_UNIT_DEFAULT_VALUE = Expression.constant(DivSizeUnit.SP)
            private val FONT_WEIGHT_DEFAULT_VALUE = Expression.constant(DivFontWeight.REGULAR)
            private val TEXT_COLOR_DEFAULT_VALUE = Expression.constant(0xFF000000.toInt())

            private val TYPE_HELPER_FONT_SIZE_UNIT = TypeHelper.from(default = DivSizeUnit.values().first()) { it is DivSizeUnit }
            private val TYPE_HELPER_FONT_WEIGHT = TypeHelper.from(default = DivFontWeight.values().first()) { it is DivFontWeight }

            @JvmStatic
            @JvmName("fromJson")
            operator fun invoke(env: ParsingEnvironment, json: JSONObject): TextStyle {
                val logger = env.logger
                return TextStyle(
                    fontSize = JsonParser.readExpression(json, "font_size", NUMBER_TO_INT, FONT_SIZE_VALIDATOR, logger, env, TYPE_HELPER_INT),
                    fontSizeUnit = JsonParser.readOptionalExpression(json, "font_size_unit", DivSizeUnit.Converter.FROM_STRING, logger, env, FONT_SIZE_UNIT_DEFAULT_VALUE, TYPE_HELPER_FONT_SIZE_UNIT) ?: FONT_SIZE_UNIT_DEFAULT_VALUE,
                    fontWeight = JsonParser.readOptionalExpression(json, "font_weight", DivFontWeight.Converter.FROM_STRING, logger, env, FONT_WEIGHT_DEFAULT_VALUE, TYPE_HELPER_FONT_WEIGHT) ?: FONT_WEIGHT_DEFAULT_VALUE,
                    offset = JsonParser.readOptional(json, "offset", DivPoint.CREATOR, logger, env),
                    textColor = JsonParser.readOptionalExpression(json, "text_color", STRING_TO_COLOR_INT, logger, env, TEXT_COLOR_DEFAULT_VALUE, TYPE_HELPER_COLOR) ?: TEXT_COLOR_DEFAULT_VALUE
                )
            }

            private val FONT_SIZE_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
            private val FONT_SIZE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }

            val CREATOR = { env: ParsingEnvironment, it: JSONObject -> TextStyle(env, json = it) }
        }

    }
}
