// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.json.*
import com.yandex.div.json.expressions.Expression
import com.yandex.div.json.expressions.ExpressionsList
import com.yandex.div.json.schema.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*

@Mockable
class DivStrokeTemplate : JSONSerializable, JsonTemplate<DivStroke> {
    @JvmField final val color: Field<Expression<Int>>
    @JvmField final val unit: Field<Expression<DivSizeUnit>> // default value: dp
    @JvmField final val width: Field<Expression<Int>> // constraint: number >= 0; default value: 1

    constructor (
        env: ParsingEnvironment,
        parent: DivStrokeTemplate? = null,
        topLevel: Boolean = false,
        json: JSONObject
    ) {
        val logger = env.logger
        color = JsonTemplateParser.readFieldWithExpression(json, "color", topLevel, parent?.color, STRING_TO_COLOR_INT, logger, env, TYPE_HELPER_COLOR)
        unit = JsonTemplateParser.readOptionalFieldWithExpression(json, "unit", topLevel, parent?.unit, DivSizeUnit.Converter.FROM_STRING, logger, env, TYPE_HELPER_UNIT)
        width = JsonTemplateParser.readOptionalFieldWithExpression(json, "width", topLevel, parent?.width, NUMBER_TO_INT, WIDTH_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
    }

    override fun resolve(env: ParsingEnvironment, data: JSONObject): DivStroke {
        return DivStroke(
            color = color.resolve(env = env, key = "color", data = data, reader = COLOR_READER),
            unit = unit.resolveOptional(env = env, key = "unit", data = data, reader = UNIT_READER) ?: UNIT_DEFAULT_VALUE,
            width = width.resolveOptional(env = env, key = "width", data = data, reader = WIDTH_READER) ?: WIDTH_DEFAULT_VALUE
        )
    }

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.writeFieldWithExpression(key = "color", field = color, converter = COLOR_INT_TO_STRING)
        json.writeFieldWithExpression(key = "unit", field = unit, converter = { v: DivSizeUnit -> DivSizeUnit.toString(v) })
        json.writeFieldWithExpression(key = "width", field = width)
        return json
    }

    companion object {
        private val UNIT_DEFAULT_VALUE = Expression.constant(DivSizeUnit.DP)
        private val WIDTH_DEFAULT_VALUE = Expression.constant(1)

        private val TYPE_HELPER_UNIT = TypeHelper.from(default = DivSizeUnit.values().first()) { it is DivSizeUnit }

        private val WIDTH_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val WIDTH_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }

        val COLOR_READER: Reader<Expression<Int>> = { key, json, env -> JsonParser.readExpression(json, key, STRING_TO_COLOR_INT, env.logger, env, TYPE_HELPER_COLOR) }
        val UNIT_READER: Reader<Expression<DivSizeUnit>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivSizeUnit.Converter.FROM_STRING, env.logger, env, UNIT_DEFAULT_VALUE, TYPE_HELPER_UNIT) ?: UNIT_DEFAULT_VALUE }
        val WIDTH_READER: Reader<Expression<Int>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, WIDTH_VALIDATOR, env.logger, env, WIDTH_DEFAULT_VALUE, TYPE_HELPER_INT) ?: WIDTH_DEFAULT_VALUE }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivStrokeTemplate(env, json = it) }
    }

}
