// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.json.*
import com.yandex.div.json.expressions.Expression
import com.yandex.div.json.expressions.ExpressionsList
import com.yandex.div.json.schema.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*

@Mockable
class DivText(
    override val accessibility: DivAccessibility = ACCESSIBILITY_DEFAULT_VALUE,
    @JvmField final val action: DivAction? = null,
    @JvmField final val actionAnimation: DivAnimation = ACTION_ANIMATION_DEFAULT_VALUE, // default value: DivAnimation(duration = Expression.constant(100), endValue = Expression.constant(0.6), name = Expression.constant(DivAnimation.Name.FADE), startValue = Expression.constant(1.0))
    @JvmField final val actions: List<DivAction>? = null, // at least 1 elements
    override val alignmentHorizontal: Expression<DivAlignmentHorizontal>? = null,
    override val alignmentVertical: Expression<DivAlignmentVertical>? = null,
    override val alpha: Expression<Double> = ALPHA_DEFAULT_VALUE, // constraint: number >= 0.0 && number <= 1.0; default value: 1.0
    @JvmField final val autoEllipsize: Expression<Boolean>? = null,
    override val background: List<DivBackground>? = null, // at least 1 elements
    override val border: DivBorder = BORDER_DEFAULT_VALUE,
    override val columnSpan: Expression<Int>? = null, // constraint: number >= 0
    @JvmField final val doubletapActions: List<DivAction>? = null, // at least 1 elements
    @JvmField final val ellipsis: Ellipsis? = null,
    override val extensions: List<DivExtension>? = null, // at least 1 elements
    override val focus: DivFocus? = null,
    @JvmField final val focusedTextColor: Expression<Int>? = null,
    @JvmField final val fontFamily: Expression<DivFontFamily> = FONT_FAMILY_DEFAULT_VALUE, // default value: text
    @JvmField final val fontSize: Expression<Int> = FONT_SIZE_DEFAULT_VALUE, // constraint: number >= 0; default value: 12
    @JvmField final val fontSizeUnit: Expression<DivSizeUnit> = FONT_SIZE_UNIT_DEFAULT_VALUE, // default value: sp
    @JvmField final val fontWeight: Expression<DivFontWeight> = FONT_WEIGHT_DEFAULT_VALUE, // default value: regular
    override val height: DivSize = HEIGHT_DEFAULT_VALUE, // default value: DivSize.WrapContent(DivWrapContentSize())
    override val id: String? = null, // at least 1 char
    @JvmField final val images: List<Image>? = null, // at least 1 elements
    @JvmField final val letterSpacing: Expression<Double> = LETTER_SPACING_DEFAULT_VALUE, // default value: 0
    @JvmField final val lineHeight: Expression<Int>? = null, // constraint: number >= 0
    @JvmField final val longtapActions: List<DivAction>? = null, // at least 1 elements
    override val margins: DivEdgeInsets = MARGINS_DEFAULT_VALUE,
    @JvmField final val maxLines: Expression<Int>? = null, // constraint: number >= 0
    @JvmField final val minHiddenLines: Expression<Int>? = null, // constraint: number >= 0
    override val paddings: DivEdgeInsets = PADDINGS_DEFAULT_VALUE,
    @JvmField final val ranges: List<Range>? = null, // at least 1 elements
    override val rowSpan: Expression<Int>? = null, // constraint: number >= 0
    @JvmField final val selectable: Expression<Boolean> = SELECTABLE_DEFAULT_VALUE, // default value: false
    override val selectedActions: List<DivAction>? = null, // at least 1 elements
    @JvmField final val strike: Expression<DivLineStyle> = STRIKE_DEFAULT_VALUE, // default value: none
    @JvmField final val text: Expression<String>, // at least 1 char
    @JvmField final val textAlignmentHorizontal: Expression<DivAlignmentHorizontal> = TEXT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE, // default value: left
    @JvmField final val textAlignmentVertical: Expression<DivAlignmentVertical> = TEXT_ALIGNMENT_VERTICAL_DEFAULT_VALUE, // default value: top
    @JvmField final val textColor: Expression<Int> = TEXT_COLOR_DEFAULT_VALUE, // default value: #FF000000
    @JvmField final val textGradient: DivTextGradient? = null,
    override val tooltips: List<DivTooltip>? = null, // at least 1 elements
    override val transform: DivTransform = TRANSFORM_DEFAULT_VALUE,
    override val transitionChange: DivChangeTransition? = null,
    override val transitionIn: DivAppearanceTransition? = null,
    override val transitionOut: DivAppearanceTransition? = null,
    override val transitionTriggers: List<DivTransitionTrigger>? = null, // at least 1 elements
    @JvmField final val underline: Expression<DivLineStyle> = UNDERLINE_DEFAULT_VALUE, // default value: none
    override val visibility: Expression<DivVisibility> = VISIBILITY_DEFAULT_VALUE, // default value: visible
    override val visibilityAction: DivVisibilityAction? = null,
    override val visibilityActions: List<DivVisibilityAction>? = null, // at least 1 elements
    override val width: DivSize = WIDTH_DEFAULT_VALUE, // default value: DivSize.MatchParent(DivMatchParentSize())
) : JSONSerializable, DivBase {

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.write(key = "accessibility", value = accessibility)
        json.write(key = "action", value = action)
        json.write(key = "action_animation", value = actionAnimation)
        json.write(key = "actions", value = actions)
        json.writeExpression(key = "alignment_horizontal", value = alignmentHorizontal, converter = { v: DivAlignmentHorizontal -> DivAlignmentHorizontal.toString(v) })
        json.writeExpression(key = "alignment_vertical", value = alignmentVertical, converter = { v: DivAlignmentVertical -> DivAlignmentVertical.toString(v) })
        json.writeExpression(key = "alpha", value = alpha)
        json.writeExpression(key = "auto_ellipsize", value = autoEllipsize)
        json.write(key = "background", value = background)
        json.write(key = "border", value = border)
        json.writeExpression(key = "column_span", value = columnSpan)
        json.write(key = "doubletap_actions", value = doubletapActions)
        json.write(key = "ellipsis", value = ellipsis)
        json.write(key = "extensions", value = extensions)
        json.write(key = "focus", value = focus)
        json.writeExpression(key = "focused_text_color", value = focusedTextColor, converter = COLOR_INT_TO_STRING)
        json.writeExpression(key = "font_family", value = fontFamily, converter = { v: DivFontFamily -> DivFontFamily.toString(v) })
        json.writeExpression(key = "font_size", value = fontSize)
        json.writeExpression(key = "font_size_unit", value = fontSizeUnit, converter = { v: DivSizeUnit -> DivSizeUnit.toString(v) })
        json.writeExpression(key = "font_weight", value = fontWeight, converter = { v: DivFontWeight -> DivFontWeight.toString(v) })
        json.write(key = "height", value = height)
        json.write(key = "id", value = id)
        json.write(key = "images", value = images)
        json.writeExpression(key = "letter_spacing", value = letterSpacing)
        json.writeExpression(key = "line_height", value = lineHeight)
        json.write(key = "longtap_actions", value = longtapActions)
        json.write(key = "margins", value = margins)
        json.writeExpression(key = "max_lines", value = maxLines)
        json.writeExpression(key = "min_hidden_lines", value = minHiddenLines)
        json.write(key = "paddings", value = paddings)
        json.write(key = "ranges", value = ranges)
        json.writeExpression(key = "row_span", value = rowSpan)
        json.writeExpression(key = "selectable", value = selectable)
        json.write(key = "selected_actions", value = selectedActions)
        json.writeExpression(key = "strike", value = strike, converter = { v: DivLineStyle -> DivLineStyle.toString(v) })
        json.writeExpression(key = "text", value = text)
        json.writeExpression(key = "text_alignment_horizontal", value = textAlignmentHorizontal, converter = { v: DivAlignmentHorizontal -> DivAlignmentHorizontal.toString(v) })
        json.writeExpression(key = "text_alignment_vertical", value = textAlignmentVertical, converter = { v: DivAlignmentVertical -> DivAlignmentVertical.toString(v) })
        json.writeExpression(key = "text_color", value = textColor, converter = COLOR_INT_TO_STRING)
        json.write(key = "text_gradient", value = textGradient)
        json.write(key = "tooltips", value = tooltips)
        json.write(key = "transform", value = transform)
        json.write(key = "transition_change", value = transitionChange)
        json.write(key = "transition_in", value = transitionIn)
        json.write(key = "transition_out", value = transitionOut)
        json.write(key = "transition_triggers", value = transitionTriggers, converter = { v: DivTransitionTrigger -> DivTransitionTrigger.toString(v) })
        json.write(key = "type", value = TYPE)
        json.writeExpression(key = "underline", value = underline, converter = { v: DivLineStyle -> DivLineStyle.toString(v) })
        json.writeExpression(key = "visibility", value = visibility, converter = { v: DivVisibility -> DivVisibility.toString(v) })
        json.write(key = "visibility_action", value = visibilityAction)
        json.write(key = "visibility_actions", value = visibilityActions)
        json.write(key = "width", value = width)
        return json
    }

    companion object {
        const val TYPE = "text"

        private val ACCESSIBILITY_DEFAULT_VALUE = DivAccessibility()
        private val ACTION_ANIMATION_DEFAULT_VALUE = DivAnimation(duration = Expression.constant(100), endValue = Expression.constant(0.6), name = Expression.constant(DivAnimation.Name.FADE), startValue = Expression.constant(1.0))
        private val ALPHA_DEFAULT_VALUE = Expression.constant(1.0)
        private val BORDER_DEFAULT_VALUE = DivBorder()
        private val FONT_FAMILY_DEFAULT_VALUE = Expression.constant(DivFontFamily.TEXT)
        private val FONT_SIZE_DEFAULT_VALUE = Expression.constant(12)
        private val FONT_SIZE_UNIT_DEFAULT_VALUE = Expression.constant(DivSizeUnit.SP)
        private val FONT_WEIGHT_DEFAULT_VALUE = Expression.constant(DivFontWeight.REGULAR)
        private val HEIGHT_DEFAULT_VALUE = DivSize.WrapContent(DivWrapContentSize())
        private val LETTER_SPACING_DEFAULT_VALUE = Expression.constant(0.0)
        private val MARGINS_DEFAULT_VALUE = DivEdgeInsets()
        private val PADDINGS_DEFAULT_VALUE = DivEdgeInsets()
        private val SELECTABLE_DEFAULT_VALUE = Expression.constant(false)
        private val STRIKE_DEFAULT_VALUE = Expression.constant(DivLineStyle.NONE)
        private val TEXT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE = Expression.constant(DivAlignmentHorizontal.LEFT)
        private val TEXT_ALIGNMENT_VERTICAL_DEFAULT_VALUE = Expression.constant(DivAlignmentVertical.TOP)
        private val TEXT_COLOR_DEFAULT_VALUE = Expression.constant(0xFF000000.toInt())
        private val TRANSFORM_DEFAULT_VALUE = DivTransform()
        private val UNDERLINE_DEFAULT_VALUE = Expression.constant(DivLineStyle.NONE)
        private val VISIBILITY_DEFAULT_VALUE = Expression.constant(DivVisibility.VISIBLE)
        private val WIDTH_DEFAULT_VALUE = DivSize.MatchParent(DivMatchParentSize())

        private val TYPE_HELPER_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.values().first()) { it is DivAlignmentHorizontal }
        private val TYPE_HELPER_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.values().first()) { it is DivAlignmentVertical }
        private val TYPE_HELPER_FONT_FAMILY = TypeHelper.from(default = DivFontFamily.values().first()) { it is DivFontFamily }
        private val TYPE_HELPER_FONT_SIZE_UNIT = TypeHelper.from(default = DivSizeUnit.values().first()) { it is DivSizeUnit }
        private val TYPE_HELPER_FONT_WEIGHT = TypeHelper.from(default = DivFontWeight.values().first()) { it is DivFontWeight }
        private val TYPE_HELPER_STRIKE = TypeHelper.from(default = DivLineStyle.values().first()) { it is DivLineStyle }
        private val TYPE_HELPER_TEXT_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.values().first()) { it is DivAlignmentHorizontal }
        private val TYPE_HELPER_TEXT_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.values().first()) { it is DivAlignmentVertical }
        private val TYPE_HELPER_UNDERLINE = TypeHelper.from(default = DivLineStyle.values().first()) { it is DivLineStyle }
        private val TYPE_HELPER_VISIBILITY = TypeHelper.from(default = DivVisibility.values().first()) { it is DivVisibility }

        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivText {
            val logger = env.logger
            return DivText(
                accessibility = JsonParser.readOptional(json, "accessibility", DivAccessibility.CREATOR, logger, env) ?: ACCESSIBILITY_DEFAULT_VALUE,
                action = JsonParser.readOptional(json, "action", DivAction.CREATOR, logger, env),
                actionAnimation = JsonParser.readOptional(json, "action_animation", DivAnimation.CREATOR, logger, env) ?: ACTION_ANIMATION_DEFAULT_VALUE,
                actions = JsonParser.readOptionalList(json, "actions", DivAction.CREATOR, ACTIONS_VALIDATOR, logger, env),
                alignmentHorizontal = JsonParser.readOptionalExpression(json, "alignment_horizontal", DivAlignmentHorizontal.Converter.FROM_STRING, logger, env, TYPE_HELPER_ALIGNMENT_HORIZONTAL),
                alignmentVertical = JsonParser.readOptionalExpression(json, "alignment_vertical", DivAlignmentVertical.Converter.FROM_STRING, logger, env, TYPE_HELPER_ALIGNMENT_VERTICAL),
                alpha = JsonParser.readOptionalExpression(json, "alpha", NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, logger, env, ALPHA_DEFAULT_VALUE, TYPE_HELPER_DOUBLE) ?: ALPHA_DEFAULT_VALUE,
                autoEllipsize = JsonParser.readOptionalExpression(json, "auto_ellipsize", ANY_TO_BOOLEAN, logger, env, TYPE_HELPER_BOOLEAN),
                background = JsonParser.readOptionalList(json, "background", DivBackground.CREATOR, BACKGROUND_VALIDATOR, logger, env),
                border = JsonParser.readOptional(json, "border", DivBorder.CREATOR, logger, env) ?: BORDER_DEFAULT_VALUE,
                columnSpan = JsonParser.readOptionalExpression(json, "column_span", NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR, logger, env, TYPE_HELPER_INT),
                doubletapActions = JsonParser.readOptionalList(json, "doubletap_actions", DivAction.CREATOR, DOUBLETAP_ACTIONS_VALIDATOR, logger, env),
                ellipsis = JsonParser.readOptional(json, "ellipsis", Ellipsis.CREATOR, logger, env),
                extensions = JsonParser.readOptionalList(json, "extensions", DivExtension.CREATOR, EXTENSIONS_VALIDATOR, logger, env),
                focus = JsonParser.readOptional(json, "focus", DivFocus.CREATOR, logger, env),
                focusedTextColor = JsonParser.readOptionalExpression(json, "focused_text_color", STRING_TO_COLOR_INT, logger, env, TYPE_HELPER_COLOR),
                fontFamily = JsonParser.readOptionalExpression(json, "font_family", DivFontFamily.Converter.FROM_STRING, logger, env, FONT_FAMILY_DEFAULT_VALUE, TYPE_HELPER_FONT_FAMILY) ?: FONT_FAMILY_DEFAULT_VALUE,
                fontSize = JsonParser.readOptionalExpression(json, "font_size", NUMBER_TO_INT, FONT_SIZE_VALIDATOR, logger, env, FONT_SIZE_DEFAULT_VALUE, TYPE_HELPER_INT) ?: FONT_SIZE_DEFAULT_VALUE,
                fontSizeUnit = JsonParser.readOptionalExpression(json, "font_size_unit", DivSizeUnit.Converter.FROM_STRING, logger, env, FONT_SIZE_UNIT_DEFAULT_VALUE, TYPE_HELPER_FONT_SIZE_UNIT) ?: FONT_SIZE_UNIT_DEFAULT_VALUE,
                fontWeight = JsonParser.readOptionalExpression(json, "font_weight", DivFontWeight.Converter.FROM_STRING, logger, env, FONT_WEIGHT_DEFAULT_VALUE, TYPE_HELPER_FONT_WEIGHT) ?: FONT_WEIGHT_DEFAULT_VALUE,
                height = JsonParser.readOptional(json, "height", DivSize.CREATOR, logger, env) ?: HEIGHT_DEFAULT_VALUE,
                id = JsonParser.readOptional(json, "id", ID_VALIDATOR, logger, env),
                images = JsonParser.readOptionalList(json, "images", Image.CREATOR, IMAGES_VALIDATOR, logger, env),
                letterSpacing = JsonParser.readOptionalExpression(json, "letter_spacing", NUMBER_TO_DOUBLE, logger, env, LETTER_SPACING_DEFAULT_VALUE, TYPE_HELPER_DOUBLE) ?: LETTER_SPACING_DEFAULT_VALUE,
                lineHeight = JsonParser.readOptionalExpression(json, "line_height", NUMBER_TO_INT, LINE_HEIGHT_VALIDATOR, logger, env, TYPE_HELPER_INT),
                longtapActions = JsonParser.readOptionalList(json, "longtap_actions", DivAction.CREATOR, LONGTAP_ACTIONS_VALIDATOR, logger, env),
                margins = JsonParser.readOptional(json, "margins", DivEdgeInsets.CREATOR, logger, env) ?: MARGINS_DEFAULT_VALUE,
                maxLines = JsonParser.readOptionalExpression(json, "max_lines", NUMBER_TO_INT, MAX_LINES_VALIDATOR, logger, env, TYPE_HELPER_INT),
                minHiddenLines = JsonParser.readOptionalExpression(json, "min_hidden_lines", NUMBER_TO_INT, MIN_HIDDEN_LINES_VALIDATOR, logger, env, TYPE_HELPER_INT),
                paddings = JsonParser.readOptional(json, "paddings", DivEdgeInsets.CREATOR, logger, env) ?: PADDINGS_DEFAULT_VALUE,
                ranges = JsonParser.readOptionalList(json, "ranges", Range.CREATOR, RANGES_VALIDATOR, logger, env),
                rowSpan = JsonParser.readOptionalExpression(json, "row_span", NUMBER_TO_INT, ROW_SPAN_VALIDATOR, logger, env, TYPE_HELPER_INT),
                selectable = JsonParser.readOptionalExpression(json, "selectable", ANY_TO_BOOLEAN, logger, env, SELECTABLE_DEFAULT_VALUE, TYPE_HELPER_BOOLEAN) ?: SELECTABLE_DEFAULT_VALUE,
                selectedActions = JsonParser.readOptionalList(json, "selected_actions", DivAction.CREATOR, SELECTED_ACTIONS_VALIDATOR, logger, env),
                strike = JsonParser.readOptionalExpression(json, "strike", DivLineStyle.Converter.FROM_STRING, logger, env, STRIKE_DEFAULT_VALUE, TYPE_HELPER_STRIKE) ?: STRIKE_DEFAULT_VALUE,
                text = JsonParser.readExpression(json, "text", TEXT_VALIDATOR, logger, env, TYPE_HELPER_STRING),
                textAlignmentHorizontal = JsonParser.readOptionalExpression(json, "text_alignment_horizontal", DivAlignmentHorizontal.Converter.FROM_STRING, logger, env, TEXT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE, TYPE_HELPER_TEXT_ALIGNMENT_HORIZONTAL) ?: TEXT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE,
                textAlignmentVertical = JsonParser.readOptionalExpression(json, "text_alignment_vertical", DivAlignmentVertical.Converter.FROM_STRING, logger, env, TEXT_ALIGNMENT_VERTICAL_DEFAULT_VALUE, TYPE_HELPER_TEXT_ALIGNMENT_VERTICAL) ?: TEXT_ALIGNMENT_VERTICAL_DEFAULT_VALUE,
                textColor = JsonParser.readOptionalExpression(json, "text_color", STRING_TO_COLOR_INT, logger, env, TEXT_COLOR_DEFAULT_VALUE, TYPE_HELPER_COLOR) ?: TEXT_COLOR_DEFAULT_VALUE,
                textGradient = JsonParser.readOptional(json, "text_gradient", DivTextGradient.CREATOR, logger, env),
                tooltips = JsonParser.readOptionalList(json, "tooltips", DivTooltip.CREATOR, TOOLTIPS_VALIDATOR, logger, env),
                transform = JsonParser.readOptional(json, "transform", DivTransform.CREATOR, logger, env) ?: TRANSFORM_DEFAULT_VALUE,
                transitionChange = JsonParser.readOptional(json, "transition_change", DivChangeTransition.CREATOR, logger, env),
                transitionIn = JsonParser.readOptional(json, "transition_in", DivAppearanceTransition.CREATOR, logger, env),
                transitionOut = JsonParser.readOptional(json, "transition_out", DivAppearanceTransition.CREATOR, logger, env),
                transitionTriggers = JsonParser.readOptionalList(json, "transition_triggers", DivTransitionTrigger.Converter.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR, logger, env),
                underline = JsonParser.readOptionalExpression(json, "underline", DivLineStyle.Converter.FROM_STRING, logger, env, UNDERLINE_DEFAULT_VALUE, TYPE_HELPER_UNDERLINE) ?: UNDERLINE_DEFAULT_VALUE,
                visibility = JsonParser.readOptionalExpression(json, "visibility", DivVisibility.Converter.FROM_STRING, logger, env, VISIBILITY_DEFAULT_VALUE, TYPE_HELPER_VISIBILITY) ?: VISIBILITY_DEFAULT_VALUE,
                visibilityAction = JsonParser.readOptional(json, "visibility_action", DivVisibilityAction.CREATOR, logger, env),
                visibilityActions = JsonParser.readOptionalList(json, "visibility_actions", DivVisibilityAction.CREATOR, VISIBILITY_ACTIONS_VALIDATOR, logger, env),
                width = JsonParser.readOptional(json, "width", DivSize.CREATOR, logger, env) ?: WIDTH_DEFAULT_VALUE
            )
        }

        private val ACTIONS_VALIDATOR = ListValidator<DivAction> { it: List<*> -> it.size >= 1 }
        private val ALPHA_TEMPLATE_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val ALPHA_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val BACKGROUND_VALIDATOR = ListValidator<DivBackground> { it: List<*> -> it.size >= 1 }
        private val COLUMN_SPAN_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val COLUMN_SPAN_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val DOUBLETAP_ACTIONS_VALIDATOR = ListValidator<DivAction> { it: List<*> -> it.size >= 1 }
        private val EXTENSIONS_VALIDATOR = ListValidator<DivExtension> { it: List<*> -> it.size >= 1 }
        private val FONT_SIZE_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val FONT_SIZE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val ID_TEMPLATE_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val ID_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val IMAGES_VALIDATOR = ListValidator<DivText.Image> { it: List<*> -> it.size >= 1 }
        private val LINE_HEIGHT_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val LINE_HEIGHT_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val LONGTAP_ACTIONS_VALIDATOR = ListValidator<DivAction> { it: List<*> -> it.size >= 1 }
        private val MAX_LINES_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val MAX_LINES_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val MIN_HIDDEN_LINES_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val MIN_HIDDEN_LINES_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val RANGES_VALIDATOR = ListValidator<DivText.Range> { it: List<*> -> it.size >= 1 }
        private val ROW_SPAN_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val ROW_SPAN_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val SELECTED_ACTIONS_VALIDATOR = ListValidator<DivAction> { it: List<*> -> it.size >= 1 }
        private val TEXT_TEMPLATE_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val TEXT_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val TOOLTIPS_VALIDATOR = ListValidator<DivTooltip> { it: List<*> -> it.size >= 1 }
        private val TRANSITION_TRIGGERS_VALIDATOR = ListValidator<DivTransitionTrigger> { it: List<*> -> it.size >= 1 }
        private val VISIBILITY_ACTIONS_VALIDATOR = ListValidator<DivVisibilityAction> { it: List<*> -> it.size >= 1 }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivText(env, json = it) }
    }


    @Mockable
    class Range(
        @JvmField final val actions: List<DivAction>? = null, // at least 1 elements
        @JvmField final val background: DivTextRangeBackground? = null,
        @JvmField final val border: DivTextRangeBorder? = null,
        @JvmField final val end: Expression<Int>, // constraint: number > 0
        @JvmField final val fontFamily: Expression<DivFontFamily>? = null,
        @JvmField final val fontSize: Expression<Int>? = null, // constraint: number >= 0
        @JvmField final val fontSizeUnit: Expression<DivSizeUnit> = FONT_SIZE_UNIT_DEFAULT_VALUE, // default value: sp
        @JvmField final val fontWeight: Expression<DivFontWeight>? = null,
        @JvmField final val letterSpacing: Expression<Double>? = null,
        @JvmField final val lineHeight: Expression<Int>? = null, // constraint: number >= 0
        @JvmField final val start: Expression<Int>, // constraint: number >= 0
        @JvmField final val strike: Expression<DivLineStyle>? = null,
        @JvmField final val textColor: Expression<Int>? = null,
        @JvmField final val topOffset: Expression<Int>? = null, // constraint: number >= 0
        @JvmField final val underline: Expression<DivLineStyle>? = null,
    ) : JSONSerializable {

        override fun writeToJSON(): JSONObject {
            val json = JSONObject()
            json.write(key = "actions", value = actions)
            json.write(key = "background", value = background)
            json.write(key = "border", value = border)
            json.writeExpression(key = "end", value = end)
            json.writeExpression(key = "font_family", value = fontFamily, converter = { v: DivFontFamily -> DivFontFamily.toString(v) })
            json.writeExpression(key = "font_size", value = fontSize)
            json.writeExpression(key = "font_size_unit", value = fontSizeUnit, converter = { v: DivSizeUnit -> DivSizeUnit.toString(v) })
            json.writeExpression(key = "font_weight", value = fontWeight, converter = { v: DivFontWeight -> DivFontWeight.toString(v) })
            json.writeExpression(key = "letter_spacing", value = letterSpacing)
            json.writeExpression(key = "line_height", value = lineHeight)
            json.writeExpression(key = "start", value = start)
            json.writeExpression(key = "strike", value = strike, converter = { v: DivLineStyle -> DivLineStyle.toString(v) })
            json.writeExpression(key = "text_color", value = textColor, converter = COLOR_INT_TO_STRING)
            json.writeExpression(key = "top_offset", value = topOffset)
            json.writeExpression(key = "underline", value = underline, converter = { v: DivLineStyle -> DivLineStyle.toString(v) })
            return json
        }

        companion object {
            private val FONT_SIZE_UNIT_DEFAULT_VALUE = Expression.constant(DivSizeUnit.SP)

            private val TYPE_HELPER_FONT_FAMILY = TypeHelper.from(default = DivFontFamily.values().first()) { it is DivFontFamily }
            private val TYPE_HELPER_FONT_SIZE_UNIT = TypeHelper.from(default = DivSizeUnit.values().first()) { it is DivSizeUnit }
            private val TYPE_HELPER_FONT_WEIGHT = TypeHelper.from(default = DivFontWeight.values().first()) { it is DivFontWeight }
            private val TYPE_HELPER_STRIKE = TypeHelper.from(default = DivLineStyle.values().first()) { it is DivLineStyle }
            private val TYPE_HELPER_UNDERLINE = TypeHelper.from(default = DivLineStyle.values().first()) { it is DivLineStyle }

            @JvmStatic
            @JvmName("fromJson")
            operator fun invoke(env: ParsingEnvironment, json: JSONObject): Range {
                val logger = env.logger
                return Range(
                    actions = JsonParser.readOptionalList(json, "actions", DivAction.CREATOR, ACTIONS_VALIDATOR, logger, env),
                    background = JsonParser.readOptional(json, "background", DivTextRangeBackground.CREATOR, logger, env),
                    border = JsonParser.readOptional(json, "border", DivTextRangeBorder.CREATOR, logger, env),
                    end = JsonParser.readExpression(json, "end", NUMBER_TO_INT, END_VALIDATOR, logger, env, TYPE_HELPER_INT),
                    fontFamily = JsonParser.readOptionalExpression(json, "font_family", DivFontFamily.Converter.FROM_STRING, logger, env, TYPE_HELPER_FONT_FAMILY),
                    fontSize = JsonParser.readOptionalExpression(json, "font_size", NUMBER_TO_INT, FONT_SIZE_VALIDATOR, logger, env, TYPE_HELPER_INT),
                    fontSizeUnit = JsonParser.readOptionalExpression(json, "font_size_unit", DivSizeUnit.Converter.FROM_STRING, logger, env, FONT_SIZE_UNIT_DEFAULT_VALUE, TYPE_HELPER_FONT_SIZE_UNIT) ?: FONT_SIZE_UNIT_DEFAULT_VALUE,
                    fontWeight = JsonParser.readOptionalExpression(json, "font_weight", DivFontWeight.Converter.FROM_STRING, logger, env, TYPE_HELPER_FONT_WEIGHT),
                    letterSpacing = JsonParser.readOptionalExpression(json, "letter_spacing", NUMBER_TO_DOUBLE, logger, env, TYPE_HELPER_DOUBLE),
                    lineHeight = JsonParser.readOptionalExpression(json, "line_height", NUMBER_TO_INT, LINE_HEIGHT_VALIDATOR, logger, env, TYPE_HELPER_INT),
                    start = JsonParser.readExpression(json, "start", NUMBER_TO_INT, START_VALIDATOR, logger, env, TYPE_HELPER_INT),
                    strike = JsonParser.readOptionalExpression(json, "strike", DivLineStyle.Converter.FROM_STRING, logger, env, TYPE_HELPER_STRIKE),
                    textColor = JsonParser.readOptionalExpression(json, "text_color", STRING_TO_COLOR_INT, logger, env, TYPE_HELPER_COLOR),
                    topOffset = JsonParser.readOptionalExpression(json, "top_offset", NUMBER_TO_INT, TOP_OFFSET_VALIDATOR, logger, env, TYPE_HELPER_INT),
                    underline = JsonParser.readOptionalExpression(json, "underline", DivLineStyle.Converter.FROM_STRING, logger, env, TYPE_HELPER_UNDERLINE)
                )
            }

            private val ACTIONS_VALIDATOR = ListValidator<DivAction> { it: List<*> -> it.size >= 1 }
            private val END_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it > 0 }
            private val END_VALIDATOR = ValueValidator<Int> { it: Int -> it > 0 }
            private val FONT_SIZE_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
            private val FONT_SIZE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
            private val LINE_HEIGHT_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
            private val LINE_HEIGHT_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
            private val START_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
            private val START_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
            private val TOP_OFFSET_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
            private val TOP_OFFSET_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }

            val CREATOR = { env: ParsingEnvironment, it: JSONObject -> Range(env, json = it) }
        }

    }

    @Mockable
    class Image(
        @JvmField final val height: DivFixedSize = HEIGHT_DEFAULT_VALUE, // default value: DivFixedSize(value = Expression.constant(20))
        @JvmField final val start: Expression<Int>, // constraint: number >= 0
        @JvmField final val tintColor: Expression<Int>? = null,
        @JvmField final val tintMode: Expression<DivBlendMode> = TINT_MODE_DEFAULT_VALUE, // default value: source_in
        @JvmField final val url: Expression<Uri>,
        @JvmField final val width: DivFixedSize = WIDTH_DEFAULT_VALUE, // default value: DivFixedSize(value = Expression.constant(20))
    ) : JSONSerializable {

        override fun writeToJSON(): JSONObject {
            val json = JSONObject()
            json.write(key = "height", value = height)
            json.writeExpression(key = "start", value = start)
            json.writeExpression(key = "tint_color", value = tintColor, converter = COLOR_INT_TO_STRING)
            json.writeExpression(key = "tint_mode", value = tintMode, converter = { v: DivBlendMode -> DivBlendMode.toString(v) })
            json.writeExpression(key = "url", value = url, converter = URI_TO_STRING)
            json.write(key = "width", value = width)
            return json
        }

        companion object {
            private val HEIGHT_DEFAULT_VALUE = DivFixedSize(value = Expression.constant(20))
            private val TINT_MODE_DEFAULT_VALUE = Expression.constant(DivBlendMode.SOURCE_IN)
            private val WIDTH_DEFAULT_VALUE = DivFixedSize(value = Expression.constant(20))

            private val TYPE_HELPER_TINT_MODE = TypeHelper.from(default = DivBlendMode.values().first()) { it is DivBlendMode }

            @JvmStatic
            @JvmName("fromJson")
            operator fun invoke(env: ParsingEnvironment, json: JSONObject): Image {
                val logger = env.logger
                return Image(
                    height = JsonParser.readOptional(json, "height", DivFixedSize.CREATOR, logger, env) ?: HEIGHT_DEFAULT_VALUE,
                    start = JsonParser.readExpression(json, "start", NUMBER_TO_INT, START_VALIDATOR, logger, env, TYPE_HELPER_INT),
                    tintColor = JsonParser.readOptionalExpression(json, "tint_color", STRING_TO_COLOR_INT, logger, env, TYPE_HELPER_COLOR),
                    tintMode = JsonParser.readOptionalExpression(json, "tint_mode", DivBlendMode.Converter.FROM_STRING, logger, env, TINT_MODE_DEFAULT_VALUE, TYPE_HELPER_TINT_MODE) ?: TINT_MODE_DEFAULT_VALUE,
                    url = JsonParser.readExpression(json, "url", STRING_TO_URI, logger, env, TYPE_HELPER_URI),
                    width = JsonParser.readOptional(json, "width", DivFixedSize.CREATOR, logger, env) ?: WIDTH_DEFAULT_VALUE
                )
            }

            private val START_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
            private val START_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }

            val CREATOR = { env: ParsingEnvironment, it: JSONObject -> Image(env, json = it) }
        }

    }

    @Mockable
    class Ellipsis(
        @JvmField final val actions: List<DivAction>? = null, // at least 1 elements
        @JvmField final val images: List<Image>? = null, // at least 1 elements
        @JvmField final val ranges: List<Range>? = null, // at least 1 elements
        @JvmField final val text: Expression<String>, // at least 1 char
    ) : JSONSerializable {

        override fun writeToJSON(): JSONObject {
            val json = JSONObject()
            json.write(key = "actions", value = actions)
            json.write(key = "images", value = images)
            json.write(key = "ranges", value = ranges)
            json.writeExpression(key = "text", value = text)
            return json
        }

        companion object {
            @JvmStatic
            @JvmName("fromJson")
            operator fun invoke(env: ParsingEnvironment, json: JSONObject): Ellipsis {
                val logger = env.logger
                return Ellipsis(
                    actions = JsonParser.readOptionalList(json, "actions", DivAction.CREATOR, ACTIONS_VALIDATOR, logger, env),
                    images = JsonParser.readOptionalList(json, "images", Image.CREATOR, IMAGES_VALIDATOR, logger, env),
                    ranges = JsonParser.readOptionalList(json, "ranges", Range.CREATOR, RANGES_VALIDATOR, logger, env),
                    text = JsonParser.readExpression(json, "text", TEXT_VALIDATOR, logger, env, TYPE_HELPER_STRING)
                )
            }

            private val ACTIONS_VALIDATOR = ListValidator<DivAction> { it: List<*> -> it.size >= 1 }
            private val IMAGES_VALIDATOR = ListValidator<DivText.Image> { it: List<*> -> it.size >= 1 }
            private val RANGES_VALIDATOR = ListValidator<DivText.Range> { it: List<*> -> it.size >= 1 }
            private val TEXT_TEMPLATE_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
            private val TEXT_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }

            val CREATOR = { env: ParsingEnvironment, it: JSONObject -> Ellipsis(env, json = it) }
        }

    }
}
