// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.json.*
import com.yandex.div.json.expressions.Expression
import com.yandex.div.json.expressions.ExpressionsList
import com.yandex.div.json.schema.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*

@Mockable
class DivTextTemplate : JSONSerializable, JsonTemplate<DivText> {
    @JvmField final val accessibility: Field<DivAccessibilityTemplate>
    @JvmField final val action: Field<DivActionTemplate>
    @JvmField final val actionAnimation: Field<DivAnimationTemplate> // default value: DivAnimation(duration = Expression.constant(100), endValue = Expression.constant(0.6), name = Expression.constant(DivAnimation.Name.FADE), startValue = Expression.constant(1.0))
    @JvmField final val actions: Field<List<DivActionTemplate>> // at least 1 elements
    @JvmField final val alignmentHorizontal: Field<Expression<DivAlignmentHorizontal>>
    @JvmField final val alignmentVertical: Field<Expression<DivAlignmentVertical>>
    @JvmField final val alpha: Field<Expression<Double>> // constraint: number >= 0.0 && number <= 1.0; default value: 1.0
    @JvmField final val autoEllipsize: Field<Expression<Boolean>>
    @JvmField final val background: Field<List<DivBackgroundTemplate>> // at least 1 elements
    @JvmField final val border: Field<DivBorderTemplate>
    @JvmField final val columnSpan: Field<Expression<Int>> // constraint: number >= 0
    @JvmField final val doubletapActions: Field<List<DivActionTemplate>> // at least 1 elements
    @JvmField final val ellipsis: Field<EllipsisTemplate>
    @JvmField final val extensions: Field<List<DivExtensionTemplate>> // at least 1 elements
    @JvmField final val focus: Field<DivFocusTemplate>
    @JvmField final val focusedTextColor: Field<Expression<Int>>
    @JvmField final val fontFamily: Field<Expression<DivFontFamily>> // default value: text
    @JvmField final val fontSize: Field<Expression<Int>> // constraint: number >= 0; default value: 12
    @JvmField final val fontSizeUnit: Field<Expression<DivSizeUnit>> // default value: sp
    @JvmField final val fontWeight: Field<Expression<DivFontWeight>> // default value: regular
    @JvmField final val height: Field<DivSizeTemplate> // default value: DivSize.WrapContent(DivWrapContentSize())
    @JvmField final val id: Field<String> // at least 1 char
    @JvmField final val images: Field<List<ImageTemplate>> // at least 1 elements
    @JvmField final val letterSpacing: Field<Expression<Double>> // default value: 0
    @JvmField final val lineHeight: Field<Expression<Int>> // constraint: number >= 0
    @JvmField final val longtapActions: Field<List<DivActionTemplate>> // at least 1 elements
    @JvmField final val margins: Field<DivEdgeInsetsTemplate>
    @JvmField final val maxLines: Field<Expression<Int>> // constraint: number >= 0
    @JvmField final val minHiddenLines: Field<Expression<Int>> // constraint: number >= 0
    @JvmField final val paddings: Field<DivEdgeInsetsTemplate>
    @JvmField final val ranges: Field<List<RangeTemplate>> // at least 1 elements
    @JvmField final val rowSpan: Field<Expression<Int>> // constraint: number >= 0
    @JvmField final val selectable: Field<Expression<Boolean>> // default value: false
    @JvmField final val selectedActions: Field<List<DivActionTemplate>> // at least 1 elements
    @JvmField final val strike: Field<Expression<DivLineStyle>> // default value: none
    @JvmField final val text: Field<Expression<String>> // at least 1 char
    @JvmField final val textAlignmentHorizontal: Field<Expression<DivAlignmentHorizontal>> // default value: left
    @JvmField final val textAlignmentVertical: Field<Expression<DivAlignmentVertical>> // default value: top
    @JvmField final val textColor: Field<Expression<Int>> // default value: #FF000000
    @JvmField final val textGradient: Field<DivTextGradientTemplate>
    @JvmField final val tooltips: Field<List<DivTooltipTemplate>> // at least 1 elements
    @JvmField final val transform: Field<DivTransformTemplate>
    @JvmField final val transitionChange: Field<DivChangeTransitionTemplate>
    @JvmField final val transitionIn: Field<DivAppearanceTransitionTemplate>
    @JvmField final val transitionOut: Field<DivAppearanceTransitionTemplate>
    @JvmField final val transitionTriggers: Field<List<DivTransitionTrigger>> // at least 1 elements
    @JvmField final val underline: Field<Expression<DivLineStyle>> // default value: none
    @JvmField final val visibility: Field<Expression<DivVisibility>> // default value: visible
    @JvmField final val visibilityAction: Field<DivVisibilityActionTemplate>
    @JvmField final val visibilityActions: Field<List<DivVisibilityActionTemplate>> // at least 1 elements
    @JvmField final val width: Field<DivSizeTemplate> // default value: DivSize.MatchParent(DivMatchParentSize())

    constructor (
        env: ParsingEnvironment,
        parent: DivTextTemplate? = null,
        topLevel: Boolean = false,
        json: JSONObject
    ) {
        val logger = env.logger
        accessibility = JsonTemplateParser.readOptionalField(json, "accessibility", topLevel, parent?.accessibility, DivAccessibilityTemplate.CREATOR, logger, env)
        action = JsonTemplateParser.readOptionalField(json, "action", topLevel, parent?.action, DivActionTemplate.CREATOR, logger, env)
        actionAnimation = JsonTemplateParser.readOptionalField(json, "action_animation", topLevel, parent?.actionAnimation, DivAnimationTemplate.CREATOR, logger, env)
        actions = JsonTemplateParser.readOptionalListField(json, "actions", topLevel, parent?.actions, DivActionTemplate.CREATOR, ACTIONS_TEMPLATE_VALIDATOR, logger, env)
        alignmentHorizontal = JsonTemplateParser.readOptionalFieldWithExpression(json, "alignment_horizontal", topLevel, parent?.alignmentHorizontal, DivAlignmentHorizontal.Converter.FROM_STRING, logger, env, TYPE_HELPER_ALIGNMENT_HORIZONTAL)
        alignmentVertical = JsonTemplateParser.readOptionalFieldWithExpression(json, "alignment_vertical", topLevel, parent?.alignmentVertical, DivAlignmentVertical.Converter.FROM_STRING, logger, env, TYPE_HELPER_ALIGNMENT_VERTICAL)
        alpha = JsonTemplateParser.readOptionalFieldWithExpression(json, "alpha", topLevel, parent?.alpha, NUMBER_TO_DOUBLE, ALPHA_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_DOUBLE)
        autoEllipsize = JsonTemplateParser.readOptionalFieldWithExpression(json, "auto_ellipsize", topLevel, parent?.autoEllipsize, ANY_TO_BOOLEAN, logger, env, TYPE_HELPER_BOOLEAN)
        background = JsonTemplateParser.readOptionalListField(json, "background", topLevel, parent?.background, DivBackgroundTemplate.CREATOR, BACKGROUND_TEMPLATE_VALIDATOR, logger, env)
        border = JsonTemplateParser.readOptionalField(json, "border", topLevel, parent?.border, DivBorderTemplate.CREATOR, logger, env)
        columnSpan = JsonTemplateParser.readOptionalFieldWithExpression(json, "column_span", topLevel, parent?.columnSpan, NUMBER_TO_INT, COLUMN_SPAN_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
        doubletapActions = JsonTemplateParser.readOptionalListField(json, "doubletap_actions", topLevel, parent?.doubletapActions, DivActionTemplate.CREATOR, DOUBLETAP_ACTIONS_TEMPLATE_VALIDATOR, logger, env)
        ellipsis = JsonTemplateParser.readOptionalField(json, "ellipsis", topLevel, parent?.ellipsis, EllipsisTemplate.CREATOR, logger, env)
        extensions = JsonTemplateParser.readOptionalListField(json, "extensions", topLevel, parent?.extensions, DivExtensionTemplate.CREATOR, EXTENSIONS_TEMPLATE_VALIDATOR, logger, env)
        focus = JsonTemplateParser.readOptionalField(json, "focus", topLevel, parent?.focus, DivFocusTemplate.CREATOR, logger, env)
        focusedTextColor = JsonTemplateParser.readOptionalFieldWithExpression(json, "focused_text_color", topLevel, parent?.focusedTextColor, STRING_TO_COLOR_INT, logger, env, TYPE_HELPER_COLOR)
        fontFamily = JsonTemplateParser.readOptionalFieldWithExpression(json, "font_family", topLevel, parent?.fontFamily, DivFontFamily.Converter.FROM_STRING, logger, env, TYPE_HELPER_FONT_FAMILY)
        fontSize = JsonTemplateParser.readOptionalFieldWithExpression(json, "font_size", topLevel, parent?.fontSize, NUMBER_TO_INT, FONT_SIZE_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
        fontSizeUnit = JsonTemplateParser.readOptionalFieldWithExpression(json, "font_size_unit", topLevel, parent?.fontSizeUnit, DivSizeUnit.Converter.FROM_STRING, logger, env, TYPE_HELPER_FONT_SIZE_UNIT)
        fontWeight = JsonTemplateParser.readOptionalFieldWithExpression(json, "font_weight", topLevel, parent?.fontWeight, DivFontWeight.Converter.FROM_STRING, logger, env, TYPE_HELPER_FONT_WEIGHT)
        height = JsonTemplateParser.readOptionalField(json, "height", topLevel, parent?.height, DivSizeTemplate.CREATOR, logger, env)
        id = JsonTemplateParser.readOptionalField(json, "id", topLevel, parent?.id, ID_TEMPLATE_VALIDATOR, logger, env)
        images = JsonTemplateParser.readOptionalListField(json, "images", topLevel, parent?.images, ImageTemplate.CREATOR, IMAGES_TEMPLATE_VALIDATOR, logger, env)
        letterSpacing = JsonTemplateParser.readOptionalFieldWithExpression(json, "letter_spacing", topLevel, parent?.letterSpacing, NUMBER_TO_DOUBLE, logger, env, TYPE_HELPER_DOUBLE)
        lineHeight = JsonTemplateParser.readOptionalFieldWithExpression(json, "line_height", topLevel, parent?.lineHeight, NUMBER_TO_INT, LINE_HEIGHT_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
        longtapActions = JsonTemplateParser.readOptionalListField(json, "longtap_actions", topLevel, parent?.longtapActions, DivActionTemplate.CREATOR, LONGTAP_ACTIONS_TEMPLATE_VALIDATOR, logger, env)
        margins = JsonTemplateParser.readOptionalField(json, "margins", topLevel, parent?.margins, DivEdgeInsetsTemplate.CREATOR, logger, env)
        maxLines = JsonTemplateParser.readOptionalFieldWithExpression(json, "max_lines", topLevel, parent?.maxLines, NUMBER_TO_INT, MAX_LINES_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
        minHiddenLines = JsonTemplateParser.readOptionalFieldWithExpression(json, "min_hidden_lines", topLevel, parent?.minHiddenLines, NUMBER_TO_INT, MIN_HIDDEN_LINES_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
        paddings = JsonTemplateParser.readOptionalField(json, "paddings", topLevel, parent?.paddings, DivEdgeInsetsTemplate.CREATOR, logger, env)
        ranges = JsonTemplateParser.readOptionalListField(json, "ranges", topLevel, parent?.ranges, RangeTemplate.CREATOR, RANGES_TEMPLATE_VALIDATOR, logger, env)
        rowSpan = JsonTemplateParser.readOptionalFieldWithExpression(json, "row_span", topLevel, parent?.rowSpan, NUMBER_TO_INT, ROW_SPAN_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
        selectable = JsonTemplateParser.readOptionalFieldWithExpression(json, "selectable", topLevel, parent?.selectable, ANY_TO_BOOLEAN, logger, env, TYPE_HELPER_BOOLEAN)
        selectedActions = JsonTemplateParser.readOptionalListField(json, "selected_actions", topLevel, parent?.selectedActions, DivActionTemplate.CREATOR, SELECTED_ACTIONS_TEMPLATE_VALIDATOR, logger, env)
        strike = JsonTemplateParser.readOptionalFieldWithExpression(json, "strike", topLevel, parent?.strike, DivLineStyle.Converter.FROM_STRING, logger, env, TYPE_HELPER_STRIKE)
        text = JsonTemplateParser.readFieldWithExpression(json, "text", topLevel, parent?.text, TEXT_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_STRING)
        textAlignmentHorizontal = JsonTemplateParser.readOptionalFieldWithExpression(json, "text_alignment_horizontal", topLevel, parent?.textAlignmentHorizontal, DivAlignmentHorizontal.Converter.FROM_STRING, logger, env, TYPE_HELPER_TEXT_ALIGNMENT_HORIZONTAL)
        textAlignmentVertical = JsonTemplateParser.readOptionalFieldWithExpression(json, "text_alignment_vertical", topLevel, parent?.textAlignmentVertical, DivAlignmentVertical.Converter.FROM_STRING, logger, env, TYPE_HELPER_TEXT_ALIGNMENT_VERTICAL)
        textColor = JsonTemplateParser.readOptionalFieldWithExpression(json, "text_color", topLevel, parent?.textColor, STRING_TO_COLOR_INT, logger, env, TYPE_HELPER_COLOR)
        textGradient = JsonTemplateParser.readOptionalField(json, "text_gradient", topLevel, parent?.textGradient, DivTextGradientTemplate.CREATOR, logger, env)
        tooltips = JsonTemplateParser.readOptionalListField(json, "tooltips", topLevel, parent?.tooltips, DivTooltipTemplate.CREATOR, TOOLTIPS_TEMPLATE_VALIDATOR, logger, env)
        transform = JsonTemplateParser.readOptionalField(json, "transform", topLevel, parent?.transform, DivTransformTemplate.CREATOR, logger, env)
        transitionChange = JsonTemplateParser.readOptionalField(json, "transition_change", topLevel, parent?.transitionChange, DivChangeTransitionTemplate.CREATOR, logger, env)
        transitionIn = JsonTemplateParser.readOptionalField(json, "transition_in", topLevel, parent?.transitionIn, DivAppearanceTransitionTemplate.CREATOR, logger, env)
        transitionOut = JsonTemplateParser.readOptionalField(json, "transition_out", topLevel, parent?.transitionOut, DivAppearanceTransitionTemplate.CREATOR, logger, env)
        transitionTriggers = JsonTemplateParser.readOptionalListField(json, "transition_triggers", topLevel, parent?.transitionTriggers, DivTransitionTrigger.Converter.FROM_STRING, TRANSITION_TRIGGERS_TEMPLATE_VALIDATOR, logger, env)
        underline = JsonTemplateParser.readOptionalFieldWithExpression(json, "underline", topLevel, parent?.underline, DivLineStyle.Converter.FROM_STRING, logger, env, TYPE_HELPER_UNDERLINE)
        visibility = JsonTemplateParser.readOptionalFieldWithExpression(json, "visibility", topLevel, parent?.visibility, DivVisibility.Converter.FROM_STRING, logger, env, TYPE_HELPER_VISIBILITY)
        visibilityAction = JsonTemplateParser.readOptionalField(json, "visibility_action", topLevel, parent?.visibilityAction, DivVisibilityActionTemplate.CREATOR, logger, env)
        visibilityActions = JsonTemplateParser.readOptionalListField(json, "visibility_actions", topLevel, parent?.visibilityActions, DivVisibilityActionTemplate.CREATOR, VISIBILITY_ACTIONS_TEMPLATE_VALIDATOR, logger, env)
        width = JsonTemplateParser.readOptionalField(json, "width", topLevel, parent?.width, DivSizeTemplate.CREATOR, logger, env)
    }

    override fun resolve(env: ParsingEnvironment, data: JSONObject): DivText {
        return DivText(
            accessibility = accessibility.resolveOptionalTemplate(env = env, key = "accessibility", data = data, reader = ACCESSIBILITY_READER) ?: ACCESSIBILITY_DEFAULT_VALUE,
            action = action.resolveOptionalTemplate(env = env, key = "action", data = data, reader = ACTION_READER),
            actionAnimation = actionAnimation.resolveOptionalTemplate(env = env, key = "action_animation", data = data, reader = ACTION_ANIMATION_READER) ?: ACTION_ANIMATION_DEFAULT_VALUE,
            actions = actions.resolveOptionalTemplateList(env = env, key = "actions", data = data, ACTIONS_VALIDATOR, reader = ACTIONS_READER),
            alignmentHorizontal = alignmentHorizontal.resolveOptional(env = env, key = "alignment_horizontal", data = data, reader = ALIGNMENT_HORIZONTAL_READER),
            alignmentVertical = alignmentVertical.resolveOptional(env = env, key = "alignment_vertical", data = data, reader = ALIGNMENT_VERTICAL_READER),
            alpha = alpha.resolveOptional(env = env, key = "alpha", data = data, reader = ALPHA_READER) ?: ALPHA_DEFAULT_VALUE,
            autoEllipsize = autoEllipsize.resolveOptional(env = env, key = "auto_ellipsize", data = data, reader = AUTO_ELLIPSIZE_READER),
            background = background.resolveOptionalTemplateList(env = env, key = "background", data = data, BACKGROUND_VALIDATOR, reader = BACKGROUND_READER),
            border = border.resolveOptionalTemplate(env = env, key = "border", data = data, reader = BORDER_READER) ?: BORDER_DEFAULT_VALUE,
            columnSpan = columnSpan.resolveOptional(env = env, key = "column_span", data = data, reader = COLUMN_SPAN_READER),
            doubletapActions = doubletapActions.resolveOptionalTemplateList(env = env, key = "doubletap_actions", data = data, DOUBLETAP_ACTIONS_VALIDATOR, reader = DOUBLETAP_ACTIONS_READER),
            ellipsis = ellipsis.resolveOptionalTemplate(env = env, key = "ellipsis", data = data, reader = ELLIPSIS_READER),
            extensions = extensions.resolveOptionalTemplateList(env = env, key = "extensions", data = data, EXTENSIONS_VALIDATOR, reader = EXTENSIONS_READER),
            focus = focus.resolveOptionalTemplate(env = env, key = "focus", data = data, reader = FOCUS_READER),
            focusedTextColor = focusedTextColor.resolveOptional(env = env, key = "focused_text_color", data = data, reader = FOCUSED_TEXT_COLOR_READER),
            fontFamily = fontFamily.resolveOptional(env = env, key = "font_family", data = data, reader = FONT_FAMILY_READER) ?: FONT_FAMILY_DEFAULT_VALUE,
            fontSize = fontSize.resolveOptional(env = env, key = "font_size", data = data, reader = FONT_SIZE_READER) ?: FONT_SIZE_DEFAULT_VALUE,
            fontSizeUnit = fontSizeUnit.resolveOptional(env = env, key = "font_size_unit", data = data, reader = FONT_SIZE_UNIT_READER) ?: FONT_SIZE_UNIT_DEFAULT_VALUE,
            fontWeight = fontWeight.resolveOptional(env = env, key = "font_weight", data = data, reader = FONT_WEIGHT_READER) ?: FONT_WEIGHT_DEFAULT_VALUE,
            height = height.resolveOptionalTemplate(env = env, key = "height", data = data, reader = HEIGHT_READER) ?: HEIGHT_DEFAULT_VALUE,
            id = id.resolveOptional(env = env, key = "id", data = data, reader = ID_READER),
            images = images.resolveOptionalTemplateList(env = env, key = "images", data = data, IMAGES_VALIDATOR, reader = IMAGES_READER),
            letterSpacing = letterSpacing.resolveOptional(env = env, key = "letter_spacing", data = data, reader = LETTER_SPACING_READER) ?: LETTER_SPACING_DEFAULT_VALUE,
            lineHeight = lineHeight.resolveOptional(env = env, key = "line_height", data = data, reader = LINE_HEIGHT_READER),
            longtapActions = longtapActions.resolveOptionalTemplateList(env = env, key = "longtap_actions", data = data, LONGTAP_ACTIONS_VALIDATOR, reader = LONGTAP_ACTIONS_READER),
            margins = margins.resolveOptionalTemplate(env = env, key = "margins", data = data, reader = MARGINS_READER) ?: MARGINS_DEFAULT_VALUE,
            maxLines = maxLines.resolveOptional(env = env, key = "max_lines", data = data, reader = MAX_LINES_READER),
            minHiddenLines = minHiddenLines.resolveOptional(env = env, key = "min_hidden_lines", data = data, reader = MIN_HIDDEN_LINES_READER),
            paddings = paddings.resolveOptionalTemplate(env = env, key = "paddings", data = data, reader = PADDINGS_READER) ?: PADDINGS_DEFAULT_VALUE,
            ranges = ranges.resolveOptionalTemplateList(env = env, key = "ranges", data = data, RANGES_VALIDATOR, reader = RANGES_READER),
            rowSpan = rowSpan.resolveOptional(env = env, key = "row_span", data = data, reader = ROW_SPAN_READER),
            selectable = selectable.resolveOptional(env = env, key = "selectable", data = data, reader = SELECTABLE_READER) ?: SELECTABLE_DEFAULT_VALUE,
            selectedActions = selectedActions.resolveOptionalTemplateList(env = env, key = "selected_actions", data = data, SELECTED_ACTIONS_VALIDATOR, reader = SELECTED_ACTIONS_READER),
            strike = strike.resolveOptional(env = env, key = "strike", data = data, reader = STRIKE_READER) ?: STRIKE_DEFAULT_VALUE,
            text = text.resolve(env = env, key = "text", data = data, reader = TEXT_READER),
            textAlignmentHorizontal = textAlignmentHorizontal.resolveOptional(env = env, key = "text_alignment_horizontal", data = data, reader = TEXT_ALIGNMENT_HORIZONTAL_READER) ?: TEXT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE,
            textAlignmentVertical = textAlignmentVertical.resolveOptional(env = env, key = "text_alignment_vertical", data = data, reader = TEXT_ALIGNMENT_VERTICAL_READER) ?: TEXT_ALIGNMENT_VERTICAL_DEFAULT_VALUE,
            textColor = textColor.resolveOptional(env = env, key = "text_color", data = data, reader = TEXT_COLOR_READER) ?: TEXT_COLOR_DEFAULT_VALUE,
            textGradient = textGradient.resolveOptionalTemplate(env = env, key = "text_gradient", data = data, reader = TEXT_GRADIENT_READER),
            tooltips = tooltips.resolveOptionalTemplateList(env = env, key = "tooltips", data = data, TOOLTIPS_VALIDATOR, reader = TOOLTIPS_READER),
            transform = transform.resolveOptionalTemplate(env = env, key = "transform", data = data, reader = TRANSFORM_READER) ?: TRANSFORM_DEFAULT_VALUE,
            transitionChange = transitionChange.resolveOptionalTemplate(env = env, key = "transition_change", data = data, reader = TRANSITION_CHANGE_READER),
            transitionIn = transitionIn.resolveOptionalTemplate(env = env, key = "transition_in", data = data, reader = TRANSITION_IN_READER),
            transitionOut = transitionOut.resolveOptionalTemplate(env = env, key = "transition_out", data = data, reader = TRANSITION_OUT_READER),
            transitionTriggers = transitionTriggers.resolveOptionalList(env = env, key = "transition_triggers", data = data, TRANSITION_TRIGGERS_VALIDATOR, reader = TRANSITION_TRIGGERS_READER),
            underline = underline.resolveOptional(env = env, key = "underline", data = data, reader = UNDERLINE_READER) ?: UNDERLINE_DEFAULT_VALUE,
            visibility = visibility.resolveOptional(env = env, key = "visibility", data = data, reader = VISIBILITY_READER) ?: VISIBILITY_DEFAULT_VALUE,
            visibilityAction = visibilityAction.resolveOptionalTemplate(env = env, key = "visibility_action", data = data, reader = VISIBILITY_ACTION_READER),
            visibilityActions = visibilityActions.resolveOptionalTemplateList(env = env, key = "visibility_actions", data = data, VISIBILITY_ACTIONS_VALIDATOR, reader = VISIBILITY_ACTIONS_READER),
            width = width.resolveOptionalTemplate(env = env, key = "width", data = data, reader = WIDTH_READER) ?: WIDTH_DEFAULT_VALUE
        )
    }

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.writeField(key = "accessibility", field = accessibility)
        json.writeField(key = "action", field = action)
        json.writeField(key = "action_animation", field = actionAnimation)
        json.writeField(key = "actions", field = actions)
        json.writeFieldWithExpression(key = "alignment_horizontal", field = alignmentHorizontal, converter = { v: DivAlignmentHorizontal -> DivAlignmentHorizontal.toString(v) })
        json.writeFieldWithExpression(key = "alignment_vertical", field = alignmentVertical, converter = { v: DivAlignmentVertical -> DivAlignmentVertical.toString(v) })
        json.writeFieldWithExpression(key = "alpha", field = alpha)
        json.writeFieldWithExpression(key = "auto_ellipsize", field = autoEllipsize)
        json.writeField(key = "background", field = background)
        json.writeField(key = "border", field = border)
        json.writeFieldWithExpression(key = "column_span", field = columnSpan)
        json.writeField(key = "doubletap_actions", field = doubletapActions)
        json.writeField(key = "ellipsis", field = ellipsis)
        json.writeField(key = "extensions", field = extensions)
        json.writeField(key = "focus", field = focus)
        json.writeFieldWithExpression(key = "focused_text_color", field = focusedTextColor, converter = COLOR_INT_TO_STRING)
        json.writeFieldWithExpression(key = "font_family", field = fontFamily, converter = { v: DivFontFamily -> DivFontFamily.toString(v) })
        json.writeFieldWithExpression(key = "font_size", field = fontSize)
        json.writeFieldWithExpression(key = "font_size_unit", field = fontSizeUnit, converter = { v: DivSizeUnit -> DivSizeUnit.toString(v) })
        json.writeFieldWithExpression(key = "font_weight", field = fontWeight, converter = { v: DivFontWeight -> DivFontWeight.toString(v) })
        json.writeField(key = "height", field = height)
        json.writeField(key = "id", field = id)
        json.writeField(key = "images", field = images)
        json.writeFieldWithExpression(key = "letter_spacing", field = letterSpacing)
        json.writeFieldWithExpression(key = "line_height", field = lineHeight)
        json.writeField(key = "longtap_actions", field = longtapActions)
        json.writeField(key = "margins", field = margins)
        json.writeFieldWithExpression(key = "max_lines", field = maxLines)
        json.writeFieldWithExpression(key = "min_hidden_lines", field = minHiddenLines)
        json.writeField(key = "paddings", field = paddings)
        json.writeField(key = "ranges", field = ranges)
        json.writeFieldWithExpression(key = "row_span", field = rowSpan)
        json.writeFieldWithExpression(key = "selectable", field = selectable)
        json.writeField(key = "selected_actions", field = selectedActions)
        json.writeFieldWithExpression(key = "strike", field = strike, converter = { v: DivLineStyle -> DivLineStyle.toString(v) })
        json.writeFieldWithExpression(key = "text", field = text)
        json.writeFieldWithExpression(key = "text_alignment_horizontal", field = textAlignmentHorizontal, converter = { v: DivAlignmentHorizontal -> DivAlignmentHorizontal.toString(v) })
        json.writeFieldWithExpression(key = "text_alignment_vertical", field = textAlignmentVertical, converter = { v: DivAlignmentVertical -> DivAlignmentVertical.toString(v) })
        json.writeFieldWithExpression(key = "text_color", field = textColor, converter = COLOR_INT_TO_STRING)
        json.writeField(key = "text_gradient", field = textGradient)
        json.writeField(key = "tooltips", field = tooltips)
        json.writeField(key = "transform", field = transform)
        json.writeField(key = "transition_change", field = transitionChange)
        json.writeField(key = "transition_in", field = transitionIn)
        json.writeField(key = "transition_out", field = transitionOut)
        json.writeField(key = "transition_triggers", field = transitionTriggers, converter = { v: DivTransitionTrigger -> DivTransitionTrigger.toString(v) })
        json.write(key = "type", value = TYPE)
        json.writeFieldWithExpression(key = "underline", field = underline, converter = { v: DivLineStyle -> DivLineStyle.toString(v) })
        json.writeFieldWithExpression(key = "visibility", field = visibility, converter = { v: DivVisibility -> DivVisibility.toString(v) })
        json.writeField(key = "visibility_action", field = visibilityAction)
        json.writeField(key = "visibility_actions", field = visibilityActions)
        json.writeField(key = "width", field = width)
        return json
    }

    companion object {
        const val TYPE = "text"

        private val ACCESSIBILITY_DEFAULT_VALUE = DivAccessibility()
        private val ACTION_ANIMATION_DEFAULT_VALUE = DivAnimation(duration = Expression.constant(100), endValue = Expression.constant(0.6), name = Expression.constant(DivAnimation.Name.FADE), startValue = Expression.constant(1.0))
        private val ALPHA_DEFAULT_VALUE = Expression.constant(1.0)
        private val BORDER_DEFAULT_VALUE = DivBorder()
        private val FONT_FAMILY_DEFAULT_VALUE = Expression.constant(DivFontFamily.TEXT)
        private val FONT_SIZE_DEFAULT_VALUE = Expression.constant(12)
        private val FONT_SIZE_UNIT_DEFAULT_VALUE = Expression.constant(DivSizeUnit.SP)
        private val FONT_WEIGHT_DEFAULT_VALUE = Expression.constant(DivFontWeight.REGULAR)
        private val HEIGHT_DEFAULT_VALUE = DivSize.WrapContent(DivWrapContentSize())
        private val LETTER_SPACING_DEFAULT_VALUE = Expression.constant(0.0)
        private val MARGINS_DEFAULT_VALUE = DivEdgeInsets()
        private val PADDINGS_DEFAULT_VALUE = DivEdgeInsets()
        private val SELECTABLE_DEFAULT_VALUE = Expression.constant(false)
        private val STRIKE_DEFAULT_VALUE = Expression.constant(DivLineStyle.NONE)
        private val TEXT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE = Expression.constant(DivAlignmentHorizontal.LEFT)
        private val TEXT_ALIGNMENT_VERTICAL_DEFAULT_VALUE = Expression.constant(DivAlignmentVertical.TOP)
        private val TEXT_COLOR_DEFAULT_VALUE = Expression.constant(0xFF000000.toInt())
        private val TRANSFORM_DEFAULT_VALUE = DivTransform()
        private val UNDERLINE_DEFAULT_VALUE = Expression.constant(DivLineStyle.NONE)
        private val VISIBILITY_DEFAULT_VALUE = Expression.constant(DivVisibility.VISIBLE)
        private val WIDTH_DEFAULT_VALUE = DivSize.MatchParent(DivMatchParentSize())

        private val TYPE_HELPER_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.values().first()) { it is DivAlignmentHorizontal }
        private val TYPE_HELPER_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.values().first()) { it is DivAlignmentVertical }
        private val TYPE_HELPER_FONT_FAMILY = TypeHelper.from(default = DivFontFamily.values().first()) { it is DivFontFamily }
        private val TYPE_HELPER_FONT_SIZE_UNIT = TypeHelper.from(default = DivSizeUnit.values().first()) { it is DivSizeUnit }
        private val TYPE_HELPER_FONT_WEIGHT = TypeHelper.from(default = DivFontWeight.values().first()) { it is DivFontWeight }
        private val TYPE_HELPER_STRIKE = TypeHelper.from(default = DivLineStyle.values().first()) { it is DivLineStyle }
        private val TYPE_HELPER_TEXT_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.values().first()) { it is DivAlignmentHorizontal }
        private val TYPE_HELPER_TEXT_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.values().first()) { it is DivAlignmentVertical }
        private val TYPE_HELPER_UNDERLINE = TypeHelper.from(default = DivLineStyle.values().first()) { it is DivLineStyle }
        private val TYPE_HELPER_VISIBILITY = TypeHelper.from(default = DivVisibility.values().first()) { it is DivVisibility }

        private val ACTIONS_VALIDATOR = ListValidator<DivAction> { it: List<*> -> it.size >= 1 }
        private val ACTIONS_TEMPLATE_VALIDATOR = ListValidator<DivActionTemplate> { it: List<*> -> it.size >= 1 }
        private val ALPHA_TEMPLATE_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val ALPHA_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val BACKGROUND_VALIDATOR = ListValidator<DivBackground> { it: List<*> -> it.size >= 1 }
        private val BACKGROUND_TEMPLATE_VALIDATOR = ListValidator<DivBackgroundTemplate> { it: List<*> -> it.size >= 1 }
        private val COLUMN_SPAN_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val COLUMN_SPAN_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val DOUBLETAP_ACTIONS_VALIDATOR = ListValidator<DivAction> { it: List<*> -> it.size >= 1 }
        private val DOUBLETAP_ACTIONS_TEMPLATE_VALIDATOR = ListValidator<DivActionTemplate> { it: List<*> -> it.size >= 1 }
        private val EXTENSIONS_VALIDATOR = ListValidator<DivExtension> { it: List<*> -> it.size >= 1 }
        private val EXTENSIONS_TEMPLATE_VALIDATOR = ListValidator<DivExtensionTemplate> { it: List<*> -> it.size >= 1 }
        private val FONT_SIZE_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val FONT_SIZE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val ID_TEMPLATE_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val ID_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val IMAGES_VALIDATOR = ListValidator<DivText.Image> { it: List<*> -> it.size >= 1 }
        private val IMAGES_TEMPLATE_VALIDATOR = ListValidator<DivTextTemplate.ImageTemplate> { it: List<*> -> it.size >= 1 }
        private val LINE_HEIGHT_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val LINE_HEIGHT_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val LONGTAP_ACTIONS_VALIDATOR = ListValidator<DivAction> { it: List<*> -> it.size >= 1 }
        private val LONGTAP_ACTIONS_TEMPLATE_VALIDATOR = ListValidator<DivActionTemplate> { it: List<*> -> it.size >= 1 }
        private val MAX_LINES_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val MAX_LINES_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val MIN_HIDDEN_LINES_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val MIN_HIDDEN_LINES_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val RANGES_VALIDATOR = ListValidator<DivText.Range> { it: List<*> -> it.size >= 1 }
        private val RANGES_TEMPLATE_VALIDATOR = ListValidator<DivTextTemplate.RangeTemplate> { it: List<*> -> it.size >= 1 }
        private val ROW_SPAN_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val ROW_SPAN_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val SELECTED_ACTIONS_VALIDATOR = ListValidator<DivAction> { it: List<*> -> it.size >= 1 }
        private val SELECTED_ACTIONS_TEMPLATE_VALIDATOR = ListValidator<DivActionTemplate> { it: List<*> -> it.size >= 1 }
        private val TEXT_TEMPLATE_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val TEXT_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val TOOLTIPS_VALIDATOR = ListValidator<DivTooltip> { it: List<*> -> it.size >= 1 }
        private val TOOLTIPS_TEMPLATE_VALIDATOR = ListValidator<DivTooltipTemplate> { it: List<*> -> it.size >= 1 }
        private val TRANSITION_TRIGGERS_VALIDATOR = ListValidator<DivTransitionTrigger> { it: List<*> -> it.size >= 1 }
        private val TRANSITION_TRIGGERS_TEMPLATE_VALIDATOR = ListValidator<DivTransitionTrigger> { it: List<*> -> it.size >= 1 }
        private val VISIBILITY_ACTIONS_VALIDATOR = ListValidator<DivVisibilityAction> { it: List<*> -> it.size >= 1 }
        private val VISIBILITY_ACTIONS_TEMPLATE_VALIDATOR = ListValidator<DivVisibilityActionTemplate> { it: List<*> -> it.size >= 1 }

        val ACCESSIBILITY_READER: Reader<DivAccessibility> = { key, json, env -> JsonParser.readOptional(json, key, DivAccessibility.CREATOR, env.logger, env) ?: ACCESSIBILITY_DEFAULT_VALUE }
        val ACTION_READER: Reader<DivAction?> = { key, json, env -> JsonParser.readOptional(json, key, DivAction.CREATOR, env.logger, env) }
        val ACTION_ANIMATION_READER: Reader<DivAnimation> = { key, json, env -> JsonParser.readOptional(json, key, DivAnimation.CREATOR, env.logger, env) ?: ACTION_ANIMATION_DEFAULT_VALUE }
        val ACTIONS_READER: Reader<List<DivAction>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivAction.CREATOR, ACTIONS_VALIDATOR, env.logger, env) }
        val ALIGNMENT_HORIZONTAL_READER: Reader<Expression<DivAlignmentHorizontal>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivAlignmentHorizontal.Converter.FROM_STRING, env.logger, env, TYPE_HELPER_ALIGNMENT_HORIZONTAL) }
        val ALIGNMENT_VERTICAL_READER: Reader<Expression<DivAlignmentVertical>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivAlignmentVertical.Converter.FROM_STRING, env.logger, env, TYPE_HELPER_ALIGNMENT_VERTICAL) }
        val ALPHA_READER: Reader<Expression<Double>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, env.logger, env, ALPHA_DEFAULT_VALUE, TYPE_HELPER_DOUBLE) ?: ALPHA_DEFAULT_VALUE }
        val AUTO_ELLIPSIZE_READER: Reader<Expression<Boolean>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, ANY_TO_BOOLEAN, env.logger, env, TYPE_HELPER_BOOLEAN) }
        val BACKGROUND_READER: Reader<List<DivBackground>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivBackground.CREATOR, BACKGROUND_VALIDATOR, env.logger, env) }
        val BORDER_READER: Reader<DivBorder> = { key, json, env -> JsonParser.readOptional(json, key, DivBorder.CREATOR, env.logger, env) ?: BORDER_DEFAULT_VALUE }
        val COLUMN_SPAN_READER: Reader<Expression<Int>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR, env.logger, env, TYPE_HELPER_INT) }
        val DOUBLETAP_ACTIONS_READER: Reader<List<DivAction>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivAction.CREATOR, DOUBLETAP_ACTIONS_VALIDATOR, env.logger, env) }
        val ELLIPSIS_READER: Reader<DivText.Ellipsis?> = { key, json, env -> JsonParser.readOptional(json, key, DivText.Ellipsis.CREATOR, env.logger, env) }
        val EXTENSIONS_READER: Reader<List<DivExtension>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivExtension.CREATOR, EXTENSIONS_VALIDATOR, env.logger, env) }
        val FOCUS_READER: Reader<DivFocus?> = { key, json, env -> JsonParser.readOptional(json, key, DivFocus.CREATOR, env.logger, env) }
        val FOCUSED_TEXT_COLOR_READER: Reader<Expression<Int>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, STRING_TO_COLOR_INT, env.logger, env, TYPE_HELPER_COLOR) }
        val FONT_FAMILY_READER: Reader<Expression<DivFontFamily>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivFontFamily.Converter.FROM_STRING, env.logger, env, FONT_FAMILY_DEFAULT_VALUE, TYPE_HELPER_FONT_FAMILY) ?: FONT_FAMILY_DEFAULT_VALUE }
        val FONT_SIZE_READER: Reader<Expression<Int>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, FONT_SIZE_VALIDATOR, env.logger, env, FONT_SIZE_DEFAULT_VALUE, TYPE_HELPER_INT) ?: FONT_SIZE_DEFAULT_VALUE }
        val FONT_SIZE_UNIT_READER: Reader<Expression<DivSizeUnit>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivSizeUnit.Converter.FROM_STRING, env.logger, env, FONT_SIZE_UNIT_DEFAULT_VALUE, TYPE_HELPER_FONT_SIZE_UNIT) ?: FONT_SIZE_UNIT_DEFAULT_VALUE }
        val FONT_WEIGHT_READER: Reader<Expression<DivFontWeight>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivFontWeight.Converter.FROM_STRING, env.logger, env, FONT_WEIGHT_DEFAULT_VALUE, TYPE_HELPER_FONT_WEIGHT) ?: FONT_WEIGHT_DEFAULT_VALUE }
        val HEIGHT_READER: Reader<DivSize> = { key, json, env -> JsonParser.readOptional(json, key, DivSize.CREATOR, env.logger, env) ?: HEIGHT_DEFAULT_VALUE }
        val ID_READER: Reader<String?> = { key, json, env -> JsonParser.readOptional(json, key, ID_VALIDATOR, env.logger, env) }
        val IMAGES_READER: Reader<List<DivText.Image>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivText.Image.CREATOR, IMAGES_VALIDATOR, env.logger, env) }
        val LETTER_SPACING_READER: Reader<Expression<Double>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_DOUBLE, env.logger, env, LETTER_SPACING_DEFAULT_VALUE, TYPE_HELPER_DOUBLE) ?: LETTER_SPACING_DEFAULT_VALUE }
        val LINE_HEIGHT_READER: Reader<Expression<Int>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, LINE_HEIGHT_VALIDATOR, env.logger, env, TYPE_HELPER_INT) }
        val LONGTAP_ACTIONS_READER: Reader<List<DivAction>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivAction.CREATOR, LONGTAP_ACTIONS_VALIDATOR, env.logger, env) }
        val MARGINS_READER: Reader<DivEdgeInsets> = { key, json, env -> JsonParser.readOptional(json, key, DivEdgeInsets.CREATOR, env.logger, env) ?: MARGINS_DEFAULT_VALUE }
        val MAX_LINES_READER: Reader<Expression<Int>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, MAX_LINES_VALIDATOR, env.logger, env, TYPE_HELPER_INT) }
        val MIN_HIDDEN_LINES_READER: Reader<Expression<Int>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, MIN_HIDDEN_LINES_VALIDATOR, env.logger, env, TYPE_HELPER_INT) }
        val PADDINGS_READER: Reader<DivEdgeInsets> = { key, json, env -> JsonParser.readOptional(json, key, DivEdgeInsets.CREATOR, env.logger, env) ?: PADDINGS_DEFAULT_VALUE }
        val RANGES_READER: Reader<List<DivText.Range>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivText.Range.CREATOR, RANGES_VALIDATOR, env.logger, env) }
        val ROW_SPAN_READER: Reader<Expression<Int>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, ROW_SPAN_VALIDATOR, env.logger, env, TYPE_HELPER_INT) }
        val SELECTABLE_READER: Reader<Expression<Boolean>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, ANY_TO_BOOLEAN, env.logger, env, SELECTABLE_DEFAULT_VALUE, TYPE_HELPER_BOOLEAN) ?: SELECTABLE_DEFAULT_VALUE }
        val SELECTED_ACTIONS_READER: Reader<List<DivAction>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivAction.CREATOR, SELECTED_ACTIONS_VALIDATOR, env.logger, env) }
        val STRIKE_READER: Reader<Expression<DivLineStyle>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivLineStyle.Converter.FROM_STRING, env.logger, env, STRIKE_DEFAULT_VALUE, TYPE_HELPER_STRIKE) ?: STRIKE_DEFAULT_VALUE }
        val TEXT_READER: Reader<Expression<String>> = { key, json, env -> JsonParser.readExpression(json, key, TEXT_VALIDATOR, env.logger, env, TYPE_HELPER_STRING) }
        val TEXT_ALIGNMENT_HORIZONTAL_READER: Reader<Expression<DivAlignmentHorizontal>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivAlignmentHorizontal.Converter.FROM_STRING, env.logger, env, TEXT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE, TYPE_HELPER_TEXT_ALIGNMENT_HORIZONTAL) ?: TEXT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE }
        val TEXT_ALIGNMENT_VERTICAL_READER: Reader<Expression<DivAlignmentVertical>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivAlignmentVertical.Converter.FROM_STRING, env.logger, env, TEXT_ALIGNMENT_VERTICAL_DEFAULT_VALUE, TYPE_HELPER_TEXT_ALIGNMENT_VERTICAL) ?: TEXT_ALIGNMENT_VERTICAL_DEFAULT_VALUE }
        val TEXT_COLOR_READER: Reader<Expression<Int>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, STRING_TO_COLOR_INT, env.logger, env, TEXT_COLOR_DEFAULT_VALUE, TYPE_HELPER_COLOR) ?: TEXT_COLOR_DEFAULT_VALUE }
        val TEXT_GRADIENT_READER: Reader<DivTextGradient?> = { key, json, env -> JsonParser.readOptional(json, key, DivTextGradient.CREATOR, env.logger, env) }
        val TOOLTIPS_READER: Reader<List<DivTooltip>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivTooltip.CREATOR, TOOLTIPS_VALIDATOR, env.logger, env) }
        val TRANSFORM_READER: Reader<DivTransform> = { key, json, env -> JsonParser.readOptional(json, key, DivTransform.CREATOR, env.logger, env) ?: TRANSFORM_DEFAULT_VALUE }
        val TRANSITION_CHANGE_READER: Reader<DivChangeTransition?> = { key, json, env -> JsonParser.readOptional(json, key, DivChangeTransition.CREATOR, env.logger, env) }
        val TRANSITION_IN_READER: Reader<DivAppearanceTransition?> = { key, json, env -> JsonParser.readOptional(json, key, DivAppearanceTransition.CREATOR, env.logger, env) }
        val TRANSITION_OUT_READER: Reader<DivAppearanceTransition?> = { key, json, env -> JsonParser.readOptional(json, key, DivAppearanceTransition.CREATOR, env.logger, env) }
        val TRANSITION_TRIGGERS_READER: Reader<List<DivTransitionTrigger>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivTransitionTrigger.Converter.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR, env.logger, env) }
        val TYPE_READER: Reader<String> = { key, json, env -> JsonParser.read(json, key, env.logger, env) }
        val UNDERLINE_READER: Reader<Expression<DivLineStyle>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivLineStyle.Converter.FROM_STRING, env.logger, env, UNDERLINE_DEFAULT_VALUE, TYPE_HELPER_UNDERLINE) ?: UNDERLINE_DEFAULT_VALUE }
        val VISIBILITY_READER: Reader<Expression<DivVisibility>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivVisibility.Converter.FROM_STRING, env.logger, env, VISIBILITY_DEFAULT_VALUE, TYPE_HELPER_VISIBILITY) ?: VISIBILITY_DEFAULT_VALUE }
        val VISIBILITY_ACTION_READER: Reader<DivVisibilityAction?> = { key, json, env -> JsonParser.readOptional(json, key, DivVisibilityAction.CREATOR, env.logger, env) }
        val VISIBILITY_ACTIONS_READER: Reader<List<DivVisibilityAction>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivVisibilityAction.CREATOR, VISIBILITY_ACTIONS_VALIDATOR, env.logger, env) }
        val WIDTH_READER: Reader<DivSize> = { key, json, env -> JsonParser.readOptional(json, key, DivSize.CREATOR, env.logger, env) ?: WIDTH_DEFAULT_VALUE }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivTextTemplate(env, json = it) }
    }


    @Mockable
    class RangeTemplate : JSONSerializable, JsonTemplate<DivText.Range> {
        @JvmField final val actions: Field<List<DivActionTemplate>> // at least 1 elements
        @JvmField final val background: Field<DivTextRangeBackgroundTemplate>
        @JvmField final val border: Field<DivTextRangeBorderTemplate>
        @JvmField final val end: Field<Expression<Int>> // constraint: number > 0
        @JvmField final val fontFamily: Field<Expression<DivFontFamily>>
        @JvmField final val fontSize: Field<Expression<Int>> // constraint: number >= 0
        @JvmField final val fontSizeUnit: Field<Expression<DivSizeUnit>> // default value: sp
        @JvmField final val fontWeight: Field<Expression<DivFontWeight>>
        @JvmField final val letterSpacing: Field<Expression<Double>>
        @JvmField final val lineHeight: Field<Expression<Int>> // constraint: number >= 0
        @JvmField final val start: Field<Expression<Int>> // constraint: number >= 0
        @JvmField final val strike: Field<Expression<DivLineStyle>>
        @JvmField final val textColor: Field<Expression<Int>>
        @JvmField final val topOffset: Field<Expression<Int>> // constraint: number >= 0
        @JvmField final val underline: Field<Expression<DivLineStyle>>

        constructor (
            env: ParsingEnvironment,
            parent: RangeTemplate? = null,
            topLevel: Boolean = false,
            json: JSONObject
        ) {
            val logger = env.logger
            actions = JsonTemplateParser.readOptionalListField(json, "actions", topLevel, parent?.actions, DivActionTemplate.CREATOR, ACTIONS_TEMPLATE_VALIDATOR, logger, env)
            background = JsonTemplateParser.readOptionalField(json, "background", topLevel, parent?.background, DivTextRangeBackgroundTemplate.CREATOR, logger, env)
            border = JsonTemplateParser.readOptionalField(json, "border", topLevel, parent?.border, DivTextRangeBorderTemplate.CREATOR, logger, env)
            end = JsonTemplateParser.readFieldWithExpression(json, "end", topLevel, parent?.end, NUMBER_TO_INT, END_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
            fontFamily = JsonTemplateParser.readOptionalFieldWithExpression(json, "font_family", topLevel, parent?.fontFamily, DivFontFamily.Converter.FROM_STRING, logger, env, TYPE_HELPER_FONT_FAMILY)
            fontSize = JsonTemplateParser.readOptionalFieldWithExpression(json, "font_size", topLevel, parent?.fontSize, NUMBER_TO_INT, FONT_SIZE_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
            fontSizeUnit = JsonTemplateParser.readOptionalFieldWithExpression(json, "font_size_unit", topLevel, parent?.fontSizeUnit, DivSizeUnit.Converter.FROM_STRING, logger, env, TYPE_HELPER_FONT_SIZE_UNIT)
            fontWeight = JsonTemplateParser.readOptionalFieldWithExpression(json, "font_weight", topLevel, parent?.fontWeight, DivFontWeight.Converter.FROM_STRING, logger, env, TYPE_HELPER_FONT_WEIGHT)
            letterSpacing = JsonTemplateParser.readOptionalFieldWithExpression(json, "letter_spacing", topLevel, parent?.letterSpacing, NUMBER_TO_DOUBLE, logger, env, TYPE_HELPER_DOUBLE)
            lineHeight = JsonTemplateParser.readOptionalFieldWithExpression(json, "line_height", topLevel, parent?.lineHeight, NUMBER_TO_INT, LINE_HEIGHT_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
            start = JsonTemplateParser.readFieldWithExpression(json, "start", topLevel, parent?.start, NUMBER_TO_INT, START_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
            strike = JsonTemplateParser.readOptionalFieldWithExpression(json, "strike", topLevel, parent?.strike, DivLineStyle.Converter.FROM_STRING, logger, env, TYPE_HELPER_STRIKE)
            textColor = JsonTemplateParser.readOptionalFieldWithExpression(json, "text_color", topLevel, parent?.textColor, STRING_TO_COLOR_INT, logger, env, TYPE_HELPER_COLOR)
            topOffset = JsonTemplateParser.readOptionalFieldWithExpression(json, "top_offset", topLevel, parent?.topOffset, NUMBER_TO_INT, TOP_OFFSET_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
            underline = JsonTemplateParser.readOptionalFieldWithExpression(json, "underline", topLevel, parent?.underline, DivLineStyle.Converter.FROM_STRING, logger, env, TYPE_HELPER_UNDERLINE)
        }

        override fun resolve(env: ParsingEnvironment, data: JSONObject): DivText.Range {
            return DivText.Range(
                actions = actions.resolveOptionalTemplateList(env = env, key = "actions", data = data, ACTIONS_VALIDATOR, reader = ACTIONS_READER),
                background = background.resolveOptionalTemplate(env = env, key = "background", data = data, reader = BACKGROUND_READER),
                border = border.resolveOptionalTemplate(env = env, key = "border", data = data, reader = BORDER_READER),
                end = end.resolve(env = env, key = "end", data = data, reader = END_READER),
                fontFamily = fontFamily.resolveOptional(env = env, key = "font_family", data = data, reader = FONT_FAMILY_READER),
                fontSize = fontSize.resolveOptional(env = env, key = "font_size", data = data, reader = FONT_SIZE_READER),
                fontSizeUnit = fontSizeUnit.resolveOptional(env = env, key = "font_size_unit", data = data, reader = FONT_SIZE_UNIT_READER) ?: FONT_SIZE_UNIT_DEFAULT_VALUE,
                fontWeight = fontWeight.resolveOptional(env = env, key = "font_weight", data = data, reader = FONT_WEIGHT_READER),
                letterSpacing = letterSpacing.resolveOptional(env = env, key = "letter_spacing", data = data, reader = LETTER_SPACING_READER),
                lineHeight = lineHeight.resolveOptional(env = env, key = "line_height", data = data, reader = LINE_HEIGHT_READER),
                start = start.resolve(env = env, key = "start", data = data, reader = START_READER),
                strike = strike.resolveOptional(env = env, key = "strike", data = data, reader = STRIKE_READER),
                textColor = textColor.resolveOptional(env = env, key = "text_color", data = data, reader = TEXT_COLOR_READER),
                topOffset = topOffset.resolveOptional(env = env, key = "top_offset", data = data, reader = TOP_OFFSET_READER),
                underline = underline.resolveOptional(env = env, key = "underline", data = data, reader = UNDERLINE_READER)
            )
        }

        override fun writeToJSON(): JSONObject {
            val json = JSONObject()
            json.writeField(key = "actions", field = actions)
            json.writeField(key = "background", field = background)
            json.writeField(key = "border", field = border)
            json.writeFieldWithExpression(key = "end", field = end)
            json.writeFieldWithExpression(key = "font_family", field = fontFamily, converter = { v: DivFontFamily -> DivFontFamily.toString(v) })
            json.writeFieldWithExpression(key = "font_size", field = fontSize)
            json.writeFieldWithExpression(key = "font_size_unit", field = fontSizeUnit, converter = { v: DivSizeUnit -> DivSizeUnit.toString(v) })
            json.writeFieldWithExpression(key = "font_weight", field = fontWeight, converter = { v: DivFontWeight -> DivFontWeight.toString(v) })
            json.writeFieldWithExpression(key = "letter_spacing", field = letterSpacing)
            json.writeFieldWithExpression(key = "line_height", field = lineHeight)
            json.writeFieldWithExpression(key = "start", field = start)
            json.writeFieldWithExpression(key = "strike", field = strike, converter = { v: DivLineStyle -> DivLineStyle.toString(v) })
            json.writeFieldWithExpression(key = "text_color", field = textColor, converter = COLOR_INT_TO_STRING)
            json.writeFieldWithExpression(key = "top_offset", field = topOffset)
            json.writeFieldWithExpression(key = "underline", field = underline, converter = { v: DivLineStyle -> DivLineStyle.toString(v) })
            return json
        }

        companion object {
            private val FONT_SIZE_UNIT_DEFAULT_VALUE = Expression.constant(DivSizeUnit.SP)

            private val TYPE_HELPER_FONT_FAMILY = TypeHelper.from(default = DivFontFamily.values().first()) { it is DivFontFamily }
            private val TYPE_HELPER_FONT_SIZE_UNIT = TypeHelper.from(default = DivSizeUnit.values().first()) { it is DivSizeUnit }
            private val TYPE_HELPER_FONT_WEIGHT = TypeHelper.from(default = DivFontWeight.values().first()) { it is DivFontWeight }
            private val TYPE_HELPER_STRIKE = TypeHelper.from(default = DivLineStyle.values().first()) { it is DivLineStyle }
            private val TYPE_HELPER_UNDERLINE = TypeHelper.from(default = DivLineStyle.values().first()) { it is DivLineStyle }

            private val ACTIONS_VALIDATOR = ListValidator<DivAction> { it: List<*> -> it.size >= 1 }
            private val ACTIONS_TEMPLATE_VALIDATOR = ListValidator<DivActionTemplate> { it: List<*> -> it.size >= 1 }
            private val END_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it > 0 }
            private val END_VALIDATOR = ValueValidator<Int> { it: Int -> it > 0 }
            private val FONT_SIZE_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
            private val FONT_SIZE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
            private val LINE_HEIGHT_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
            private val LINE_HEIGHT_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
            private val START_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
            private val START_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
            private val TOP_OFFSET_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
            private val TOP_OFFSET_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }

            val ACTIONS_READER: Reader<List<DivAction>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivAction.CREATOR, ACTIONS_VALIDATOR, env.logger, env) }
            val BACKGROUND_READER: Reader<DivTextRangeBackground?> = { key, json, env -> JsonParser.readOptional(json, key, DivTextRangeBackground.CREATOR, env.logger, env) }
            val BORDER_READER: Reader<DivTextRangeBorder?> = { key, json, env -> JsonParser.readOptional(json, key, DivTextRangeBorder.CREATOR, env.logger, env) }
            val END_READER: Reader<Expression<Int>> = { key, json, env -> JsonParser.readExpression(json, key, NUMBER_TO_INT, END_VALIDATOR, env.logger, env, TYPE_HELPER_INT) }
            val FONT_FAMILY_READER: Reader<Expression<DivFontFamily>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivFontFamily.Converter.FROM_STRING, env.logger, env, TYPE_HELPER_FONT_FAMILY) }
            val FONT_SIZE_READER: Reader<Expression<Int>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, FONT_SIZE_VALIDATOR, env.logger, env, TYPE_HELPER_INT) }
            val FONT_SIZE_UNIT_READER: Reader<Expression<DivSizeUnit>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivSizeUnit.Converter.FROM_STRING, env.logger, env, FONT_SIZE_UNIT_DEFAULT_VALUE, TYPE_HELPER_FONT_SIZE_UNIT) ?: FONT_SIZE_UNIT_DEFAULT_VALUE }
            val FONT_WEIGHT_READER: Reader<Expression<DivFontWeight>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivFontWeight.Converter.FROM_STRING, env.logger, env, TYPE_HELPER_FONT_WEIGHT) }
            val LETTER_SPACING_READER: Reader<Expression<Double>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_DOUBLE, env.logger, env, TYPE_HELPER_DOUBLE) }
            val LINE_HEIGHT_READER: Reader<Expression<Int>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, LINE_HEIGHT_VALIDATOR, env.logger, env, TYPE_HELPER_INT) }
            val START_READER: Reader<Expression<Int>> = { key, json, env -> JsonParser.readExpression(json, key, NUMBER_TO_INT, START_VALIDATOR, env.logger, env, TYPE_HELPER_INT) }
            val STRIKE_READER: Reader<Expression<DivLineStyle>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivLineStyle.Converter.FROM_STRING, env.logger, env, TYPE_HELPER_STRIKE) }
            val TEXT_COLOR_READER: Reader<Expression<Int>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, STRING_TO_COLOR_INT, env.logger, env, TYPE_HELPER_COLOR) }
            val TOP_OFFSET_READER: Reader<Expression<Int>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, TOP_OFFSET_VALIDATOR, env.logger, env, TYPE_HELPER_INT) }
            val UNDERLINE_READER: Reader<Expression<DivLineStyle>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivLineStyle.Converter.FROM_STRING, env.logger, env, TYPE_HELPER_UNDERLINE) }

            val CREATOR = { env: ParsingEnvironment, it: JSONObject -> RangeTemplate(env, json = it) }
        }

    }

    @Mockable
    class ImageTemplate : JSONSerializable, JsonTemplate<DivText.Image> {
        @JvmField final val height: Field<DivFixedSizeTemplate> // default value: DivFixedSize(value = Expression.constant(20))
        @JvmField final val start: Field<Expression<Int>> // constraint: number >= 0
        @JvmField final val tintColor: Field<Expression<Int>>
        @JvmField final val tintMode: Field<Expression<DivBlendMode>> // default value: source_in
        @JvmField final val url: Field<Expression<Uri>>
        @JvmField final val width: Field<DivFixedSizeTemplate> // default value: DivFixedSize(value = Expression.constant(20))

        constructor (
            env: ParsingEnvironment,
            parent: ImageTemplate? = null,
            topLevel: Boolean = false,
            json: JSONObject
        ) {
            val logger = env.logger
            height = JsonTemplateParser.readOptionalField(json, "height", topLevel, parent?.height, DivFixedSizeTemplate.CREATOR, logger, env)
            start = JsonTemplateParser.readFieldWithExpression(json, "start", topLevel, parent?.start, NUMBER_TO_INT, START_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
            tintColor = JsonTemplateParser.readOptionalFieldWithExpression(json, "tint_color", topLevel, parent?.tintColor, STRING_TO_COLOR_INT, logger, env, TYPE_HELPER_COLOR)
            tintMode = JsonTemplateParser.readOptionalFieldWithExpression(json, "tint_mode", topLevel, parent?.tintMode, DivBlendMode.Converter.FROM_STRING, logger, env, TYPE_HELPER_TINT_MODE)
            url = JsonTemplateParser.readFieldWithExpression(json, "url", topLevel, parent?.url, STRING_TO_URI, logger, env, TYPE_HELPER_URI)
            width = JsonTemplateParser.readOptionalField(json, "width", topLevel, parent?.width, DivFixedSizeTemplate.CREATOR, logger, env)
        }

        override fun resolve(env: ParsingEnvironment, data: JSONObject): DivText.Image {
            return DivText.Image(
                height = height.resolveOptionalTemplate(env = env, key = "height", data = data, reader = HEIGHT_READER) ?: HEIGHT_DEFAULT_VALUE,
                start = start.resolve(env = env, key = "start", data = data, reader = START_READER),
                tintColor = tintColor.resolveOptional(env = env, key = "tint_color", data = data, reader = TINT_COLOR_READER),
                tintMode = tintMode.resolveOptional(env = env, key = "tint_mode", data = data, reader = TINT_MODE_READER) ?: TINT_MODE_DEFAULT_VALUE,
                url = url.resolve(env = env, key = "url", data = data, reader = URL_READER),
                width = width.resolveOptionalTemplate(env = env, key = "width", data = data, reader = WIDTH_READER) ?: WIDTH_DEFAULT_VALUE
            )
        }

        override fun writeToJSON(): JSONObject {
            val json = JSONObject()
            json.writeField(key = "height", field = height)
            json.writeFieldWithExpression(key = "start", field = start)
            json.writeFieldWithExpression(key = "tint_color", field = tintColor, converter = COLOR_INT_TO_STRING)
            json.writeFieldWithExpression(key = "tint_mode", field = tintMode, converter = { v: DivBlendMode -> DivBlendMode.toString(v) })
            json.writeFieldWithExpression(key = "url", field = url, converter = URI_TO_STRING)
            json.writeField(key = "width", field = width)
            return json
        }

        companion object {
            private val HEIGHT_DEFAULT_VALUE = DivFixedSize(value = Expression.constant(20))
            private val TINT_MODE_DEFAULT_VALUE = Expression.constant(DivBlendMode.SOURCE_IN)
            private val WIDTH_DEFAULT_VALUE = DivFixedSize(value = Expression.constant(20))

            private val TYPE_HELPER_TINT_MODE = TypeHelper.from(default = DivBlendMode.values().first()) { it is DivBlendMode }

            private val START_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
            private val START_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }

            val HEIGHT_READER: Reader<DivFixedSize> = { key, json, env -> JsonParser.readOptional(json, key, DivFixedSize.CREATOR, env.logger, env) ?: HEIGHT_DEFAULT_VALUE }
            val START_READER: Reader<Expression<Int>> = { key, json, env -> JsonParser.readExpression(json, key, NUMBER_TO_INT, START_VALIDATOR, env.logger, env, TYPE_HELPER_INT) }
            val TINT_COLOR_READER: Reader<Expression<Int>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, STRING_TO_COLOR_INT, env.logger, env, TYPE_HELPER_COLOR) }
            val TINT_MODE_READER: Reader<Expression<DivBlendMode>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivBlendMode.Converter.FROM_STRING, env.logger, env, TINT_MODE_DEFAULT_VALUE, TYPE_HELPER_TINT_MODE) ?: TINT_MODE_DEFAULT_VALUE }
            val URL_READER: Reader<Expression<Uri>> = { key, json, env -> JsonParser.readExpression(json, key, STRING_TO_URI, env.logger, env, TYPE_HELPER_URI) }
            val WIDTH_READER: Reader<DivFixedSize> = { key, json, env -> JsonParser.readOptional(json, key, DivFixedSize.CREATOR, env.logger, env) ?: WIDTH_DEFAULT_VALUE }

            val CREATOR = { env: ParsingEnvironment, it: JSONObject -> ImageTemplate(env, json = it) }
        }

    }

    @Mockable
    class EllipsisTemplate : JSONSerializable, JsonTemplate<DivText.Ellipsis> {
        @JvmField final val actions: Field<List<DivActionTemplate>> // at least 1 elements
        @JvmField final val images: Field<List<ImageTemplate>> // at least 1 elements
        @JvmField final val ranges: Field<List<RangeTemplate>> // at least 1 elements
        @JvmField final val text: Field<Expression<String>> // at least 1 char

        constructor (
            env: ParsingEnvironment,
            parent: EllipsisTemplate? = null,
            topLevel: Boolean = false,
            json: JSONObject
        ) {
            val logger = env.logger
            actions = JsonTemplateParser.readOptionalListField(json, "actions", topLevel, parent?.actions, DivActionTemplate.CREATOR, ACTIONS_TEMPLATE_VALIDATOR, logger, env)
            images = JsonTemplateParser.readOptionalListField(json, "images", topLevel, parent?.images, ImageTemplate.CREATOR, IMAGES_TEMPLATE_VALIDATOR, logger, env)
            ranges = JsonTemplateParser.readOptionalListField(json, "ranges", topLevel, parent?.ranges, RangeTemplate.CREATOR, RANGES_TEMPLATE_VALIDATOR, logger, env)
            text = JsonTemplateParser.readFieldWithExpression(json, "text", topLevel, parent?.text, TEXT_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_STRING)
        }

        override fun resolve(env: ParsingEnvironment, data: JSONObject): DivText.Ellipsis {
            return DivText.Ellipsis(
                actions = actions.resolveOptionalTemplateList(env = env, key = "actions", data = data, ACTIONS_VALIDATOR, reader = ACTIONS_READER),
                images = images.resolveOptionalTemplateList(env = env, key = "images", data = data, IMAGES_VALIDATOR, reader = IMAGES_READER),
                ranges = ranges.resolveOptionalTemplateList(env = env, key = "ranges", data = data, RANGES_VALIDATOR, reader = RANGES_READER),
                text = text.resolve(env = env, key = "text", data = data, reader = TEXT_READER)
            )
        }

        override fun writeToJSON(): JSONObject {
            val json = JSONObject()
            json.writeField(key = "actions", field = actions)
            json.writeField(key = "images", field = images)
            json.writeField(key = "ranges", field = ranges)
            json.writeFieldWithExpression(key = "text", field = text)
            return json
        }

        companion object {
            private val ACTIONS_VALIDATOR = ListValidator<DivAction> { it: List<*> -> it.size >= 1 }
            private val ACTIONS_TEMPLATE_VALIDATOR = ListValidator<DivActionTemplate> { it: List<*> -> it.size >= 1 }
            private val IMAGES_VALIDATOR = ListValidator<DivText.Image> { it: List<*> -> it.size >= 1 }
            private val IMAGES_TEMPLATE_VALIDATOR = ListValidator<DivTextTemplate.ImageTemplate> { it: List<*> -> it.size >= 1 }
            private val RANGES_VALIDATOR = ListValidator<DivText.Range> { it: List<*> -> it.size >= 1 }
            private val RANGES_TEMPLATE_VALIDATOR = ListValidator<DivTextTemplate.RangeTemplate> { it: List<*> -> it.size >= 1 }
            private val TEXT_TEMPLATE_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
            private val TEXT_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }

            val ACTIONS_READER: Reader<List<DivAction>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivAction.CREATOR, ACTIONS_VALIDATOR, env.logger, env) }
            val IMAGES_READER: Reader<List<DivText.Image>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivText.Image.CREATOR, IMAGES_VALIDATOR, env.logger, env) }
            val RANGES_READER: Reader<List<DivText.Range>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivText.Range.CREATOR, RANGES_VALIDATOR, env.logger, env) }
            val TEXT_READER: Reader<Expression<String>> = { key, json, env -> JsonParser.readExpression(json, key, TEXT_VALIDATOR, env.logger, env, TYPE_HELPER_STRING) }

            val CREATOR = { env: ParsingEnvironment, it: JSONObject -> EllipsisTemplate(env, json = it) }
        }

    }
}
