// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.json.*
import com.yandex.div.json.expressions.Expression
import com.yandex.div.json.expressions.ExpressionsList
import com.yandex.div.json.schema.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*

@Mockable
class DivVisibilityActionTemplate : JSONSerializable, JsonTemplate<DivVisibilityAction> {
    @JvmField final val downloadCallbacks: Field<DivDownloadCallbacksTemplate>
    @JvmField final val logId: Field<String> // at least 1 char
    @JvmField final val logLimit: Field<Expression<Int>> // constraint: number >= 0; default value: 1
    @JvmField final val payload: Field<JSONObject>
    @JvmField final val referer: Field<Expression<Uri>>
    @JvmField final val url: Field<Expression<Uri>>
    @JvmField final val visibilityDuration: Field<Expression<Int>> // constraint: number >= 0; default value: 800
    @JvmField final val visibilityPercentage: Field<Expression<Int>> // constraint: number > 0 && number <= 100; default value: 50

    constructor (
        env: ParsingEnvironment,
        parent: DivVisibilityActionTemplate? = null,
        topLevel: Boolean = false,
        json: JSONObject
    ) {
        val logger = env.logger
        downloadCallbacks = JsonTemplateParser.readOptionalField(json, "download_callbacks", topLevel, parent?.downloadCallbacks, DivDownloadCallbacksTemplate.CREATOR, logger, env)
        logId = JsonTemplateParser.readField(json, "log_id", topLevel, parent?.logId, LOG_ID_TEMPLATE_VALIDATOR, logger, env)
        logLimit = JsonTemplateParser.readOptionalFieldWithExpression(json, "log_limit", topLevel, parent?.logLimit, NUMBER_TO_INT, LOG_LIMIT_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
        payload = JsonTemplateParser.readOptionalField(json, "payload", topLevel, parent?.payload, logger, env)
        referer = JsonTemplateParser.readOptionalFieldWithExpression(json, "referer", topLevel, parent?.referer, STRING_TO_URI, logger, env, TYPE_HELPER_URI)
        url = JsonTemplateParser.readOptionalFieldWithExpression(json, "url", topLevel, parent?.url, STRING_TO_URI, logger, env, TYPE_HELPER_URI)
        visibilityDuration = JsonTemplateParser.readOptionalFieldWithExpression(json, "visibility_duration", topLevel, parent?.visibilityDuration, NUMBER_TO_INT, VISIBILITY_DURATION_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
        visibilityPercentage = JsonTemplateParser.readOptionalFieldWithExpression(json, "visibility_percentage", topLevel, parent?.visibilityPercentage, NUMBER_TO_INT, VISIBILITY_PERCENTAGE_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
    }

    override fun resolve(env: ParsingEnvironment, data: JSONObject): DivVisibilityAction {
        return DivVisibilityAction(
            downloadCallbacks = downloadCallbacks.resolveOptionalTemplate(env = env, key = "download_callbacks", data = data, reader = DOWNLOAD_CALLBACKS_READER),
            logId = logId.resolve(env = env, key = "log_id", data = data, reader = LOG_ID_READER),
            logLimit = logLimit.resolveOptional(env = env, key = "log_limit", data = data, reader = LOG_LIMIT_READER) ?: LOG_LIMIT_DEFAULT_VALUE,
            payload = payload.resolveOptional(env = env, key = "payload", data = data, reader = PAYLOAD_READER),
            referer = referer.resolveOptional(env = env, key = "referer", data = data, reader = REFERER_READER),
            url = url.resolveOptional(env = env, key = "url", data = data, reader = URL_READER),
            visibilityDuration = visibilityDuration.resolveOptional(env = env, key = "visibility_duration", data = data, reader = VISIBILITY_DURATION_READER) ?: VISIBILITY_DURATION_DEFAULT_VALUE,
            visibilityPercentage = visibilityPercentage.resolveOptional(env = env, key = "visibility_percentage", data = data, reader = VISIBILITY_PERCENTAGE_READER) ?: VISIBILITY_PERCENTAGE_DEFAULT_VALUE
        )
    }

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.writeField(key = "download_callbacks", field = downloadCallbacks)
        json.writeField(key = "log_id", field = logId)
        json.writeFieldWithExpression(key = "log_limit", field = logLimit)
        json.writeField(key = "payload", field = payload)
        json.writeFieldWithExpression(key = "referer", field = referer, converter = URI_TO_STRING)
        json.writeFieldWithExpression(key = "url", field = url, converter = URI_TO_STRING)
        json.writeFieldWithExpression(key = "visibility_duration", field = visibilityDuration)
        json.writeFieldWithExpression(key = "visibility_percentage", field = visibilityPercentage)
        return json
    }

    companion object {
        private val LOG_LIMIT_DEFAULT_VALUE = Expression.constant(1)
        private val VISIBILITY_DURATION_DEFAULT_VALUE = Expression.constant(800)
        private val VISIBILITY_PERCENTAGE_DEFAULT_VALUE = Expression.constant(50)

        private val LOG_ID_TEMPLATE_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val LOG_ID_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val LOG_LIMIT_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val LOG_LIMIT_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val VISIBILITY_DURATION_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val VISIBILITY_DURATION_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val VISIBILITY_PERCENTAGE_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it > 0 && it <= 100 }
        private val VISIBILITY_PERCENTAGE_VALIDATOR = ValueValidator<Int> { it: Int -> it > 0 && it <= 100 }

        val DOWNLOAD_CALLBACKS_READER: Reader<DivDownloadCallbacks?> = { key, json, env -> JsonParser.readOptional(json, key, DivDownloadCallbacks.CREATOR, env.logger, env) }
        val LOG_ID_READER: Reader<String> = { key, json, env -> JsonParser.read(json, key, LOG_ID_VALIDATOR, env.logger, env) }
        val LOG_LIMIT_READER: Reader<Expression<Int>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, LOG_LIMIT_VALIDATOR, env.logger, env, LOG_LIMIT_DEFAULT_VALUE, TYPE_HELPER_INT) ?: LOG_LIMIT_DEFAULT_VALUE }
        val PAYLOAD_READER: Reader<JSONObject?> = { key, json, env -> JsonParser.readOptional(json, key, env.logger, env) }
        val REFERER_READER: Reader<Expression<Uri>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, STRING_TO_URI, env.logger, env, TYPE_HELPER_URI) }
        val URL_READER: Reader<Expression<Uri>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, STRING_TO_URI, env.logger, env, TYPE_HELPER_URI) }
        val VISIBILITY_DURATION_READER: Reader<Expression<Int>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, VISIBILITY_DURATION_VALIDATOR, env.logger, env, VISIBILITY_DURATION_DEFAULT_VALUE, TYPE_HELPER_INT) ?: VISIBILITY_DURATION_DEFAULT_VALUE }
        val VISIBILITY_PERCENTAGE_READER: Reader<Expression<Int>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, VISIBILITY_PERCENTAGE_VALIDATOR, env.logger, env, VISIBILITY_PERCENTAGE_DEFAULT_VALUE, TYPE_HELPER_INT) ?: VISIBILITY_PERCENTAGE_DEFAULT_VALUE }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivVisibilityActionTemplate(env, json = it) }
    }

}
