// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*

@Mockable
sealed class Div : JSONSerializable {
    class Image(val value: DivImage) : Div()
    class GifImage(val value: DivGifImage) : Div()
    class Text(val value: DivText) : Div()
    class Separator(val value: DivSeparator) : Div()
    class Container(val value: DivContainer) : Div()
    class Grid(val value: DivGrid) : Div()
    class Gallery(val value: DivGallery) : Div()
    class Pager(val value: DivPager) : Div()
    class Tabs(val value: DivTabs) : Div()
    class State(val value: DivState) : Div()
    class Custom(val value: DivCustom) : Div()
    class Indicator(val value: DivIndicator) : Div()
    class Slider(val value: DivSlider) : Div()
    class Input(val value: DivInput) : Div()

    fun value(): DivBase {
        return when (this) {
            is Image -> value
            is GifImage -> value
            is Text -> value
            is Separator -> value
            is Container -> value
            is Grid -> value
            is Gallery -> value
            is Pager -> value
            is Tabs -> value
            is State -> value
            is Custom -> value
            is Indicator -> value
            is Slider -> value
            is Input -> value
        }
    }

    override fun writeToJSON(): JSONObject {
        return when (this) {
            is Image -> value.writeToJSON()
            is GifImage -> value.writeToJSON()
            is Text -> value.writeToJSON()
            is Separator -> value.writeToJSON()
            is Container -> value.writeToJSON()
            is Grid -> value.writeToJSON()
            is Gallery -> value.writeToJSON()
            is Pager -> value.writeToJSON()
            is Tabs -> value.writeToJSON()
            is State -> value.writeToJSON()
            is Custom -> value.writeToJSON()
            is Indicator -> value.writeToJSON()
            is Slider -> value.writeToJSON()
            is Input -> value.writeToJSON()
        }
    }

    companion object {
        @Throws(ParsingException::class)
        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): Div {
            val logger = env.logger
            val type: String = json.read("type", logger = logger, env = env)
            when (type) {
                DivImage.TYPE -> return Image(DivImage(env, json))
                DivGifImage.TYPE -> return GifImage(DivGifImage(env, json))
                DivText.TYPE -> return Text(DivText(env, json))
                DivSeparator.TYPE -> return Separator(DivSeparator(env, json))
                DivContainer.TYPE -> return Container(DivContainer(env, json))
                DivGrid.TYPE -> return Grid(DivGrid(env, json))
                DivGallery.TYPE -> return Gallery(DivGallery(env, json))
                DivPager.TYPE -> return Pager(DivPager(env, json))
                DivTabs.TYPE -> return Tabs(DivTabs(env, json))
                DivState.TYPE -> return State(DivState(env, json))
                DivCustom.TYPE -> return Custom(DivCustom(env, json))
                DivIndicator.TYPE -> return Indicator(DivIndicator(env, json))
                DivSlider.TYPE -> return Slider(DivSlider(env, json))
                DivInput.TYPE -> return Input(DivInput(env, json))
            }
            val template = env.templates.getOrThrow(type, json) as? DivTemplate
            if (template != null) {
                return template.resolve(env, json)
            } else {
                throw typeMismatch(json = json, key = "type", value = type)
            }
        }
        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> Div(env, json = it) }
    }
}
