// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*

@Mockable
class DivActionTemplate : JSONSerializable, JsonTemplate<DivAction> {
    @JvmField final val downloadCallbacks: Field<DivDownloadCallbacksTemplate>
    @JvmField final val logId: Field<String> // at least 1 char
    @JvmField final val logUrl: Field<Expression<Uri>>
    @JvmField final val menuItems: Field<List<MenuItemTemplate>> // at least 1 elements
    @JvmField final val payload: Field<JSONObject>
    @JvmField final val referer: Field<Expression<Uri>>
    @JvmField final val target: Field<Expression<DivAction.Target>>
    @JvmField final val url: Field<Expression<Uri>>

    constructor (
        env: ParsingEnvironment,
        parent: DivActionTemplate? = null,
        topLevel: Boolean = false,
        json: JSONObject
    ) {
        val logger = env.logger
        downloadCallbacks = JsonTemplateParser.readOptionalField(json, "download_callbacks", topLevel, parent?.downloadCallbacks, DivDownloadCallbacksTemplate.CREATOR, logger, env)
        logId = JsonTemplateParser.readField(json, "log_id", topLevel, parent?.logId, LOG_ID_TEMPLATE_VALIDATOR, logger, env)
        logUrl = JsonTemplateParser.readOptionalFieldWithExpression(json, "log_url", topLevel, parent?.logUrl, STRING_TO_URI, logger, env, TYPE_HELPER_URI)
        menuItems = JsonTemplateParser.readOptionalListField(json, "menu_items", topLevel, parent?.menuItems, MenuItemTemplate.CREATOR, MENU_ITEMS_TEMPLATE_VALIDATOR, logger, env)
        payload = JsonTemplateParser.readOptionalField(json, "payload", topLevel, parent?.payload, logger, env)
        referer = JsonTemplateParser.readOptionalFieldWithExpression(json, "referer", topLevel, parent?.referer, STRING_TO_URI, logger, env, TYPE_HELPER_URI)
        target = JsonTemplateParser.readOptionalFieldWithExpression(json, "target", topLevel, parent?.target, DivAction.Target.Converter.FROM_STRING, logger, env, TYPE_HELPER_TARGET)
        url = JsonTemplateParser.readOptionalFieldWithExpression(json, "url", topLevel, parent?.url, STRING_TO_URI, logger, env, TYPE_HELPER_URI)
    }

    override fun resolve(env: ParsingEnvironment, data: JSONObject): DivAction {
        return DivAction(
            downloadCallbacks = downloadCallbacks.resolveOptionalTemplate(env = env, key = "download_callbacks", data = data, reader = DOWNLOAD_CALLBACKS_READER),
            logId = logId.resolve(env = env, key = "log_id", data = data, reader = LOG_ID_READER),
            logUrl = logUrl.resolveOptional(env = env, key = "log_url", data = data, reader = LOG_URL_READER),
            menuItems = menuItems.resolveOptionalTemplateList(env = env, key = "menu_items", data = data, MENU_ITEMS_VALIDATOR, reader = MENU_ITEMS_READER),
            payload = payload.resolveOptional(env = env, key = "payload", data = data, reader = PAYLOAD_READER),
            referer = referer.resolveOptional(env = env, key = "referer", data = data, reader = REFERER_READER),
            target = target.resolveOptional(env = env, key = "target", data = data, reader = TARGET_READER),
            url = url.resolveOptional(env = env, key = "url", data = data, reader = URL_READER)
        )
    }

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.writeField(key = "download_callbacks", field = downloadCallbacks)
        json.writeField(key = "log_id", field = logId)
        json.writeFieldWithExpression(key = "log_url", field = logUrl, converter = URI_TO_STRING)
        json.writeField(key = "menu_items", field = menuItems)
        json.writeField(key = "payload", field = payload)
        json.writeFieldWithExpression(key = "referer", field = referer, converter = URI_TO_STRING)
        json.writeFieldWithExpression(key = "target", field = target, converter = { v: DivAction.Target -> DivAction.Target.toString(v) })
        json.writeFieldWithExpression(key = "url", field = url, converter = URI_TO_STRING)
        return json
    }

    companion object {
        private val TYPE_HELPER_TARGET = TypeHelper.from(default = DivAction.Target.values().first()) { it is DivAction.Target }

        private val LOG_ID_TEMPLATE_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val LOG_ID_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val MENU_ITEMS_VALIDATOR = ListValidator<DivAction.MenuItem> { it: List<*> -> it.size >= 1 }
        private val MENU_ITEMS_TEMPLATE_VALIDATOR = ListValidator<DivActionTemplate.MenuItemTemplate> { it: List<*> -> it.size >= 1 }

        val DOWNLOAD_CALLBACKS_READER: Reader<DivDownloadCallbacks?> = { key, json, env -> JsonParser.readOptional(json, key, DivDownloadCallbacks.CREATOR, env.logger, env) }
        val LOG_ID_READER: Reader<String> = { key, json, env -> JsonParser.read(json, key, LOG_ID_VALIDATOR, env.logger, env) }
        val LOG_URL_READER: Reader<Expression<Uri>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, STRING_TO_URI, env.logger, env, TYPE_HELPER_URI) }
        val MENU_ITEMS_READER: Reader<List<DivAction.MenuItem>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivAction.MenuItem.CREATOR, MENU_ITEMS_VALIDATOR, env.logger, env) }
        val PAYLOAD_READER: Reader<JSONObject?> = { key, json, env -> JsonParser.readOptional(json, key, env.logger, env) }
        val REFERER_READER: Reader<Expression<Uri>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, STRING_TO_URI, env.logger, env, TYPE_HELPER_URI) }
        val TARGET_READER: Reader<Expression<DivAction.Target>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivAction.Target.Converter.FROM_STRING, env.logger, env, TYPE_HELPER_TARGET) }
        val URL_READER: Reader<Expression<Uri>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, STRING_TO_URI, env.logger, env, TYPE_HELPER_URI) }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivActionTemplate(env, json = it) }
    }


    @Mockable
    class MenuItemTemplate : JSONSerializable, JsonTemplate<DivAction.MenuItem> {
        @JvmField final val action: Field<DivActionTemplate>
        @JvmField final val actions: Field<List<DivActionTemplate>> // at least 1 elements
        @JvmField final val text: Field<Expression<String>> // at least 1 char

        constructor (
            env: ParsingEnvironment,
            parent: MenuItemTemplate? = null,
            topLevel: Boolean = false,
            json: JSONObject
        ) {
            val logger = env.logger
            action = JsonTemplateParser.readOptionalField(json, "action", topLevel, parent?.action, DivActionTemplate.CREATOR, logger, env)
            actions = JsonTemplateParser.readOptionalListField(json, "actions", topLevel, parent?.actions, DivActionTemplate.CREATOR, ACTIONS_TEMPLATE_VALIDATOR, logger, env)
            text = JsonTemplateParser.readFieldWithExpression(json, "text", topLevel, parent?.text, TEXT_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_STRING)
        }

        override fun resolve(env: ParsingEnvironment, data: JSONObject): DivAction.MenuItem {
            return DivAction.MenuItem(
                action = action.resolveOptionalTemplate(env = env, key = "action", data = data, reader = ACTION_READER),
                actions = actions.resolveOptionalTemplateList(env = env, key = "actions", data = data, ACTIONS_VALIDATOR, reader = ACTIONS_READER),
                text = text.resolve(env = env, key = "text", data = data, reader = TEXT_READER)
            )
        }

        override fun writeToJSON(): JSONObject {
            val json = JSONObject()
            json.writeField(key = "action", field = action)
            json.writeField(key = "actions", field = actions)
            json.writeFieldWithExpression(key = "text", field = text)
            return json
        }

        companion object {
            private val ACTIONS_VALIDATOR = ListValidator<DivAction> { it: List<*> -> it.size >= 1 }
            private val ACTIONS_TEMPLATE_VALIDATOR = ListValidator<DivActionTemplate> { it: List<*> -> it.size >= 1 }
            private val TEXT_TEMPLATE_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
            private val TEXT_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }

            val ACTION_READER: Reader<DivAction?> = { key, json, env -> JsonParser.readOptional(json, key, DivAction.CREATOR, env.logger, env) }
            val ACTIONS_READER: Reader<List<DivAction>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivAction.CREATOR, ACTIONS_VALIDATOR, env.logger, env) }
            val TEXT_READER: Reader<Expression<String>> = { key, json, env -> JsonParser.readExpression(json, key, TEXT_VALIDATOR, env.logger, env, TYPE_HELPER_STRING) }

            val CREATOR = { env: ParsingEnvironment, it: JSONObject -> MenuItemTemplate(env, json = it) }
        }

    }
}
