// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*

@Mockable
class DivData(
    @JvmField final val logId: String, // at least 1 char
    @JvmField final val states: List<State>, // at least 1 elements; all received elements must be valid
    @JvmField final val timers: List<DivTimer>? = null, // at least 1 elements
    @JvmField final val transitionAnimationSelector: Expression<DivTransitionSelector> = TRANSITION_ANIMATION_SELECTOR_DEFAULT_VALUE, // default value: none
    @JvmField final val variableTriggers: List<DivTrigger>? = null, // at least 1 elements
    @JvmField final val variables: List<DivVariable>? = null, // at least 1 elements
    @JvmField final val parsingErrors: List<Exception>? = null,
) : JSONSerializable {

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.write(key = "log_id", value = logId)
        json.write(key = "states", value = states)
        json.write(key = "timers", value = timers)
        json.writeExpression(key = "transition_animation_selector", value = transitionAnimationSelector, converter = { v: DivTransitionSelector -> DivTransitionSelector.toString(v) })
        json.write(key = "variable_triggers", value = variableTriggers)
        json.write(key = "variables", value = variables)
        return json
    }

    fun copyWithNewArray(
        states: List<DivData.State>,
    ) = DivData(
        logId,
        states,
        timers,
        transitionAnimationSelector,
        variableTriggers,
        variables,
    )

    companion object {
        private val TRANSITION_ANIMATION_SELECTOR_DEFAULT_VALUE = Expression.constant(DivTransitionSelector.NONE)

        private val TYPE_HELPER_TRANSITION_ANIMATION_SELECTOR = TypeHelper.from(default = DivTransitionSelector.values().first()) { it is DivTransitionSelector }

        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivData {
            val env = env.withErrorsCollector()
            val logger = env.logger
            return DivData(
                logId = JsonParser.read(json, "log_id", LOG_ID_VALIDATOR, logger, env),
                states = JsonParser.readStrictList(json, "states", State.CREATOR, STATES_VALIDATOR, logger, env),
                timers = JsonParser.readOptionalList(json, "timers", DivTimer.CREATOR, TIMERS_VALIDATOR, logger, env),
                transitionAnimationSelector = JsonParser.readOptionalExpression(json, "transition_animation_selector", DivTransitionSelector.Converter.FROM_STRING, logger, env, TRANSITION_ANIMATION_SELECTOR_DEFAULT_VALUE, TYPE_HELPER_TRANSITION_ANIMATION_SELECTOR) ?: TRANSITION_ANIMATION_SELECTOR_DEFAULT_VALUE,
                variableTriggers = JsonParser.readOptionalList(json, "variable_triggers", DivTrigger.CREATOR, VARIABLE_TRIGGERS_VALIDATOR, logger, env),
                variables = JsonParser.readOptionalList(json, "variables", DivVariable.CREATOR, VARIABLES_VALIDATOR, logger, env),
                parsingErrors = env.collectErrors()
            )
        }

        private val LOG_ID_TEMPLATE_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val LOG_ID_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val STATES_VALIDATOR = ListValidator<DivData.State> { it: List<*> -> it.size >= 1 }
        private val TIMERS_VALIDATOR = ListValidator<DivTimer> { it: List<*> -> it.size >= 1 }
        private val VARIABLE_TRIGGERS_VALIDATOR = ListValidator<DivTrigger> { it: List<*> -> it.size >= 1 }
        private val VARIABLES_VALIDATOR = ListValidator<DivVariable> { it: List<*> -> it.size >= 1 }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivData(env, json = it) }
    }


    @Mockable
    class State(
        @JvmField final val div: Div,
        @JvmField final val stateId: Int,
    ) : JSONSerializable {

        override fun writeToJSON(): JSONObject {
            val json = JSONObject()
            json.write(key = "div", value = div)
            json.write(key = "state_id", value = stateId)
            return json
        }

        companion object {
            @JvmStatic
            @JvmName("fromJson")
            operator fun invoke(env: ParsingEnvironment, json: JSONObject): State {
                val logger = env.logger
                return State(
                    div = JsonParser.read(json, "div", Div.CREATOR, logger, env),
                    stateId = JsonParser.read(json, "state_id", NUMBER_TO_INT, logger, env)
                )
            }

            val CREATOR = { env: ParsingEnvironment, it: JSONObject -> State(env, json = it) }
        }

    }
}
