// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*

@Mockable
class DivFocus(
    @JvmField final val background: List<DivBackground>? = null, // at least 1 elements
    @JvmField final val border: DivBorder = BORDER_DEFAULT_VALUE,
    @JvmField final val nextFocusIds: NextFocusIds? = null,
    @JvmField final val onBlur: List<DivAction>? = null, // at least 1 elements
    @JvmField final val onFocus: List<DivAction>? = null, // at least 1 elements
) : JSONSerializable {

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.write(key = "background", value = background)
        json.write(key = "border", value = border)
        json.write(key = "next_focus_ids", value = nextFocusIds)
        json.write(key = "on_blur", value = onBlur)
        json.write(key = "on_focus", value = onFocus)
        return json
    }

    companion object {
        private val BORDER_DEFAULT_VALUE = DivBorder()

        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivFocus {
            val logger = env.logger
            return DivFocus(
                background = JsonParser.readOptionalList(json, "background", DivBackground.CREATOR, BACKGROUND_VALIDATOR, logger, env),
                border = JsonParser.readOptional(json, "border", DivBorder.CREATOR, logger, env) ?: BORDER_DEFAULT_VALUE,
                nextFocusIds = JsonParser.readOptional(json, "next_focus_ids", NextFocusIds.CREATOR, logger, env),
                onBlur = JsonParser.readOptionalList(json, "on_blur", DivAction.CREATOR, ON_BLUR_VALIDATOR, logger, env),
                onFocus = JsonParser.readOptionalList(json, "on_focus", DivAction.CREATOR, ON_FOCUS_VALIDATOR, logger, env)
            )
        }

        private val BACKGROUND_VALIDATOR = ListValidator<DivBackground> { it: List<*> -> it.size >= 1 }
        private val ON_BLUR_VALIDATOR = ListValidator<DivAction> { it: List<*> -> it.size >= 1 }
        private val ON_FOCUS_VALIDATOR = ListValidator<DivAction> { it: List<*> -> it.size >= 1 }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivFocus(env, json = it) }
    }


    @Mockable
    class NextFocusIds(
        @JvmField final val down: Expression<String>? = null, // at least 1 char
        @JvmField final val forward: Expression<String>? = null, // at least 1 char
        @JvmField final val left: Expression<String>? = null, // at least 1 char
        @JvmField final val right: Expression<String>? = null, // at least 1 char
        @JvmField final val up: Expression<String>? = null, // at least 1 char
    ) : JSONSerializable {

        override fun writeToJSON(): JSONObject {
            val json = JSONObject()
            json.writeExpression(key = "down", value = down)
            json.writeExpression(key = "forward", value = forward)
            json.writeExpression(key = "left", value = left)
            json.writeExpression(key = "right", value = right)
            json.writeExpression(key = "up", value = up)
            return json
        }

        companion object {
            @JvmStatic
            @JvmName("fromJson")
            operator fun invoke(env: ParsingEnvironment, json: JSONObject): NextFocusIds {
                val logger = env.logger
                return NextFocusIds(
                    down = JsonParser.readOptionalExpression(json, "down", DOWN_VALIDATOR, logger, env, TYPE_HELPER_STRING),
                    forward = JsonParser.readOptionalExpression(json, "forward", FORWARD_VALIDATOR, logger, env, TYPE_HELPER_STRING),
                    left = JsonParser.readOptionalExpression(json, "left", LEFT_VALIDATOR, logger, env, TYPE_HELPER_STRING),
                    right = JsonParser.readOptionalExpression(json, "right", RIGHT_VALIDATOR, logger, env, TYPE_HELPER_STRING),
                    up = JsonParser.readOptionalExpression(json, "up", UP_VALIDATOR, logger, env, TYPE_HELPER_STRING)
                )
            }

            private val DOWN_TEMPLATE_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
            private val DOWN_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
            private val FORWARD_TEMPLATE_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
            private val FORWARD_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
            private val LEFT_TEMPLATE_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
            private val LEFT_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
            private val RIGHT_TEMPLATE_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
            private val RIGHT_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
            private val UP_TEMPLATE_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
            private val UP_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }

            val CREATOR = { env: ParsingEnvironment, it: JSONObject -> NextFocusIds(env, json = it) }
        }

    }
}
