// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*

@Mockable
class DivSlideTransitionTemplate : JSONSerializable, JsonTemplate<DivSlideTransition> {
    @JvmField final val distance: Field<DivDimensionTemplate>
    @JvmField final val duration: Field<Expression<Int>> // constraint: number >= 0; default value: 200
    @JvmField final val edge: Field<Expression<DivSlideTransition.Edge>> // default value: bottom
    @JvmField final val interpolator: Field<Expression<DivAnimationInterpolator>> // default value: ease_in_out
    @JvmField final val startDelay: Field<Expression<Int>> // constraint: number >= 0; default value: 0

    constructor (
        env: ParsingEnvironment,
        parent: DivSlideTransitionTemplate? = null,
        topLevel: Boolean = false,
        json: JSONObject
    ) {
        val logger = env.logger
        distance = JsonTemplateParser.readOptionalField(json, "distance", topLevel, parent?.distance, DivDimensionTemplate.CREATOR, logger, env)
        duration = JsonTemplateParser.readOptionalFieldWithExpression(json, "duration", topLevel, parent?.duration, NUMBER_TO_INT, DURATION_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
        edge = JsonTemplateParser.readOptionalFieldWithExpression(json, "edge", topLevel, parent?.edge, DivSlideTransition.Edge.Converter.FROM_STRING, logger, env, TYPE_HELPER_EDGE)
        interpolator = JsonTemplateParser.readOptionalFieldWithExpression(json, "interpolator", topLevel, parent?.interpolator, DivAnimationInterpolator.Converter.FROM_STRING, logger, env, TYPE_HELPER_INTERPOLATOR)
        startDelay = JsonTemplateParser.readOptionalFieldWithExpression(json, "start_delay", topLevel, parent?.startDelay, NUMBER_TO_INT, START_DELAY_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
    }

    override fun resolve(env: ParsingEnvironment, data: JSONObject): DivSlideTransition {
        return DivSlideTransition(
            distance = distance.resolveOptionalTemplate(env = env, key = "distance", data = data, reader = DISTANCE_READER),
            duration = duration.resolveOptional(env = env, key = "duration", data = data, reader = DURATION_READER) ?: DURATION_DEFAULT_VALUE,
            edge = edge.resolveOptional(env = env, key = "edge", data = data, reader = EDGE_READER) ?: EDGE_DEFAULT_VALUE,
            interpolator = interpolator.resolveOptional(env = env, key = "interpolator", data = data, reader = INTERPOLATOR_READER) ?: INTERPOLATOR_DEFAULT_VALUE,
            startDelay = startDelay.resolveOptional(env = env, key = "start_delay", data = data, reader = START_DELAY_READER) ?: START_DELAY_DEFAULT_VALUE
        )
    }

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.writeField(key = "distance", field = distance)
        json.writeFieldWithExpression(key = "duration", field = duration)
        json.writeFieldWithExpression(key = "edge", field = edge, converter = { v: DivSlideTransition.Edge -> DivSlideTransition.Edge.toString(v) })
        json.writeFieldWithExpression(key = "interpolator", field = interpolator, converter = { v: DivAnimationInterpolator -> DivAnimationInterpolator.toString(v) })
        json.writeFieldWithExpression(key = "start_delay", field = startDelay)
        json.write(key = "type", value = TYPE)
        return json
    }

    companion object {
        const val TYPE = "slide"

        private val DURATION_DEFAULT_VALUE = Expression.constant(200)
        private val EDGE_DEFAULT_VALUE = Expression.constant(DivSlideTransition.Edge.BOTTOM)
        private val INTERPOLATOR_DEFAULT_VALUE = Expression.constant(DivAnimationInterpolator.EASE_IN_OUT)
        private val START_DELAY_DEFAULT_VALUE = Expression.constant(0)

        private val TYPE_HELPER_EDGE = TypeHelper.from(default = DivSlideTransition.Edge.values().first()) { it is DivSlideTransition.Edge }
        private val TYPE_HELPER_INTERPOLATOR = TypeHelper.from(default = DivAnimationInterpolator.values().first()) { it is DivAnimationInterpolator }

        private val DURATION_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val DURATION_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val START_DELAY_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val START_DELAY_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }

        val DISTANCE_READER: Reader<DivDimension?> = { key, json, env -> JsonParser.readOptional(json, key, DivDimension.CREATOR, env.logger, env) }
        val DURATION_READER: Reader<Expression<Int>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, DURATION_VALIDATOR, env.logger, env, DURATION_DEFAULT_VALUE, TYPE_HELPER_INT) ?: DURATION_DEFAULT_VALUE }
        val EDGE_READER: Reader<Expression<DivSlideTransition.Edge>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivSlideTransition.Edge.Converter.FROM_STRING, env.logger, env, EDGE_DEFAULT_VALUE, TYPE_HELPER_EDGE) ?: EDGE_DEFAULT_VALUE }
        val INTERPOLATOR_READER: Reader<Expression<DivAnimationInterpolator>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivAnimationInterpolator.Converter.FROM_STRING, env.logger, env, INTERPOLATOR_DEFAULT_VALUE, TYPE_HELPER_INTERPOLATOR) ?: INTERPOLATOR_DEFAULT_VALUE }
        val START_DELAY_READER: Reader<Expression<Int>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, START_DELAY_VALIDATOR, env.logger, env, START_DELAY_DEFAULT_VALUE, TYPE_HELPER_INT) ?: START_DELAY_DEFAULT_VALUE }
        val TYPE_READER: Reader<String> = { key, json, env -> JsonParser.read(json, key, env.logger, env) }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivSlideTransitionTemplate(env, json = it) }
    }

}
