// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*

@Mockable
class DivTrigger(
    @JvmField final val actions: List<DivAction>, // at least 1 elements
    @JvmField final val condition: Expression<Boolean>,
    @JvmField final val mode: Expression<Mode> = MODE_DEFAULT_VALUE, // default value: on_condition
) : JSONSerializable {

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.write(key = "actions", value = actions)
        json.writeExpression(key = "condition", value = condition)
        json.writeExpression(key = "mode", value = mode, converter = { v: Mode -> Mode.toString(v) })
        return json
    }

    fun copyWithNewArray(
        actions: List<DivAction>,
    ) = DivTrigger(
        actions,
        condition,
        mode,
    )

    companion object {
        private val MODE_DEFAULT_VALUE = Expression.constant(Mode.ON_CONDITION)

        private val TYPE_HELPER_MODE = TypeHelper.from(default = DivTrigger.Mode.values().first()) { it is DivTrigger.Mode }

        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivTrigger {
            val logger = env.logger
            return DivTrigger(
                actions = JsonParser.readList(json, "actions", DivAction.CREATOR, ACTIONS_VALIDATOR, logger, env),
                condition = JsonParser.readExpression(json, "condition", ANY_TO_BOOLEAN, logger, env, TYPE_HELPER_BOOLEAN),
                mode = JsonParser.readOptionalExpression(json, "mode", Mode.Converter.FROM_STRING, logger, env, MODE_DEFAULT_VALUE, TYPE_HELPER_MODE) ?: MODE_DEFAULT_VALUE
            )
        }

        private val ACTIONS_VALIDATOR = ListValidator<DivAction> { it: List<*> -> it.size >= 1 }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivTrigger(env, json = it) }
    }


    enum class Mode(private val value: String) {
        ON_CONDITION("on_condition"),
        ON_VARIABLE("on_variable");

        companion object Converter {
            fun toString(obj: Mode): String {
                return obj.value
            }

            fun fromString(string: String): Mode? {
                return when (string) {
                    ON_CONDITION.value -> ON_CONDITION
                    ON_VARIABLE.value -> ON_VARIABLE
                    else -> null
                }
            }

            val FROM_STRING = { string: String ->
                when (string) {
                    ON_CONDITION.value -> ON_CONDITION
                    ON_VARIABLE.value -> ON_VARIABLE
                    else -> null
                }
            }
        }
    }
}
