// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*

@Mockable
sealed class DivVariable : JSONSerializable {
    class Str(val value: StrVariable) : DivVariable()
    class Number(val value: NumberVariable) : DivVariable()
    class Integer(val value: IntegerVariable) : DivVariable()
    class Bool(val value: BoolVariable) : DivVariable()
    class Color(val value: ColorVariable) : DivVariable()
    class Url(val value: UrlVariable) : DivVariable()

    fun value(): Any {
        return when (this) {
            is Str -> value
            is Number -> value
            is Integer -> value
            is Bool -> value
            is Color -> value
            is Url -> value
        }
    }

    override fun writeToJSON(): JSONObject {
        return when (this) {
            is Str -> value.writeToJSON()
            is Number -> value.writeToJSON()
            is Integer -> value.writeToJSON()
            is Bool -> value.writeToJSON()
            is Color -> value.writeToJSON()
            is Url -> value.writeToJSON()
        }
    }

    companion object {
        @Throws(ParsingException::class)
        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivVariable {
            val logger = env.logger
            val type: String = json.read("type", logger = logger, env = env)
            when (type) {
                StrVariable.TYPE -> return Str(StrVariable(env, json))
                NumberVariable.TYPE -> return Number(NumberVariable(env, json))
                IntegerVariable.TYPE -> return Integer(IntegerVariable(env, json))
                BoolVariable.TYPE -> return Bool(BoolVariable(env, json))
                ColorVariable.TYPE -> return Color(ColorVariable(env, json))
                UrlVariable.TYPE -> return Url(UrlVariable(env, json))
            }
            val template = env.templates.getOrThrow(type, json) as? DivVariableTemplate
            if (template != null) {
                return template.resolve(env, json)
            } else {
                throw typeMismatch(json = json, key = "type", value = type)
            }
        }
        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivVariable(env, json = it) }
    }
}
