// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*

@Mockable
class DivVisibilityAction(
    @JvmField final val downloadCallbacks: DivDownloadCallbacks? = null,
    @JvmField final val logId: String, // at least 1 char
    @JvmField final val logLimit: Expression<Int> = LOG_LIMIT_DEFAULT_VALUE, // constraint: number >= 0; default value: 1
    @JvmField final val payload: JSONObject? = null,
    @JvmField final val referer: Expression<Uri>? = null,
    @JvmField final val url: Expression<Uri>? = null,
    @JvmField final val visibilityDuration: Expression<Int> = VISIBILITY_DURATION_DEFAULT_VALUE, // constraint: number >= 0; default value: 800
    @JvmField final val visibilityPercentage: Expression<Int> = VISIBILITY_PERCENTAGE_DEFAULT_VALUE, // constraint: number > 0 && number <= 100; default value: 50
) : JSONSerializable {

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.write(key = "download_callbacks", value = downloadCallbacks)
        json.write(key = "log_id", value = logId)
        json.writeExpression(key = "log_limit", value = logLimit)
        json.write(key = "payload", value = payload)
        json.writeExpression(key = "referer", value = referer, converter = URI_TO_STRING)
        json.writeExpression(key = "url", value = url, converter = URI_TO_STRING)
        json.writeExpression(key = "visibility_duration", value = visibilityDuration)
        json.writeExpression(key = "visibility_percentage", value = visibilityPercentage)
        return json
    }

    companion object {
        private val LOG_LIMIT_DEFAULT_VALUE = Expression.constant(1)
        private val VISIBILITY_DURATION_DEFAULT_VALUE = Expression.constant(800)
        private val VISIBILITY_PERCENTAGE_DEFAULT_VALUE = Expression.constant(50)

        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivVisibilityAction {
            val logger = env.logger
            return DivVisibilityAction(
                downloadCallbacks = JsonParser.readOptional(json, "download_callbacks", DivDownloadCallbacks.CREATOR, logger, env),
                logId = JsonParser.read(json, "log_id", LOG_ID_VALIDATOR, logger, env),
                logLimit = JsonParser.readOptionalExpression(json, "log_limit", NUMBER_TO_INT, LOG_LIMIT_VALIDATOR, logger, env, LOG_LIMIT_DEFAULT_VALUE, TYPE_HELPER_INT) ?: LOG_LIMIT_DEFAULT_VALUE,
                payload = JsonParser.readOptional(json, "payload", logger, env),
                referer = JsonParser.readOptionalExpression(json, "referer", STRING_TO_URI, logger, env, TYPE_HELPER_URI),
                url = JsonParser.readOptionalExpression(json, "url", STRING_TO_URI, logger, env, TYPE_HELPER_URI),
                visibilityDuration = JsonParser.readOptionalExpression(json, "visibility_duration", NUMBER_TO_INT, VISIBILITY_DURATION_VALIDATOR, logger, env, VISIBILITY_DURATION_DEFAULT_VALUE, TYPE_HELPER_INT) ?: VISIBILITY_DURATION_DEFAULT_VALUE,
                visibilityPercentage = JsonParser.readOptionalExpression(json, "visibility_percentage", NUMBER_TO_INT, VISIBILITY_PERCENTAGE_VALIDATOR, logger, env, VISIBILITY_PERCENTAGE_DEFAULT_VALUE, TYPE_HELPER_INT) ?: VISIBILITY_PERCENTAGE_DEFAULT_VALUE
            )
        }

        private val LOG_ID_TEMPLATE_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val LOG_ID_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val LOG_LIMIT_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val LOG_LIMIT_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val VISIBILITY_DURATION_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val VISIBILITY_DURATION_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val VISIBILITY_PERCENTAGE_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it > 0 && it <= 100 }
        private val VISIBILITY_PERCENTAGE_VALIDATOR = ValueValidator<Int> { it: Int -> it > 0 && it <= 100 }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivVisibilityAction(env, json = it) }
    }

}
