// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*

@Mockable
sealed class DivBackground : JSONSerializable {
    class LinearGradient(val value: DivLinearGradient) : DivBackground()
    class RadialGradient(val value: DivRadialGradient) : DivBackground()
    class Image(val value: DivImageBackground) : DivBackground()
    class Solid(val value: DivSolidBackground) : DivBackground()
    class NinePatch(val value: DivNinePatchBackground) : DivBackground()

    fun value(): Any {
        return when (this) {
            is LinearGradient -> value
            is RadialGradient -> value
            is Image -> value
            is Solid -> value
            is NinePatch -> value
        }
    }

    override fun writeToJSON(): JSONObject {
        return when (this) {
            is LinearGradient -> value.writeToJSON()
            is RadialGradient -> value.writeToJSON()
            is Image -> value.writeToJSON()
            is Solid -> value.writeToJSON()
            is NinePatch -> value.writeToJSON()
        }
    }

    companion object {
        @Throws(ParsingException::class)
        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivBackground {
            val logger = env.logger
            val type: String = json.read("type", logger = logger, env = env)
            when (type) {
                DivLinearGradient.TYPE -> return LinearGradient(DivLinearGradient(env, json))
                DivRadialGradient.TYPE -> return RadialGradient(DivRadialGradient(env, json))
                DivImageBackground.TYPE -> return Image(DivImageBackground(env, json))
                DivSolidBackground.TYPE -> return Solid(DivSolidBackground(env, json))
                DivNinePatchBackground.TYPE -> return NinePatch(DivNinePatchBackground(env, json))
            }
            val template = env.templates.getOrThrow(type, json) as? DivBackgroundTemplate
            if (template != null) {
                return template.resolve(env, json)
            } else {
                throw typeMismatch(json = json, key = "type", value = type)
            }
        }
        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivBackground(env, json = it) }
    }
}
