// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*

@Mockable
sealed class DivBackgroundTemplate : JSONSerializable, JsonTemplate<DivBackground> {
    class LinearGradient(val value: DivLinearGradientTemplate) : DivBackgroundTemplate()
    class RadialGradient(val value: DivRadialGradientTemplate) : DivBackgroundTemplate()
    class Image(val value: DivImageBackgroundTemplate) : DivBackgroundTemplate()
    class Solid(val value: DivSolidBackgroundTemplate) : DivBackgroundTemplate()
    class NinePatch(val value: DivNinePatchBackgroundTemplate) : DivBackgroundTemplate()

    fun value(): Any {
        return when (this) {
            is LinearGradient -> value
            is RadialGradient -> value
            is Image -> value
            is Solid -> value
            is NinePatch -> value
        }
    }

    override fun writeToJSON(): JSONObject {
        return when (this) {
            is LinearGradient -> value.writeToJSON()
            is RadialGradient -> value.writeToJSON()
            is Image -> value.writeToJSON()
            is Solid -> value.writeToJSON()
            is NinePatch -> value.writeToJSON()
        }
    }

    override fun resolve(env: ParsingEnvironment, data: JSONObject): DivBackground {
        return when (this) {
            is LinearGradient -> DivBackground.LinearGradient(value.resolve(env, data))
            is RadialGradient -> DivBackground.RadialGradient(value.resolve(env, data))
            is Image -> DivBackground.Image(value.resolve(env, data))
            is Solid -> DivBackground.Solid(value.resolve(env, data))
            is NinePatch -> DivBackground.NinePatch(value.resolve(env, data))
        }
    }

    val type: String
        get() {
            return when (this) {
                is LinearGradient -> DivLinearGradientTemplate.TYPE
                is RadialGradient -> DivRadialGradientTemplate.TYPE
                is Image -> DivImageBackgroundTemplate.TYPE
                is Solid -> DivSolidBackgroundTemplate.TYPE
                is NinePatch -> DivNinePatchBackgroundTemplate.TYPE
            }
        }

    companion object {
        @Throws(ParsingException::class)
        operator fun invoke(
            env: ParsingEnvironment,
            topLevel: Boolean = false,
            json: JSONObject
        ): DivBackgroundTemplate {
            val logger = env.logger
            val receivedType: String = json.read("type", logger = logger, env = env)
            val parent = env.templates[receivedType] as? DivBackgroundTemplate
            val type = parent?.type ?: receivedType
            when (type) {
                DivLinearGradientTemplate.TYPE -> return LinearGradient(DivLinearGradientTemplate(env, parent?.value() as DivLinearGradientTemplate?, topLevel, json))
                DivRadialGradientTemplate.TYPE -> return RadialGradient(DivRadialGradientTemplate(env, parent?.value() as DivRadialGradientTemplate?, topLevel, json))
                DivImageBackgroundTemplate.TYPE -> return Image(DivImageBackgroundTemplate(env, parent?.value() as DivImageBackgroundTemplate?, topLevel, json))
                DivSolidBackgroundTemplate.TYPE -> return Solid(DivSolidBackgroundTemplate(env, parent?.value() as DivSolidBackgroundTemplate?, topLevel, json))
                DivNinePatchBackgroundTemplate.TYPE -> return NinePatch(DivNinePatchBackgroundTemplate(env, parent?.value() as DivNinePatchBackgroundTemplate?, topLevel, json))
                else -> throw typeMismatch(json = json, key = "type", value = type)
            }
        }
        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivBackgroundTemplate(env, json = it) }
    }
}
