// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*

@Mockable
class DivDataTemplate : JSONSerializable, JsonTemplate<DivData> {
    @JvmField final val logId: Field<String> // at least 1 char
    @JvmField final val states: Field<List<StateTemplate>> // at least 1 elements; all received elements must be valid
    @JvmField final val timers: Field<List<DivTimerTemplate>> // at least 1 elements
    @JvmField final val transitionAnimationSelector: Field<Expression<DivTransitionSelector>> // default value: none
    @JvmField final val variableTriggers: Field<List<DivTriggerTemplate>> // at least 1 elements
    @JvmField final val variables: Field<List<DivVariableTemplate>> // at least 1 elements

    constructor (
        env: ParsingEnvironment,
        parent: DivDataTemplate? = null,
        topLevel: Boolean = false,
        json: JSONObject
    ) {
        val logger = env.logger
        logId = JsonTemplateParser.readField(json, "log_id", topLevel, parent?.logId, LOG_ID_TEMPLATE_VALIDATOR, logger, env)
        states = JsonTemplateParser.readStrictListField(json, "states", topLevel, parent?.states, StateTemplate.CREATOR, STATES_TEMPLATE_VALIDATOR, logger, env)
        timers = JsonTemplateParser.readOptionalListField(json, "timers", topLevel, parent?.timers, DivTimerTemplate.CREATOR, TIMERS_TEMPLATE_VALIDATOR, logger, env)
        transitionAnimationSelector = JsonTemplateParser.readOptionalFieldWithExpression(json, "transition_animation_selector", topLevel, parent?.transitionAnimationSelector, DivTransitionSelector.Converter.FROM_STRING, logger, env, TYPE_HELPER_TRANSITION_ANIMATION_SELECTOR)
        variableTriggers = JsonTemplateParser.readOptionalListField(json, "variable_triggers", topLevel, parent?.variableTriggers, DivTriggerTemplate.CREATOR, VARIABLE_TRIGGERS_TEMPLATE_VALIDATOR, logger, env)
        variables = JsonTemplateParser.readOptionalListField(json, "variables", topLevel, parent?.variables, DivVariableTemplate.CREATOR, VARIABLES_TEMPLATE_VALIDATOR, logger, env)
    }

    override fun resolve(env: ParsingEnvironment, data: JSONObject): DivData {
        return DivData(
            logId = logId.resolve(env = env, key = "log_id", data = data, reader = LOG_ID_READER),
            states = states.resolveTemplateList(env = env, key = "states", data = data, STATES_VALIDATOR, reader = STATES_READER),
            timers = timers.resolveOptionalTemplateList(env = env, key = "timers", data = data, TIMERS_VALIDATOR, reader = TIMERS_READER),
            transitionAnimationSelector = transitionAnimationSelector.resolveOptional(env = env, key = "transition_animation_selector", data = data, reader = TRANSITION_ANIMATION_SELECTOR_READER) ?: TRANSITION_ANIMATION_SELECTOR_DEFAULT_VALUE,
            variableTriggers = variableTriggers.resolveOptionalTemplateList(env = env, key = "variable_triggers", data = data, VARIABLE_TRIGGERS_VALIDATOR, reader = VARIABLE_TRIGGERS_READER),
            variables = variables.resolveOptionalTemplateList(env = env, key = "variables", data = data, VARIABLES_VALIDATOR, reader = VARIABLES_READER)
        )
    }

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.writeField(key = "log_id", field = logId)
        json.writeField(key = "states", field = states)
        json.writeField(key = "timers", field = timers)
        json.writeFieldWithExpression(key = "transition_animation_selector", field = transitionAnimationSelector, converter = { v: DivTransitionSelector -> DivTransitionSelector.toString(v) })
        json.writeField(key = "variable_triggers", field = variableTriggers)
        json.writeField(key = "variables", field = variables)
        return json
    }

    companion object {
        private val TRANSITION_ANIMATION_SELECTOR_DEFAULT_VALUE = Expression.constant(DivTransitionSelector.NONE)

        private val TYPE_HELPER_TRANSITION_ANIMATION_SELECTOR = TypeHelper.from(default = DivTransitionSelector.values().first()) { it is DivTransitionSelector }

        private val LOG_ID_TEMPLATE_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val LOG_ID_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val STATES_VALIDATOR = ListValidator<DivData.State> { it: List<*> -> it.size >= 1 }
        private val STATES_TEMPLATE_VALIDATOR = ListValidator<DivDataTemplate.StateTemplate> { it: List<*> -> it.size >= 1 }
        private val TIMERS_VALIDATOR = ListValidator<DivTimer> { it: List<*> -> it.size >= 1 }
        private val TIMERS_TEMPLATE_VALIDATOR = ListValidator<DivTimerTemplate> { it: List<*> -> it.size >= 1 }
        private val VARIABLE_TRIGGERS_VALIDATOR = ListValidator<DivTrigger> { it: List<*> -> it.size >= 1 }
        private val VARIABLE_TRIGGERS_TEMPLATE_VALIDATOR = ListValidator<DivTriggerTemplate> { it: List<*> -> it.size >= 1 }
        private val VARIABLES_VALIDATOR = ListValidator<DivVariable> { it: List<*> -> it.size >= 1 }
        private val VARIABLES_TEMPLATE_VALIDATOR = ListValidator<DivVariableTemplate> { it: List<*> -> it.size >= 1 }

        val LOG_ID_READER: Reader<String> = { key, json, env -> JsonParser.read(json, key, LOG_ID_VALIDATOR, env.logger, env) }
        val STATES_READER: Reader<List<DivData.State>> = { key, json, env -> JsonParser.readStrictList(json, key, DivData.State.CREATOR, STATES_VALIDATOR, env.logger, env) }
        val TIMERS_READER: Reader<List<DivTimer>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivTimer.CREATOR, TIMERS_VALIDATOR, env.logger, env) }
        val TRANSITION_ANIMATION_SELECTOR_READER: Reader<Expression<DivTransitionSelector>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivTransitionSelector.Converter.FROM_STRING, env.logger, env, TRANSITION_ANIMATION_SELECTOR_DEFAULT_VALUE, TYPE_HELPER_TRANSITION_ANIMATION_SELECTOR) ?: TRANSITION_ANIMATION_SELECTOR_DEFAULT_VALUE }
        val VARIABLE_TRIGGERS_READER: Reader<List<DivTrigger>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivTrigger.CREATOR, VARIABLE_TRIGGERS_VALIDATOR, env.logger, env) }
        val VARIABLES_READER: Reader<List<DivVariable>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivVariable.CREATOR, VARIABLES_VALIDATOR, env.logger, env) }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivDataTemplate(env, json = it) }
    }


    @Mockable
    class StateTemplate : JSONSerializable, JsonTemplate<DivData.State> {
        @JvmField final val div: Field<DivTemplate>
        @JvmField final val stateId: Field<Int>

        constructor (
            env: ParsingEnvironment,
            parent: StateTemplate? = null,
            topLevel: Boolean = false,
            json: JSONObject
        ) {
            val logger = env.logger
            div = JsonTemplateParser.readField(json, "div", topLevel, parent?.div, DivTemplate.CREATOR, logger, env)
            stateId = JsonTemplateParser.readField(json, "state_id", topLevel, parent?.stateId, NUMBER_TO_INT, logger, env)
        }

        override fun resolve(env: ParsingEnvironment, data: JSONObject): DivData.State {
            return DivData.State(
                div = div.resolveTemplate(env = env, key = "div", data = data, reader = DIV_READER),
                stateId = stateId.resolve(env = env, key = "state_id", data = data, reader = STATE_ID_READER)
            )
        }

        override fun writeToJSON(): JSONObject {
            val json = JSONObject()
            json.writeField(key = "div", field = div)
            json.writeField(key = "state_id", field = stateId)
            return json
        }

        companion object {
            val DIV_READER: Reader<Div> = { key, json, env -> JsonParser.read(json, key, Div.CREATOR, env.logger, env) }
            val STATE_ID_READER: Reader<Int> = { key, json, env -> JsonParser.read(json, key, NUMBER_TO_INT, env.logger, env) }

            val CREATOR = { env: ParsingEnvironment, it: JSONObject -> StateTemplate(env, json = it) }
        }

    }
}
