// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*

@Mockable
sealed class DivSize : JSONSerializable {
    class Fixed(val value: DivFixedSize) : DivSize()
    class MatchParent(val value: DivMatchParentSize) : DivSize()
    class WrapContent(val value: DivWrapContentSize) : DivSize()

    fun value(): Any {
        return when (this) {
            is Fixed -> value
            is MatchParent -> value
            is WrapContent -> value
        }
    }

    override fun writeToJSON(): JSONObject {
        return when (this) {
            is Fixed -> value.writeToJSON()
            is MatchParent -> value.writeToJSON()
            is WrapContent -> value.writeToJSON()
        }
    }

    companion object {
        @Throws(ParsingException::class)
        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivSize {
            val logger = env.logger
            val type: String = json.read("type", logger = logger, env = env)
            when (type) {
                DivFixedSize.TYPE -> return Fixed(DivFixedSize(env, json))
                DivMatchParentSize.TYPE -> return MatchParent(DivMatchParentSize(env, json))
                DivWrapContentSize.TYPE -> return WrapContent(DivWrapContentSize(env, json))
            }
            val template = env.templates.getOrThrow(type, json) as? DivSizeTemplate
            if (template != null) {
                return template.resolve(env, json)
            } else {
                throw typeMismatch(json = json, key = "type", value = type)
            }
        }
        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivSize(env, json = it) }
    }
}
