// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*

@Mockable
class DivSlideTransition(
    @JvmField final val distance: DivDimension? = null,
    override val duration: Expression<Int> = DURATION_DEFAULT_VALUE, // constraint: number >= 0; default value: 200
    @JvmField final val edge: Expression<Edge> = EDGE_DEFAULT_VALUE, // default value: bottom
    override val interpolator: Expression<DivAnimationInterpolator> = INTERPOLATOR_DEFAULT_VALUE, // default value: ease_in_out
    override val startDelay: Expression<Int> = START_DELAY_DEFAULT_VALUE, // constraint: number >= 0; default value: 0
) : JSONSerializable, DivTransitionBase {

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.write(key = "distance", value = distance)
        json.writeExpression(key = "duration", value = duration)
        json.writeExpression(key = "edge", value = edge, converter = { v: Edge -> Edge.toString(v) })
        json.writeExpression(key = "interpolator", value = interpolator, converter = { v: DivAnimationInterpolator -> DivAnimationInterpolator.toString(v) })
        json.writeExpression(key = "start_delay", value = startDelay)
        json.write(key = "type", value = TYPE)
        return json
    }

    companion object {
        const val TYPE = "slide"

        private val DURATION_DEFAULT_VALUE = Expression.constant(200)
        private val EDGE_DEFAULT_VALUE = Expression.constant(Edge.BOTTOM)
        private val INTERPOLATOR_DEFAULT_VALUE = Expression.constant(DivAnimationInterpolator.EASE_IN_OUT)
        private val START_DELAY_DEFAULT_VALUE = Expression.constant(0)

        private val TYPE_HELPER_EDGE = TypeHelper.from(default = DivSlideTransition.Edge.values().first()) { it is DivSlideTransition.Edge }
        private val TYPE_HELPER_INTERPOLATOR = TypeHelper.from(default = DivAnimationInterpolator.values().first()) { it is DivAnimationInterpolator }

        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivSlideTransition {
            val logger = env.logger
            return DivSlideTransition(
                distance = JsonParser.readOptional(json, "distance", DivDimension.CREATOR, logger, env),
                duration = JsonParser.readOptionalExpression(json, "duration", NUMBER_TO_INT, DURATION_VALIDATOR, logger, env, DURATION_DEFAULT_VALUE, TYPE_HELPER_INT) ?: DURATION_DEFAULT_VALUE,
                edge = JsonParser.readOptionalExpression(json, "edge", Edge.Converter.FROM_STRING, logger, env, EDGE_DEFAULT_VALUE, TYPE_HELPER_EDGE) ?: EDGE_DEFAULT_VALUE,
                interpolator = JsonParser.readOptionalExpression(json, "interpolator", DivAnimationInterpolator.Converter.FROM_STRING, logger, env, INTERPOLATOR_DEFAULT_VALUE, TYPE_HELPER_INTERPOLATOR) ?: INTERPOLATOR_DEFAULT_VALUE,
                startDelay = JsonParser.readOptionalExpression(json, "start_delay", NUMBER_TO_INT, START_DELAY_VALIDATOR, logger, env, START_DELAY_DEFAULT_VALUE, TYPE_HELPER_INT) ?: START_DELAY_DEFAULT_VALUE
            )
        }

        private val DURATION_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val DURATION_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val START_DELAY_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val START_DELAY_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivSlideTransition(env, json = it) }
    }


    enum class Edge(private val value: String) {
        LEFT("left"),
        TOP("top"),
        RIGHT("right"),
        BOTTOM("bottom");

        companion object Converter {
            fun toString(obj: Edge): String {
                return obj.value
            }

            fun fromString(string: String): Edge? {
                return when (string) {
                    LEFT.value -> LEFT
                    TOP.value -> TOP
                    RIGHT.value -> RIGHT
                    BOTTOM.value -> BOTTOM
                    else -> null
                }
            }

            val FROM_STRING = { string: String ->
                when (string) {
                    LEFT.value -> LEFT
                    TOP.value -> TOP
                    RIGHT.value -> RIGHT
                    BOTTOM.value -> BOTTOM
                    else -> null
                }
            }
        }
    }
}
