// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*

@Mockable
class DivIndicatorTemplate : JSONSerializable, JsonTemplate<DivIndicator> {
    @JvmField final val accessibility: Field<DivAccessibilityTemplate>
    @JvmField final val activeItemColor: Field<Expression<Int>> // default value: #ffdc60
    @JvmField final val activeItemSize: Field<Expression<Double>> // constraint: number > 0; default value: 1.3
    @JvmField final val activeShape: Field<DivRoundedRectangleShapeTemplate>
    @JvmField final val alignmentHorizontal: Field<Expression<DivAlignmentHorizontal>>
    @JvmField final val alignmentVertical: Field<Expression<DivAlignmentVertical>>
    @JvmField final val alpha: Field<Expression<Double>> // constraint: number >= 0.0 && number <= 1.0; default value: 1.0
    @JvmField final val animation: Field<Expression<DivIndicator.Animation>> // default value: scale
    @JvmField final val background: Field<List<DivBackgroundTemplate>> // at least 1 elements
    @JvmField final val border: Field<DivBorderTemplate>
    @JvmField final val columnSpan: Field<Expression<Int>> // constraint: number >= 0
    @JvmField final val extensions: Field<List<DivExtensionTemplate>> // at least 1 elements
    @JvmField final val focus: Field<DivFocusTemplate>
    @JvmField final val height: Field<DivSizeTemplate> // default value: DivSize.WrapContent(DivWrapContentSize())
    @JvmField final val id: Field<String> // at least 1 char
    @JvmField final val inactiveItemColor: Field<Expression<Int>> // default value: #33919cb5
    @JvmField final val inactiveMinimumShape: Field<DivRoundedRectangleShapeTemplate>
    @JvmField final val inactiveShape: Field<DivRoundedRectangleShapeTemplate>
    @JvmField final val itemsPlacement: Field<DivIndicatorItemPlacementTemplate>
    @JvmField final val margins: Field<DivEdgeInsetsTemplate>
    @JvmField final val minimumItemSize: Field<Expression<Double>> // constraint: number > 0; default value: 0.5
    @JvmField final val paddings: Field<DivEdgeInsetsTemplate>
    @JvmField final val pagerId: Field<String>
    @JvmField final val rowSpan: Field<Expression<Int>> // constraint: number >= 0
    @JvmField final val selectedActions: Field<List<DivActionTemplate>> // at least 1 elements
    @JvmField final val shape: Field<DivShapeTemplate> // default value: DivShape.RoundedRectangle(DivRoundedRectangleShape())
    @JvmField final val spaceBetweenCenters: Field<DivFixedSizeTemplate> // default value: DivFixedSize(value = Expression.constant(15))
    @JvmField final val tooltips: Field<List<DivTooltipTemplate>> // at least 1 elements
    @JvmField final val transform: Field<DivTransformTemplate>
    @JvmField final val transitionChange: Field<DivChangeTransitionTemplate>
    @JvmField final val transitionIn: Field<DivAppearanceTransitionTemplate>
    @JvmField final val transitionOut: Field<DivAppearanceTransitionTemplate>
    @JvmField final val transitionTriggers: Field<List<DivTransitionTrigger>> // at least 1 elements
    @JvmField final val visibility: Field<Expression<DivVisibility>> // default value: visible
    @JvmField final val visibilityAction: Field<DivVisibilityActionTemplate>
    @JvmField final val visibilityActions: Field<List<DivVisibilityActionTemplate>> // at least 1 elements
    @JvmField final val width: Field<DivSizeTemplate> // default value: DivSize.MatchParent(DivMatchParentSize())

    constructor (
        env: ParsingEnvironment,
        parent: DivIndicatorTemplate? = null,
        topLevel: Boolean = false,
        json: JSONObject
    ) {
        val logger = env.logger
        accessibility = JsonTemplateParser.readOptionalField(json, "accessibility", topLevel, parent?.accessibility, DivAccessibilityTemplate.CREATOR, logger, env)
        activeItemColor = JsonTemplateParser.readOptionalFieldWithExpression(json, "active_item_color", topLevel, parent?.activeItemColor, STRING_TO_COLOR_INT, logger, env, TYPE_HELPER_COLOR)
        activeItemSize = JsonTemplateParser.readOptionalFieldWithExpression(json, "active_item_size", topLevel, parent?.activeItemSize, NUMBER_TO_DOUBLE, ACTIVE_ITEM_SIZE_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_DOUBLE)
        activeShape = JsonTemplateParser.readOptionalField(json, "active_shape", topLevel, parent?.activeShape, DivRoundedRectangleShapeTemplate.CREATOR, logger, env)
        alignmentHorizontal = JsonTemplateParser.readOptionalFieldWithExpression(json, "alignment_horizontal", topLevel, parent?.alignmentHorizontal, DivAlignmentHorizontal.Converter.FROM_STRING, logger, env, TYPE_HELPER_ALIGNMENT_HORIZONTAL)
        alignmentVertical = JsonTemplateParser.readOptionalFieldWithExpression(json, "alignment_vertical", topLevel, parent?.alignmentVertical, DivAlignmentVertical.Converter.FROM_STRING, logger, env, TYPE_HELPER_ALIGNMENT_VERTICAL)
        alpha = JsonTemplateParser.readOptionalFieldWithExpression(json, "alpha", topLevel, parent?.alpha, NUMBER_TO_DOUBLE, ALPHA_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_DOUBLE)
        animation = JsonTemplateParser.readOptionalFieldWithExpression(json, "animation", topLevel, parent?.animation, DivIndicator.Animation.Converter.FROM_STRING, logger, env, TYPE_HELPER_ANIMATION)
        background = JsonTemplateParser.readOptionalListField(json, "background", topLevel, parent?.background, DivBackgroundTemplate.CREATOR, BACKGROUND_TEMPLATE_VALIDATOR, logger, env)
        border = JsonTemplateParser.readOptionalField(json, "border", topLevel, parent?.border, DivBorderTemplate.CREATOR, logger, env)
        columnSpan = JsonTemplateParser.readOptionalFieldWithExpression(json, "column_span", topLevel, parent?.columnSpan, NUMBER_TO_INT, COLUMN_SPAN_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
        extensions = JsonTemplateParser.readOptionalListField(json, "extensions", topLevel, parent?.extensions, DivExtensionTemplate.CREATOR, EXTENSIONS_TEMPLATE_VALIDATOR, logger, env)
        focus = JsonTemplateParser.readOptionalField(json, "focus", topLevel, parent?.focus, DivFocusTemplate.CREATOR, logger, env)
        height = JsonTemplateParser.readOptionalField(json, "height", topLevel, parent?.height, DivSizeTemplate.CREATOR, logger, env)
        id = JsonTemplateParser.readOptionalField(json, "id", topLevel, parent?.id, ID_TEMPLATE_VALIDATOR, logger, env)
        inactiveItemColor = JsonTemplateParser.readOptionalFieldWithExpression(json, "inactive_item_color", topLevel, parent?.inactiveItemColor, STRING_TO_COLOR_INT, logger, env, TYPE_HELPER_COLOR)
        inactiveMinimumShape = JsonTemplateParser.readOptionalField(json, "inactive_minimum_shape", topLevel, parent?.inactiveMinimumShape, DivRoundedRectangleShapeTemplate.CREATOR, logger, env)
        inactiveShape = JsonTemplateParser.readOptionalField(json, "inactive_shape", topLevel, parent?.inactiveShape, DivRoundedRectangleShapeTemplate.CREATOR, logger, env)
        itemsPlacement = JsonTemplateParser.readOptionalField(json, "items_placement", topLevel, parent?.itemsPlacement, DivIndicatorItemPlacementTemplate.CREATOR, logger, env)
        margins = JsonTemplateParser.readOptionalField(json, "margins", topLevel, parent?.margins, DivEdgeInsetsTemplate.CREATOR, logger, env)
        minimumItemSize = JsonTemplateParser.readOptionalFieldWithExpression(json, "minimum_item_size", topLevel, parent?.minimumItemSize, NUMBER_TO_DOUBLE, MINIMUM_ITEM_SIZE_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_DOUBLE)
        paddings = JsonTemplateParser.readOptionalField(json, "paddings", topLevel, parent?.paddings, DivEdgeInsetsTemplate.CREATOR, logger, env)
        pagerId = JsonTemplateParser.readOptionalField(json, "pager_id", topLevel, parent?.pagerId, PAGER_ID_TEMPLATE_VALIDATOR, logger, env)
        rowSpan = JsonTemplateParser.readOptionalFieldWithExpression(json, "row_span", topLevel, parent?.rowSpan, NUMBER_TO_INT, ROW_SPAN_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
        selectedActions = JsonTemplateParser.readOptionalListField(json, "selected_actions", topLevel, parent?.selectedActions, DivActionTemplate.CREATOR, SELECTED_ACTIONS_TEMPLATE_VALIDATOR, logger, env)
        shape = JsonTemplateParser.readOptionalField(json, "shape", topLevel, parent?.shape, DivShapeTemplate.CREATOR, logger, env)
        spaceBetweenCenters = JsonTemplateParser.readOptionalField(json, "space_between_centers", topLevel, parent?.spaceBetweenCenters, DivFixedSizeTemplate.CREATOR, logger, env)
        tooltips = JsonTemplateParser.readOptionalListField(json, "tooltips", topLevel, parent?.tooltips, DivTooltipTemplate.CREATOR, TOOLTIPS_TEMPLATE_VALIDATOR, logger, env)
        transform = JsonTemplateParser.readOptionalField(json, "transform", topLevel, parent?.transform, DivTransformTemplate.CREATOR, logger, env)
        transitionChange = JsonTemplateParser.readOptionalField(json, "transition_change", topLevel, parent?.transitionChange, DivChangeTransitionTemplate.CREATOR, logger, env)
        transitionIn = JsonTemplateParser.readOptionalField(json, "transition_in", topLevel, parent?.transitionIn, DivAppearanceTransitionTemplate.CREATOR, logger, env)
        transitionOut = JsonTemplateParser.readOptionalField(json, "transition_out", topLevel, parent?.transitionOut, DivAppearanceTransitionTemplate.CREATOR, logger, env)
        transitionTriggers = JsonTemplateParser.readOptionalListField(json, "transition_triggers", topLevel, parent?.transitionTriggers, DivTransitionTrigger.Converter.FROM_STRING, TRANSITION_TRIGGERS_TEMPLATE_VALIDATOR, logger, env)
        visibility = JsonTemplateParser.readOptionalFieldWithExpression(json, "visibility", topLevel, parent?.visibility, DivVisibility.Converter.FROM_STRING, logger, env, TYPE_HELPER_VISIBILITY)
        visibilityAction = JsonTemplateParser.readOptionalField(json, "visibility_action", topLevel, parent?.visibilityAction, DivVisibilityActionTemplate.CREATOR, logger, env)
        visibilityActions = JsonTemplateParser.readOptionalListField(json, "visibility_actions", topLevel, parent?.visibilityActions, DivVisibilityActionTemplate.CREATOR, VISIBILITY_ACTIONS_TEMPLATE_VALIDATOR, logger, env)
        width = JsonTemplateParser.readOptionalField(json, "width", topLevel, parent?.width, DivSizeTemplate.CREATOR, logger, env)
    }

    override fun resolve(env: ParsingEnvironment, data: JSONObject): DivIndicator {
        return DivIndicator(
            accessibility = accessibility.resolveOptionalTemplate(env = env, key = "accessibility", data = data, reader = ACCESSIBILITY_READER) ?: ACCESSIBILITY_DEFAULT_VALUE,
            activeItemColor = activeItemColor.resolveOptional(env = env, key = "active_item_color", data = data, reader = ACTIVE_ITEM_COLOR_READER) ?: ACTIVE_ITEM_COLOR_DEFAULT_VALUE,
            activeItemSize = activeItemSize.resolveOptional(env = env, key = "active_item_size", data = data, reader = ACTIVE_ITEM_SIZE_READER) ?: ACTIVE_ITEM_SIZE_DEFAULT_VALUE,
            activeShape = activeShape.resolveOptionalTemplate(env = env, key = "active_shape", data = data, reader = ACTIVE_SHAPE_READER),
            alignmentHorizontal = alignmentHorizontal.resolveOptional(env = env, key = "alignment_horizontal", data = data, reader = ALIGNMENT_HORIZONTAL_READER),
            alignmentVertical = alignmentVertical.resolveOptional(env = env, key = "alignment_vertical", data = data, reader = ALIGNMENT_VERTICAL_READER),
            alpha = alpha.resolveOptional(env = env, key = "alpha", data = data, reader = ALPHA_READER) ?: ALPHA_DEFAULT_VALUE,
            animation = animation.resolveOptional(env = env, key = "animation", data = data, reader = ANIMATION_READER) ?: ANIMATION_DEFAULT_VALUE,
            background = background.resolveOptionalTemplateList(env = env, key = "background", data = data, BACKGROUND_VALIDATOR, reader = BACKGROUND_READER),
            border = border.resolveOptionalTemplate(env = env, key = "border", data = data, reader = BORDER_READER) ?: BORDER_DEFAULT_VALUE,
            columnSpan = columnSpan.resolveOptional(env = env, key = "column_span", data = data, reader = COLUMN_SPAN_READER),
            extensions = extensions.resolveOptionalTemplateList(env = env, key = "extensions", data = data, EXTENSIONS_VALIDATOR, reader = EXTENSIONS_READER),
            focus = focus.resolveOptionalTemplate(env = env, key = "focus", data = data, reader = FOCUS_READER),
            height = height.resolveOptionalTemplate(env = env, key = "height", data = data, reader = HEIGHT_READER) ?: HEIGHT_DEFAULT_VALUE,
            id = id.resolveOptional(env = env, key = "id", data = data, reader = ID_READER),
            inactiveItemColor = inactiveItemColor.resolveOptional(env = env, key = "inactive_item_color", data = data, reader = INACTIVE_ITEM_COLOR_READER) ?: INACTIVE_ITEM_COLOR_DEFAULT_VALUE,
            inactiveMinimumShape = inactiveMinimumShape.resolveOptionalTemplate(env = env, key = "inactive_minimum_shape", data = data, reader = INACTIVE_MINIMUM_SHAPE_READER),
            inactiveShape = inactiveShape.resolveOptionalTemplate(env = env, key = "inactive_shape", data = data, reader = INACTIVE_SHAPE_READER),
            itemsPlacement = itemsPlacement.resolveOptionalTemplate(env = env, key = "items_placement", data = data, reader = ITEMS_PLACEMENT_READER),
            margins = margins.resolveOptionalTemplate(env = env, key = "margins", data = data, reader = MARGINS_READER) ?: MARGINS_DEFAULT_VALUE,
            minimumItemSize = minimumItemSize.resolveOptional(env = env, key = "minimum_item_size", data = data, reader = MINIMUM_ITEM_SIZE_READER) ?: MINIMUM_ITEM_SIZE_DEFAULT_VALUE,
            paddings = paddings.resolveOptionalTemplate(env = env, key = "paddings", data = data, reader = PADDINGS_READER) ?: PADDINGS_DEFAULT_VALUE,
            pagerId = pagerId.resolveOptional(env = env, key = "pager_id", data = data, reader = PAGER_ID_READER),
            rowSpan = rowSpan.resolveOptional(env = env, key = "row_span", data = data, reader = ROW_SPAN_READER),
            selectedActions = selectedActions.resolveOptionalTemplateList(env = env, key = "selected_actions", data = data, SELECTED_ACTIONS_VALIDATOR, reader = SELECTED_ACTIONS_READER),
            shape = shape.resolveOptionalTemplate(env = env, key = "shape", data = data, reader = SHAPE_READER) ?: SHAPE_DEFAULT_VALUE,
            spaceBetweenCenters = spaceBetweenCenters.resolveOptionalTemplate(env = env, key = "space_between_centers", data = data, reader = SPACE_BETWEEN_CENTERS_READER) ?: SPACE_BETWEEN_CENTERS_DEFAULT_VALUE,
            tooltips = tooltips.resolveOptionalTemplateList(env = env, key = "tooltips", data = data, TOOLTIPS_VALIDATOR, reader = TOOLTIPS_READER),
            transform = transform.resolveOptionalTemplate(env = env, key = "transform", data = data, reader = TRANSFORM_READER) ?: TRANSFORM_DEFAULT_VALUE,
            transitionChange = transitionChange.resolveOptionalTemplate(env = env, key = "transition_change", data = data, reader = TRANSITION_CHANGE_READER),
            transitionIn = transitionIn.resolveOptionalTemplate(env = env, key = "transition_in", data = data, reader = TRANSITION_IN_READER),
            transitionOut = transitionOut.resolveOptionalTemplate(env = env, key = "transition_out", data = data, reader = TRANSITION_OUT_READER),
            transitionTriggers = transitionTriggers.resolveOptionalList(env = env, key = "transition_triggers", data = data, TRANSITION_TRIGGERS_VALIDATOR, reader = TRANSITION_TRIGGERS_READER),
            visibility = visibility.resolveOptional(env = env, key = "visibility", data = data, reader = VISIBILITY_READER) ?: VISIBILITY_DEFAULT_VALUE,
            visibilityAction = visibilityAction.resolveOptionalTemplate(env = env, key = "visibility_action", data = data, reader = VISIBILITY_ACTION_READER),
            visibilityActions = visibilityActions.resolveOptionalTemplateList(env = env, key = "visibility_actions", data = data, VISIBILITY_ACTIONS_VALIDATOR, reader = VISIBILITY_ACTIONS_READER),
            width = width.resolveOptionalTemplate(env = env, key = "width", data = data, reader = WIDTH_READER) ?: WIDTH_DEFAULT_VALUE
        )
    }

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.writeField(key = "accessibility", field = accessibility)
        json.writeFieldWithExpression(key = "active_item_color", field = activeItemColor, converter = COLOR_INT_TO_STRING)
        json.writeFieldWithExpression(key = "active_item_size", field = activeItemSize)
        json.writeField(key = "active_shape", field = activeShape)
        json.writeFieldWithExpression(key = "alignment_horizontal", field = alignmentHorizontal, converter = { v: DivAlignmentHorizontal -> DivAlignmentHorizontal.toString(v) })
        json.writeFieldWithExpression(key = "alignment_vertical", field = alignmentVertical, converter = { v: DivAlignmentVertical -> DivAlignmentVertical.toString(v) })
        json.writeFieldWithExpression(key = "alpha", field = alpha)
        json.writeFieldWithExpression(key = "animation", field = animation, converter = { v: DivIndicator.Animation -> DivIndicator.Animation.toString(v) })
        json.writeField(key = "background", field = background)
        json.writeField(key = "border", field = border)
        json.writeFieldWithExpression(key = "column_span", field = columnSpan)
        json.writeField(key = "extensions", field = extensions)
        json.writeField(key = "focus", field = focus)
        json.writeField(key = "height", field = height)
        json.writeField(key = "id", field = id)
        json.writeFieldWithExpression(key = "inactive_item_color", field = inactiveItemColor, converter = COLOR_INT_TO_STRING)
        json.writeField(key = "inactive_minimum_shape", field = inactiveMinimumShape)
        json.writeField(key = "inactive_shape", field = inactiveShape)
        json.writeField(key = "items_placement", field = itemsPlacement)
        json.writeField(key = "margins", field = margins)
        json.writeFieldWithExpression(key = "minimum_item_size", field = minimumItemSize)
        json.writeField(key = "paddings", field = paddings)
        json.writeField(key = "pager_id", field = pagerId)
        json.writeFieldWithExpression(key = "row_span", field = rowSpan)
        json.writeField(key = "selected_actions", field = selectedActions)
        json.writeField(key = "shape", field = shape)
        json.writeField(key = "space_between_centers", field = spaceBetweenCenters)
        json.writeField(key = "tooltips", field = tooltips)
        json.writeField(key = "transform", field = transform)
        json.writeField(key = "transition_change", field = transitionChange)
        json.writeField(key = "transition_in", field = transitionIn)
        json.writeField(key = "transition_out", field = transitionOut)
        json.writeField(key = "transition_triggers", field = transitionTriggers, converter = { v: DivTransitionTrigger -> DivTransitionTrigger.toString(v) })
        json.write(key = "type", value = TYPE)
        json.writeFieldWithExpression(key = "visibility", field = visibility, converter = { v: DivVisibility -> DivVisibility.toString(v) })
        json.writeField(key = "visibility_action", field = visibilityAction)
        json.writeField(key = "visibility_actions", field = visibilityActions)
        json.writeField(key = "width", field = width)
        return json
    }

    companion object {
        const val TYPE = "indicator"

        private val ACCESSIBILITY_DEFAULT_VALUE = DivAccessibility()
        private val ACTIVE_ITEM_COLOR_DEFAULT_VALUE = Expression.constant(0xffdc60.toInt())
        private val ACTIVE_ITEM_SIZE_DEFAULT_VALUE = Expression.constant(1.3)
        private val ALPHA_DEFAULT_VALUE = Expression.constant(1.0)
        private val ANIMATION_DEFAULT_VALUE = Expression.constant(DivIndicator.Animation.SCALE)
        private val BORDER_DEFAULT_VALUE = DivBorder()
        private val HEIGHT_DEFAULT_VALUE = DivSize.WrapContent(DivWrapContentSize())
        private val INACTIVE_ITEM_COLOR_DEFAULT_VALUE = Expression.constant(0x33919cb5.toInt())
        private val MARGINS_DEFAULT_VALUE = DivEdgeInsets()
        private val MINIMUM_ITEM_SIZE_DEFAULT_VALUE = Expression.constant(0.5)
        private val PADDINGS_DEFAULT_VALUE = DivEdgeInsets()
        private val SHAPE_DEFAULT_VALUE = DivShape.RoundedRectangle(DivRoundedRectangleShape())
        private val SPACE_BETWEEN_CENTERS_DEFAULT_VALUE = DivFixedSize(value = Expression.constant(15))
        private val TRANSFORM_DEFAULT_VALUE = DivTransform()
        private val VISIBILITY_DEFAULT_VALUE = Expression.constant(DivVisibility.VISIBLE)
        private val WIDTH_DEFAULT_VALUE = DivSize.MatchParent(DivMatchParentSize())

        private val TYPE_HELPER_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.values().first()) { it is DivAlignmentHorizontal }
        private val TYPE_HELPER_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.values().first()) { it is DivAlignmentVertical }
        private val TYPE_HELPER_ANIMATION = TypeHelper.from(default = DivIndicator.Animation.values().first()) { it is DivIndicator.Animation }
        private val TYPE_HELPER_VISIBILITY = TypeHelper.from(default = DivVisibility.values().first()) { it is DivVisibility }

        private val ACTIVE_ITEM_SIZE_TEMPLATE_VALIDATOR = ValueValidator<Double> { it: Double -> it > 0 }
        private val ACTIVE_ITEM_SIZE_VALIDATOR = ValueValidator<Double> { it: Double -> it > 0 }
        private val ALPHA_TEMPLATE_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val ALPHA_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val BACKGROUND_VALIDATOR = ListValidator<DivBackground> { it: List<*> -> it.size >= 1 }
        private val BACKGROUND_TEMPLATE_VALIDATOR = ListValidator<DivBackgroundTemplate> { it: List<*> -> it.size >= 1 }
        private val COLUMN_SPAN_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val COLUMN_SPAN_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val EXTENSIONS_VALIDATOR = ListValidator<DivExtension> { it: List<*> -> it.size >= 1 }
        private val EXTENSIONS_TEMPLATE_VALIDATOR = ListValidator<DivExtensionTemplate> { it: List<*> -> it.size >= 1 }
        private val ID_TEMPLATE_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val ID_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val MINIMUM_ITEM_SIZE_TEMPLATE_VALIDATOR = ValueValidator<Double> { it: Double -> it > 0 }
        private val MINIMUM_ITEM_SIZE_VALIDATOR = ValueValidator<Double> { it: Double -> it > 0 }
        private val PAGER_ID_TEMPLATE_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val PAGER_ID_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val ROW_SPAN_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val ROW_SPAN_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val SELECTED_ACTIONS_VALIDATOR = ListValidator<DivAction> { it: List<*> -> it.size >= 1 }
        private val SELECTED_ACTIONS_TEMPLATE_VALIDATOR = ListValidator<DivActionTemplate> { it: List<*> -> it.size >= 1 }
        private val TOOLTIPS_VALIDATOR = ListValidator<DivTooltip> { it: List<*> -> it.size >= 1 }
        private val TOOLTIPS_TEMPLATE_VALIDATOR = ListValidator<DivTooltipTemplate> { it: List<*> -> it.size >= 1 }
        private val TRANSITION_TRIGGERS_VALIDATOR = ListValidator<DivTransitionTrigger> { it: List<*> -> it.size >= 1 }
        private val TRANSITION_TRIGGERS_TEMPLATE_VALIDATOR = ListValidator<DivTransitionTrigger> { it: List<*> -> it.size >= 1 }
        private val VISIBILITY_ACTIONS_VALIDATOR = ListValidator<DivVisibilityAction> { it: List<*> -> it.size >= 1 }
        private val VISIBILITY_ACTIONS_TEMPLATE_VALIDATOR = ListValidator<DivVisibilityActionTemplate> { it: List<*> -> it.size >= 1 }

        val ACCESSIBILITY_READER: Reader<DivAccessibility> = { key, json, env -> JsonParser.readOptional(json, key, DivAccessibility.CREATOR, env.logger, env) ?: ACCESSIBILITY_DEFAULT_VALUE }
        val ACTIVE_ITEM_COLOR_READER: Reader<Expression<Int>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, STRING_TO_COLOR_INT, env.logger, env, ACTIVE_ITEM_COLOR_DEFAULT_VALUE, TYPE_HELPER_COLOR) ?: ACTIVE_ITEM_COLOR_DEFAULT_VALUE }
        val ACTIVE_ITEM_SIZE_READER: Reader<Expression<Double>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_DOUBLE, ACTIVE_ITEM_SIZE_VALIDATOR, env.logger, env, ACTIVE_ITEM_SIZE_DEFAULT_VALUE, TYPE_HELPER_DOUBLE) ?: ACTIVE_ITEM_SIZE_DEFAULT_VALUE }
        val ACTIVE_SHAPE_READER: Reader<DivRoundedRectangleShape?> = { key, json, env -> JsonParser.readOptional(json, key, DivRoundedRectangleShape.CREATOR, env.logger, env) }
        val ALIGNMENT_HORIZONTAL_READER: Reader<Expression<DivAlignmentHorizontal>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivAlignmentHorizontal.Converter.FROM_STRING, env.logger, env, TYPE_HELPER_ALIGNMENT_HORIZONTAL) }
        val ALIGNMENT_VERTICAL_READER: Reader<Expression<DivAlignmentVertical>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivAlignmentVertical.Converter.FROM_STRING, env.logger, env, TYPE_HELPER_ALIGNMENT_VERTICAL) }
        val ALPHA_READER: Reader<Expression<Double>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, env.logger, env, ALPHA_DEFAULT_VALUE, TYPE_HELPER_DOUBLE) ?: ALPHA_DEFAULT_VALUE }
        val ANIMATION_READER: Reader<Expression<DivIndicator.Animation>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivIndicator.Animation.Converter.FROM_STRING, env.logger, env, ANIMATION_DEFAULT_VALUE, TYPE_HELPER_ANIMATION) ?: ANIMATION_DEFAULT_VALUE }
        val BACKGROUND_READER: Reader<List<DivBackground>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivBackground.CREATOR, BACKGROUND_VALIDATOR, env.logger, env) }
        val BORDER_READER: Reader<DivBorder> = { key, json, env -> JsonParser.readOptional(json, key, DivBorder.CREATOR, env.logger, env) ?: BORDER_DEFAULT_VALUE }
        val COLUMN_SPAN_READER: Reader<Expression<Int>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR, env.logger, env, TYPE_HELPER_INT) }
        val EXTENSIONS_READER: Reader<List<DivExtension>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivExtension.CREATOR, EXTENSIONS_VALIDATOR, env.logger, env) }
        val FOCUS_READER: Reader<DivFocus?> = { key, json, env -> JsonParser.readOptional(json, key, DivFocus.CREATOR, env.logger, env) }
        val HEIGHT_READER: Reader<DivSize> = { key, json, env -> JsonParser.readOptional(json, key, DivSize.CREATOR, env.logger, env) ?: HEIGHT_DEFAULT_VALUE }
        val ID_READER: Reader<String?> = { key, json, env -> JsonParser.readOptional(json, key, ID_VALIDATOR, env.logger, env) }
        val INACTIVE_ITEM_COLOR_READER: Reader<Expression<Int>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, STRING_TO_COLOR_INT, env.logger, env, INACTIVE_ITEM_COLOR_DEFAULT_VALUE, TYPE_HELPER_COLOR) ?: INACTIVE_ITEM_COLOR_DEFAULT_VALUE }
        val INACTIVE_MINIMUM_SHAPE_READER: Reader<DivRoundedRectangleShape?> = { key, json, env -> JsonParser.readOptional(json, key, DivRoundedRectangleShape.CREATOR, env.logger, env) }
        val INACTIVE_SHAPE_READER: Reader<DivRoundedRectangleShape?> = { key, json, env -> JsonParser.readOptional(json, key, DivRoundedRectangleShape.CREATOR, env.logger, env) }
        val ITEMS_PLACEMENT_READER: Reader<DivIndicatorItemPlacement?> = { key, json, env -> JsonParser.readOptional(json, key, DivIndicatorItemPlacement.CREATOR, env.logger, env) }
        val MARGINS_READER: Reader<DivEdgeInsets> = { key, json, env -> JsonParser.readOptional(json, key, DivEdgeInsets.CREATOR, env.logger, env) ?: MARGINS_DEFAULT_VALUE }
        val MINIMUM_ITEM_SIZE_READER: Reader<Expression<Double>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_DOUBLE, MINIMUM_ITEM_SIZE_VALIDATOR, env.logger, env, MINIMUM_ITEM_SIZE_DEFAULT_VALUE, TYPE_HELPER_DOUBLE) ?: MINIMUM_ITEM_SIZE_DEFAULT_VALUE }
        val PADDINGS_READER: Reader<DivEdgeInsets> = { key, json, env -> JsonParser.readOptional(json, key, DivEdgeInsets.CREATOR, env.logger, env) ?: PADDINGS_DEFAULT_VALUE }
        val PAGER_ID_READER: Reader<String?> = { key, json, env -> JsonParser.readOptional(json, key, PAGER_ID_VALIDATOR, env.logger, env) }
        val ROW_SPAN_READER: Reader<Expression<Int>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, ROW_SPAN_VALIDATOR, env.logger, env, TYPE_HELPER_INT) }
        val SELECTED_ACTIONS_READER: Reader<List<DivAction>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivAction.CREATOR, SELECTED_ACTIONS_VALIDATOR, env.logger, env) }
        val SHAPE_READER: Reader<DivShape> = { key, json, env -> JsonParser.readOptional(json, key, DivShape.CREATOR, env.logger, env) ?: SHAPE_DEFAULT_VALUE }
        val SPACE_BETWEEN_CENTERS_READER: Reader<DivFixedSize> = { key, json, env -> JsonParser.readOptional(json, key, DivFixedSize.CREATOR, env.logger, env) ?: SPACE_BETWEEN_CENTERS_DEFAULT_VALUE }
        val TOOLTIPS_READER: Reader<List<DivTooltip>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivTooltip.CREATOR, TOOLTIPS_VALIDATOR, env.logger, env) }
        val TRANSFORM_READER: Reader<DivTransform> = { key, json, env -> JsonParser.readOptional(json, key, DivTransform.CREATOR, env.logger, env) ?: TRANSFORM_DEFAULT_VALUE }
        val TRANSITION_CHANGE_READER: Reader<DivChangeTransition?> = { key, json, env -> JsonParser.readOptional(json, key, DivChangeTransition.CREATOR, env.logger, env) }
        val TRANSITION_IN_READER: Reader<DivAppearanceTransition?> = { key, json, env -> JsonParser.readOptional(json, key, DivAppearanceTransition.CREATOR, env.logger, env) }
        val TRANSITION_OUT_READER: Reader<DivAppearanceTransition?> = { key, json, env -> JsonParser.readOptional(json, key, DivAppearanceTransition.CREATOR, env.logger, env) }
        val TRANSITION_TRIGGERS_READER: Reader<List<DivTransitionTrigger>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivTransitionTrigger.Converter.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR, env.logger, env) }
        val TYPE_READER: Reader<String> = { key, json, env -> JsonParser.read(json, key, env.logger, env) }
        val VISIBILITY_READER: Reader<Expression<DivVisibility>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivVisibility.Converter.FROM_STRING, env.logger, env, VISIBILITY_DEFAULT_VALUE, TYPE_HELPER_VISIBILITY) ?: VISIBILITY_DEFAULT_VALUE }
        val VISIBILITY_ACTION_READER: Reader<DivVisibilityAction?> = { key, json, env -> JsonParser.readOptional(json, key, DivVisibilityAction.CREATOR, env.logger, env) }
        val VISIBILITY_ACTIONS_READER: Reader<List<DivVisibilityAction>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivVisibilityAction.CREATOR, VISIBILITY_ACTIONS_VALIDATOR, env.logger, env) }
        val WIDTH_READER: Reader<DivSize> = { key, json, env -> JsonParser.readOptional(json, key, DivSize.CREATOR, env.logger, env) ?: WIDTH_DEFAULT_VALUE }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivIndicatorTemplate(env, json = it) }
    }

}
