// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*

@Mockable
class DivPatch(
    @JvmField final val changes: List<Change>, // at least 1 elements
    @JvmField final val mode: Expression<Mode> = MODE_DEFAULT_VALUE, // default value: partial
) : JSONSerializable {

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.write(key = "changes", value = changes)
        json.writeExpression(key = "mode", value = mode, converter = { v: Mode -> Mode.toString(v) })
        return json
    }

    fun copyWithNewArray(
        changes: List<DivPatch.Change>,
    ) = DivPatch(
        changes,
        mode,
    )

    companion object {
        private val MODE_DEFAULT_VALUE = Expression.constant(Mode.PARTIAL)

        private val TYPE_HELPER_MODE = TypeHelper.from(default = DivPatch.Mode.values().first()) { it is DivPatch.Mode }

        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivPatch {
            val logger = env.logger
            return DivPatch(
                changes = JsonParser.readList(json, "changes", Change.CREATOR, CHANGES_VALIDATOR, logger, env),
                mode = JsonParser.readOptionalExpression(json, "mode", Mode.Converter.FROM_STRING, logger, env, MODE_DEFAULT_VALUE, TYPE_HELPER_MODE) ?: MODE_DEFAULT_VALUE
            )
        }

        private val CHANGES_VALIDATOR = ListValidator<DivPatch.Change> { it: List<*> -> it.size >= 1 }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivPatch(env, json = it) }
    }


    enum class Mode(private val value: String) {
        TRANSACTIONAL("transactional"),
        PARTIAL("partial");

        companion object Converter {
            fun toString(obj: Mode): String {
                return obj.value
            }

            fun fromString(string: String): Mode? {
                return when (string) {
                    TRANSACTIONAL.value -> TRANSACTIONAL
                    PARTIAL.value -> PARTIAL
                    else -> null
                }
            }

            val FROM_STRING = { string: String ->
                when (string) {
                    TRANSACTIONAL.value -> TRANSACTIONAL
                    PARTIAL.value -> PARTIAL
                    else -> null
                }
            }
        }
    }

    @Mockable
    class Change(
        @JvmField final val id: String,
        @JvmField final val items: List<Div>? = null, // at least 1 elements
    ) : JSONSerializable {

        override fun writeToJSON(): JSONObject {
            val json = JSONObject()
            json.write(key = "id", value = id)
            json.write(key = "items", value = items)
            return json
        }

        companion object {
            @JvmStatic
            @JvmName("fromJson")
            operator fun invoke(env: ParsingEnvironment, json: JSONObject): Change {
                val logger = env.logger
                return Change(
                    id = JsonParser.read(json, "id", logger, env),
                    items = JsonParser.readOptionalList(json, "items", Div.CREATOR, ITEMS_VALIDATOR, logger, env)
                )
            }

            private val ITEMS_VALIDATOR = ListValidator<Div> { it: List<*> -> it.size >= 1 }

            val CREATOR = { env: ParsingEnvironment, it: JSONObject -> Change(env, json = it) }
        }

    }
}
