// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*

@Mockable
class DivSeparator(
    override val accessibility: DivAccessibility = ACCESSIBILITY_DEFAULT_VALUE,
    @JvmField final val action: DivAction? = null,
    @JvmField final val actionAnimation: DivAnimation = ACTION_ANIMATION_DEFAULT_VALUE, // default value: DivAnimation(duration = Expression.constant(100), endValue = Expression.constant(0.6), name = Expression.constant(DivAnimation.Name.FADE), startValue = Expression.constant(1.0))
    @JvmField final val actions: List<DivAction>? = null, // at least 1 elements
    override val alignmentHorizontal: Expression<DivAlignmentHorizontal>? = null,
    override val alignmentVertical: Expression<DivAlignmentVertical>? = null,
    override val alpha: Expression<Double> = ALPHA_DEFAULT_VALUE, // constraint: number >= 0.0 && number <= 1.0; default value: 1.0
    override val background: List<DivBackground>? = null, // at least 1 elements
    override val border: DivBorder = BORDER_DEFAULT_VALUE,
    override val columnSpan: Expression<Int>? = null, // constraint: number >= 0
    @JvmField final val delimiterStyle: DelimiterStyle = DELIMITER_STYLE_DEFAULT_VALUE,
    @JvmField final val doubletapActions: List<DivAction>? = null, // at least 1 elements
    override val extensions: List<DivExtension>? = null, // at least 1 elements
    override val focus: DivFocus? = null,
    override val height: DivSize = HEIGHT_DEFAULT_VALUE, // default value: DivSize.WrapContent(DivWrapContentSize())
    override val id: String? = null, // at least 1 char
    @JvmField final val longtapActions: List<DivAction>? = null, // at least 1 elements
    override val margins: DivEdgeInsets = MARGINS_DEFAULT_VALUE,
    override val paddings: DivEdgeInsets = PADDINGS_DEFAULT_VALUE,
    override val rowSpan: Expression<Int>? = null, // constraint: number >= 0
    override val selectedActions: List<DivAction>? = null, // at least 1 elements
    override val tooltips: List<DivTooltip>? = null, // at least 1 elements
    override val transform: DivTransform = TRANSFORM_DEFAULT_VALUE,
    override val transitionChange: DivChangeTransition? = null,
    override val transitionIn: DivAppearanceTransition? = null,
    override val transitionOut: DivAppearanceTransition? = null,
    override val transitionTriggers: List<DivTransitionTrigger>? = null, // at least 1 elements
    override val visibility: Expression<DivVisibility> = VISIBILITY_DEFAULT_VALUE, // default value: visible
    override val visibilityAction: DivVisibilityAction? = null,
    override val visibilityActions: List<DivVisibilityAction>? = null, // at least 1 elements
    override val width: DivSize = WIDTH_DEFAULT_VALUE, // default value: DivSize.MatchParent(DivMatchParentSize())
) : JSONSerializable, DivBase {

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.write(key = "accessibility", value = accessibility)
        json.write(key = "action", value = action)
        json.write(key = "action_animation", value = actionAnimation)
        json.write(key = "actions", value = actions)
        json.writeExpression(key = "alignment_horizontal", value = alignmentHorizontal, converter = { v: DivAlignmentHorizontal -> DivAlignmentHorizontal.toString(v) })
        json.writeExpression(key = "alignment_vertical", value = alignmentVertical, converter = { v: DivAlignmentVertical -> DivAlignmentVertical.toString(v) })
        json.writeExpression(key = "alpha", value = alpha)
        json.write(key = "background", value = background)
        json.write(key = "border", value = border)
        json.writeExpression(key = "column_span", value = columnSpan)
        json.write(key = "delimiter_style", value = delimiterStyle)
        json.write(key = "doubletap_actions", value = doubletapActions)
        json.write(key = "extensions", value = extensions)
        json.write(key = "focus", value = focus)
        json.write(key = "height", value = height)
        json.write(key = "id", value = id)
        json.write(key = "longtap_actions", value = longtapActions)
        json.write(key = "margins", value = margins)
        json.write(key = "paddings", value = paddings)
        json.writeExpression(key = "row_span", value = rowSpan)
        json.write(key = "selected_actions", value = selectedActions)
        json.write(key = "tooltips", value = tooltips)
        json.write(key = "transform", value = transform)
        json.write(key = "transition_change", value = transitionChange)
        json.write(key = "transition_in", value = transitionIn)
        json.write(key = "transition_out", value = transitionOut)
        json.write(key = "transition_triggers", value = transitionTriggers, converter = { v: DivTransitionTrigger -> DivTransitionTrigger.toString(v) })
        json.write(key = "type", value = TYPE)
        json.writeExpression(key = "visibility", value = visibility, converter = { v: DivVisibility -> DivVisibility.toString(v) })
        json.write(key = "visibility_action", value = visibilityAction)
        json.write(key = "visibility_actions", value = visibilityActions)
        json.write(key = "width", value = width)
        return json
    }

    companion object {
        const val TYPE = "separator"

        private val ACCESSIBILITY_DEFAULT_VALUE = DivAccessibility()
        private val ACTION_ANIMATION_DEFAULT_VALUE = DivAnimation(duration = Expression.constant(100), endValue = Expression.constant(0.6), name = Expression.constant(DivAnimation.Name.FADE), startValue = Expression.constant(1.0))
        private val ALPHA_DEFAULT_VALUE = Expression.constant(1.0)
        private val BORDER_DEFAULT_VALUE = DivBorder()
        private val DELIMITER_STYLE_DEFAULT_VALUE = DivSeparator.DelimiterStyle()
        private val HEIGHT_DEFAULT_VALUE = DivSize.WrapContent(DivWrapContentSize())
        private val MARGINS_DEFAULT_VALUE = DivEdgeInsets()
        private val PADDINGS_DEFAULT_VALUE = DivEdgeInsets()
        private val TRANSFORM_DEFAULT_VALUE = DivTransform()
        private val VISIBILITY_DEFAULT_VALUE = Expression.constant(DivVisibility.VISIBLE)
        private val WIDTH_DEFAULT_VALUE = DivSize.MatchParent(DivMatchParentSize())

        private val TYPE_HELPER_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.values().first()) { it is DivAlignmentHorizontal }
        private val TYPE_HELPER_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.values().first()) { it is DivAlignmentVertical }
        private val TYPE_HELPER_VISIBILITY = TypeHelper.from(default = DivVisibility.values().first()) { it is DivVisibility }

        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivSeparator {
            val logger = env.logger
            return DivSeparator(
                accessibility = JsonParser.readOptional(json, "accessibility", DivAccessibility.CREATOR, logger, env) ?: ACCESSIBILITY_DEFAULT_VALUE,
                action = JsonParser.readOptional(json, "action", DivAction.CREATOR, logger, env),
                actionAnimation = JsonParser.readOptional(json, "action_animation", DivAnimation.CREATOR, logger, env) ?: ACTION_ANIMATION_DEFAULT_VALUE,
                actions = JsonParser.readOptionalList(json, "actions", DivAction.CREATOR, ACTIONS_VALIDATOR, logger, env),
                alignmentHorizontal = JsonParser.readOptionalExpression(json, "alignment_horizontal", DivAlignmentHorizontal.Converter.FROM_STRING, logger, env, TYPE_HELPER_ALIGNMENT_HORIZONTAL),
                alignmentVertical = JsonParser.readOptionalExpression(json, "alignment_vertical", DivAlignmentVertical.Converter.FROM_STRING, logger, env, TYPE_HELPER_ALIGNMENT_VERTICAL),
                alpha = JsonParser.readOptionalExpression(json, "alpha", NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, logger, env, ALPHA_DEFAULT_VALUE, TYPE_HELPER_DOUBLE) ?: ALPHA_DEFAULT_VALUE,
                background = JsonParser.readOptionalList(json, "background", DivBackground.CREATOR, BACKGROUND_VALIDATOR, logger, env),
                border = JsonParser.readOptional(json, "border", DivBorder.CREATOR, logger, env) ?: BORDER_DEFAULT_VALUE,
                columnSpan = JsonParser.readOptionalExpression(json, "column_span", NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR, logger, env, TYPE_HELPER_INT),
                delimiterStyle = JsonParser.readOptional(json, "delimiter_style", DelimiterStyle.CREATOR, logger, env) ?: DELIMITER_STYLE_DEFAULT_VALUE,
                doubletapActions = JsonParser.readOptionalList(json, "doubletap_actions", DivAction.CREATOR, DOUBLETAP_ACTIONS_VALIDATOR, logger, env),
                extensions = JsonParser.readOptionalList(json, "extensions", DivExtension.CREATOR, EXTENSIONS_VALIDATOR, logger, env),
                focus = JsonParser.readOptional(json, "focus", DivFocus.CREATOR, logger, env),
                height = JsonParser.readOptional(json, "height", DivSize.CREATOR, logger, env) ?: HEIGHT_DEFAULT_VALUE,
                id = JsonParser.readOptional(json, "id", ID_VALIDATOR, logger, env),
                longtapActions = JsonParser.readOptionalList(json, "longtap_actions", DivAction.CREATOR, LONGTAP_ACTIONS_VALIDATOR, logger, env),
                margins = JsonParser.readOptional(json, "margins", DivEdgeInsets.CREATOR, logger, env) ?: MARGINS_DEFAULT_VALUE,
                paddings = JsonParser.readOptional(json, "paddings", DivEdgeInsets.CREATOR, logger, env) ?: PADDINGS_DEFAULT_VALUE,
                rowSpan = JsonParser.readOptionalExpression(json, "row_span", NUMBER_TO_INT, ROW_SPAN_VALIDATOR, logger, env, TYPE_HELPER_INT),
                selectedActions = JsonParser.readOptionalList(json, "selected_actions", DivAction.CREATOR, SELECTED_ACTIONS_VALIDATOR, logger, env),
                tooltips = JsonParser.readOptionalList(json, "tooltips", DivTooltip.CREATOR, TOOLTIPS_VALIDATOR, logger, env),
                transform = JsonParser.readOptional(json, "transform", DivTransform.CREATOR, logger, env) ?: TRANSFORM_DEFAULT_VALUE,
                transitionChange = JsonParser.readOptional(json, "transition_change", DivChangeTransition.CREATOR, logger, env),
                transitionIn = JsonParser.readOptional(json, "transition_in", DivAppearanceTransition.CREATOR, logger, env),
                transitionOut = JsonParser.readOptional(json, "transition_out", DivAppearanceTransition.CREATOR, logger, env),
                transitionTriggers = JsonParser.readOptionalList(json, "transition_triggers", DivTransitionTrigger.Converter.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR, logger, env),
                visibility = JsonParser.readOptionalExpression(json, "visibility", DivVisibility.Converter.FROM_STRING, logger, env, VISIBILITY_DEFAULT_VALUE, TYPE_HELPER_VISIBILITY) ?: VISIBILITY_DEFAULT_VALUE,
                visibilityAction = JsonParser.readOptional(json, "visibility_action", DivVisibilityAction.CREATOR, logger, env),
                visibilityActions = JsonParser.readOptionalList(json, "visibility_actions", DivVisibilityAction.CREATOR, VISIBILITY_ACTIONS_VALIDATOR, logger, env),
                width = JsonParser.readOptional(json, "width", DivSize.CREATOR, logger, env) ?: WIDTH_DEFAULT_VALUE
            )
        }

        private val ACTIONS_VALIDATOR = ListValidator<DivAction> { it: List<*> -> it.size >= 1 }
        private val ALPHA_TEMPLATE_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val ALPHA_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val BACKGROUND_VALIDATOR = ListValidator<DivBackground> { it: List<*> -> it.size >= 1 }
        private val COLUMN_SPAN_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val COLUMN_SPAN_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val DOUBLETAP_ACTIONS_VALIDATOR = ListValidator<DivAction> { it: List<*> -> it.size >= 1 }
        private val EXTENSIONS_VALIDATOR = ListValidator<DivExtension> { it: List<*> -> it.size >= 1 }
        private val ID_TEMPLATE_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val ID_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val LONGTAP_ACTIONS_VALIDATOR = ListValidator<DivAction> { it: List<*> -> it.size >= 1 }
        private val ROW_SPAN_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val ROW_SPAN_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val SELECTED_ACTIONS_VALIDATOR = ListValidator<DivAction> { it: List<*> -> it.size >= 1 }
        private val TOOLTIPS_VALIDATOR = ListValidator<DivTooltip> { it: List<*> -> it.size >= 1 }
        private val TRANSITION_TRIGGERS_VALIDATOR = ListValidator<DivTransitionTrigger> { it: List<*> -> it.size >= 1 }
        private val VISIBILITY_ACTIONS_VALIDATOR = ListValidator<DivVisibilityAction> { it: List<*> -> it.size >= 1 }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivSeparator(env, json = it) }
    }


    @Mockable
    class DelimiterStyle(
        @JvmField final val color: Expression<Int> = COLOR_DEFAULT_VALUE, // default value: #14000000
        @JvmField final val orientation: Expression<Orientation> = ORIENTATION_DEFAULT_VALUE, // default value: horizontal
    ) : JSONSerializable {

        override fun writeToJSON(): JSONObject {
            val json = JSONObject()
            json.writeExpression(key = "color", value = color, converter = COLOR_INT_TO_STRING)
            json.writeExpression(key = "orientation", value = orientation, converter = { v: Orientation -> Orientation.toString(v) })
            return json
        }

        companion object {
            private val COLOR_DEFAULT_VALUE = Expression.constant(0x14000000.toInt())
            private val ORIENTATION_DEFAULT_VALUE = Expression.constant(Orientation.HORIZONTAL)

            private val TYPE_HELPER_ORIENTATION = TypeHelper.from(default = DivSeparator.DelimiterStyle.Orientation.values().first()) { it is DivSeparator.DelimiterStyle.Orientation }

            @JvmStatic
            @JvmName("fromJson")
            operator fun invoke(env: ParsingEnvironment, json: JSONObject): DelimiterStyle {
                val logger = env.logger
                return DelimiterStyle(
                    color = JsonParser.readOptionalExpression(json, "color", STRING_TO_COLOR_INT, logger, env, COLOR_DEFAULT_VALUE, TYPE_HELPER_COLOR) ?: COLOR_DEFAULT_VALUE,
                    orientation = JsonParser.readOptionalExpression(json, "orientation", Orientation.Converter.FROM_STRING, logger, env, ORIENTATION_DEFAULT_VALUE, TYPE_HELPER_ORIENTATION) ?: ORIENTATION_DEFAULT_VALUE
                )
            }

            val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DelimiterStyle(env, json = it) }
        }


        enum class Orientation(private val value: String) {
            VERTICAL("vertical"),
            HORIZONTAL("horizontal");

            companion object Converter {
                fun toString(obj: Orientation): String {
                    return obj.value
                }

                fun fromString(string: String): Orientation? {
                    return when (string) {
                        VERTICAL.value -> VERTICAL
                        HORIZONTAL.value -> HORIZONTAL
                        else -> null
                    }
                }

                val FROM_STRING = { string: String ->
                    when (string) {
                        VERTICAL.value -> VERTICAL
                        HORIZONTAL.value -> HORIZONTAL
                        else -> null
                    }
                }
            }
        }
    }
}
