// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*

@Mockable
class DivTabsTemplate : JSONSerializable, JsonTemplate<DivTabs> {
    @JvmField final val accessibility: Field<DivAccessibilityTemplate>
    @JvmField final val alignmentHorizontal: Field<Expression<DivAlignmentHorizontal>>
    @JvmField final val alignmentVertical: Field<Expression<DivAlignmentVertical>>
    @JvmField final val alpha: Field<Expression<Double>> // constraint: number >= 0.0 && number <= 1.0; default value: 1.0
    @JvmField final val background: Field<List<DivBackgroundTemplate>> // at least 1 elements
    @JvmField final val border: Field<DivBorderTemplate>
    @JvmField final val columnSpan: Field<Expression<Int>> // constraint: number >= 0
    @JvmField final val dynamicHeight: Field<Expression<Boolean>> // default value: false
    @JvmField final val extensions: Field<List<DivExtensionTemplate>> // at least 1 elements
    @JvmField final val focus: Field<DivFocusTemplate>
    @JvmField final val hasSeparator: Field<Expression<Boolean>> // default value: false
    @JvmField final val height: Field<DivSizeTemplate> // default value: DivSize.WrapContent(DivWrapContentSize())
    @JvmField final val id: Field<String> // at least 1 char
    @JvmField final val items: Field<List<ItemTemplate>> // at least 1 elements
    @JvmField final val margins: Field<DivEdgeInsetsTemplate>
    @JvmField final val paddings: Field<DivEdgeInsetsTemplate>
    @JvmField final val restrictParentScroll: Field<Expression<Boolean>> // default value: false
    @JvmField final val rowSpan: Field<Expression<Int>> // constraint: number >= 0
    @JvmField final val selectedActions: Field<List<DivActionTemplate>> // at least 1 elements
    @JvmField final val selectedTab: Field<Expression<Int>> // constraint: number >= 0; default value: 0
    @JvmField final val separatorColor: Field<Expression<Int>> // default value: #14000000
    @JvmField final val separatorPaddings: Field<DivEdgeInsetsTemplate> // default value: DivEdgeInsets(bottom = Expression.constant(0), left = Expression.constant(12), right = Expression.constant(12), top = Expression.constant(0))
    @JvmField final val switchTabsByContentSwipeEnabled: Field<Expression<Boolean>> // default value: true
    @JvmField final val tabTitleStyle: Field<TabTitleStyleTemplate>
    @JvmField final val titlePaddings: Field<DivEdgeInsetsTemplate> // default value: DivEdgeInsets(bottom = Expression.constant(8), left = Expression.constant(12), right = Expression.constant(12), top = Expression.constant(0))
    @JvmField final val tooltips: Field<List<DivTooltipTemplate>> // at least 1 elements
    @JvmField final val transform: Field<DivTransformTemplate>
    @JvmField final val transitionChange: Field<DivChangeTransitionTemplate>
    @JvmField final val transitionIn: Field<DivAppearanceTransitionTemplate>
    @JvmField final val transitionOut: Field<DivAppearanceTransitionTemplate>
    @JvmField final val transitionTriggers: Field<List<DivTransitionTrigger>> // at least 1 elements
    @JvmField final val visibility: Field<Expression<DivVisibility>> // default value: visible
    @JvmField final val visibilityAction: Field<DivVisibilityActionTemplate>
    @JvmField final val visibilityActions: Field<List<DivVisibilityActionTemplate>> // at least 1 elements
    @JvmField final val width: Field<DivSizeTemplate> // default value: DivSize.MatchParent(DivMatchParentSize())

    constructor (
        env: ParsingEnvironment,
        parent: DivTabsTemplate? = null,
        topLevel: Boolean = false,
        json: JSONObject
    ) {
        val logger = env.logger
        accessibility = JsonTemplateParser.readOptionalField(json, "accessibility", topLevel, parent?.accessibility, DivAccessibilityTemplate.CREATOR, logger, env)
        alignmentHorizontal = JsonTemplateParser.readOptionalFieldWithExpression(json, "alignment_horizontal", topLevel, parent?.alignmentHorizontal, DivAlignmentHorizontal.Converter.FROM_STRING, logger, env, TYPE_HELPER_ALIGNMENT_HORIZONTAL)
        alignmentVertical = JsonTemplateParser.readOptionalFieldWithExpression(json, "alignment_vertical", topLevel, parent?.alignmentVertical, DivAlignmentVertical.Converter.FROM_STRING, logger, env, TYPE_HELPER_ALIGNMENT_VERTICAL)
        alpha = JsonTemplateParser.readOptionalFieldWithExpression(json, "alpha", topLevel, parent?.alpha, NUMBER_TO_DOUBLE, ALPHA_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_DOUBLE)
        background = JsonTemplateParser.readOptionalListField(json, "background", topLevel, parent?.background, DivBackgroundTemplate.CREATOR, BACKGROUND_TEMPLATE_VALIDATOR, logger, env)
        border = JsonTemplateParser.readOptionalField(json, "border", topLevel, parent?.border, DivBorderTemplate.CREATOR, logger, env)
        columnSpan = JsonTemplateParser.readOptionalFieldWithExpression(json, "column_span", topLevel, parent?.columnSpan, NUMBER_TO_INT, COLUMN_SPAN_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
        dynamicHeight = JsonTemplateParser.readOptionalFieldWithExpression(json, "dynamic_height", topLevel, parent?.dynamicHeight, ANY_TO_BOOLEAN, logger, env, TYPE_HELPER_BOOLEAN)
        extensions = JsonTemplateParser.readOptionalListField(json, "extensions", topLevel, parent?.extensions, DivExtensionTemplate.CREATOR, EXTENSIONS_TEMPLATE_VALIDATOR, logger, env)
        focus = JsonTemplateParser.readOptionalField(json, "focus", topLevel, parent?.focus, DivFocusTemplate.CREATOR, logger, env)
        hasSeparator = JsonTemplateParser.readOptionalFieldWithExpression(json, "has_separator", topLevel, parent?.hasSeparator, ANY_TO_BOOLEAN, logger, env, TYPE_HELPER_BOOLEAN)
        height = JsonTemplateParser.readOptionalField(json, "height", topLevel, parent?.height, DivSizeTemplate.CREATOR, logger, env)
        id = JsonTemplateParser.readOptionalField(json, "id", topLevel, parent?.id, ID_TEMPLATE_VALIDATOR, logger, env)
        items = JsonTemplateParser.readListField(json, "items", topLevel, parent?.items, ItemTemplate.CREATOR, ITEMS_TEMPLATE_VALIDATOR, logger, env)
        margins = JsonTemplateParser.readOptionalField(json, "margins", topLevel, parent?.margins, DivEdgeInsetsTemplate.CREATOR, logger, env)
        paddings = JsonTemplateParser.readOptionalField(json, "paddings", topLevel, parent?.paddings, DivEdgeInsetsTemplate.CREATOR, logger, env)
        restrictParentScroll = JsonTemplateParser.readOptionalFieldWithExpression(json, "restrict_parent_scroll", topLevel, parent?.restrictParentScroll, ANY_TO_BOOLEAN, logger, env, TYPE_HELPER_BOOLEAN)
        rowSpan = JsonTemplateParser.readOptionalFieldWithExpression(json, "row_span", topLevel, parent?.rowSpan, NUMBER_TO_INT, ROW_SPAN_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
        selectedActions = JsonTemplateParser.readOptionalListField(json, "selected_actions", topLevel, parent?.selectedActions, DivActionTemplate.CREATOR, SELECTED_ACTIONS_TEMPLATE_VALIDATOR, logger, env)
        selectedTab = JsonTemplateParser.readOptionalFieldWithExpression(json, "selected_tab", topLevel, parent?.selectedTab, NUMBER_TO_INT, SELECTED_TAB_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
        separatorColor = JsonTemplateParser.readOptionalFieldWithExpression(json, "separator_color", topLevel, parent?.separatorColor, STRING_TO_COLOR_INT, logger, env, TYPE_HELPER_COLOR)
        separatorPaddings = JsonTemplateParser.readOptionalField(json, "separator_paddings", topLevel, parent?.separatorPaddings, DivEdgeInsetsTemplate.CREATOR, logger, env)
        switchTabsByContentSwipeEnabled = JsonTemplateParser.readOptionalFieldWithExpression(json, "switch_tabs_by_content_swipe_enabled", topLevel, parent?.switchTabsByContentSwipeEnabled, ANY_TO_BOOLEAN, logger, env, TYPE_HELPER_BOOLEAN)
        tabTitleStyle = JsonTemplateParser.readOptionalField(json, "tab_title_style", topLevel, parent?.tabTitleStyle, TabTitleStyleTemplate.CREATOR, logger, env)
        titlePaddings = JsonTemplateParser.readOptionalField(json, "title_paddings", topLevel, parent?.titlePaddings, DivEdgeInsetsTemplate.CREATOR, logger, env)
        tooltips = JsonTemplateParser.readOptionalListField(json, "tooltips", topLevel, parent?.tooltips, DivTooltipTemplate.CREATOR, TOOLTIPS_TEMPLATE_VALIDATOR, logger, env)
        transform = JsonTemplateParser.readOptionalField(json, "transform", topLevel, parent?.transform, DivTransformTemplate.CREATOR, logger, env)
        transitionChange = JsonTemplateParser.readOptionalField(json, "transition_change", topLevel, parent?.transitionChange, DivChangeTransitionTemplate.CREATOR, logger, env)
        transitionIn = JsonTemplateParser.readOptionalField(json, "transition_in", topLevel, parent?.transitionIn, DivAppearanceTransitionTemplate.CREATOR, logger, env)
        transitionOut = JsonTemplateParser.readOptionalField(json, "transition_out", topLevel, parent?.transitionOut, DivAppearanceTransitionTemplate.CREATOR, logger, env)
        transitionTriggers = JsonTemplateParser.readOptionalListField(json, "transition_triggers", topLevel, parent?.transitionTriggers, DivTransitionTrigger.Converter.FROM_STRING, TRANSITION_TRIGGERS_TEMPLATE_VALIDATOR, logger, env)
        visibility = JsonTemplateParser.readOptionalFieldWithExpression(json, "visibility", topLevel, parent?.visibility, DivVisibility.Converter.FROM_STRING, logger, env, TYPE_HELPER_VISIBILITY)
        visibilityAction = JsonTemplateParser.readOptionalField(json, "visibility_action", topLevel, parent?.visibilityAction, DivVisibilityActionTemplate.CREATOR, logger, env)
        visibilityActions = JsonTemplateParser.readOptionalListField(json, "visibility_actions", topLevel, parent?.visibilityActions, DivVisibilityActionTemplate.CREATOR, VISIBILITY_ACTIONS_TEMPLATE_VALIDATOR, logger, env)
        width = JsonTemplateParser.readOptionalField(json, "width", topLevel, parent?.width, DivSizeTemplate.CREATOR, logger, env)
    }

    override fun resolve(env: ParsingEnvironment, data: JSONObject): DivTabs {
        return DivTabs(
            accessibility = accessibility.resolveOptionalTemplate(env = env, key = "accessibility", data = data, reader = ACCESSIBILITY_READER) ?: ACCESSIBILITY_DEFAULT_VALUE,
            alignmentHorizontal = alignmentHorizontal.resolveOptional(env = env, key = "alignment_horizontal", data = data, reader = ALIGNMENT_HORIZONTAL_READER),
            alignmentVertical = alignmentVertical.resolveOptional(env = env, key = "alignment_vertical", data = data, reader = ALIGNMENT_VERTICAL_READER),
            alpha = alpha.resolveOptional(env = env, key = "alpha", data = data, reader = ALPHA_READER) ?: ALPHA_DEFAULT_VALUE,
            background = background.resolveOptionalTemplateList(env = env, key = "background", data = data, BACKGROUND_VALIDATOR, reader = BACKGROUND_READER),
            border = border.resolveOptionalTemplate(env = env, key = "border", data = data, reader = BORDER_READER) ?: BORDER_DEFAULT_VALUE,
            columnSpan = columnSpan.resolveOptional(env = env, key = "column_span", data = data, reader = COLUMN_SPAN_READER),
            dynamicHeight = dynamicHeight.resolveOptional(env = env, key = "dynamic_height", data = data, reader = DYNAMIC_HEIGHT_READER) ?: DYNAMIC_HEIGHT_DEFAULT_VALUE,
            extensions = extensions.resolveOptionalTemplateList(env = env, key = "extensions", data = data, EXTENSIONS_VALIDATOR, reader = EXTENSIONS_READER),
            focus = focus.resolveOptionalTemplate(env = env, key = "focus", data = data, reader = FOCUS_READER),
            hasSeparator = hasSeparator.resolveOptional(env = env, key = "has_separator", data = data, reader = HAS_SEPARATOR_READER) ?: HAS_SEPARATOR_DEFAULT_VALUE,
            height = height.resolveOptionalTemplate(env = env, key = "height", data = data, reader = HEIGHT_READER) ?: HEIGHT_DEFAULT_VALUE,
            id = id.resolveOptional(env = env, key = "id", data = data, reader = ID_READER),
            items = items.resolveTemplateList(env = env, key = "items", data = data, ITEMS_VALIDATOR, reader = ITEMS_READER),
            margins = margins.resolveOptionalTemplate(env = env, key = "margins", data = data, reader = MARGINS_READER) ?: MARGINS_DEFAULT_VALUE,
            paddings = paddings.resolveOptionalTemplate(env = env, key = "paddings", data = data, reader = PADDINGS_READER) ?: PADDINGS_DEFAULT_VALUE,
            restrictParentScroll = restrictParentScroll.resolveOptional(env = env, key = "restrict_parent_scroll", data = data, reader = RESTRICT_PARENT_SCROLL_READER) ?: RESTRICT_PARENT_SCROLL_DEFAULT_VALUE,
            rowSpan = rowSpan.resolveOptional(env = env, key = "row_span", data = data, reader = ROW_SPAN_READER),
            selectedActions = selectedActions.resolveOptionalTemplateList(env = env, key = "selected_actions", data = data, SELECTED_ACTIONS_VALIDATOR, reader = SELECTED_ACTIONS_READER),
            selectedTab = selectedTab.resolveOptional(env = env, key = "selected_tab", data = data, reader = SELECTED_TAB_READER) ?: SELECTED_TAB_DEFAULT_VALUE,
            separatorColor = separatorColor.resolveOptional(env = env, key = "separator_color", data = data, reader = SEPARATOR_COLOR_READER) ?: SEPARATOR_COLOR_DEFAULT_VALUE,
            separatorPaddings = separatorPaddings.resolveOptionalTemplate(env = env, key = "separator_paddings", data = data, reader = SEPARATOR_PADDINGS_READER) ?: SEPARATOR_PADDINGS_DEFAULT_VALUE,
            switchTabsByContentSwipeEnabled = switchTabsByContentSwipeEnabled.resolveOptional(env = env, key = "switch_tabs_by_content_swipe_enabled", data = data, reader = SWITCH_TABS_BY_CONTENT_SWIPE_ENABLED_READER) ?: SWITCH_TABS_BY_CONTENT_SWIPE_ENABLED_DEFAULT_VALUE,
            tabTitleStyle = tabTitleStyle.resolveOptionalTemplate(env = env, key = "tab_title_style", data = data, reader = TAB_TITLE_STYLE_READER) ?: TAB_TITLE_STYLE_DEFAULT_VALUE,
            titlePaddings = titlePaddings.resolveOptionalTemplate(env = env, key = "title_paddings", data = data, reader = TITLE_PADDINGS_READER) ?: TITLE_PADDINGS_DEFAULT_VALUE,
            tooltips = tooltips.resolveOptionalTemplateList(env = env, key = "tooltips", data = data, TOOLTIPS_VALIDATOR, reader = TOOLTIPS_READER),
            transform = transform.resolveOptionalTemplate(env = env, key = "transform", data = data, reader = TRANSFORM_READER) ?: TRANSFORM_DEFAULT_VALUE,
            transitionChange = transitionChange.resolveOptionalTemplate(env = env, key = "transition_change", data = data, reader = TRANSITION_CHANGE_READER),
            transitionIn = transitionIn.resolveOptionalTemplate(env = env, key = "transition_in", data = data, reader = TRANSITION_IN_READER),
            transitionOut = transitionOut.resolveOptionalTemplate(env = env, key = "transition_out", data = data, reader = TRANSITION_OUT_READER),
            transitionTriggers = transitionTriggers.resolveOptionalList(env = env, key = "transition_triggers", data = data, TRANSITION_TRIGGERS_VALIDATOR, reader = TRANSITION_TRIGGERS_READER),
            visibility = visibility.resolveOptional(env = env, key = "visibility", data = data, reader = VISIBILITY_READER) ?: VISIBILITY_DEFAULT_VALUE,
            visibilityAction = visibilityAction.resolveOptionalTemplate(env = env, key = "visibility_action", data = data, reader = VISIBILITY_ACTION_READER),
            visibilityActions = visibilityActions.resolveOptionalTemplateList(env = env, key = "visibility_actions", data = data, VISIBILITY_ACTIONS_VALIDATOR, reader = VISIBILITY_ACTIONS_READER),
            width = width.resolveOptionalTemplate(env = env, key = "width", data = data, reader = WIDTH_READER) ?: WIDTH_DEFAULT_VALUE
        )
    }

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.writeField(key = "accessibility", field = accessibility)
        json.writeFieldWithExpression(key = "alignment_horizontal", field = alignmentHorizontal, converter = { v: DivAlignmentHorizontal -> DivAlignmentHorizontal.toString(v) })
        json.writeFieldWithExpression(key = "alignment_vertical", field = alignmentVertical, converter = { v: DivAlignmentVertical -> DivAlignmentVertical.toString(v) })
        json.writeFieldWithExpression(key = "alpha", field = alpha)
        json.writeField(key = "background", field = background)
        json.writeField(key = "border", field = border)
        json.writeFieldWithExpression(key = "column_span", field = columnSpan)
        json.writeFieldWithExpression(key = "dynamic_height", field = dynamicHeight)
        json.writeField(key = "extensions", field = extensions)
        json.writeField(key = "focus", field = focus)
        json.writeFieldWithExpression(key = "has_separator", field = hasSeparator)
        json.writeField(key = "height", field = height)
        json.writeField(key = "id", field = id)
        json.writeField(key = "items", field = items)
        json.writeField(key = "margins", field = margins)
        json.writeField(key = "paddings", field = paddings)
        json.writeFieldWithExpression(key = "restrict_parent_scroll", field = restrictParentScroll)
        json.writeFieldWithExpression(key = "row_span", field = rowSpan)
        json.writeField(key = "selected_actions", field = selectedActions)
        json.writeFieldWithExpression(key = "selected_tab", field = selectedTab)
        json.writeFieldWithExpression(key = "separator_color", field = separatorColor, converter = COLOR_INT_TO_STRING)
        json.writeField(key = "separator_paddings", field = separatorPaddings)
        json.writeFieldWithExpression(key = "switch_tabs_by_content_swipe_enabled", field = switchTabsByContentSwipeEnabled)
        json.writeField(key = "tab_title_style", field = tabTitleStyle)
        json.writeField(key = "title_paddings", field = titlePaddings)
        json.writeField(key = "tooltips", field = tooltips)
        json.writeField(key = "transform", field = transform)
        json.writeField(key = "transition_change", field = transitionChange)
        json.writeField(key = "transition_in", field = transitionIn)
        json.writeField(key = "transition_out", field = transitionOut)
        json.writeField(key = "transition_triggers", field = transitionTriggers, converter = { v: DivTransitionTrigger -> DivTransitionTrigger.toString(v) })
        json.write(key = "type", value = TYPE)
        json.writeFieldWithExpression(key = "visibility", field = visibility, converter = { v: DivVisibility -> DivVisibility.toString(v) })
        json.writeField(key = "visibility_action", field = visibilityAction)
        json.writeField(key = "visibility_actions", field = visibilityActions)
        json.writeField(key = "width", field = width)
        return json
    }

    companion object {
        const val TYPE = "tabs"

        private val ACCESSIBILITY_DEFAULT_VALUE = DivAccessibility()
        private val ALPHA_DEFAULT_VALUE = Expression.constant(1.0)
        private val BORDER_DEFAULT_VALUE = DivBorder()
        private val DYNAMIC_HEIGHT_DEFAULT_VALUE = Expression.constant(false)
        private val HAS_SEPARATOR_DEFAULT_VALUE = Expression.constant(false)
        private val HEIGHT_DEFAULT_VALUE = DivSize.WrapContent(DivWrapContentSize())
        private val MARGINS_DEFAULT_VALUE = DivEdgeInsets()
        private val PADDINGS_DEFAULT_VALUE = DivEdgeInsets()
        private val RESTRICT_PARENT_SCROLL_DEFAULT_VALUE = Expression.constant(false)
        private val SELECTED_TAB_DEFAULT_VALUE = Expression.constant(0)
        private val SEPARATOR_COLOR_DEFAULT_VALUE = Expression.constant(0x14000000.toInt())
        private val SEPARATOR_PADDINGS_DEFAULT_VALUE = DivEdgeInsets(bottom = Expression.constant(0), left = Expression.constant(12), right = Expression.constant(12), top = Expression.constant(0))
        private val SWITCH_TABS_BY_CONTENT_SWIPE_ENABLED_DEFAULT_VALUE = Expression.constant(true)
        private val TAB_TITLE_STYLE_DEFAULT_VALUE = DivTabs.TabTitleStyle()
        private val TITLE_PADDINGS_DEFAULT_VALUE = DivEdgeInsets(bottom = Expression.constant(8), left = Expression.constant(12), right = Expression.constant(12), top = Expression.constant(0))
        private val TRANSFORM_DEFAULT_VALUE = DivTransform()
        private val VISIBILITY_DEFAULT_VALUE = Expression.constant(DivVisibility.VISIBLE)
        private val WIDTH_DEFAULT_VALUE = DivSize.MatchParent(DivMatchParentSize())

        private val TYPE_HELPER_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.values().first()) { it is DivAlignmentHorizontal }
        private val TYPE_HELPER_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.values().first()) { it is DivAlignmentVertical }
        private val TYPE_HELPER_VISIBILITY = TypeHelper.from(default = DivVisibility.values().first()) { it is DivVisibility }

        private val ALPHA_TEMPLATE_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val ALPHA_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val BACKGROUND_VALIDATOR = ListValidator<DivBackground> { it: List<*> -> it.size >= 1 }
        private val BACKGROUND_TEMPLATE_VALIDATOR = ListValidator<DivBackgroundTemplate> { it: List<*> -> it.size >= 1 }
        private val COLUMN_SPAN_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val COLUMN_SPAN_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val EXTENSIONS_VALIDATOR = ListValidator<DivExtension> { it: List<*> -> it.size >= 1 }
        private val EXTENSIONS_TEMPLATE_VALIDATOR = ListValidator<DivExtensionTemplate> { it: List<*> -> it.size >= 1 }
        private val ID_TEMPLATE_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val ID_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
        private val ITEMS_VALIDATOR = ListValidator<DivTabs.Item> { it: List<*> -> it.size >= 1 }
        private val ITEMS_TEMPLATE_VALIDATOR = ListValidator<DivTabsTemplate.ItemTemplate> { it: List<*> -> it.size >= 1 }
        private val ROW_SPAN_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val ROW_SPAN_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val SELECTED_ACTIONS_VALIDATOR = ListValidator<DivAction> { it: List<*> -> it.size >= 1 }
        private val SELECTED_ACTIONS_TEMPLATE_VALIDATOR = ListValidator<DivActionTemplate> { it: List<*> -> it.size >= 1 }
        private val SELECTED_TAB_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val SELECTED_TAB_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
        private val TOOLTIPS_VALIDATOR = ListValidator<DivTooltip> { it: List<*> -> it.size >= 1 }
        private val TOOLTIPS_TEMPLATE_VALIDATOR = ListValidator<DivTooltipTemplate> { it: List<*> -> it.size >= 1 }
        private val TRANSITION_TRIGGERS_VALIDATOR = ListValidator<DivTransitionTrigger> { it: List<*> -> it.size >= 1 }
        private val TRANSITION_TRIGGERS_TEMPLATE_VALIDATOR = ListValidator<DivTransitionTrigger> { it: List<*> -> it.size >= 1 }
        private val VISIBILITY_ACTIONS_VALIDATOR = ListValidator<DivVisibilityAction> { it: List<*> -> it.size >= 1 }
        private val VISIBILITY_ACTIONS_TEMPLATE_VALIDATOR = ListValidator<DivVisibilityActionTemplate> { it: List<*> -> it.size >= 1 }

        val ACCESSIBILITY_READER: Reader<DivAccessibility> = { key, json, env -> JsonParser.readOptional(json, key, DivAccessibility.CREATOR, env.logger, env) ?: ACCESSIBILITY_DEFAULT_VALUE }
        val ALIGNMENT_HORIZONTAL_READER: Reader<Expression<DivAlignmentHorizontal>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivAlignmentHorizontal.Converter.FROM_STRING, env.logger, env, TYPE_HELPER_ALIGNMENT_HORIZONTAL) }
        val ALIGNMENT_VERTICAL_READER: Reader<Expression<DivAlignmentVertical>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivAlignmentVertical.Converter.FROM_STRING, env.logger, env, TYPE_HELPER_ALIGNMENT_VERTICAL) }
        val ALPHA_READER: Reader<Expression<Double>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, env.logger, env, ALPHA_DEFAULT_VALUE, TYPE_HELPER_DOUBLE) ?: ALPHA_DEFAULT_VALUE }
        val BACKGROUND_READER: Reader<List<DivBackground>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivBackground.CREATOR, BACKGROUND_VALIDATOR, env.logger, env) }
        val BORDER_READER: Reader<DivBorder> = { key, json, env -> JsonParser.readOptional(json, key, DivBorder.CREATOR, env.logger, env) ?: BORDER_DEFAULT_VALUE }
        val COLUMN_SPAN_READER: Reader<Expression<Int>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR, env.logger, env, TYPE_HELPER_INT) }
        val DYNAMIC_HEIGHT_READER: Reader<Expression<Boolean>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, ANY_TO_BOOLEAN, env.logger, env, DYNAMIC_HEIGHT_DEFAULT_VALUE, TYPE_HELPER_BOOLEAN) ?: DYNAMIC_HEIGHT_DEFAULT_VALUE }
        val EXTENSIONS_READER: Reader<List<DivExtension>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivExtension.CREATOR, EXTENSIONS_VALIDATOR, env.logger, env) }
        val FOCUS_READER: Reader<DivFocus?> = { key, json, env -> JsonParser.readOptional(json, key, DivFocus.CREATOR, env.logger, env) }
        val HAS_SEPARATOR_READER: Reader<Expression<Boolean>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, ANY_TO_BOOLEAN, env.logger, env, HAS_SEPARATOR_DEFAULT_VALUE, TYPE_HELPER_BOOLEAN) ?: HAS_SEPARATOR_DEFAULT_VALUE }
        val HEIGHT_READER: Reader<DivSize> = { key, json, env -> JsonParser.readOptional(json, key, DivSize.CREATOR, env.logger, env) ?: HEIGHT_DEFAULT_VALUE }
        val ID_READER: Reader<String?> = { key, json, env -> JsonParser.readOptional(json, key, ID_VALIDATOR, env.logger, env) }
        val ITEMS_READER: Reader<List<DivTabs.Item>> = { key, json, env -> JsonParser.readList(json, key, DivTabs.Item.CREATOR, ITEMS_VALIDATOR, env.logger, env) }
        val MARGINS_READER: Reader<DivEdgeInsets> = { key, json, env -> JsonParser.readOptional(json, key, DivEdgeInsets.CREATOR, env.logger, env) ?: MARGINS_DEFAULT_VALUE }
        val PADDINGS_READER: Reader<DivEdgeInsets> = { key, json, env -> JsonParser.readOptional(json, key, DivEdgeInsets.CREATOR, env.logger, env) ?: PADDINGS_DEFAULT_VALUE }
        val RESTRICT_PARENT_SCROLL_READER: Reader<Expression<Boolean>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, ANY_TO_BOOLEAN, env.logger, env, RESTRICT_PARENT_SCROLL_DEFAULT_VALUE, TYPE_HELPER_BOOLEAN) ?: RESTRICT_PARENT_SCROLL_DEFAULT_VALUE }
        val ROW_SPAN_READER: Reader<Expression<Int>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, ROW_SPAN_VALIDATOR, env.logger, env, TYPE_HELPER_INT) }
        val SELECTED_ACTIONS_READER: Reader<List<DivAction>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivAction.CREATOR, SELECTED_ACTIONS_VALIDATOR, env.logger, env) }
        val SELECTED_TAB_READER: Reader<Expression<Int>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, SELECTED_TAB_VALIDATOR, env.logger, env, SELECTED_TAB_DEFAULT_VALUE, TYPE_HELPER_INT) ?: SELECTED_TAB_DEFAULT_VALUE }
        val SEPARATOR_COLOR_READER: Reader<Expression<Int>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, STRING_TO_COLOR_INT, env.logger, env, SEPARATOR_COLOR_DEFAULT_VALUE, TYPE_HELPER_COLOR) ?: SEPARATOR_COLOR_DEFAULT_VALUE }
        val SEPARATOR_PADDINGS_READER: Reader<DivEdgeInsets> = { key, json, env -> JsonParser.readOptional(json, key, DivEdgeInsets.CREATOR, env.logger, env) ?: SEPARATOR_PADDINGS_DEFAULT_VALUE }
        val SWITCH_TABS_BY_CONTENT_SWIPE_ENABLED_READER: Reader<Expression<Boolean>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, ANY_TO_BOOLEAN, env.logger, env, SWITCH_TABS_BY_CONTENT_SWIPE_ENABLED_DEFAULT_VALUE, TYPE_HELPER_BOOLEAN) ?: SWITCH_TABS_BY_CONTENT_SWIPE_ENABLED_DEFAULT_VALUE }
        val TAB_TITLE_STYLE_READER: Reader<DivTabs.TabTitleStyle> = { key, json, env -> JsonParser.readOptional(json, key, DivTabs.TabTitleStyle.CREATOR, env.logger, env) ?: TAB_TITLE_STYLE_DEFAULT_VALUE }
        val TITLE_PADDINGS_READER: Reader<DivEdgeInsets> = { key, json, env -> JsonParser.readOptional(json, key, DivEdgeInsets.CREATOR, env.logger, env) ?: TITLE_PADDINGS_DEFAULT_VALUE }
        val TOOLTIPS_READER: Reader<List<DivTooltip>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivTooltip.CREATOR, TOOLTIPS_VALIDATOR, env.logger, env) }
        val TRANSFORM_READER: Reader<DivTransform> = { key, json, env -> JsonParser.readOptional(json, key, DivTransform.CREATOR, env.logger, env) ?: TRANSFORM_DEFAULT_VALUE }
        val TRANSITION_CHANGE_READER: Reader<DivChangeTransition?> = { key, json, env -> JsonParser.readOptional(json, key, DivChangeTransition.CREATOR, env.logger, env) }
        val TRANSITION_IN_READER: Reader<DivAppearanceTransition?> = { key, json, env -> JsonParser.readOptional(json, key, DivAppearanceTransition.CREATOR, env.logger, env) }
        val TRANSITION_OUT_READER: Reader<DivAppearanceTransition?> = { key, json, env -> JsonParser.readOptional(json, key, DivAppearanceTransition.CREATOR, env.logger, env) }
        val TRANSITION_TRIGGERS_READER: Reader<List<DivTransitionTrigger>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivTransitionTrigger.Converter.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR, env.logger, env) }
        val TYPE_READER: Reader<String> = { key, json, env -> JsonParser.read(json, key, env.logger, env) }
        val VISIBILITY_READER: Reader<Expression<DivVisibility>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivVisibility.Converter.FROM_STRING, env.logger, env, VISIBILITY_DEFAULT_VALUE, TYPE_HELPER_VISIBILITY) ?: VISIBILITY_DEFAULT_VALUE }
        val VISIBILITY_ACTION_READER: Reader<DivVisibilityAction?> = { key, json, env -> JsonParser.readOptional(json, key, DivVisibilityAction.CREATOR, env.logger, env) }
        val VISIBILITY_ACTIONS_READER: Reader<List<DivVisibilityAction>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivVisibilityAction.CREATOR, VISIBILITY_ACTIONS_VALIDATOR, env.logger, env) }
        val WIDTH_READER: Reader<DivSize> = { key, json, env -> JsonParser.readOptional(json, key, DivSize.CREATOR, env.logger, env) ?: WIDTH_DEFAULT_VALUE }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivTabsTemplate(env, json = it) }
    }


    @Mockable
    class TabTitleStyleTemplate : JSONSerializable, JsonTemplate<DivTabs.TabTitleStyle> {
        @JvmField final val activeBackgroundColor: Field<Expression<Int>> // default value: #FFFFDC60
        @JvmField final val activeFontWeight: Field<Expression<DivFontWeight>>
        @JvmField final val activeTextColor: Field<Expression<Int>> // default value: #CC000000
        @JvmField final val animationDuration: Field<Expression<Int>> // constraint: number >= 0; default value: 300
        @JvmField final val animationType: Field<Expression<DivTabs.TabTitleStyle.AnimationType>> // default value: slide
        @JvmField final val cornerRadius: Field<Expression<Int>> // constraint: number >= 0
        @JvmField final val cornersRadius: Field<DivCornersRadiusTemplate>
        @JvmField final val fontFamily: Field<Expression<DivFontFamily>> // default value: text
        @JvmField final val fontSize: Field<Expression<Int>> // constraint: number >= 0; default value: 12
        @JvmField final val fontSizeUnit: Field<Expression<DivSizeUnit>> // default value: sp
        @JvmField final val fontWeight: Field<Expression<DivFontWeight>> // default value: regular
        @JvmField final val inactiveBackgroundColor: Field<Expression<Int>>
        @JvmField final val inactiveFontWeight: Field<Expression<DivFontWeight>>
        @JvmField final val inactiveTextColor: Field<Expression<Int>> // default value: #80000000
        @JvmField final val itemSpacing: Field<Expression<Int>> // constraint: number >= 0; default value: 0
        @JvmField final val letterSpacing: Field<Expression<Double>> // default value: 0
        @JvmField final val lineHeight: Field<Expression<Int>> // constraint: number >= 0
        @JvmField final val paddings: Field<DivEdgeInsetsTemplate> // default value: DivEdgeInsets(bottom = Expression.constant(6), left = Expression.constant(8), right = Expression.constant(8), top = Expression.constant(6))

        constructor (
            env: ParsingEnvironment,
            parent: TabTitleStyleTemplate? = null,
            topLevel: Boolean = false,
            json: JSONObject
        ) {
            val logger = env.logger
            activeBackgroundColor = JsonTemplateParser.readOptionalFieldWithExpression(json, "active_background_color", topLevel, parent?.activeBackgroundColor, STRING_TO_COLOR_INT, logger, env, TYPE_HELPER_COLOR)
            activeFontWeight = JsonTemplateParser.readOptionalFieldWithExpression(json, "active_font_weight", topLevel, parent?.activeFontWeight, DivFontWeight.Converter.FROM_STRING, logger, env, TYPE_HELPER_ACTIVE_FONT_WEIGHT)
            activeTextColor = JsonTemplateParser.readOptionalFieldWithExpression(json, "active_text_color", topLevel, parent?.activeTextColor, STRING_TO_COLOR_INT, logger, env, TYPE_HELPER_COLOR)
            animationDuration = JsonTemplateParser.readOptionalFieldWithExpression(json, "animation_duration", topLevel, parent?.animationDuration, NUMBER_TO_INT, ANIMATION_DURATION_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
            animationType = JsonTemplateParser.readOptionalFieldWithExpression(json, "animation_type", topLevel, parent?.animationType, DivTabs.TabTitleStyle.AnimationType.Converter.FROM_STRING, logger, env, TYPE_HELPER_ANIMATION_TYPE)
            cornerRadius = JsonTemplateParser.readOptionalFieldWithExpression(json, "corner_radius", topLevel, parent?.cornerRadius, NUMBER_TO_INT, CORNER_RADIUS_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
            cornersRadius = JsonTemplateParser.readOptionalField(json, "corners_radius", topLevel, parent?.cornersRadius, DivCornersRadiusTemplate.CREATOR, logger, env)
            fontFamily = JsonTemplateParser.readOptionalFieldWithExpression(json, "font_family", topLevel, parent?.fontFamily, DivFontFamily.Converter.FROM_STRING, logger, env, TYPE_HELPER_FONT_FAMILY)
            fontSize = JsonTemplateParser.readOptionalFieldWithExpression(json, "font_size", topLevel, parent?.fontSize, NUMBER_TO_INT, FONT_SIZE_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
            fontSizeUnit = JsonTemplateParser.readOptionalFieldWithExpression(json, "font_size_unit", topLevel, parent?.fontSizeUnit, DivSizeUnit.Converter.FROM_STRING, logger, env, TYPE_HELPER_FONT_SIZE_UNIT)
            fontWeight = JsonTemplateParser.readOptionalFieldWithExpression(json, "font_weight", topLevel, parent?.fontWeight, DivFontWeight.Converter.FROM_STRING, logger, env, TYPE_HELPER_FONT_WEIGHT)
            inactiveBackgroundColor = JsonTemplateParser.readOptionalFieldWithExpression(json, "inactive_background_color", topLevel, parent?.inactiveBackgroundColor, STRING_TO_COLOR_INT, logger, env, TYPE_HELPER_COLOR)
            inactiveFontWeight = JsonTemplateParser.readOptionalFieldWithExpression(json, "inactive_font_weight", topLevel, parent?.inactiveFontWeight, DivFontWeight.Converter.FROM_STRING, logger, env, TYPE_HELPER_INACTIVE_FONT_WEIGHT)
            inactiveTextColor = JsonTemplateParser.readOptionalFieldWithExpression(json, "inactive_text_color", topLevel, parent?.inactiveTextColor, STRING_TO_COLOR_INT, logger, env, TYPE_HELPER_COLOR)
            itemSpacing = JsonTemplateParser.readOptionalFieldWithExpression(json, "item_spacing", topLevel, parent?.itemSpacing, NUMBER_TO_INT, ITEM_SPACING_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
            letterSpacing = JsonTemplateParser.readOptionalFieldWithExpression(json, "letter_spacing", topLevel, parent?.letterSpacing, NUMBER_TO_DOUBLE, logger, env, TYPE_HELPER_DOUBLE)
            lineHeight = JsonTemplateParser.readOptionalFieldWithExpression(json, "line_height", topLevel, parent?.lineHeight, NUMBER_TO_INT, LINE_HEIGHT_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
            paddings = JsonTemplateParser.readOptionalField(json, "paddings", topLevel, parent?.paddings, DivEdgeInsetsTemplate.CREATOR, logger, env)
        }

        override fun resolve(env: ParsingEnvironment, data: JSONObject): DivTabs.TabTitleStyle {
            return DivTabs.TabTitleStyle(
                activeBackgroundColor = activeBackgroundColor.resolveOptional(env = env, key = "active_background_color", data = data, reader = ACTIVE_BACKGROUND_COLOR_READER) ?: ACTIVE_BACKGROUND_COLOR_DEFAULT_VALUE,
                activeFontWeight = activeFontWeight.resolveOptional(env = env, key = "active_font_weight", data = data, reader = ACTIVE_FONT_WEIGHT_READER),
                activeTextColor = activeTextColor.resolveOptional(env = env, key = "active_text_color", data = data, reader = ACTIVE_TEXT_COLOR_READER) ?: ACTIVE_TEXT_COLOR_DEFAULT_VALUE,
                animationDuration = animationDuration.resolveOptional(env = env, key = "animation_duration", data = data, reader = ANIMATION_DURATION_READER) ?: ANIMATION_DURATION_DEFAULT_VALUE,
                animationType = animationType.resolveOptional(env = env, key = "animation_type", data = data, reader = ANIMATION_TYPE_READER) ?: ANIMATION_TYPE_DEFAULT_VALUE,
                cornerRadius = cornerRadius.resolveOptional(env = env, key = "corner_radius", data = data, reader = CORNER_RADIUS_READER),
                cornersRadius = cornersRadius.resolveOptionalTemplate(env = env, key = "corners_radius", data = data, reader = CORNERS_RADIUS_READER),
                fontFamily = fontFamily.resolveOptional(env = env, key = "font_family", data = data, reader = FONT_FAMILY_READER) ?: FONT_FAMILY_DEFAULT_VALUE,
                fontSize = fontSize.resolveOptional(env = env, key = "font_size", data = data, reader = FONT_SIZE_READER) ?: FONT_SIZE_DEFAULT_VALUE,
                fontSizeUnit = fontSizeUnit.resolveOptional(env = env, key = "font_size_unit", data = data, reader = FONT_SIZE_UNIT_READER) ?: FONT_SIZE_UNIT_DEFAULT_VALUE,
                fontWeight = fontWeight.resolveOptional(env = env, key = "font_weight", data = data, reader = FONT_WEIGHT_READER) ?: FONT_WEIGHT_DEFAULT_VALUE,
                inactiveBackgroundColor = inactiveBackgroundColor.resolveOptional(env = env, key = "inactive_background_color", data = data, reader = INACTIVE_BACKGROUND_COLOR_READER),
                inactiveFontWeight = inactiveFontWeight.resolveOptional(env = env, key = "inactive_font_weight", data = data, reader = INACTIVE_FONT_WEIGHT_READER),
                inactiveTextColor = inactiveTextColor.resolveOptional(env = env, key = "inactive_text_color", data = data, reader = INACTIVE_TEXT_COLOR_READER) ?: INACTIVE_TEXT_COLOR_DEFAULT_VALUE,
                itemSpacing = itemSpacing.resolveOptional(env = env, key = "item_spacing", data = data, reader = ITEM_SPACING_READER) ?: ITEM_SPACING_DEFAULT_VALUE,
                letterSpacing = letterSpacing.resolveOptional(env = env, key = "letter_spacing", data = data, reader = LETTER_SPACING_READER) ?: LETTER_SPACING_DEFAULT_VALUE,
                lineHeight = lineHeight.resolveOptional(env = env, key = "line_height", data = data, reader = LINE_HEIGHT_READER),
                paddings = paddings.resolveOptionalTemplate(env = env, key = "paddings", data = data, reader = PADDINGS_READER) ?: PADDINGS_DEFAULT_VALUE
            )
        }

        override fun writeToJSON(): JSONObject {
            val json = JSONObject()
            json.writeFieldWithExpression(key = "active_background_color", field = activeBackgroundColor, converter = COLOR_INT_TO_STRING)
            json.writeFieldWithExpression(key = "active_font_weight", field = activeFontWeight, converter = { v: DivFontWeight -> DivFontWeight.toString(v) })
            json.writeFieldWithExpression(key = "active_text_color", field = activeTextColor, converter = COLOR_INT_TO_STRING)
            json.writeFieldWithExpression(key = "animation_duration", field = animationDuration)
            json.writeFieldWithExpression(key = "animation_type", field = animationType, converter = { v: DivTabs.TabTitleStyle.AnimationType -> DivTabs.TabTitleStyle.AnimationType.toString(v) })
            json.writeFieldWithExpression(key = "corner_radius", field = cornerRadius)
            json.writeField(key = "corners_radius", field = cornersRadius)
            json.writeFieldWithExpression(key = "font_family", field = fontFamily, converter = { v: DivFontFamily -> DivFontFamily.toString(v) })
            json.writeFieldWithExpression(key = "font_size", field = fontSize)
            json.writeFieldWithExpression(key = "font_size_unit", field = fontSizeUnit, converter = { v: DivSizeUnit -> DivSizeUnit.toString(v) })
            json.writeFieldWithExpression(key = "font_weight", field = fontWeight, converter = { v: DivFontWeight -> DivFontWeight.toString(v) })
            json.writeFieldWithExpression(key = "inactive_background_color", field = inactiveBackgroundColor, converter = COLOR_INT_TO_STRING)
            json.writeFieldWithExpression(key = "inactive_font_weight", field = inactiveFontWeight, converter = { v: DivFontWeight -> DivFontWeight.toString(v) })
            json.writeFieldWithExpression(key = "inactive_text_color", field = inactiveTextColor, converter = COLOR_INT_TO_STRING)
            json.writeFieldWithExpression(key = "item_spacing", field = itemSpacing)
            json.writeFieldWithExpression(key = "letter_spacing", field = letterSpacing)
            json.writeFieldWithExpression(key = "line_height", field = lineHeight)
            json.writeField(key = "paddings", field = paddings)
            return json
        }

        companion object {
            private val ACTIVE_BACKGROUND_COLOR_DEFAULT_VALUE = Expression.constant(0xFFFFDC60.toInt())
            private val ACTIVE_TEXT_COLOR_DEFAULT_VALUE = Expression.constant(0xCC000000.toInt())
            private val ANIMATION_DURATION_DEFAULT_VALUE = Expression.constant(300)
            private val ANIMATION_TYPE_DEFAULT_VALUE = Expression.constant(DivTabs.TabTitleStyle.AnimationType.SLIDE)
            private val FONT_FAMILY_DEFAULT_VALUE = Expression.constant(DivFontFamily.TEXT)
            private val FONT_SIZE_DEFAULT_VALUE = Expression.constant(12)
            private val FONT_SIZE_UNIT_DEFAULT_VALUE = Expression.constant(DivSizeUnit.SP)
            private val FONT_WEIGHT_DEFAULT_VALUE = Expression.constant(DivFontWeight.REGULAR)
            private val INACTIVE_TEXT_COLOR_DEFAULT_VALUE = Expression.constant(0x80000000.toInt())
            private val ITEM_SPACING_DEFAULT_VALUE = Expression.constant(0)
            private val LETTER_SPACING_DEFAULT_VALUE = Expression.constant(0.0)
            private val PADDINGS_DEFAULT_VALUE = DivEdgeInsets(bottom = Expression.constant(6), left = Expression.constant(8), right = Expression.constant(8), top = Expression.constant(6))

            private val TYPE_HELPER_ACTIVE_FONT_WEIGHT = TypeHelper.from(default = DivFontWeight.values().first()) { it is DivFontWeight }
            private val TYPE_HELPER_ANIMATION_TYPE = TypeHelper.from(default = DivTabs.TabTitleStyle.AnimationType.values().first()) { it is DivTabs.TabTitleStyle.AnimationType }
            private val TYPE_HELPER_FONT_FAMILY = TypeHelper.from(default = DivFontFamily.values().first()) { it is DivFontFamily }
            private val TYPE_HELPER_FONT_SIZE_UNIT = TypeHelper.from(default = DivSizeUnit.values().first()) { it is DivSizeUnit }
            private val TYPE_HELPER_FONT_WEIGHT = TypeHelper.from(default = DivFontWeight.values().first()) { it is DivFontWeight }
            private val TYPE_HELPER_INACTIVE_FONT_WEIGHT = TypeHelper.from(default = DivFontWeight.values().first()) { it is DivFontWeight }

            private val ANIMATION_DURATION_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
            private val ANIMATION_DURATION_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
            private val CORNER_RADIUS_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
            private val CORNER_RADIUS_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
            private val FONT_SIZE_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
            private val FONT_SIZE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
            private val ITEM_SPACING_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
            private val ITEM_SPACING_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
            private val LINE_HEIGHT_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
            private val LINE_HEIGHT_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }

            val ACTIVE_BACKGROUND_COLOR_READER: Reader<Expression<Int>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, STRING_TO_COLOR_INT, env.logger, env, ACTIVE_BACKGROUND_COLOR_DEFAULT_VALUE, TYPE_HELPER_COLOR) ?: ACTIVE_BACKGROUND_COLOR_DEFAULT_VALUE }
            val ACTIVE_FONT_WEIGHT_READER: Reader<Expression<DivFontWeight>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivFontWeight.Converter.FROM_STRING, env.logger, env, TYPE_HELPER_ACTIVE_FONT_WEIGHT) }
            val ACTIVE_TEXT_COLOR_READER: Reader<Expression<Int>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, STRING_TO_COLOR_INT, env.logger, env, ACTIVE_TEXT_COLOR_DEFAULT_VALUE, TYPE_HELPER_COLOR) ?: ACTIVE_TEXT_COLOR_DEFAULT_VALUE }
            val ANIMATION_DURATION_READER: Reader<Expression<Int>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, ANIMATION_DURATION_VALIDATOR, env.logger, env, ANIMATION_DURATION_DEFAULT_VALUE, TYPE_HELPER_INT) ?: ANIMATION_DURATION_DEFAULT_VALUE }
            val ANIMATION_TYPE_READER: Reader<Expression<DivTabs.TabTitleStyle.AnimationType>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivTabs.TabTitleStyle.AnimationType.Converter.FROM_STRING, env.logger, env, ANIMATION_TYPE_DEFAULT_VALUE, TYPE_HELPER_ANIMATION_TYPE) ?: ANIMATION_TYPE_DEFAULT_VALUE }
            val CORNER_RADIUS_READER: Reader<Expression<Int>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, CORNER_RADIUS_VALIDATOR, env.logger, env, TYPE_HELPER_INT) }
            val CORNERS_RADIUS_READER: Reader<DivCornersRadius?> = { key, json, env -> JsonParser.readOptional(json, key, DivCornersRadius.CREATOR, env.logger, env) }
            val FONT_FAMILY_READER: Reader<Expression<DivFontFamily>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivFontFamily.Converter.FROM_STRING, env.logger, env, FONT_FAMILY_DEFAULT_VALUE, TYPE_HELPER_FONT_FAMILY) ?: FONT_FAMILY_DEFAULT_VALUE }
            val FONT_SIZE_READER: Reader<Expression<Int>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, FONT_SIZE_VALIDATOR, env.logger, env, FONT_SIZE_DEFAULT_VALUE, TYPE_HELPER_INT) ?: FONT_SIZE_DEFAULT_VALUE }
            val FONT_SIZE_UNIT_READER: Reader<Expression<DivSizeUnit>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivSizeUnit.Converter.FROM_STRING, env.logger, env, FONT_SIZE_UNIT_DEFAULT_VALUE, TYPE_HELPER_FONT_SIZE_UNIT) ?: FONT_SIZE_UNIT_DEFAULT_VALUE }
            val FONT_WEIGHT_READER: Reader<Expression<DivFontWeight>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivFontWeight.Converter.FROM_STRING, env.logger, env, FONT_WEIGHT_DEFAULT_VALUE, TYPE_HELPER_FONT_WEIGHT) ?: FONT_WEIGHT_DEFAULT_VALUE }
            val INACTIVE_BACKGROUND_COLOR_READER: Reader<Expression<Int>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, STRING_TO_COLOR_INT, env.logger, env, TYPE_HELPER_COLOR) }
            val INACTIVE_FONT_WEIGHT_READER: Reader<Expression<DivFontWeight>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivFontWeight.Converter.FROM_STRING, env.logger, env, TYPE_HELPER_INACTIVE_FONT_WEIGHT) }
            val INACTIVE_TEXT_COLOR_READER: Reader<Expression<Int>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, STRING_TO_COLOR_INT, env.logger, env, INACTIVE_TEXT_COLOR_DEFAULT_VALUE, TYPE_HELPER_COLOR) ?: INACTIVE_TEXT_COLOR_DEFAULT_VALUE }
            val ITEM_SPACING_READER: Reader<Expression<Int>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, ITEM_SPACING_VALIDATOR, env.logger, env, ITEM_SPACING_DEFAULT_VALUE, TYPE_HELPER_INT) ?: ITEM_SPACING_DEFAULT_VALUE }
            val LETTER_SPACING_READER: Reader<Expression<Double>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_DOUBLE, env.logger, env, LETTER_SPACING_DEFAULT_VALUE, TYPE_HELPER_DOUBLE) ?: LETTER_SPACING_DEFAULT_VALUE }
            val LINE_HEIGHT_READER: Reader<Expression<Int>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, LINE_HEIGHT_VALIDATOR, env.logger, env, TYPE_HELPER_INT) }
            val PADDINGS_READER: Reader<DivEdgeInsets> = { key, json, env -> JsonParser.readOptional(json, key, DivEdgeInsets.CREATOR, env.logger, env) ?: PADDINGS_DEFAULT_VALUE }

            val CREATOR = { env: ParsingEnvironment, it: JSONObject -> TabTitleStyleTemplate(env, json = it) }
        }

    }

    @Mockable
    class ItemTemplate : JSONSerializable, JsonTemplate<DivTabs.Item> {
        @JvmField final val div: Field<DivTemplate>
        @JvmField final val title: Field<Expression<String>> // at least 1 char
        @JvmField final val titleClickAction: Field<DivActionTemplate>

        constructor (
            env: ParsingEnvironment,
            parent: ItemTemplate? = null,
            topLevel: Boolean = false,
            json: JSONObject
        ) {
            val logger = env.logger
            div = JsonTemplateParser.readField(json, "div", topLevel, parent?.div, DivTemplate.CREATOR, logger, env)
            title = JsonTemplateParser.readFieldWithExpression(json, "title", topLevel, parent?.title, TITLE_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_STRING)
            titleClickAction = JsonTemplateParser.readOptionalField(json, "title_click_action", topLevel, parent?.titleClickAction, DivActionTemplate.CREATOR, logger, env)
        }

        override fun resolve(env: ParsingEnvironment, data: JSONObject): DivTabs.Item {
            return DivTabs.Item(
                div = div.resolveTemplate(env = env, key = "div", data = data, reader = DIV_READER),
                title = title.resolve(env = env, key = "title", data = data, reader = TITLE_READER),
                titleClickAction = titleClickAction.resolveOptionalTemplate(env = env, key = "title_click_action", data = data, reader = TITLE_CLICK_ACTION_READER)
            )
        }

        override fun writeToJSON(): JSONObject {
            val json = JSONObject()
            json.writeField(key = "div", field = div)
            json.writeFieldWithExpression(key = "title", field = title)
            json.writeField(key = "title_click_action", field = titleClickAction)
            return json
        }

        companion object {
            private val TITLE_TEMPLATE_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }
            private val TITLE_VALIDATOR = ValueValidator<String> { it: String -> it.length >= 1 }

            val DIV_READER: Reader<Div> = { key, json, env -> JsonParser.read(json, key, Div.CREATOR, env.logger, env) }
            val TITLE_READER: Reader<Expression<String>> = { key, json, env -> JsonParser.readExpression(json, key, TITLE_VALIDATOR, env.logger, env, TYPE_HELPER_STRING) }
            val TITLE_CLICK_ACTION_READER: Reader<DivAction?> = { key, json, env -> JsonParser.readOptional(json, key, DivAction.CREATOR, env.logger, env) }

            val CREATOR = { env: ParsingEnvironment, it: JSONObject -> ItemTemplate(env, json = it) }
        }

    }
}
