// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*

@Mockable
class DivWrapContentSizeTemplate : JSONSerializable, JsonTemplate<DivWrapContentSize> {
    @JvmField final val constrained: Field<Expression<Boolean>>
    @JvmField final val maxSize: Field<ConstraintSizeTemplate>
    @JvmField final val minSize: Field<ConstraintSizeTemplate>

    constructor (
        env: ParsingEnvironment,
        parent: DivWrapContentSizeTemplate? = null,
        topLevel: Boolean = false,
        json: JSONObject
    ) {
        val logger = env.logger
        constrained = JsonTemplateParser.readOptionalFieldWithExpression(json, "constrained", topLevel, parent?.constrained, ANY_TO_BOOLEAN, logger, env, TYPE_HELPER_BOOLEAN)
        maxSize = JsonTemplateParser.readOptionalField(json, "max_size", topLevel, parent?.maxSize, ConstraintSizeTemplate.CREATOR, logger, env)
        minSize = JsonTemplateParser.readOptionalField(json, "min_size", topLevel, parent?.minSize, ConstraintSizeTemplate.CREATOR, logger, env)
    }

    override fun resolve(env: ParsingEnvironment, data: JSONObject): DivWrapContentSize {
        return DivWrapContentSize(
            constrained = constrained.resolveOptional(env = env, key = "constrained", data = data, reader = CONSTRAINED_READER),
            maxSize = maxSize.resolveOptionalTemplate(env = env, key = "max_size", data = data, reader = MAX_SIZE_READER),
            minSize = minSize.resolveOptionalTemplate(env = env, key = "min_size", data = data, reader = MIN_SIZE_READER)
        )
    }

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.writeFieldWithExpression(key = "constrained", field = constrained)
        json.writeField(key = "max_size", field = maxSize)
        json.writeField(key = "min_size", field = minSize)
        json.write(key = "type", value = TYPE)
        return json
    }

    companion object {
        const val TYPE = "wrap_content"

        val CONSTRAINED_READER: Reader<Expression<Boolean>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, ANY_TO_BOOLEAN, env.logger, env, TYPE_HELPER_BOOLEAN) }
        val MAX_SIZE_READER: Reader<DivWrapContentSize.ConstraintSize?> = { key, json, env -> JsonParser.readOptional(json, key, DivWrapContentSize.ConstraintSize.CREATOR, env.logger, env) }
        val MIN_SIZE_READER: Reader<DivWrapContentSize.ConstraintSize?> = { key, json, env -> JsonParser.readOptional(json, key, DivWrapContentSize.ConstraintSize.CREATOR, env.logger, env) }
        val TYPE_READER: Reader<String> = { key, json, env -> JsonParser.read(json, key, env.logger, env) }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivWrapContentSizeTemplate(env, json = it) }
    }


    @Mockable
    class ConstraintSizeTemplate : JSONSerializable, JsonTemplate<DivWrapContentSize.ConstraintSize> {
        @JvmField final val unit: Field<Expression<DivSizeUnit>> // default value: dp
        @JvmField final val value: Field<Expression<Int>> // constraint: number >= 0

        constructor (
            env: ParsingEnvironment,
            parent: ConstraintSizeTemplate? = null,
            topLevel: Boolean = false,
            json: JSONObject
        ) {
            val logger = env.logger
            unit = JsonTemplateParser.readOptionalFieldWithExpression(json, "unit", topLevel, parent?.unit, DivSizeUnit.Converter.FROM_STRING, logger, env, TYPE_HELPER_UNIT)
            value = JsonTemplateParser.readFieldWithExpression(json, "value", topLevel, parent?.value, NUMBER_TO_INT, VALUE_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
        }

        override fun resolve(env: ParsingEnvironment, data: JSONObject): DivWrapContentSize.ConstraintSize {
            return DivWrapContentSize.ConstraintSize(
                unit = unit.resolveOptional(env = env, key = "unit", data = data, reader = UNIT_READER) ?: UNIT_DEFAULT_VALUE,
                value = value.resolve(env = env, key = "value", data = data, reader = VALUE_READER)
            )
        }

        override fun writeToJSON(): JSONObject {
            val json = JSONObject()
            json.writeFieldWithExpression(key = "unit", field = unit, converter = { v: DivSizeUnit -> DivSizeUnit.toString(v) })
            json.writeFieldWithExpression(key = "value", field = value)
            return json
        }

        companion object {
            private val UNIT_DEFAULT_VALUE = Expression.constant(DivSizeUnit.DP)

            private val TYPE_HELPER_UNIT = TypeHelper.from(default = DivSizeUnit.values().first()) { it is DivSizeUnit }

            private val VALUE_TEMPLATE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }
            private val VALUE_VALIDATOR = ValueValidator<Int> { it: Int -> it >= 0 }

            val UNIT_READER: Reader<Expression<DivSizeUnit>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivSizeUnit.Converter.FROM_STRING, env.logger, env, UNIT_DEFAULT_VALUE, TYPE_HELPER_UNIT) ?: UNIT_DEFAULT_VALUE }
            val VALUE_READER: Reader<Expression<Int>> = { key, json, env -> JsonParser.readExpression(json, key, NUMBER_TO_INT, VALUE_VALIDATOR, env.logger, env, TYPE_HELPER_INT) }

            val CREATOR = { env: ParsingEnvironment, it: JSONObject -> ConstraintSizeTemplate(env, json = it) }
        }

    }
}
